/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _PLATFORM_H
#define _PLATFORM_H

/* Distinguish between Windows and Posix */
#if (defined(__linux) || defined(__unix))
# define _YICS_POSIX 1
#elif (defined(WIN32) || defined(_WIN32) || defined(__WIN32) || defined(_WINDOWS) || defined(_WINDOWS_))
# define _YICS_WIN32 1
#else
# error "Platform unsupported."
#endif

/* 64 bit integer support */
#if (defined(__STDC__) && defined(__STDC_VERSION__))
# if (__STDC__ && __STDC_VERSION >= 199901L)
#  define i64_t long long
#  define i64fmt "%lld"
# endif
#endif

#if !defined(i64_t) || !defined(i64fmt)
# undef i64_t
# undef i64fmt
# if defined(__GNUC__) || defined(__MWERKS__) || defined (__SUNPRO_C) || defined (__SUNPRO_CC) || defined (__APPLE_CC__) || defined (_LONG_LONG) || defined (_CRAYC)
#  define i64_t long long
#  define i64fmt "%lld"
# elif defined(__WATCOMC__) || defined(_MSC_VER) || defined (__BORLANDC__) || defined (__alpha) || defined (__DECC)
#  define i64_t __int64
#  define i64fmt "%I64d"
# else
#  error "Compiler unsupported."
# endif
#endif

/* The vsnprintf function */
#if defined(__WATCOMC__) || defined(_MSC_VER)
# define vsnprintf(b,n,f,a) _vsnprintf (b,n,f,a)
# define snprintf           (_snprintf)
#endif

/* Annoying warning modes */
#ifdef _MSC_VER
#pragma warning(disable:4100)
#pragma warning(disable:4127) /* A warning in MSVC header files */
#pragma warning(disable:4032) /* A warning in MSVC header files */
#pragma warning(disable:4115) /* A warning in MSVC header files */
#endif

/* XXX: MinGW-cross-compiled EXEs segfault when %lld is used... so we can't
 * sprintf long longs.  The temporary solution is to cast to double and use
 * %.0f instead.  #undef'd to prevent accidental usage. */
#undef i64fmt

#endif
