#!/usr/bin/perl -w

my $is = 'fh00';
my $os = 'fh01';
my $halftable = 0;
my $endtable = 0;

open($is, '<manual_8.txt');
open($os, '>manual_8.raw');
print $os <<EOT;
\@TITLE=\@WPP_TITLE\@ Keywords list\@
\@TSSNAVBAR_IS_4=y\@
\@TSSNAVBAR_URL_L=\@TSS_DIR_PREFIX\@manual_7\@
\@TSSNAVBAR_URL_R=\@TSS_DIR_PREFIX\@manual_9\@

\@MACRO DIRECTIVE(NAME, NOTE, R, T, C)\@
<tr>
	<td>
		\@NAME\@\@IF NOTE\@\\
		<sub>\@RLINK("[\@NOTE\@]", "#Note\@NOTE\@")\@</sub>\@ENDIF\@
	</td>
	\@USE("\@R\@", "\@T\@", "\@C\@")\@
</tr>
\@ENDMACRO\@

\@MACRO VARIABLE(NAME, NOTE, SR, ST, SC, GR, GT, GC)\@
<tr>
	<td>
		\@NAME\@\@IF NOTE\@\\
		<sub>\@RLINK("[\@NOTE\@]", "#Note\@NOTE\@")\@</sub>\@ENDIF\@
	</td>
	\@USE("\@SR\@", "\@ST\@", "\@SC\@")\@
	\@USE("\@GR\@", "\@GT\@", "\@GC\@")\@
</tr>
\@ENDMACRO\@

\@MACRO USE(R, T, C)\@
<td>\@R\@</td>
<td>\@T\@</td>
<td>\@C\@</td>
\@ENDMACRO\@

\@INCLUDE utils/box_macros\@
\@INCLUDE utils/h_macros\@
\@D=\$\@
\$Date\$

\@SPARAG_OPEN("Keywords list", "LINKSNREFS")\@

<table class="tablelist" width="100%">
<tr>
	<th width="90%">Directives</th>
	<th colspan="3">Use</th>
</tr>
EOT
while (<$is>) {
	chop;
	SW: {
	/^NOTE ([0-9]+): (.*)$/o &&
		do {
			if ($endtable == 0) {
				$endtable = 1;
				print $os <<EOT;
</table>

<p/>

<dl>
<dt>
	<b>Legenda</b>
</dt>
<dd>
	<b>R</b> = source files
</dd>
<dd>
	<b>T</b> = template files
</dd>
<dd>
	<b>C</b> = configuration files and command line (only for variables through
	the \@RLINK("-D switch", "manual_1.html#-D")\@).
</dd>
EOT
			}
			print $os "<dt><a name=\"Note$1\"></a><b>Note $1</b></dt>\n<dd>$2</dd>\n";
			last SW;
		};
	/^\| ([A-Z_0-9\/\@a-z]+)[\t\s]*\| ([RTC\s]) ([RTC\s]) ([RTC\s]) \|(?: ([0-9]+))?$/o &&
		do {
			printf $os '@DIRECTIVE("%s", "%s", "%s", "%s", "%s")@',
				$1, defined $5 ? $5 : '', $2, $3, $4;
			print $os "\n";
			last SW;
		};
	/^\| ([A-Z_0-9\/\@a-z]+)[\t\s]*\| ([RTC\s]) ([RTC\s]) ([RTC\s]) \| ([RTC\s]) ([RTC\s]) ([RTC\s]) \|(?: ([0-9]+))?$/o &&
		do {
			if ($halftable == 0) {
				$halftable = 1;
				print $os <<EOT;
</table>


<p/>


<table class="tablelist" width="100%">
<tr>
	<th width="85%">Variables/Constants</th>
	<th colspan="3">Set</th>
	<th colspan="3">Get</th>
</tr>

EOT
			}
			printf $os '@VARIABLE("%s", "%s", "%s", "%s", "%s", "%s", "%s", "%s")@',
				$1, defined $8 ? $8 : '', $2, $3, $4, $5, $6, $7;
			print $os "\n";
			last SW;
		};
	}
}
print $os <<"EOT";
</dl>
\@SPARAG_CLOSE()\@
EOT

close($os);
close($is);
