/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.openmath.jome.model.processor;

import fr.ove.openmath.jome.ctrl.linear.LinearParser;
import fr.ove.openmath.jome.ctrlview.bidim.FormulaDisplay;
import fr.ove.openmath.jome.model.Formula;
import fr.ove.openmath.jome.model.FormulaTreeStructure;
import fr.ove.openmath.jome.model.Icon;
import fr.ove.openmath.jome.model.events.ModelEvent;
import fr.ove.openmath.jome.model.processor.DepthProcessorInterface;
import fr.ove.openmath.jome.model.processor.ProcessorImpl;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.util.Enumeration;

public class DepthProcessor
extends ProcessorImpl
implements DepthProcessorInterface {
    private int maxDepthValue = 0;

    public DepthProcessor(Formula formula) {
        super(formula);
    }

    @Override
    public void setDepthLevel(int n) {
        this.setLevel(n);
    }

    @Override
    public int getDepthLevel() {
        return this.getLevel();
    }

    @Override
    public int getMaxDepthValue() {
        return this.maxDepthValue;
    }

    @Override
    public void doProcess() {
        Formula formula = this.getFormula();
        if (formula != null) {
            switch (this.getProcessingId()) {
                case 1: {
                    this.maxDepthValue = 0;
                    this.computeMaxDepthValue(formula);
                    break;
                }
                case 2: {
                    this.setUpdateDisplay(true);
                    this.iconifyTheFTS(formula, this.getLevel());
                    this.setUpdateDisplay(false);
                    break;
                }
                case 3: {
                    this.setUpdateDisplay(true);
                    this.iconifyAllTheFTS(formula, this.getLevel());
                    this.setUpdateDisplay(false);
                    break;
                }
                case 4: {
                    this.maxDepthValue = 0;
                    this.computeMaxDepthValue(formula);
                    this.setLevel(this.maxDepthValue / 2);
                    this.iconifyAllTheFTS(formula, this.getLevel());
                }
            }
        }
    }

    private void iconifyTheFTS(FormulaTreeStructure formulaTreeStructure, int n) {
        Object object;
        Object var3_3 = null;
        if (formulaTreeStructure.isIcon()) {
            object = (FormulaTreeStructure)formulaTreeStructure.getFather();
            formulaTreeStructure.uniconify();
            ModelEvent modelEvent = new ModelEvent(object);
            modelEvent.setAction(7, null);
            ((FormulaTreeStructure)object).fireModelEvent(modelEvent);
            this.iconifyTheFTS((FormulaTreeStructure)object, n);
        }
        if (formulaTreeStructure.getDepth() < n) {
            if (formulaTreeStructure.getNbChildren() > 0) {
                object = formulaTreeStructure.getChildren().elements();
                while (object.hasMoreElements()) {
                    this.iconifyTheFTS((FormulaTreeStructure)object.nextElement(), n);
                }
            }
        } else if (formulaTreeStructure.getNbChildren() > 0) {
            this.iconify(formulaTreeStructure, n);
        }
    }

    private void iconifyAllTheFTS(FormulaTreeStructure formulaTreeStructure, int n) {
        if (formulaTreeStructure.getNbChildren() > 0) {
            Enumeration enumeration = formulaTreeStructure.getChildren().elements();
            while (enumeration.hasMoreElements()) {
                this.iconifyAllTheFTS((FormulaTreeStructure)enumeration.nextElement(), n);
            }
            if (formulaTreeStructure.getDepth() >= n) {
                this.iconify(formulaTreeStructure, n);
            }
        }
    }

    private void iconify(FormulaTreeStructure formulaTreeStructure, int n) {
        if (formulaTreeStructure.getFather() != null) {
            Icon icon = new Icon(formulaTreeStructure);
            icon.addIconified(formulaTreeStructure);
            FormulaTreeStructure formulaTreeStructure2 = (FormulaTreeStructure)formulaTreeStructure.getFather();
            formulaTreeStructure2.addChild(icon, formulaTreeStructure.getRank());
            formulaTreeStructure2.removeChild(formulaTreeStructure);
            if (this.getUpdateDisplay()) {
                ModelEvent modelEvent = new ModelEvent(formulaTreeStructure2);
                modelEvent.setAction(0, icon);
                formulaTreeStructure2.fireModelEvent(modelEvent);
            }
        }
    }

    private void computeMaxDepthValue(FormulaTreeStructure formulaTreeStructure) {
        if (formulaTreeStructure.getNbChildren() > 0) {
            Enumeration enumeration = formulaTreeStructure.getChildren().elements();
            while (enumeration.hasMoreElements()) {
                this.computeMaxDepthValue((FormulaTreeStructure)enumeration.nextElement());
            }
        }
        this.maxDepthValue = Math.max(formulaTreeStructure.getDepth(), this.maxDepthValue);
    }

    public static void main(String[] stringArray) {
        String string = "1+2/3*(4+3/5)^2+2/((3+5^9)*(1+2+3))";
        Formula formula = new Formula();
        formula.setDoProcessing(true);
        DepthProcessor depthProcessor = new DepthProcessor(formula);
        formula.setProcessor(depthProcessor);
        FormulaDisplay formulaDisplay = new FormulaDisplay();
        formula.addModelListener(formulaDisplay);
        formulaDisplay.addControlListener(formula);
        Frame frame = new Frame();
        frame.setLayout(new BorderLayout());
        frame.setBounds(50, 50, 250, 80);
        frame.add("Center", formulaDisplay);
        frame.setVisible(true);
        LinearParser linearParser = new LinearParser();
        linearParser.addLinearParserListener(formula);
        linearParser.parse(string);
        System.out.println("la formule saisie est : \t\t" + string);
        System.out.println("la formule construite est : \t\t" + formula.getLinear());
    }
}

