/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes;

import java.text.NumberFormat;

public class GeometryHolder {
    public static final int TRIANGLES = 1;
    public static final int QUADS = 2;
    public static final int TRIANGLE_STRIPS = 3;
    public static final int TRIANGLE_FANS = 4;
    public static final int INDEXED_QUADS = 5;
    public static final int INDEXED_TRIANGLES = 6;
    public static final int INDEXED_TRIANGLE_STRIPS = 7;
    public static final int INDEXED_TRIANGLE_FANS = 8;
    public static final int LINES = 9;
    public static final int LINE_STRIPS = 10;
    public static final int INDEXED_LINES = 11;
    public static final int INDEXED_LINE_STRIPS = 12;
    public static final int NORMAL_DATA = 2;
    public static final int TEXTURE_2D_DATA = 4;
    public static final int TEXTURE_3D_DATA = 8;
    public int geometryType = 0;
    public int geometrySubType;
    public int geometryComponents;
    public int vertexCount;
    public float[] coordinates;
    public float[] normals;
    public int indexesCount;
    public int[] indexes;
    public int numStrips;
    public int[] stripCounts;
    public float[][] textureCoordinates;
    public int numTexSets;
    public int numUniqueTexSets;
    public float[] colors;
    public int[] normalIndexes;
    public int[] texCoordIndexes;
    public int[] colorIndexes;

    public void prettyPrint() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setMinimumFractionDigits(3);
        boolean bl = (this.geometryComponents & 4) == 0;
        System.out.println();
        for (int i = 0; i < this.vertexCount; ++i) {
            System.out.print(i);
            System.out.print(" v: ");
            System.out.print(numberFormat.format(this.coordinates[i * 3]));
            System.out.print(' ');
            System.out.print(numberFormat.format(this.coordinates[i * 3 + 1]));
            System.out.print(' ');
            System.out.print(numberFormat.format(this.coordinates[i * 3 + 2]));
            if (this.normals != null) {
                System.out.print(", n: ");
                System.out.print(numberFormat.format(this.normals[i * 3]));
                System.out.print(' ');
                System.out.print(numberFormat.format(this.normals[i * 3 + 1]));
                System.out.print(' ');
                System.out.print(numberFormat.format(this.normals[i * 3 + 2]));
            }
            if (this.colors != null) {
                System.out.print(", c: ");
                System.out.print(numberFormat.format(this.colors[i * 3]));
                System.out.print(' ');
                System.out.print(numberFormat.format(this.colors[i * 3 + 1]));
                System.out.print(' ');
                System.out.print(numberFormat.format(this.colors[i * 3 + 2]));
            }
            for (int j = 0; j < this.numTexSets; ++j) {
                if (this.textureCoordinates[j] == null) continue;
                if (bl) {
                    System.out.print(", t: ");
                    System.out.print(numberFormat.format(this.textureCoordinates[j][i * 3]));
                    System.out.print(' ');
                    System.out.print(numberFormat.format(this.textureCoordinates[j][i * 3 + 1]));
                    System.out.print(' ');
                    System.out.print(numberFormat.format(this.textureCoordinates[j][i * 3 + 2]));
                    continue;
                }
                System.out.print(", t: ");
                System.out.print(numberFormat.format(this.textureCoordinates[j][i * 2]));
                System.out.print(' ');
                System.out.print(numberFormat.format(this.textureCoordinates[j][i * 2 + 1]));
            }
            System.out.println();
        }
    }
}

