/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.eventmodel;

import java.util.ArrayList;
import java.util.List;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.ViewpointStatusListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.xj3d.core.eventmodel.ViewpointManager;

public class DefaultViewpointManager
implements ViewpointManager,
ViewpointStatusListener {
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private VRMLViewpointNodeType nextViewpoint;
    private VRMLViewpointNodeType currentViewpoint;
    private ArrayList viewpointsByLayer = new ArrayList();
    private ArrayList defaultViewpoints = new ArrayList();
    private ArrayList boundViewpoints = new ArrayList();
    private int activeLayerId = -1;

    public DefaultViewpointManager(BrowserCore browserCore) {
        browserCore.addViewpointStatusListener(this);
    }

    public void updateViewpoint(long l) {
        if (this.nextViewpoint != null) {
            this.nextViewpoint.setBind(true, true, l);
            this.currentViewpoint = this.nextViewpoint;
            this.nextViewpoint = null;
        }
    }

    public void shutdown() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setViewpoint(VRMLViewpointNodeType vRMLViewpointNodeType) {
        this.nextViewpoint = vRMLViewpointNodeType;
    }

    public void resetViewpoint() {
        this.nextViewpoint = this.currentViewpoint;
    }

    public void firstViewpoint() {
        ArrayList arrayList = (ArrayList)this.viewpointsByLayer.get(this.activeLayerId);
        if (arrayList.size() != 0) {
            this.nextViewpoint = (VRMLViewpointNodeType)arrayList.get(0);
            if (this.nextViewpoint == this.defaultViewpoints.get(this.activeLayerId)) {
                this.nextViewpoint = (VRMLViewpointNodeType)arrayList.get(1);
            }
        }
    }

    public void lastViewpoint() {
        ArrayList arrayList = (ArrayList)this.viewpointsByLayer.get(this.activeLayerId);
        int n = arrayList.size();
        if (n != 0) {
            this.nextViewpoint = (VRMLViewpointNodeType)arrayList.get(n - 1);
            if (this.nextViewpoint == this.defaultViewpoints.get(this.activeLayerId)) {
                this.nextViewpoint = (VRMLViewpointNodeType)arrayList.get(n - 2);
            }
        }
    }

    public void nextViewpoint() {
        ArrayList arrayList = (ArrayList)this.viewpointsByLayer.get(this.activeLayerId);
        if (arrayList.size() < 2) {
            return;
        }
        int n = arrayList.indexOf(this.currentViewpoint);
        if (n != -1) {
            n = n == arrayList.size() - 1 ? 0 : ++n;
            Object e = this.defaultViewpoints.get(this.activeLayerId);
            if (n == arrayList.indexOf(e)) {
                ++n;
            }
            if (n >= arrayList.size() - 1) {
                n = 0;
            }
            this.nextViewpoint = (VRMLViewpointNodeType)arrayList.get(n);
        }
    }

    public void previousViewpoint() {
        ArrayList arrayList = (ArrayList)this.viewpointsByLayer.get(this.activeLayerId);
        if (arrayList.size() < 2) {
            return;
        }
        int n = arrayList.indexOf(this.currentViewpoint);
        if (n != -1) {
            n = n == 0 ? arrayList.size() - 1 : --n;
            Object e = this.defaultViewpoints.get(this.activeLayerId);
            if (n == arrayList.indexOf(e)) {
                --n;
            }
            if (n < 0) {
                n = arrayList.size() - 1;
            }
            this.nextViewpoint = (VRMLViewpointNodeType)arrayList.get(n);
        }
    }

    public void clear() {
        this.viewpointsByLayer.clear();
        this.defaultViewpoints.clear();
        this.boundViewpoints.clear();
    }

    public void viewpointLayerAdded(int n) {
        if (n >= this.viewpointsByLayer.size()) {
            for (int i = this.viewpointsByLayer.size(); i <= n; ++i) {
                this.viewpointsByLayer.add(null);
            }
            this.defaultViewpoints.add(null);
            this.boundViewpoints.add(null);
        }
        this.viewpointsByLayer.set(n, new ArrayList());
    }

    public void viewpointLayerRemoved(int n) {
        this.viewpointsByLayer.set(n, null);
        this.defaultViewpoints.set(n, null);
        this.boundViewpoints.set(n, null);
    }

    public void viewpointLayerActive(int n) {
        ArrayList arrayList;
        this.activeLayerId = n;
        if (n != -1 && (arrayList = (ArrayList)this.viewpointsByLayer.get(n)) != null && arrayList.size() != 0) {
            this.currentViewpoint = (VRMLViewpointNodeType)this.boundViewpoints.get(n);
        }
    }

    public void viewpointAdded(VRMLViewpointNodeType vRMLViewpointNodeType, int n, boolean bl) {
        if (bl) {
            this.defaultViewpoints.set(n, vRMLViewpointNodeType);
            if (this.boundViewpoints.get(n) == null) {
                this.boundViewpoints.set(n, vRMLViewpointNodeType);
            }
        }
        ArrayList arrayList = (ArrayList)this.viewpointsByLayer.get(n);
        arrayList.add(vRMLViewpointNodeType);
    }

    public void viewpointRemoved(VRMLViewpointNodeType vRMLViewpointNodeType, int n) {
        ArrayList arrayList = (ArrayList)this.viewpointsByLayer.get(n);
        arrayList.remove(vRMLViewpointNodeType);
        if (this.defaultViewpoints.get(n) == vRMLViewpointNodeType) {
            this.defaultViewpoints.set(n, null);
        }
        if (this.boundViewpoints.get(n) == vRMLViewpointNodeType) {
            this.boundViewpoints.set(n, this.defaultViewpoints.get(n));
        }
    }

    public void viewpointBound(VRMLViewpointNodeType vRMLViewpointNodeType, int n) {
        this.boundViewpoints.set(n, vRMLViewpointNodeType);
        if (n == this.activeLayerId) {
            this.currentViewpoint = vRMLViewpointNodeType;
        }
    }

    public List getActiveViewpoints() {
        return (List)this.viewpointsByLayer.get(this.activeLayerId);
    }
}

