// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SMLSL_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SMLSL_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_smlsl_8H[] = {
  0xf5d7, 0xe3c8, 0xc2f9, 0xc20c, 0xc17c, 0xc07e, 0xc17e, 0xf52f,
  0xef11, 0xd680, 0xc27c, 0xc18e, 0x3ffd, 0xc0fe, 0xc1fd, 0xf5ad,
  0xe719, 0xd62b, 0xc1ff, 0x3f10, 0x3f7e, 0xc17e, 0xc27c, 0x08df,
  0xe6e6, 0xd5d6, 0x3e82, 0x3e92, 0x3eff, 0xc1fe, 0xd5d5, 0x199b,
  0xe6b3, 0x2a81, 0x3e05, 0x3e14, 0x3e80, 0xd57e, 0xe6b3, 0x2f43,
  0x1980, 0x2a2c, 0x3d88, 0x3d96, 0x2b27, 0xe67e, 0xfc87, 0x31b9,
  0x194d, 0x29d7, 0x3d0b, 0x2a64, 0x1a49, 0xfc7e, 0xff02, 0x3237,
  0x191a, 0x2982, 0x2a00, 0x19a8, 0x0475, 0xfefe, 0xff81, 0x32b5,
  0x18e7, 0x1c8f, 0x1966, 0x0400, 0x01fa, 0xff7e, 0x0000, 0x3333,
  0x1122, 0x1145, 0x03ea, 0x018a, 0x017b, 0xfffe, 0x007f, 0x33b1,
  0x0a5c, 0x02a9, 0x0179, 0x010c, 0x00fc, 0x007e, 0x00fe, 0x342f,
  0x0198, 0x0100, 0x00fc, 0x008e, 0x007d, 0x00fe, 0x017d, 0x3723,
  0x0099, 0x00ab, 0x007f, 0x0010, 0xfffe, 0x017e, 0x0477, 0x4c4d,
  0x0066, 0x0056, 0x0002, 0xff92, 0xff7f, 0x047e, 0x19cc, 0x5d09,
  0x0033, 0x0001, 0xff85, 0xff14, 0xfc85, 0x19fe, 0x2aaa, 0x70b9,
  0x0000, 0xffac, 0xff08, 0xfc20, 0xe730, 0x2afe, 0x3e82, 0x7137,
  0xffcd, 0xff57, 0xfc1a, 0xe6f6, 0xd652, 0x3efe, 0x3f01, 0x71b5,
  0xff9a, 0xfd59, 0xe71b, 0xd63a, 0xc27a, 0x3f7e, 0x3f80, 0xf433,
  0xfe68, 0xef12, 0xd681, 0xc28a, 0xc1fb, 0x3ffe, 0xc0ff, 0xf4b1,
  0xef11, 0xd680, 0xc27c, 0xc18e, 0x3ffd, 0xc0fe, 0xc1fd, 0xf5ad,
  0xe3c7, 0xc2f8, 0xc1fe, 0xc10f, 0xc07d, 0xc17d, 0xc27b, 0xf62a,
  0xd67f, 0xc27b, 0xc180, 0x3f90, 0xc0fd, 0xc1fc, 0xc2f9, 0x0935,
  0xd62a, 0xc1fe, 0x3f02, 0x3f11, 0xc17d, 0xc27b, 0xd62b, 0x19cf,
  0xd5d5, 0x3e81, 0x3e84, 0x3e92, 0xc1fd, 0xd5d4, 0xe6e7, 0x2f4b,
  0x2a80, 0x3e04, 0x3e06, 0x3e13, 0xd57d, 0xe6b2, 0xfc8f, 0x31bc,
  0x2a2b, 0x3d87, 0x3d88, 0x2aba, 0xe67d, 0xfc86, 0xff05, 0x3239,
  0x29d6, 0x3d0a, 0x2a56, 0x19dc, 0xfc7d, 0xff01, 0xff83, 0x32b6,
  0x2981, 0x29ff, 0x199a, 0x0408, 0xfefd, 0xff80, 0x0001, 0x3333,
  0x1c8e, 0x1965, 0x03f2, 0x018d, 0xff7d, 0xffff, 0x007f, 0x33b0,
  0x1144, 0x03e9, 0x017c, 0x010e, 0xfffd, 0x007e, 0x00fd, 0x342d,
  0x02a8, 0x0178, 0x00fe, 0x008f, 0x007d, 0x00fd, 0x017b, 0x371b,
  0x00ff, 0x00fb, 0x0080, 0x0010, 0x00fd, 0x017c, 0x046f, 0x4c1a,
  0x00aa, 0x007e, 0x0002, 0xff91, 0x017d, 0x0476, 0x1999, 0x5cb4,
  0x0055, 0x0001, 0xff84, 0xff12, 0x047d, 0x19cb, 0x2a55, 0x703c,
  0x0000, 0xff84, 0xff06, 0xfc18, 0x19fd, 0x2aa9, 0x3e05, 0x70b9,
  0xffab, 0xff07, 0xfc12, 0xe6c3, 0x2afd, 0x3e81, 0x3e83, 0x7136,
  0xff56, 0xfc19, 0xe6e8, 0xd5e5, 0x3efd, 0x3f00, 0x3f01, 0xf4b3,
  0xfd58, 0xe71a, 0xd62c, 0xc20d, 0x3f7d, 0x3f7f, 0xc17f, 0xf530,
  0xe719, 0xd62b, 0xc1ff, 0x3f10, 0x3f7e, 0xc17e, 0xc27c, 0x08df,
  0xd67f, 0xc27b, 0xc180, 0x3f90, 0xc0fd, 0xc1fc, 0xc2f9, 0x0935,
  0xc2f7, 0xc1fd, 0xc101, 0xc010, 0xc17c, 0xc27a, 0xc376, 0x164f,
  0xc27a, 0xc17f, 0x3f82, 0xc090, 0xc1fb, 0xc2f8, 0xd681, 0x21bb,
  0xc1fd, 0x3f01, 0x3f03, 0xc110, 0xc27a, 0xd62a, 0xe71b, 0x3083,
  0x3e80, 0x3e83, 0x3e84, 0xc190, 0xd5d3, 0xe6e6, 0xfc97, 0x3231,
  0x3e03, 0x3e05, 0x3e05, 0xd510, 0xe6b1, 0xfc8e, 0xff08, 0x3287,
  0x3d86, 0x3d87, 0x2aac, 0xe610, 0xfc85, 0xff04, 0xff85, 0x32dd,
  0x3d09, 0x2a55, 0x19ce, 0xfc10, 0xff00, 0xff82, 0x0002, 0x3333,
  0x29fe, 0x1999, 0x03fa, 0xfe90, 0xff7f, 0x0000, 0x007f, 0x3389,
  0x1964, 0x03f1, 0x017f, 0xff10, 0xfffe, 0x007e, 0x00fc, 0x33df,
  0x03e8, 0x017b, 0x0100, 0xff90, 0x007d, 0x00fc, 0x0179, 0x35e3,
  0x0177, 0x00fd, 0x0081, 0x0010, 0x00fc, 0x017a, 0x0467, 0x4455,
  0x00fa, 0x007f, 0x0002, 0x0090, 0x017b, 0x046e, 0x1966, 0x4fc1,
  0x007d, 0x0001, 0xff83, 0x0110, 0x0475, 0x1998, 0x2a00, 0x5d31,
  0x0000, 0xff83, 0xff04, 0x0410, 0x19ca, 0x2a54, 0x3d88, 0x5d87,
  0xff83, 0xff05, 0xfc0a, 0x1990, 0x2aa8, 0x3e04, 0x3e05, 0x5ddd,
  0xff06, 0xfc11, 0xe6b5, 0x2a90, 0x3e80, 0x3e82, 0x3e82, 0x0833,
  0xfc18, 0xe6e7, 0xd5d7, 0x3e90, 0x3eff, 0x3f00, 0xc1ff, 0x0889,
  0xe6e6, 0xd5d6, 0x3e82, 0x3e92, 0x3eff, 0xc1fe, 0xd5d5, 0x199b,
  0xd62a, 0xc1fe, 0x3f02, 0x3f11, 0xc17d, 0xc27b, 0xd62b, 0x19cf,
  0xc27a, 0xc17f, 0x3f82, 0xc090, 0xc1fb, 0xc2f8, 0xd681, 0x21bb,
  0xc1fc, 0xc100, 0xc002, 0xc10f, 0xc279, 0xc375, 0xe39b, 0x28a3,
  0xc17e, 0x3f81, 0xc082, 0xc18e, 0xc2f7, 0xd680, 0xef07, 0x3193,
  0x3f00, 0x3f02, 0xc102, 0xc20d, 0xd629, 0xe71a, 0xfdcf, 0x3297,
  0x3e82, 0x3e83, 0xc182, 0xd566, 0xe6e5, 0xfc96, 0xff7d, 0x32cb,
  0x3e04, 0x3e04, 0xd502, 0xe644, 0xfc8d, 0xff07, 0xffd3, 0x32ff,
  0x3d86, 0x2aab, 0xe602, 0xfc18, 0xff03, 0xff84, 0x0029, 0x3333,
  0x2a54, 0x19cd, 0xfc02, 0xfe93, 0xff81, 0x0001, 0x007f, 0x3367,
  0x1998, 0x03f9, 0xfe82, 0xff12, 0xffff, 0x007e, 0x00d5, 0x339b,
  0x03f0, 0x017e, 0xff02, 0xff91, 0x007d, 0x00fb, 0x012b, 0x34d3,
  0x017a, 0x00ff, 0xff82, 0x0010, 0x00fb, 0x0178, 0x032f, 0x3d8f,
  0x00fc, 0x0080, 0x0002, 0x008f, 0x0179, 0x0466, 0x11a1, 0x4477,
  0x007e, 0x0001, 0x0082, 0x010e, 0x046d, 0x1965, 0x1d0d, 0x4c97,
  0x0000, 0xff82, 0x0102, 0x0408, 0x1997, 0x29ff, 0x2a7d, 0x4ccb,
  0xff82, 0xff03, 0x0402, 0x195d, 0x2a53, 0x3d87, 0x2ad3, 0x4cff,
  0xff04, 0xfc09, 0x1982, 0x2a3b, 0x3e03, 0x3e04, 0x2b29, 0x1933,
  0xfc10, 0xe6b4, 0x2a82, 0x3e13, 0x3e81, 0x3e81, 0xd57f, 0x1967,
  0xe6b3, 0x2a81, 0x3e05, 0x3e14, 0x3e80, 0xd57e, 0xe6b3, 0x2f43,
  0xd5d5, 0x3e81, 0x3e84, 0x3e92, 0xc1fd, 0xd5d4, 0xe6e7, 0x2f4b,
  0xc1fd, 0x3f01, 0x3f03, 0xc110, 0xc27a, 0xd62a, 0xe71b, 0x3083,
  0xc17e, 0x3f81, 0xc082, 0xc18e, 0xc2f7, 0xd680, 0xef07, 0x3193,
  0xc0ff, 0xc001, 0xc101, 0xc20c, 0xc374, 0xe39a, 0xf5ef, 0x32f3,
  0x3f80, 0xc081, 0xc180, 0xc28a, 0xd67f, 0xef06, 0xfedf, 0x331b,
  0x3f01, 0xc101, 0xc1ff, 0xd5bc, 0xe719, 0xfdce, 0xffe3, 0x3323,
  0x3e82, 0xc181, 0xd558, 0xe678, 0xfc95, 0xff7c, 0x0017, 0x332b,
  0x3e03, 0xd501, 0xe636, 0xfc20, 0xff06, 0xffd2, 0x004b, 0x3333,
  0x2aaa, 0xe601, 0xfc0a, 0xfe96, 0xff83, 0x0028, 0x007f, 0x333b,
  0x19cc, 0xfc01, 0xfe85, 0xff14, 0x0000, 0x007e, 0x00b3, 0x3343,
  0x03f8, 0xfe81, 0xff04, 0xff92, 0x007d, 0x00d4, 0x00e7, 0x3373,
  0x017d, 0xff01, 0xff83, 0x0010, 0x00fa, 0x012a, 0x021f, 0x34cb,
  0x00fe, 0xff81, 0x0002, 0x008e, 0x0177, 0x032e, 0x0adb, 0x35db,
  0x007f, 0x0001, 0x0081, 0x010c, 0x0465, 0x11a0, 0x11c3, 0x371b,
  0x0000, 0x0081, 0x0100, 0x0400, 0x1964, 0x1d0c, 0x19e3, 0x3723,
  0xff81, 0x0101, 0x03fa, 0x192a, 0x29fe, 0x2a7c, 0x1a17, 0x372b,
  0xff02, 0x0401, 0x194f, 0x29e6, 0x3d86, 0x2ad2, 0x1a4b, 0x2f33,
  0xfc08, 0x1981, 0x2a2d, 0x3d96, 0x3e03, 0x2b28, 0xe67f, 0x2f3b,
  0x1980, 0x2a2c, 0x3d88, 0x3d96, 0x2b27, 0xe67e, 0xfc87, 0x31b9,
  0x2a80, 0x3e04, 0x3e06, 0x3e13, 0xd57d, 0xe6b2, 0xfc8f, 0x31bc,
  0x3e80, 0x3e83, 0x3e84, 0xc190, 0xd5d3, 0xe6e6, 0xfc97, 0x3231,
  0x3f00, 0x3f02, 0xc102, 0xc20d, 0xd629, 0xe71a, 0xfdcf, 0x3297,
  0x3f80, 0xc081, 0xc180, 0xc28a, 0xd67f, 0xef06, 0xfedf, 0x331b,
  0xc000, 0xc100, 0xc1fe, 0xc307, 0xe399, 0xf5ee, 0x003f, 0x332a,
  0xc080, 0xc17f, 0xc27c, 0xd612, 0xef05, 0xfede, 0x0067, 0x332d,
  0xc100, 0xc1fe, 0xd5ae, 0xe6ac, 0xfdcd, 0xffe2, 0x006f, 0x3330,
  0xc180, 0xd557, 0xe66a, 0xfc28, 0xff7b, 0x0016, 0x0077, 0x3333,
  0xd500, 0xe635, 0xfc12, 0xfe99, 0xffd1, 0x004a, 0x007f, 0x3336,
  0xe600, 0xfc09, 0xfe88, 0xff16, 0x0027, 0x007e, 0x0087, 0x3339,
  0xfc00, 0xfe84, 0xff06, 0xff93, 0x007d, 0x00b2, 0x008f, 0x334b,
  0xfe80, 0xff03, 0xff84, 0x0010, 0x00d3, 0x00e6, 0x00bf, 0x33cc,
  0xff00, 0xff82, 0x0002, 0x008d, 0x0129, 0x021e, 0x0217, 0x3432,
  0xff80, 0x0001, 0x0080, 0x010a, 0x032d, 0x0ada, 0x0327, 0x34aa,
  0x0000, 0x0080, 0x00fe, 0x03f8, 0x119f, 0x11c2, 0x0467, 0x34ad,
  0x0080, 0x00ff, 0x03f2, 0x18f7, 0x1d0b, 0x19e2, 0x046f, 0x34b0,
  0x0100, 0x03f9, 0x191c, 0x2991, 0x2a7b, 0x1a16, 0x0477, 0x31b3,
  0x0400, 0x194e, 0x29d8, 0x3d19, 0x2ad1, 0x1a4a, 0xfc7f, 0x31b6,
  0x194d, 0x29d7, 0x3d0b, 0x2a64, 0x1a49, 0xfc7e, 0xff02, 0x3237,
  0x2a2b, 0x3d87, 0x3d88, 0x2aba, 0xe67d, 0xfc86, 0xff05, 0x3239,
  0x3e03, 0x3e05, 0x3e05, 0xd510, 0xe6b1, 0xfc8e, 0xff08, 0x3287,
  0x3e82, 0x3e83, 0xc182, 0xd566, 0xe6e5, 0xfc96, 0xff7d, 0x32cb,
  0x3f01, 0xc101, 0xc1ff, 0xd5bc, 0xe719, 0xfdce, 0xffe3, 0x3323,
  0xc080, 0xc17f, 0xc27c, 0xd612, 0xef05, 0xfede, 0x0067, 0x332d,
  0xc0ff, 0xc1fd, 0xc2f9, 0xe32c, 0xf5ed, 0x003e, 0x0076, 0x332f,
  0xc17e, 0xc27b, 0xd604, 0xee98, 0xfedd, 0x0066, 0x0079, 0x3331,
  0xc1fd, 0xd5ad, 0xe69e, 0xfd60, 0xffe1, 0x006e, 0x007c, 0x3333,
  0xd556, 0xe669, 0xfc1a, 0xff0e, 0x0015, 0x0076, 0x007f, 0x3335,
  0xe634, 0xfc11, 0xfe8b, 0xff64, 0x0049, 0x007e, 0x0082, 0x3337,
  0xfc08, 0xfe87, 0xff08, 0xffba, 0x007d, 0x0086, 0x0085, 0x3343,
  0xfe83, 0xff05, 0xff85, 0x0010, 0x00b1, 0x008e, 0x0097, 0x3399,
  0xff02, 0xff83, 0x0002, 0x0066, 0x00e5, 0x00be, 0x0118, 0x33dd,
  0xff81, 0x0001, 0x007f, 0x00bc, 0x021d, 0x0216, 0x017e, 0x342d,
  0x0000, 0x007f, 0x00fc, 0x02c0, 0x0ad9, 0x0326, 0x01f6, 0x342f,
  0x007f, 0x00fd, 0x03ea, 0x1132, 0x11c1, 0x0466, 0x01f9, 0x3431,
  0x00fe, 0x03f1, 0x18e9, 0x1c9e, 0x19e1, 0x046e, 0x01fc, 0x3233,
  0x03f8, 0x191b, 0x2983, 0x2a0e, 0x1a15, 0x0476, 0xfeff, 0x3235,
  0x191a, 0x2982, 0x2a00, 0x19a8, 0x0475, 0xfefe, 0xff81, 0x32b5,
  0x29d6, 0x3d0a, 0x2a56, 0x19dc, 0xfc7d, 0xff01, 0xff83, 0x32b6,
  0x3d86, 0x3d87, 0x2aac, 0xe610, 0xfc85, 0xff04, 0xff85, 0x32dd,
  0x3e04, 0x3e04, 0xd502, 0xe644, 0xfc8d, 0xff07, 0xffd3, 0x32ff,
  0x3e82, 0xc181, 0xd558, 0xe678, 0xfc95, 0xff7c, 0x0017, 0x332b,
  0xc100, 0xc1fe, 0xd5ae, 0xe6ac, 0xfdcd, 0xffe2, 0x006f, 0x3330,
  0xc17e, 0xc27b, 0xd604, 0xee98, 0xfedd, 0x0066, 0x0079, 0x3331,
  0xc1fc, 0xc2f8, 0xe31e, 0xf580, 0x003d, 0x0075, 0x007b, 0x3332,
  0xc27a, 0xd603, 0xee8a, 0xfe70, 0x0065, 0x0078, 0x007d, 0x3333,
  0xd5ac, 0xe69d, 0xfd52, 0xff74, 0x006d, 0x007b, 0x007f, 0x3334,
  0xe668, 0xfc19, 0xff00, 0xffa8, 0x0075, 0x007e, 0x0081, 0x3335,
  0xfc10, 0xfe8a, 0xff56, 0xffdc, 0x007d, 0x0081, 0x0083, 0x333b,
  0xfe86, 0xff07, 0xffac, 0x0010, 0x0085, 0x0084, 0x008f, 0x3366,
  0xff04, 0xff84, 0x0002, 0x0044, 0x008d, 0x0096, 0x00e5, 0x3388,
  0xff82, 0x0001, 0x0058, 0x0078, 0x00bd, 0x0117, 0x0129, 0x33b0,
  0x0000, 0x007e, 0x00ae, 0x01b0, 0x0215, 0x017d, 0x0179, 0x33b1,
  0x007e, 0x00fb, 0x02b2, 0x0a6c, 0x0325, 0x01f5, 0x017b, 0x33b2,
  0x00fc, 0x03e9, 0x1124, 0x1154, 0x0465, 0x01f8, 0x017d, 0x32b3,
  0x03f0, 0x18e8, 0x1c90, 0x1974, 0x046d, 0x01fb, 0xff7f, 0x32b4,
  0x18e7, 0x1c8f, 0x1966, 0x0400, 0x01fa, 0xff7e, 0x0000, 0x3333,
  0x2981, 0x29ff, 0x199a, 0x0408, 0xfefd, 0xff80, 0x0001, 0x3333,
  0x3d09, 0x2a55, 0x19ce, 0xfc10, 0xff00, 0xff82, 0x0002, 0x3333,
  0x3d86, 0x2aab, 0xe602, 0xfc18, 0xff03, 0xff84, 0x0029, 0x3333,
  0x3e03, 0xd501, 0xe636, 0xfc20, 0xff06, 0xffd2, 0x004b, 0x3333,
  0xc180, 0xd557, 0xe66a, 0xfc28, 0xff7b, 0x0016, 0x0077, 0x3333,
  0xc1fd, 0xd5ad, 0xe69e, 0xfd60, 0xffe1, 0x006e, 0x007c, 0x3333,
  0xc27a, 0xd603, 0xee8a, 0xfe70, 0x0065, 0x0078, 0x007d, 0x3333,
  0xc2f7, 0xe31d, 0xf572, 0xffd0, 0x0074, 0x007a, 0x007e, 0x3333,
  0xd602, 0xee89, 0xfe62, 0xfff8, 0x0077, 0x007c, 0x007f, 0x3333,
  0xe69c, 0xfd51, 0xff66, 0x0000, 0x007a, 0x007e, 0x0080, 0x3333,
  0xfc18, 0xfeff, 0xff9a, 0x0008, 0x007d, 0x0080, 0x0081, 0x3333,
  0xfe89, 0xff55, 0xffce, 0x0010, 0x0080, 0x0082, 0x0087, 0x3333,
  0xff06, 0xffab, 0x0002, 0x0018, 0x0083, 0x008e, 0x00b2, 0x3333,
  0xff83, 0x0001, 0x0036, 0x0020, 0x0095, 0x00e4, 0x00d4, 0x3333,
  0x0000, 0x0057, 0x006a, 0x0050, 0x0116, 0x0128, 0x00fc, 0x3333,
  0x007d, 0x00ad, 0x01a2, 0x01a8, 0x017c, 0x0178, 0x00fd, 0x3333,
  0x00fa, 0x02b1, 0x0a5e, 0x02b8, 0x01f4, 0x017a, 0x00fe, 0x3333,
  0x03e8, 0x1123, 0x1146, 0x03f8, 0x01f7, 0x017c, 0xffff, 0x3333,
  0x1122, 0x1145, 0x03ea, 0x018a, 0x017b, 0xfffe, 0x007f, 0x33b1,
  0x1c8e, 0x1965, 0x03f2, 0x018d, 0xff7d, 0xffff, 0x007f, 0x33b0,
  0x29fe, 0x1999, 0x03fa, 0xfe90, 0xff7f, 0x0000, 0x007f, 0x3389,
  0x2a54, 0x19cd, 0xfc02, 0xfe93, 0xff81, 0x0001, 0x007f, 0x3367,
  0x2aaa, 0xe601, 0xfc0a, 0xfe96, 0xff83, 0x0028, 0x007f, 0x333b,
  0xd500, 0xe635, 0xfc12, 0xfe99, 0xffd1, 0x004a, 0x007f, 0x3336,
  0xd556, 0xe669, 0xfc1a, 0xff0e, 0x0015, 0x0076, 0x007f, 0x3335,
  0xd5ac, 0xe69d, 0xfd52, 0xff74, 0x006d, 0x007b, 0x007f, 0x3334,
  0xd602, 0xee89, 0xfe62, 0xfff8, 0x0077, 0x007c, 0x007f, 0x3333,
  0xe31c, 0xf571, 0xffc2, 0x0007, 0x0079, 0x007d, 0x007f, 0x3332,
  0xee88, 0xfe61, 0xffea, 0x000a, 0x007b, 0x007e, 0x007f, 0x3331,
  0xfd50, 0xff65, 0xfff2, 0x000d, 0x007d, 0x007f, 0x007f, 0x332b,
  0xfefe, 0xff99, 0xfffa, 0x0010, 0x007f, 0x0080, 0x007f, 0x3300,
  0xff54, 0xffcd, 0x0002, 0x0013, 0x0081, 0x0086, 0x007f, 0x32de,
  0xffaa, 0x0001, 0x000a, 0x0016, 0x008d, 0x00b1, 0x007f, 0x32b6,
  0x0000, 0x0035, 0x0012, 0x0028, 0x00e3, 0x00d3, 0x007f, 0x32b5,
  0x0056, 0x0069, 0x0042, 0x00a9, 0x0127, 0x00fb, 0x007f, 0x32b4,
  0x00ac, 0x01a1, 0x019a, 0x010f, 0x0177, 0x00fc, 0x007f, 0x33b3,
  0x02b0, 0x0a5d, 0x02aa, 0x0187, 0x0179, 0x00fd, 0x007f, 0x33b2,
  0x0a5c, 0x02a9, 0x0179, 0x010c, 0x00fc, 0x007e, 0x00fe, 0x342f,
  0x1144, 0x03e9, 0x017c, 0x010e, 0xfffd, 0x007e, 0x00fd, 0x342d,
  0x1964, 0x03f1, 0x017f, 0xff10, 0xfffe, 0x007e, 0x00fc, 0x33df,
  0x1998, 0x03f9, 0xfe82, 0xff12, 0xffff, 0x007e, 0x00d5, 0x339b,
  0x19cc, 0xfc01, 0xfe85, 0xff14, 0x0000, 0x007e, 0x00b3, 0x3343,
  0xe600, 0xfc09, 0xfe88, 0xff16, 0x0027, 0x007e, 0x0087, 0x3339,
  0xe634, 0xfc11, 0xfe8b, 0xff64, 0x0049, 0x007e, 0x0082, 0x3337,
  0xe668, 0xfc19, 0xff00, 0xffa8, 0x0075, 0x007e, 0x0081, 0x3335,
  0xe69c, 0xfd51, 0xff66, 0x0000, 0x007a, 0x007e, 0x0080, 0x3333,
  0xee88, 0xfe61, 0xffea, 0x000a, 0x007b, 0x007e, 0x007f, 0x3331,
  0xf570, 0xffc1, 0xfff9, 0x000c, 0x007c, 0x007e, 0x007e, 0x332f,
  0xfe60, 0xffe9, 0xfffc, 0x000e, 0x007d, 0x007e, 0x007d, 0x3323,
  0xff64, 0xfff1, 0xffff, 0x0010, 0x007e, 0x007e, 0x0077, 0x32cd,
  0xff98, 0xfff9, 0x0002, 0x0012, 0x007f, 0x007e, 0x004c, 0x3289,
  0xffcc, 0x0001, 0x0005, 0x0014, 0x0085, 0x007e, 0x002a, 0x3239,
  0x0000, 0x0009, 0x0008, 0x0020, 0x00b0, 0x007e, 0x0002, 0x3237,
  0x0034, 0x0011, 0x001a, 0x0076, 0x00d2, 0x007e, 0x0001, 0x3235,
  0x0068, 0x0041, 0x009b, 0x00ba, 0x00fa, 0x007e, 0x0000, 0x3433,
  0x01a0, 0x0199, 0x0101, 0x010a, 0x00fb, 0x007e, 0x00ff, 0x3431,
  0x0198, 0x0100, 0x00fc, 0x008e, 0x007d, 0x00fe, 0x017d, 0x3723,
  0x02a8, 0x0178, 0x00fe, 0x008f, 0x007d, 0x00fd, 0x017b, 0x371b,
  0x03e8, 0x017b, 0x0100, 0xff90, 0x007d, 0x00fc, 0x0179, 0x35e3,
  0x03f0, 0x017e, 0xff02, 0xff91, 0x007d, 0x00fb, 0x012b, 0x34d3,
  0x03f8, 0xfe81, 0xff04, 0xff92, 0x007d, 0x00d4, 0x00e7, 0x3373,
  0xfc00, 0xfe84, 0xff06, 0xff93, 0x007d, 0x00b2, 0x008f, 0x334b,
  0xfc08, 0xfe87, 0xff08, 0xffba, 0x007d, 0x0086, 0x0085, 0x3343,
  0xfc10, 0xfe8a, 0xff56, 0xffdc, 0x007d, 0x0081, 0x0083, 0x333b,
  0xfc18, 0xfeff, 0xff9a, 0x0008, 0x007d, 0x0080, 0x0081, 0x3333,
  0xfd50, 0xff65, 0xfff2, 0x000d, 0x007d, 0x007f, 0x007f, 0x332b,
  0xfe60, 0xffe9, 0xfffc, 0x000e, 0x007d, 0x007e, 0x007d, 0x3323,
  0xffc0, 0xfff8, 0xfffe, 0x000f, 0x007d, 0x007d, 0x007b, 0x32f3,
  0xffe8, 0xfffb, 0x0000, 0x0010, 0x007d, 0x007c, 0x006f, 0x319b,
  0xfff0, 0xfffe, 0x0002, 0x0011, 0x007d, 0x0076, 0x0019, 0x308b,
  0xfff8, 0x0001, 0x0004, 0x0012, 0x007d, 0x004b, 0xffd5, 0x2f4b,
  0x0000, 0x0004, 0x0006, 0x0018, 0x007d, 0x0029, 0xff85, 0x2f43,
  0x0008, 0x0007, 0x0012, 0x0043, 0x007d, 0x0001, 0xff83, 0x2f3b,
  0x0010, 0x0019, 0x0068, 0x0065, 0x007d, 0x0000, 0xff81, 0x3733,
  0x0040, 0x009a, 0x00ac, 0x008d, 0x007d, 0xffff, 0x017f, 0x372b,
  0x0099, 0x00ab, 0x007f, 0x0010, 0xfffe, 0x017e, 0x0477, 0x4c4d,
  0x00ff, 0x00fb, 0x0080, 0x0010, 0x00fd, 0x017c, 0x046f, 0x4c1a,
  0x0177, 0x00fd, 0x0081, 0x0010, 0x00fc, 0x017a, 0x0467, 0x4455,
  0x017a, 0x00ff, 0xff82, 0x0010, 0x00fb, 0x0178, 0x032f, 0x3d8f,
  0x017d, 0xff01, 0xff83, 0x0010, 0x00fa, 0x012a, 0x021f, 0x34cb,
  0xfe80, 0xff03, 0xff84, 0x0010, 0x00d3, 0x00e6, 0x00bf, 0x33cc,
  0xfe83, 0xff05, 0xff85, 0x0010, 0x00b1, 0x008e, 0x0097, 0x3399,
  0xfe86, 0xff07, 0xffac, 0x0010, 0x0085, 0x0084, 0x008f, 0x3366,
  0xfe89, 0xff55, 0xffce, 0x0010, 0x0080, 0x0082, 0x0087, 0x3333,
  0xfefe, 0xff99, 0xfffa, 0x0010, 0x007f, 0x0080, 0x007f, 0x3300,
  0xff64, 0xfff1, 0xffff, 0x0010, 0x007e, 0x007e, 0x0077, 0x32cd,
  0xffe8, 0xfffb, 0x0000, 0x0010, 0x007d, 0x007c, 0x006f, 0x319b,
  0xfff7, 0xfffd, 0x0001, 0x0010, 0x007c, 0x007a, 0x003f, 0x290a,
  0xfffa, 0xffff, 0x0002, 0x0010, 0x007b, 0x006e, 0xfee7, 0x2244,
  0xfffd, 0x0001, 0x0003, 0x0010, 0x0075, 0x0018, 0xfdd7, 0x1a4c,
  0x0000, 0x0003, 0x0004, 0x0010, 0x004a, 0xffd4, 0xfc97, 0x1a19,
  0x0003, 0x0005, 0x000a, 0x0010, 0x0028, 0xff84, 0xfc8f, 0x19e6,
  0x0006, 0x0011, 0x0035, 0x0010, 0x0000, 0xff82, 0xfc87, 0x4cb3,
  0x0018, 0x0067, 0x0057, 0x0010, 0xffff, 0xff80, 0x047f, 0x4c80,
  0x0066, 0x0056, 0x0002, 0xff92, 0xff7f, 0x047e, 0x19cc, 0x5d09,
  0x00aa, 0x007e, 0x0002, 0xff91, 0x017d, 0x0476, 0x1999, 0x5cb4,
  0x00fa, 0x007f, 0x0002, 0x0090, 0x017b, 0x046e, 0x1966, 0x4fc1,
  0x00fc, 0x0080, 0x0002, 0x008f, 0x0179, 0x0466, 0x11a1, 0x4477,
  0x00fe, 0xff81, 0x0002, 0x008e, 0x0177, 0x032e, 0x0adb, 0x35db,
  0xff00, 0xff82, 0x0002, 0x008d, 0x0129, 0x021e, 0x0217, 0x3432,
  0xff02, 0xff83, 0x0002, 0x0066, 0x00e5, 0x00be, 0x0118, 0x33dd,
  0xff04, 0xff84, 0x0002, 0x0044, 0x008d, 0x0096, 0x00e5, 0x3388,
  0xff06, 0xffab, 0x0002, 0x0018, 0x0083, 0x008e, 0x00b2, 0x3333,
  0xff54, 0xffcd, 0x0002, 0x0013, 0x0081, 0x0086, 0x007f, 0x32de,
  0xff98, 0xfff9, 0x0002, 0x0012, 0x007f, 0x007e, 0x004c, 0x3289,
  0xfff0, 0xfffe, 0x0002, 0x0011, 0x007d, 0x0076, 0x0019, 0x308b,
  0xfffa, 0xffff, 0x0002, 0x0010, 0x007b, 0x006e, 0xfee7, 0x2244,
  0xfffc, 0x0000, 0x0002, 0x000f, 0x0079, 0x003e, 0xf656, 0x16fa,
  0xfffe, 0x0001, 0x0002, 0x000e, 0x006d, 0xfee6, 0xef90, 0x09b2,
  0x0000, 0x0002, 0x0002, 0x0008, 0x0017, 0xfdd6, 0xe798, 0x095d,
  0x0002, 0x0003, 0x0002, 0xffdd, 0xffd3, 0xfc96, 0xe765, 0x0908,
  0x0004, 0x0009, 0x0002, 0xffbb, 0xff83, 0xfc8e, 0xe732, 0x5db3,
  0x0010, 0x0034, 0x0002, 0xff93, 0xff81, 0xfc86, 0x19ff, 0x5d5e,
  0x0033, 0x0001, 0xff85, 0xff14, 0xfc85, 0x19fe, 0x2aaa, 0x70b9,
  0x0055, 0x0001, 0xff84, 0xff12, 0x047d, 0x19cb, 0x2a55, 0x703c,
  0x007d, 0x0001, 0xff83, 0x0110, 0x0475, 0x1998, 0x2a00, 0x5d31,
  0x007e, 0x0001, 0x0082, 0x010e, 0x046d, 0x1965, 0x1d0d, 0x4c97,
  0x007f, 0x0001, 0x0081, 0x010c, 0x0465, 0x11a0, 0x11c3, 0x371b,
  0xff80, 0x0001, 0x0080, 0x010a, 0x032d, 0x0ada, 0x0327, 0x34aa,
  0xff81, 0x0001, 0x007f, 0x00bc, 0x021d, 0x0216, 0x017e, 0x342d,
  0xff82, 0x0001, 0x0058, 0x0078, 0x00bd, 0x0117, 0x0129, 0x33b0,
  0xff83, 0x0001, 0x0036, 0x0020, 0x0095, 0x00e4, 0x00d4, 0x3333,
  0xffaa, 0x0001, 0x000a, 0x0016, 0x008d, 0x00b1, 0x007f, 0x32b6,
  0xffcc, 0x0001, 0x0005, 0x0014, 0x0085, 0x007e, 0x002a, 0x3239,
  0xfff8, 0x0001, 0x0004, 0x0012, 0x007d, 0x004b, 0xffd5, 0x2f4b,
  0xfffd, 0x0001, 0x0003, 0x0010, 0x0075, 0x0018, 0xfdd7, 0x1a4c,
  0xfffe, 0x0001, 0x0002, 0x000e, 0x006d, 0xfee6, 0xef90, 0x09b2,
  0xffff, 0x0001, 0x0001, 0x000c, 0x003d, 0xf655, 0xe446, 0xf62a,
  0x0000, 0x0001, 0x0000, 0x0000, 0xfee5, 0xef8f, 0xd6fe, 0xf5ad,
  0x0001, 0x0001, 0xfffa, 0xffaa, 0xfdd5, 0xe797, 0xd6a9, 0xf530,
  0x0002, 0x0001, 0xffcf, 0xff66, 0xfc95, 0xe764, 0xd654, 0x71b3,
  0x0008, 0x0001, 0xffad, 0xff16, 0xfc8d, 0xe731, 0x2aff, 0x7136,
  0x0000, 0xffac, 0xff08, 0xfc20, 0xe730, 0x2afe, 0x3e82, 0x7137,
  0x0000, 0xff84, 0xff06, 0xfc18, 0x19fd, 0x2aa9, 0x3e05, 0x70b9,
  0x0000, 0xff83, 0xff04, 0x0410, 0x19ca, 0x2a54, 0x3d88, 0x5d87,
  0x0000, 0xff82, 0x0102, 0x0408, 0x1997, 0x29ff, 0x2a7d, 0x4ccb,
  0x0000, 0x0081, 0x0100, 0x0400, 0x1964, 0x1d0c, 0x19e3, 0x3723,
  0x0000, 0x0080, 0x00fe, 0x03f8, 0x119f, 0x11c2, 0x0467, 0x34ad,
  0x0000, 0x007f, 0x00fc, 0x02c0, 0x0ad9, 0x0326, 0x01f6, 0x342f,
  0x0000, 0x007e, 0x00ae, 0x01b0, 0x0215, 0x017d, 0x0179, 0x33b1,
  0x0000, 0x0057, 0x006a, 0x0050, 0x0116, 0x0128, 0x00fc, 0x3333,
  0x0000, 0x0035, 0x0012, 0x0028, 0x00e3, 0x00d3, 0x007f, 0x32b5,
  0x0000, 0x0009, 0x0008, 0x0020, 0x00b0, 0x007e, 0x0002, 0x3237,
  0x0000, 0x0004, 0x0006, 0x0018, 0x007d, 0x0029, 0xff85, 0x2f43,
  0x0000, 0x0003, 0x0004, 0x0010, 0x004a, 0xffd4, 0xfc97, 0x1a19,
  0x0000, 0x0002, 0x0002, 0x0008, 0x0017, 0xfdd6, 0xe798, 0x095d,
  0x0000, 0x0001, 0x0000, 0x0000, 0xfee5, 0xef8f, 0xd6fe, 0xf5ad,
  0x0000, 0x0000, 0xfffe, 0xffd0, 0xf654, 0xe445, 0xc376, 0xf52f,
  0x0000, 0xffff, 0xfff2, 0xfe78, 0xef8e, 0xd6fd, 0xc2f9, 0xf4b1,
  0x0000, 0xfff9, 0xff9c, 0xfd68, 0xe796, 0xd6a8, 0xc27c, 0x7233,
  0x0000, 0xffce, 0xff58, 0xfc28, 0xe763, 0xd653, 0x3eff, 0x71b5,
  0xffcd, 0xff57, 0xfc1a, 0xe6f6, 0xd652, 0x3efe, 0x3f01, 0x71b5,
  0xffab, 0xff07, 0xfc12, 0xe6c3, 0x2afd, 0x3e81, 0x3e83, 0x7136,
  0xff83, 0xff05, 0xfc0a, 0x1990, 0x2aa8, 0x3e04, 0x3e05, 0x5ddd,
  0xff82, 0xff03, 0x0402, 0x195d, 0x2a53, 0x3d87, 0x2ad3, 0x4cff,
  0xff81, 0x0101, 0x03fa, 0x192a, 0x29fe, 0x2a7c, 0x1a17, 0x372b,
  0x0080, 0x00ff, 0x03f2, 0x18f7, 0x1d0b, 0x19e2, 0x046f, 0x34b0,
  0x007f, 0x00fd, 0x03ea, 0x1132, 0x11c1, 0x0466, 0x01f9, 0x3431,
  0x007e, 0x00fb, 0x02b2, 0x0a6c, 0x0325, 0x01f5, 0x017b, 0x33b2,
  0x007d, 0x00ad, 0x01a2, 0x01a8, 0x017c, 0x0178, 0x00fd, 0x3333,
  0x0056, 0x0069, 0x0042, 0x00a9, 0x0127, 0x00fb, 0x007f, 0x32b4,
  0x0034, 0x0011, 0x001a, 0x0076, 0x00d2, 0x007e, 0x0001, 0x3235,
  0x0008, 0x0007, 0x0012, 0x0043, 0x007d, 0x0001, 0xff83, 0x2f3b,
  0x0003, 0x0005, 0x000a, 0x0010, 0x0028, 0xff84, 0xfc8f, 0x19e6,
  0x0002, 0x0003, 0x0002, 0xffdd, 0xffd3, 0xfc96, 0xe765, 0x0908,
  0x0001, 0x0001, 0xfffa, 0xffaa, 0xfdd5, 0xe797, 0xd6a9, 0xf530,
  0x0000, 0xffff, 0xfff2, 0xfe78, 0xef8e, 0xd6fd, 0xc2f9, 0xf4b1,
  0xffff, 0xfffd, 0xffc2, 0xf5e7, 0xe444, 0xc375, 0xc27b, 0xf432,
  0xfffe, 0xfff1, 0xfe6a, 0xef21, 0xd6fc, 0xc2f8, 0xc1fd, 0x72b3,
  0xfff8, 0xff9b, 0xfd5a, 0xe729, 0xd6a7, 0xc27b, 0x3f7f, 0x7234,
  0xff9a, 0xfd59, 0xe71b, 0xd63a, 0xc27a, 0x3f7e, 0x3f80, 0xf433,
  0xff56, 0xfc19, 0xe6e8, 0xd5e5, 0x3efd, 0x3f00, 0x3f01, 0xf4b3,
  0xff06, 0xfc11, 0xe6b5, 0x2a90, 0x3e80, 0x3e82, 0x3e82, 0x0833,
  0xff04, 0xfc09, 0x1982, 0x2a3b, 0x3e03, 0x3e04, 0x2b29, 0x1933,
  0xff02, 0x0401, 0x194f, 0x29e6, 0x3d86, 0x2ad2, 0x1a4b, 0x2f33,
  0x0100, 0x03f9, 0x191c, 0x2991, 0x2a7b, 0x1a16, 0x0477, 0x31b3,
  0x00fe, 0x03f1, 0x18e9, 0x1c9e, 0x19e1, 0x046e, 0x01fc, 0x3233,
  0x00fc, 0x03e9, 0x1124, 0x1154, 0x0465, 0x01f8, 0x017d, 0x32b3,
  0x00fa, 0x02b1, 0x0a5e, 0x02b8, 0x01f4, 0x017a, 0x00fe, 0x3333,
  0x00ac, 0x01a1, 0x019a, 0x010f, 0x0177, 0x00fc, 0x007f, 0x33b3,
  0x0068, 0x0041, 0x009b, 0x00ba, 0x00fa, 0x007e, 0x0000, 0x3433,
  0x0010, 0x0019, 0x0068, 0x0065, 0x007d, 0x0000, 0xff81, 0x3733,
  0x0006, 0x0011, 0x0035, 0x0010, 0x0000, 0xff82, 0xfc87, 0x4cb3,
  0x0004, 0x0009, 0x0002, 0xffbb, 0xff83, 0xfc8e, 0xe732, 0x5db3,
  0x0002, 0x0001, 0xffcf, 0xff66, 0xfc95, 0xe764, 0xd654, 0x71b3,
  0x0000, 0xfff9, 0xff9c, 0xfd68, 0xe796, 0xd6a8, 0xc27c, 0x7233,
  0xfffe, 0xfff1, 0xfe6a, 0xef21, 0xd6fc, 0xc2f8, 0xc1fd, 0x72b3,
  0xfffc, 0xffc1, 0xf5d9, 0xe3d7, 0xc374, 0xc27a, 0xc17e, 0xf333,
  0xfff0, 0xfe69, 0xef13, 0xd68f, 0xc2f7, 0xc1fc, 0x3fff, 0xf3b3,
  0xfe68, 0xef12, 0xd681, 0xc28a, 0xc1fb, 0x3ffe, 0xc0ff, 0xf4b1,
  0xfd58, 0xe71a, 0xd62c, 0xc20d, 0x3f7d, 0x3f7f, 0xc17f, 0xf530,
  0xfc18, 0xe6e7, 0xd5d7, 0x3e90, 0x3eff, 0x3f00, 0xc1ff, 0x0889,
  0xfc10, 0xe6b4, 0x2a82, 0x3e13, 0x3e81, 0x3e81, 0xd57f, 0x1967,
  0xfc08, 0x1981, 0x2a2d, 0x3d96, 0x3e03, 0x2b28, 0xe67f, 0x2f3b,
  0x0400, 0x194e, 0x29d8, 0x3d19, 0x2ad1, 0x1a4a, 0xfc7f, 0x31b6,
  0x03f8, 0x191b, 0x2983, 0x2a0e, 0x1a15, 0x0476, 0xfeff, 0x3235,
  0x03f0, 0x18e8, 0x1c90, 0x1974, 0x046d, 0x01fb, 0xff7f, 0x32b4,
  0x03e8, 0x1123, 0x1146, 0x03f8, 0x01f7, 0x017c, 0xffff, 0x3333,
  0x02b0, 0x0a5d, 0x02aa, 0x0187, 0x0179, 0x00fd, 0x007f, 0x33b2,
  0x01a0, 0x0199, 0x0101, 0x010a, 0x00fb, 0x007e, 0x00ff, 0x3431,
  0x0040, 0x009a, 0x00ac, 0x008d, 0x007d, 0xffff, 0x017f, 0x372b,
  0x0018, 0x0067, 0x0057, 0x0010, 0xffff, 0xff80, 0x047f, 0x4c80,
  0x0010, 0x0034, 0x0002, 0xff93, 0xff81, 0xfc86, 0x19ff, 0x5d5e,
  0x0008, 0x0001, 0xffad, 0xff16, 0xfc8d, 0xe731, 0x2aff, 0x7136,
  0x0000, 0xffce, 0xff58, 0xfc28, 0xe763, 0xd653, 0x3eff, 0x71b5,
  0xfff8, 0xff9b, 0xfd5a, 0xe729, 0xd6a7, 0xc27b, 0x3f7f, 0x7234,
  0xfff0, 0xfe69, 0xef13, 0xd68f, 0xc2f7, 0xc1fc, 0x3fff, 0xf3b3,
  0xffc0, 0xf5d8, 0xe3c9, 0xc307, 0xc279, 0xc17d, 0xc07f, 0xf432,
};
const unsigned kExpectedCount_NEON_smlsl_8H = 361;

#endif  // VIXL_SIM_SMLSL_8H_TRACE_AARCH64_H_
