---
title: Column Reference
description: A reference for customizing the Trippy TUI columns.
sidebar:
  order: 4
---

The following table lists the columns that are available for display in the Tui. These can be overridden with the
`--tui-custom-columns` command line option or in the `tui-custom-columns` attribute in the `tui` section of the
configuration file.

| Column   | Code | Description                                                                                                                                                                                                                                                                                                                                           |
| -------- | ---- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `#`      | `h`  | The time-to-live (TTL) for the hop                                                                                                                                                                                                                                                                                                                    |
| `Host`   | `o`  | The hostname(s) and IP address(s) for the host(s) for the hop<br/>May include AS info, GeoIp and ICMP extensions<br/>Shows full hop details in hop detail navigation mode                                                                                                                                                                             |
| `Loss%`  | `l`  | The packet loss % for the hop                                                                                                                                                                                                                                                                                                                         |
| `Snd`    | `s`  | The number of probes sent for the hop                                                                                                                                                                                                                                                                                                                 |
| `Recv`   | `r`  | The number of probe responses received for the hop                                                                                                                                                                                                                                                                                                    |
| `Last`   | `a`  | The round-trip-time (RTT) of the last probe for the hop                                                                                                                                                                                                                                                                                               |
| `Avg`    | `v`  | The average RTT of all probes for the hop                                                                                                                                                                                                                                                                                                             |
| `Best`   | `b`  | The best RTT of all probes for the hop                                                                                                                                                                                                                                                                                                                |
| `Wrst`   | `w`  | The worst RTT of all probes for the hop                                                                                                                                                                                                                                                                                                               |
| `StDev`  | `d`  | The standard deviation of all probes for the hop                                                                                                                                                                                                                                                                                                      |
| `Sts`    | `t`  | The status for the hop:<br/>- 🟢 Healthy hop<br/>- 🔵 Non-target hop with packet loss (does not necessarily indicate a problem)<br/>- 🟤 Non-target hop is unresponsive (does not necessarily indicate a problem) <br/>- 🟡 Target hop with packet loss (likely indicates a problem)<br/>- 🔴 Target hop is unresponsive (likely indicates a problem) |
| `Jttr`   | `j`  | The round-trip-time (RTT) difference between consecutive rounds for the hop                                                                                                                                                                                                                                                                           |
| `Javg`   | `g`  | The average jitter of all probes for the hop                                                                                                                                                                                                                                                                                                          |
| `Jmax`   | `x`  | The maximum jitter of all probes for the hop                                                                                                                                                                                                                                                                                                          |
| `Jint`   | `i`  | The smoothed jitter value of all probes for the hop                                                                                                                                                                                                                                                                                                   |
| `Seq`    | `Q`  | The sequence number for the last probe for the hop                                                                                                                                                                                                                                                                                                    |
| `Sprt`   | `S`  | The source port for the last probe for the hop                                                                                                                                                                                                                                                                                                        |
| `Dprt`   | `P`  | The destination port for the last probe for the hop                                                                                                                                                                                                                                                                                                   |
| `Type`   | `T`  | The icmp packet type for the last probe for the hop:<br/>- TE: TimeExceeded<br/>- ER: EchoReply<br/>- DU: DestinationUnreachable<br/>- NA: NotApplicable                                                                                                                                                                                              |
| `Code`   | `C`  | The icmp packet code for the last probe for the hop                                                                                                                                                                                                                                                                                                   |
| `Nat`    | `N`  | The NAT detection status for the hop                                                                                                                                                                                                                                                                                                                  |
| `Fail`   | `f`  | The number of probes which failed to send for the hop                                                                                                                                                                                                                                                                                                 |
| `Floss`  | `F`  | A _heuristic_ for the number of probes with _forward loss_ for the hop                                                                                                                                                                                                                                                                                |
| `Bloss`  | `B`  | A _heuristic_ for the number of probes with _backward loss_ for the hop                                                                                                                                                                                                                                                                               |
| `Floss%` | `D`  | The _forward loss_ % for the hop                                                                                                                                                                                                                                                                                                                      |

The default columns are `holsravbwdt`.

:::note
The columns will be shown in the order specified in the configuration.
:::
