package azqueue

// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"bytes"
	"context"
	"encoding/xml"
	"github.com/Azure/azure-pipeline-go/pipeline"
	"io"
	"io/ioutil"
	"net/http"
	"net/url"
	"strconv"
)

// messagesClient is the client for the Messages methods of the Azqueue service.
type messagesClient struct {
	managementClient
}

// newMessagesClient creates an instance of the messagesClient client.
func newMessagesClient(url url.URL, p pipeline.Pipeline) messagesClient {
	return messagesClient{newManagementClient(url, p)}
}

// Clear the Clear operation deletes all messages from the specified queue.
//
// timeout is the The timeout parameter is expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations>Setting
// Timeouts for Queue Service Operations.</a> requestID is provides a client-generated, opaque value with a 1 KB
// character limit that is recorded in the analytics logs when storage analytics logging is enabled.
func (client messagesClient) Clear(ctx context.Context, timeout *int32, requestID *string) (*MessagesClearResponse, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.clearPreparer(timeout, requestID)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.clearResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*MessagesClearResponse), err
}

// clearPreparer prepares the Clear request.
func (client messagesClient) clearPreparer(timeout *int32, requestID *string) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("DELETE", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	if requestID != nil {
		req.Header.Set("x-ms-client-request-id", *requestID)
	}
	return req, nil
}

// clearResponder handles the response to the Clear request.
func (client messagesClient) clearResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK, http.StatusNoContent)
	if resp == nil {
		return nil, err
	}
	io.Copy(ioutil.Discard, resp.Response().Body)
	resp.Response().Body.Close()
	return &MessagesClearResponse{rawResponse: resp.Response()}, err
}

// Dequeue the Dequeue operation retrieves one or more messages from the front of the queue.
//
// numberOfMessages is optional. A nonzero integer value that specifies the number of messages to retrieve from the
// queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single message
// is retrieved from the queue with this operation. visibilitytimeout is optional. Specifies the new visibility timeout
// value, in seconds, relative to server time. The default value is 30 seconds. A specified value must be larger than
// or equal to 1 second, and cannot be larger than 7 days, or larger than 2 hours on REST protocol versions prior to
// version 2011-08-18. The visibility timeout of a message can be set to a value later than the expiry time. timeout is
// the The timeout parameter is expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations>Setting
// Timeouts for Queue Service Operations.</a> requestID is provides a client-generated, opaque value with a 1 KB
// character limit that is recorded in the analytics logs when storage analytics logging is enabled.
func (client messagesClient) Dequeue(ctx context.Context, numberOfMessages *int32, visibilitytimeout *int32, timeout *int32, requestID *string) (*QueueMessagesList, error) {
	if err := validate([]validation{
		{targetValue: numberOfMessages,
			constraints: []constraint{{target: "numberOfMessages", name: null, rule: false,
				chain: []constraint{{target: "numberOfMessages", name: inclusiveMinimum, rule: 1, chain: nil}}}}},
		{targetValue: visibilitytimeout,
			constraints: []constraint{{target: "visibilitytimeout", name: null, rule: false,
				chain: []constraint{{target: "visibilitytimeout", name: inclusiveMaximum, rule: 604800, chain: nil},
					{target: "visibilitytimeout", name: inclusiveMinimum, rule: 0, chain: nil},
				}}}},
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.dequeuePreparer(numberOfMessages, visibilitytimeout, timeout, requestID)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.dequeueResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*QueueMessagesList), err
}

// dequeuePreparer prepares the Dequeue request.
func (client messagesClient) dequeuePreparer(numberOfMessages *int32, visibilitytimeout *int32, timeout *int32, requestID *string) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("GET", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if numberOfMessages != nil {
		params.Set("numofmessages", strconv.FormatInt(int64(*numberOfMessages), 10))
	}
	if visibilitytimeout != nil {
		params.Set("visibilitytimeout", strconv.FormatInt(int64(*visibilitytimeout), 10))
	}
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	if requestID != nil {
		req.Header.Set("x-ms-client-request-id", *requestID)
	}
	return req, nil
}

// dequeueResponder handles the response to the Dequeue request.
func (client messagesClient) dequeueResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK)
	if resp == nil {
		return nil, err
	}
	result := &QueueMessagesList{rawResponse: resp.Response()}
	if err != nil {
		return result, err
	}
	defer resp.Response().Body.Close()
	b, err := ioutil.ReadAll(resp.Response().Body)
	if err != nil {
		return result, err
	}
	if len(b) > 0 {
		b = removeBOM(b)
		err = xml.Unmarshal(b, result)
		if err != nil {
			return result, NewResponseError(err, resp.Response(), "failed to unmarshal response body")
		}
	}
	return result, nil
}

// Enqueue the Enqueue operation adds a new message to the back of the message queue. A visibility timeout can also be
// specified to make the message invisible until the visibility timeout expires. A message must be in a format that can
// be included in an XML request with UTF-8 encoding. The encoded message can be up to 64 KB in size for versions
// 2011-08-18 and newer, or 8 KB in size for previous versions.
//
// queueMessage is a Message object which can be stored in a Queue visibilitytimeout is optional. Specifies the new
// visibility timeout value, in seconds, relative to server time. The default value is 30 seconds. A specified value
// must be larger than or equal to 1 second, and cannot be larger than 7 days, or larger than 2 hours on REST protocol
// versions prior to version 2011-08-18. The visibility timeout of a message can be set to a value later than the
// expiry time. messageTimeToLive is optional. Specifies the time-to-live interval for the message, in seconds. Prior
// to version 2017-07-29, the maximum time-to-live allowed is 7 days. For version 2017-07-29 or later, the maximum
// time-to-live can be any positive number, as well as -1 indicating that the message does not expire. If this
// parameter is omitted, the default time-to-live is 7 days. timeout is the The timeout parameter is expressed in
// seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations>Setting
// Timeouts for Queue Service Operations.</a> requestID is provides a client-generated, opaque value with a 1 KB
// character limit that is recorded in the analytics logs when storage analytics logging is enabled.
func (client messagesClient) Enqueue(ctx context.Context, queueMessage QueueMessage, visibilitytimeout *int32, messageTimeToLive *int32, timeout *int32, requestID *string) (*EnqueueResponse, error) {
	if err := validate([]validation{
		{targetValue: visibilitytimeout,
			constraints: []constraint{{target: "visibilitytimeout", name: null, rule: false,
				chain: []constraint{{target: "visibilitytimeout", name: inclusiveMaximum, rule: 604800, chain: nil},
					{target: "visibilitytimeout", name: inclusiveMinimum, rule: 0, chain: nil},
				}}}},
		{targetValue: messageTimeToLive,
			constraints: []constraint{{target: "messageTimeToLive", name: null, rule: false,
				chain: []constraint{{target: "messageTimeToLive", name: inclusiveMinimum, rule: -1, chain: nil}}}}},
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.enqueuePreparer(queueMessage, visibilitytimeout, messageTimeToLive, timeout, requestID)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.enqueueResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*EnqueueResponse), err
}

// enqueuePreparer prepares the Enqueue request.
func (client messagesClient) enqueuePreparer(queueMessage QueueMessage, visibilitytimeout *int32, messageTimeToLive *int32, timeout *int32, requestID *string) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("POST", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if visibilitytimeout != nil {
		params.Set("visibilitytimeout", strconv.FormatInt(int64(*visibilitytimeout), 10))
	}
	if messageTimeToLive != nil {
		params.Set("messagettl", strconv.FormatInt(int64(*messageTimeToLive), 10))
	}
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	if requestID != nil {
		req.Header.Set("x-ms-client-request-id", *requestID)
	}
	b, err := xml.Marshal(queueMessage)
	if err != nil {
		return req, pipeline.NewError(err, "failed to marshal request body")
	}
	req.Header.Set("Content-Type", "application/xml")
	err = req.SetBody(bytes.NewReader(b))
	if err != nil {
		return req, pipeline.NewError(err, "failed to set request body")
	}
	return req, nil
}

// enqueueResponder handles the response to the Enqueue request.
func (client messagesClient) enqueueResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK, http.StatusCreated)
	if resp == nil {
		return nil, err
	}
	result := &EnqueueResponse{rawResponse: resp.Response()}
	if err != nil {
		return result, err
	}
	defer resp.Response().Body.Close()
	b, err := ioutil.ReadAll(resp.Response().Body)
	if err != nil {
		return result, err
	}
	if len(b) > 0 {
		b = removeBOM(b)
		err = xml.Unmarshal(b, result)
		if err != nil {
			return result, NewResponseError(err, resp.Response(), "failed to unmarshal response body")
		}
	}
	return result, nil
}

// Peek the Peek operation retrieves one or more messages from the front of the queue, but does not alter the
// visibility of the message.
//
// numberOfMessages is optional. A nonzero integer value that specifies the number of messages to retrieve from the
// queue, up to a maximum of 32. If fewer are visible, the visible messages are returned. By default, a single message
// is retrieved from the queue with this operation. timeout is the The timeout parameter is expressed in seconds. For
// more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations>Setting
// Timeouts for Queue Service Operations.</a> requestID is provides a client-generated, opaque value with a 1 KB
// character limit that is recorded in the analytics logs when storage analytics logging is enabled.
func (client messagesClient) Peek(ctx context.Context, numberOfMessages *int32, timeout *int32, requestID *string) (*PeekResponse, error) {
	if err := validate([]validation{
		{targetValue: numberOfMessages,
			constraints: []constraint{{target: "numberOfMessages", name: null, rule: false,
				chain: []constraint{{target: "numberOfMessages", name: inclusiveMinimum, rule: 1, chain: nil}}}}},
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.peekPreparer(numberOfMessages, timeout, requestID)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.peekResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*PeekResponse), err
}

// peekPreparer prepares the Peek request.
func (client messagesClient) peekPreparer(numberOfMessages *int32, timeout *int32, requestID *string) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("GET", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	if numberOfMessages != nil {
		params.Set("numofmessages", strconv.FormatInt(int64(*numberOfMessages), 10))
	}
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	params.Set("peekonly", "true")
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	if requestID != nil {
		req.Header.Set("x-ms-client-request-id", *requestID)
	}
	return req, nil
}

// peekResponder handles the response to the Peek request.
func (client messagesClient) peekResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK)
	if resp == nil {
		return nil, err
	}
	result := &PeekResponse{rawResponse: resp.Response()}
	if err != nil {
		return result, err
	}
	defer resp.Response().Body.Close()
	b, err := ioutil.ReadAll(resp.Response().Body)
	if err != nil {
		return result, err
	}
	if len(b) > 0 {
		b = removeBOM(b)
		err = xml.Unmarshal(b, result)
		if err != nil {
			return result, NewResponseError(err, resp.Response(), "failed to unmarshal response body")
		}
	}
	return result, nil
}
