from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


CONF = _Mock()

_ = _Mock()

assert_interfaces_valid = _Mock()

canvas_to_axes = _Mock()

compute_angle = _Mock()

compute_center = _Mock()

compute_distance = _Mock()

compute_rect_size = _Mock()

np = _Mock()

unicode_literals = _Mock()

update_dataset = _Mock()

SIG_ANNOTATION_CHANGED = '2annotation_changed(PyQt_PyObject)'

SIG_ITEM_MOVED = '2item_moved(PyQt_PyObject,double,double,double,double)'

class AbstractShape(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class AnnotatedCircle(_Mock):
  pass
  AutoScale = 2
  LABEL_ANCHOR = u'C'
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class AnnotatedEllipse(_Mock):
  pass
  AutoScale = 2
  LABEL_ANCHOR = u'C'
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class AnnotatedObliqueRectangle(_Mock):
  pass
  AutoScale = 2
  LABEL_ANCHOR = u'C'
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class AnnotatedPoint(_Mock):
  pass
  AutoScale = 2
  LABEL_ANCHOR = u'TL'
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class AnnotatedRectangle(_Mock):
  pass
  AutoScale = 2
  LABEL_ANCHOR = u'TL'
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class AnnotatedSegment(_Mock):
  pass
  AutoScale = 2
  LABEL_ANCHOR = u'C'
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class AnnotatedShape(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class AnnotationParam(_Mock):
  pass


class DataInfoLabel(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _private = False
  _readonly = False

class EllipseShape(_Mock):
  pass
  ADDITIONNAL_POINTS = 0
  AutoScale = 2
  CLOSED = True
  LINK_ADDITIONNAL_POINTS = False
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class IBasePlotItem(_Mock):
  pass
  _can_move = True
  _can_resize = True
  _can_rotate = True
  _can_select = True
  _private = False
  _readonly = False
  selected = False

class ISerializableType(_Mock):
  pass


class IShapeItemType(_Mock):
  pass


class LabelParam(_Mock):
  pass
  _legend = False
  _multiselection = False
  _no_contents = True

class ObliqueRectangleShape(_Mock):
  pass
  ADDITIONNAL_POINTS = 2
  AutoScale = 2
  CLOSED = True
  LINK_ADDITIONNAL_POINTS = True
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class PointShape(_Mock):
  pass
  ADDITIONNAL_POINTS = 0
  AutoScale = 2
  CLOSED = False
  LINK_ADDITIONNAL_POINTS = False
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class RectangleShape(_Mock):
  pass
  ADDITIONNAL_POINTS = 0
  AutoScale = 2
  CLOSED = True
  LINK_ADDITIONNAL_POINTS = False
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

class SegmentShape(_Mock):
  pass
  ADDITIONNAL_POINTS = 1
  AutoScale = 2
  CLOSED = False
  LINK_ADDITIONNAL_POINTS = False
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _can_move = True
  _can_resize = True
  _can_rotate = False
  _can_select = True
  _private = False
  _readonly = False

