
#line 131 "qmljs.g"
/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtQml module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qmljsengine_p.h"
#include "qmljslexer_p.h"
#include "qmljsast_p.h"
#include "qmljsmemorypool_p.h"

#include <QtCore/qdebug.h>
#include <QtCore/qcoreapplication.h>

#include <string.h>


#line 489 "qmljs.g"


#include "qmljsparser_p.h"

#include <QtCore/qvarlengtharray.h>

//
//  W A R N I N G
//  -------------
//
// This file is automatically generated from qmljs.g.
// Changes should be made to that file, not here. Any change to this file will
// be lost!
//
// To regenerate this file, run:
//    qlalr --no-debug --no-lines --qt qmljs.g
//

#define UNIMPLEMENTED syntaxError(loc(1), "Unimplemented"); return false

using namespace QmlJS;

QT_QML_BEGIN_NAMESPACE

void Parser::reallocateStack()
{
    if (! stack_size)
        stack_size = 128;
    else
        stack_size <<= 1;

    sym_stack = reinterpret_cast<Value*> (realloc(sym_stack, stack_size * sizeof(Value)));
    state_stack = reinterpret_cast<int*> (realloc(state_stack, stack_size * sizeof(int)));
    location_stack = reinterpret_cast<AST::SourceLocation*> (realloc(location_stack, stack_size * sizeof(AST::SourceLocation)));
    string_stack.resize(stack_size);
    rawString_stack.resize(stack_size);
}

Parser::Parser(Engine *engine):
    driver(engine),
    pool(engine->pool())
{
}

Parser::~Parser()
{
    if (stack_size) {
        free(sym_stack);
        free(state_stack);
        free(location_stack);
    }
}

static inline AST::SourceLocation location(Lexer *lexer)
{
    AST::SourceLocation loc;
    loc.offset = lexer->tokenOffset();
    loc.length = lexer->tokenLength();
    loc.startLine = lexer->tokenStartLine();
    loc.startColumn = lexer->tokenStartColumn();
    return loc;
}

AST::UiQualifiedId *Parser::reparseAsQualifiedId(AST::ExpressionNode *expr)
{
    QVarLengthArray<QStringRef, 4> nameIds;
    QVarLengthArray<AST::SourceLocation, 4> locations;

    AST::ExpressionNode *it = expr;
    while (AST::FieldMemberExpression *m = AST::cast<AST::FieldMemberExpression *>(it)) {
        nameIds.append(m->name);
        locations.append(m->identifierToken);
        it = m->base;
    }

    if (AST::IdentifierExpression *idExpr = AST::cast<AST::IdentifierExpression *>(it)) {
        AST::UiQualifiedId *q = new (pool) AST::UiQualifiedId(idExpr->name);
        q->identifierToken = idExpr->identifierToken;

        AST::UiQualifiedId *currentId = q;
        for (int i = nameIds.size() - 1; i != -1; --i) {
            currentId = new (pool) AST::UiQualifiedId(currentId, nameIds[i]);
            currentId->identifierToken = locations[i];
        }

        return currentId->finish();
    }

    return 0;
}

void Parser::pushToken(int token)
{
    Q_ASSERT(last_token);
    Q_ASSERT(last_token < &token_buffer[TOKEN_BUFFER_SIZE]);
    last_token->token = yytoken;
    last_token->dval = yylval;
    last_token->spell = yytokenspell;
    last_token->raw = yytokenraw;
    last_token->loc = yylloc;
    ++last_token;
    yytoken = token;
}

int Parser::lookaheadToken(Lexer *lexer)
{
    if (yytoken < 0) {
        yytoken = lexer->lex();
        yylval = lexer->tokenValue();
        yytokenspell = lexer->tokenSpell();
        yytokenraw = lexer->rawString();
        yylloc = location(lexer);
    }
    return yytoken;
}

bool Parser::ensureNoFunctionTypeAnnotations(AST::TypeAnnotation *returnValueAnnotation, AST::FormalParameterList *formals)
{
    for (auto formal = formals; formal; formal = formal->next) {
        if (formal->element && formal->element->typeAnnotation) {
            syntaxError(formal->element->typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in function parameters in JavaScript functions");
            return false;
        }
    }
    if (returnValueAnnotation) {
        syntaxError(returnValueAnnotation->firstSourceLocation(), "Type annotations are not permitted for the return value of JavaScript functions");
        return false;
    }
    return true;
}

//#define PARSER_DEBUG

bool Parser::parse(int startToken)
{
    Lexer *lexer = driver->lexer();
    bool hadErrors = false;
    yytoken = -1;
    int action = 0;

    token_buffer[0].token = startToken;
    first_token = &token_buffer[0];
    if (startToken == T_FEED_JS_SCRIPT && !lexer->qmlMode()) {
        Directives ignoreDirectives;
        Directives *directives = driver->directives();
        if (!directives)
            directives = &ignoreDirectives;
        DiagnosticMessage error;
        if (!lexer->scanDirectives(directives, &error)) {
            diagnostic_messages.append(error);
            return false;
        }
        token_buffer[1].token = lexer->tokenKind();
        token_buffer[1].dval = lexer->tokenValue();
        token_buffer[1].loc = location(lexer);
        token_buffer[1].spell = lexer->tokenSpell();
        last_token = &token_buffer[2];
    } else {
        last_token = &token_buffer[1];
    }

    tos = -1;
    program = 0;

    do {
        if (++tos == stack_size)
            reallocateStack();

        state_stack[tos] = action;

    _Lcheck_token:
        if (yytoken == -1 && -TERMINAL_COUNT != action_index[action]) {
            yyprevlloc = yylloc;

            if (first_token == last_token) {
                yytoken = lexer->lex();
                yylval = lexer->tokenValue();
                yytokenspell = lexer->tokenSpell();
                yytokenraw = lexer->rawString();
                yylloc = location(lexer);
            } else {
                yytoken = first_token->token;
                yylval = first_token->dval;
                yytokenspell = first_token->spell;
                yytokenraw = first_token->raw;
                yylloc = first_token->loc;
                ++first_token;
                if (first_token == last_token)
                    first_token = last_token = &token_buffer[0];
            }
        }

#ifdef PARSER_DEBUG
       qDebug() << "   in state" << action;
#endif

        action = t_action(action, yytoken);
#ifdef PARSER_DEBUG
       qDebug() << "   current token" << yytoken << (yytoken >= 0 ? spell[yytoken] : "(null)") << "new state" << action;
#endif
        if (action > 0) {
            if (action != ACCEPT_STATE) {
                yytoken = -1;
                sym(1).dval = yylval;
                stringRef(1) = yytokenspell;
                rawStringRef(1) = yytokenraw;
                loc(1) = yylloc;
            } else {
              --tos;
              return ! hadErrors;
            }
        } else if (action < 0) {
          const int r = -action - 1;
          tos -= rhs[r];

#ifdef PARSER_DEBUG
          qDebug() << "        reducing through rule " << -action;
#endif

          switch (r) {

#line 716 "qmljs.g"

    case 0: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 724 "qmljs.g"

    case 1: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 732 "qmljs.g"

    case 2: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 740 "qmljs.g"

    case 3: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 748 "qmljs.g"

    case 4: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 756 "qmljs.g"

    case 5: {
        sym(1).Node = sym(2).Node;
        program = sym(1).Node;
    } break;

#line 765 "qmljs.g"

    case 6: {
        sym(1).UiProgram = new (pool) AST::UiProgram(sym(1).UiHeaderItemList, sym(2).UiObjectMemberList->finish());
    } break;

#line 773 "qmljs.g"

    case 8: {
        sym(1).Node = sym(1).UiHeaderItemList->finish();
    } break;

#line 780 "qmljs.g"

    case 9: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiPragma);
    } break;

#line 787 "qmljs.g"

    case 10: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiImport);
    } break;

#line 794 "qmljs.g"

    case 11: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiPragma);
    } break;

#line 801 "qmljs.g"

    case 12: {
        sym(1).Node = new (pool) AST::UiHeaderItemList(sym(1).UiHeaderItemList, sym(2).UiImport);
    } break;

#line 813 "qmljs.g"

    case 16: {
        AST::UiPragma *pragma = new (pool) AST::UiPragma(stringRef(2));
        pragma->pragmaToken = loc(1);
        pragma->semicolonToken = loc(3);
        sym(1).Node = pragma;
    } break;

#line 825 "qmljs.g"

    case 18: {
        sym(1).UiImport->semicolonToken = loc(2);
    } break;

#line 832 "qmljs.g"

    case 19: {
        auto version = new (pool) AST::UiVersionSpecifier(sym(1).dval, sym(3).dval);
        version->majorToken = loc(1);
        version->minorToken = loc(3);
        sym(1).UiVersionSpecifier = version;
    } break;

#line 843 "qmljs.g"

    case 20: {
        auto version = new (pool) AST::UiVersionSpecifier(sym(1).dval, 0);
        version->majorToken = loc(1);
        sym(1).UiVersionSpecifier = version;
    } break;

#line 852 "qmljs.g"

    case 21: {
        auto versionToken = loc(2);
        auto version = sym(2).UiVersionSpecifier;
        sym(1).UiImport->version = version;
        if (version->minorToken.isValid()) {
            versionToken.length += version->minorToken.length + (version->minorToken.offset - versionToken.offset - versionToken.length);
        }
        sym(1).UiImport->versionToken = versionToken;
        sym(1).UiImport->semicolonToken = loc(3);
    } break;

#line 866 "qmljs.g"

    case 22: {
        auto versionToken = loc(2);
        auto version = sym(2).UiVersionSpecifier;
        sym(1).UiImport->version = version;
        if (version->minorToken.isValid()) {
            versionToken.length += version->minorToken.length + (version->minorToken.offset - versionToken.offset - versionToken.length);
        }
        sym(1).UiImport->versionToken = versionToken;
        sym(1).UiImport->asToken = loc(3);
        sym(1).UiImport->importIdToken = loc(4);
        sym(1).UiImport->importId = stringRef(4);
        sym(1).UiImport->semicolonToken = loc(5);
    } break;

#line 878 "qmljs.g"

    case 23: {
        sym(1).UiImport->asToken = loc(2);
        sym(1).UiImport->importIdToken = loc(3);
        sym(1).UiImport->importId = stringRef(3);
        sym(1).UiImport->semicolonToken = loc(4);
    } break;

#line 888 "qmljs.g"

    case 24: {
        AST::UiImport *node = 0;

        if (AST::StringLiteral *importIdLiteral = AST::cast<AST::StringLiteral *>(sym(2).Expression)) {
            node = new (pool) AST::UiImport(importIdLiteral->value);
            node->fileNameToken = loc(2);
        } else if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(2).Expression)) {
            node = new (pool) AST::UiImport(qualifiedId);
            node->fileNameToken = loc(2);
        }

        sym(1).Node = node;

        if (node) {
            node->importToken = loc(1);
        } else {
            diagnostic_messages.append(compileError(loc(1),
             QLatin1String("Expected a qualified name id or a string literal")));

            return false; // ### remove me
        }
    } break;

#line 914 "qmljs.g"

    case 25: {
        sym(1).Node = nullptr;
    } break;

#line 921 "qmljs.g"

    case 26: {
        sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
    } break;

#line 928 "qmljs.g"

    case 27: {
        sym(1).Node = new (pool) AST::UiObjectMemberList(sym(1).UiObjectMember);
    } break;

#line 935 "qmljs.g"

    case 28: {
        AST::UiObjectMemberList *node = new (pool) AST:: UiObjectMemberList(sym(1).UiObjectMemberList, sym(2).UiObjectMember);
        sym(1).Node = node;
    } break;

#line 943 "qmljs.g"

    case 29: {
        sym(1).Node = new (pool) AST::UiArrayMemberList(sym(1).UiObjectMember);
    } break;

#line 950 "qmljs.g"

    case 30: {
        AST::UiArrayMemberList *node = new (pool) AST::UiArrayMemberList(sym(1).UiArrayMemberList, sym(3).UiObjectMember);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 959 "qmljs.g"

    case 31: {
        AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer((AST::UiObjectMemberList*)0);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(2);
        sym(1).Node = node;
    } break;

#line 969 "qmljs.g"

    case 32: {
        AST::UiObjectInitializer *node = new (pool) AST::UiObjectInitializer(sym(2).UiObjectMemberList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 979 "qmljs.g"

    case 33: {
        AST::UiObjectDefinition *node = new (pool) AST::UiObjectDefinition(sym(1).UiQualifiedId, sym(2).UiObjectInitializer);
        sym(1).Node = node;
    } break;

#line 989 "qmljs.g"

    case 35: {
        AST::UiArrayBinding *node = new (pool) AST::UiArrayBinding(sym(1).UiQualifiedId, sym(5).UiArrayMemberList->finish());
        node->colonToken = loc(2);
        node->lbracketToken = loc(4);
        node->rbracketToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1000 "qmljs.g"

    case 36: {
        AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
            sym(1).UiQualifiedId, sym(4).UiQualifiedId, sym(5).UiObjectInitializer);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1010 "qmljs.g"

    case 37: {
        AST::UiObjectBinding *node = new (pool) AST::UiObjectBinding(
          sym(3).UiQualifiedId, sym(1).UiQualifiedId, sym(4).UiObjectInitializer);
        node->colonToken = loc(2);
        node->hasOnToken = true;
        sym(1).Node = node;
    } break;

#line 1022 "qmljs.g"
  case 38: Q_FALLTHROUGH();
#line 1024 "qmljs.g"

    case 39: {
        AST::ObjectPattern *l = new (pool) AST::ObjectPattern(sym(3).PatternPropertyList->finish());
        l->lbraceToken = loc(1);
        l->rbraceToken = loc(4);
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(l);
        sym(1).Node = node;
    } break;

#line 1036 "qmljs.g"
  case 40: Q_FALLTHROUGH();
#line 1038 "qmljs.g"
  case 41: Q_FALLTHROUGH();
#line 1040 "qmljs.g"

    case 42: {
        sym(1).Node = sym(3).Node;
    } break;

#line 1048 "qmljs.g"
  case 43: Q_FALLTHROUGH();
#line 1050 "qmljs.g"
  case 44: Q_FALLTHROUGH();
#line 1052 "qmljs.g"
  case 45: Q_FALLTHROUGH();
#line 1054 "qmljs.g"
  case 46: Q_FALLTHROUGH();
#line 1056 "qmljs.g"
  case 47: Q_FALLTHROUGH();
#line 1058 "qmljs.g"

    case 48: {
        sym(1).Node = sym(2).Node;
    } break;

#line 1065 "qmljs.g"

case 49:
{
    AST::UiScriptBinding *node = new (pool) AST::UiScriptBinding(sym(1).UiQualifiedId, sym(3).Statement);
    node->colonToken = loc(2);
    sym(1).Node = node;
    } break;

#line 1075 "qmljs.g"
  case 50: Q_FALLTHROUGH();
#line 1077 "qmljs.g"
  case 51: Q_FALLTHROUGH();
#line 1079 "qmljs.g"

    case 52: {
        AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1088 "qmljs.g"

    case 53: {
        AST::UiQualifiedId *node = new (pool) AST::UiQualifiedId(sym(1).UiQualifiedId, stringRef(3));
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1097 "qmljs.g"

    case 54: {
        sym(1).Node = nullptr;
    } break;

#line 1104 "qmljs.g"

    case 55: {
        sym(1).Node = sym(1).UiParameterList->finish();
    } break;

#line 1111 "qmljs.g"

    case 56: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(3).UiQualifiedId->finish(), stringRef(1));
        node->identifierToken = loc(1);
        node->colonToken = loc(2);
        node->propertyTypeToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1122 "qmljs.g"

    case 57: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiQualifiedId->finish(), stringRef(2));
        node->propertyTypeToken = loc(1);
        node->identifierToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1132 "qmljs.g"

    case 58: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiParameterList, sym(5).UiQualifiedId->finish(), stringRef(3));
        node->propertyTypeToken = loc(5);
        node->commaToken = loc(2);
        node->identifierToken = loc(3);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1144 "qmljs.g"

    case 59: {
        AST::UiParameterList *node = new (pool) AST::UiParameterList(sym(1).UiParameterList, sym(3).UiQualifiedId->finish(), stringRef(4));
        node->propertyTypeToken = loc(3);
        node->commaToken = loc(2);
        node->identifierToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1155 "qmljs.g"

    case 60: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
        node->type = AST::UiPublicMember::Signal;
        node->propertyToken = loc(1);
        node->typeToken = loc(2);
        node->identifierToken = loc(2);
        node->parameters = sym(4).UiParameterList;
        node->semicolonToken = loc(6);
        sym(1).Node = node;
    } break;

#line 1169 "qmljs.g"

    case 61: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(nullptr, stringRef(2));
        node->type = AST::UiPublicMember::Signal;
        node->propertyToken = loc(1);
        node->typeToken = loc(2);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1182 "qmljs.g"

    case 62: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
        node->typeModifier = stringRef(2);
        node->propertyToken = loc(1);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->semicolonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 1198 "qmljs.g"

    case 64: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isReadonlyMember = true;
        node->readonlyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1208 "qmljs.g"

    case 65: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
        node->propertyToken = loc(1);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->semicolonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1223 "qmljs.g"

    case 67: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isDefaultMember = true;
        node->defaultToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1233 "qmljs.g"

    case 68: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isDefaultMember = true;
        node->defaultToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1243 "qmljs.g"

/* we need OptionalSemicolon because UiScriptStatement might already parse the last semicolon
  and then we would miss a semicolon (see tests/auto/quick/qquickvisualdatamodel/data/objectlist.qml)*/

#line 1249 "qmljs.g"

    case 71: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->requiredToken = loc(1);
        node->isRequired = true;
        sym(1).Node = node;
    } break;

#line 1260 "qmljs.g"

    case 72: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3), sym(5).Statement);
        node->propertyToken = loc(1);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1274 "qmljs.g"

    case 74: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isReadonlyMember = true;
        node->readonlyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1284 "qmljs.g"

    case 75: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isDefaultMember = true;
        node->defaultToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1294 "qmljs.g"

    case 76: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(4).UiQualifiedId->finish(), stringRef(6));
        node->typeModifier = stringRef(2);
        node->propertyToken = loc(1);
        node->typeModifierToken = loc(2);
        node->typeToken = loc(4);
        node->identifierToken = loc(6);
        node->semicolonToken = loc(7); // insert a fake ';' before ':'

        AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(6));
        propertyName->identifierToken = loc(6);
        propertyName->next = 0;

        AST::UiArrayBinding *binding = new (pool) AST::UiArrayBinding(propertyName, sym(9).UiArrayMemberList->finish());
        binding->colonToken = loc(7);
        binding->lbracketToken = loc(8);
        binding->rbracketToken = loc(10);

        node->binding = binding;

        sym(1).Node = node;
    } break;

#line 1322 "qmljs.g"

    case 78: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isReadonlyMember = true;
        node->readonlyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1332 "qmljs.g"

    case 79: {
        AST::UiPublicMember *node = new (pool) AST::UiPublicMember(sym(2).UiQualifiedId->finish(), stringRef(3));
        node->propertyToken = loc(1);
        node->typeToken = loc(2);
        node->identifierToken = loc(3);
        node->semicolonToken = loc(4); // insert a fake ';' before ':'

        AST::UiQualifiedId *propertyName = new (pool) AST::UiQualifiedId(stringRef(3));
        propertyName->identifierToken = loc(3);
        propertyName->next = 0;

        AST::UiObjectBinding *binding = new (pool) AST::UiObjectBinding(
          propertyName, sym(6).UiQualifiedId, sym(7).UiObjectInitializer);
        binding->colonToken = loc(4);

        node->binding = binding;

        sym(1).Node = node;
    } break;

#line 1357 "qmljs.g"

    case 81: {
        AST::UiPublicMember *node = sym(2).UiPublicMember;
        node->isReadonlyMember = true;
        node->readonlyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1367 "qmljs.g"

    case 82: {
        auto node = new (pool) AST::UiSourceElement(sym(1).Node);
        sym(1).Node = node;
    } break;

#line 1375 "qmljs.g"

    case 83: {
        sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
    } break;

#line 1382 "qmljs.g"

    case 84: {
        sym(1).Node = new (pool) AST::UiSourceElement(sym(1).Node);
    } break;

#line 1389 "qmljs.g"

    case 85: {
      if (AST::ArrayMemberExpression *mem = AST::cast<AST::ArrayMemberExpression *>(sym(1).Expression)) {
        diagnostic_messages.append(compileError(mem->lbracketToken,
          QLatin1String("Ignored annotation"), Severity::Warning));

        sym(1).Expression = mem->base;
      }

      if (AST::UiQualifiedId *qualifiedId = reparseAsQualifiedId(sym(1).Expression)) {
        sym(1).UiQualifiedId = qualifiedId;
      } else {
        sym(1).UiQualifiedId = 0;

        diagnostic_messages.append(compileError(loc(1),
          QLatin1String("Expected a qualified name id")));

        return false; // ### recover
      }
    } break;

#line 1412 "qmljs.g"

    case 86: {
        AST::UiEnumDeclaration *enumDeclaration = new (pool) AST::UiEnumDeclaration(stringRef(2), sym(4).UiEnumMemberList->finish());
        enumDeclaration->enumToken = loc(1);
        enumDeclaration->rbraceToken = loc(5);
        sym(1).Node = enumDeclaration;
        break;
    }

#line 1423 "qmljs.g"

    case 87: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1));
        node->memberToken = loc(1);
        sym(1).Node = node;
        break;
    }

#line 1433 "qmljs.g"

    case 88: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(stringRef(1), sym(3).dval);
        node->memberToken = loc(1);
        node->valueToken = loc(3);
        sym(1).Node = node;
        break;
    }

#line 1444 "qmljs.g"

    case 89: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3));
        node->memberToken = loc(3);
        sym(1).Node = node;
        break;
    }

#line 1454 "qmljs.g"

    case 90: {
        AST::UiEnumMemberList *node = new (pool) AST::UiEnumMemberList(sym(1).UiEnumMemberList, stringRef(3), sym(5).dval);
        node->memberToken = loc(3);
        node->valueToken = loc(5);
        sym(1).Node = node;
        break;
    }

#line 1496 "qmljs.g"

    case 115: {
        sym(1).TypeArgumentList = new (pool) AST::TypeArgumentList(sym(1).Type);
    } break;

#line 1503 "qmljs.g"

    case 116: {
        sym(1).TypeArgumentList = new (pool) AST::TypeArgumentList(sym(1).TypeArgumentList, sym(3).Type);
    } break;

#line 1510 "qmljs.g"

    case 117: {
        sym(1).Type = new (pool) AST::Type(sym(1).UiQualifiedId, sym(3).TypeArgumentList->finish());
    } break;

#line 1517 "qmljs.g"

    case 118: {
        AST::UiQualifiedId *id = new (pool) AST::UiQualifiedId(stringRef(1));
        id->identifierToken = loc(1);
        sym(1).Type = new (pool) AST::Type(id->finish());
    } break;

#line 1526 "qmljs.g"

    case 119: {
        sym(1).Type = new (pool) AST::Type(sym(1).UiQualifiedId);
    } break;

#line 1533 "qmljs.g"

    case 120: {
        sym(1).TypeAnnotation = new (pool) AST::TypeAnnotation(sym(2).Type);
        sym(1).TypeAnnotation->colonToken = loc(1);
    } break;

#line 1542 "qmljs.g"

    case 122: {
        sym(1).TypeAnnotation = nullptr;
    } break;

#line 1553 "qmljs.g"

    case 123: {
        AST::ThisExpression *node = new (pool) AST::ThisExpression();
        node->thisToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1562 "qmljs.g"

    case 124: {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1580 "qmljs.g"

    case 133: {
        if (coverExpressionType != CE_ParenthesizedExpression) {
            syntaxError(coverExpressionErrorLocation, "Expected token ')'.");
            return false;
        }
    } break;

#line 1591 "qmljs.g"

    case 134: {
        AST::NestedExpression *node = new (pool) AST::NestedExpression(sym(2).Expression);
        node->lparenToken = loc(1);
        node->rparenToken = loc(3);
        sym(1).Node = node;
        coverExpressionType = CE_ParenthesizedExpression;
    } break;

#line 1602 "qmljs.g"

    case 135: {
        sym(1).Node = nullptr;
        coverExpressionErrorLocation = loc(2);
        coverExpressionType = CE_FormalParameterList;
    } break;

#line 1611 "qmljs.g"

    case 136: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(2).PatternElement))->finish(pool);
        sym(1).Node = node;
        coverExpressionErrorLocation = loc(2);
        coverExpressionType = CE_FormalParameterList;
    } break;

#line 1621 "qmljs.g"

    case 137: {
        AST::FormalParameterList *list = sym(2).Expression->reparseAsFormalParameterList(pool);
        if (!list) {
            syntaxError(loc(1), "Invalid Arrow parameter list.");
            return false;
        }
        if (sym(4).Node) {
            list = new (pool) AST::FormalParameterList(list, sym(4).PatternElement);
        }
        coverExpressionErrorLocation = loc(4);
        coverExpressionType = CE_FormalParameterList;
        sym(1).Node = list->finish(pool);
    } break;

#line 1638 "qmljs.g"

    case 138: {
        AST::NullExpression *node = new (pool) AST::NullExpression();
        node->nullToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1647 "qmljs.g"

    case 139: {
        AST::TrueLiteral *node = new (pool) AST::TrueLiteral();
        node->trueToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1656 "qmljs.g"

    case 140: {
        AST::FalseLiteral *node = new (pool) AST::FalseLiteral();
        node->falseToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1665 "qmljs.g"

    case 141: {
        AST::NumericLiteral *node = new (pool) AST::NumericLiteral(sym(1).dval);
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1674 "qmljs.g"
  case 142: Q_FALLTHROUGH();
#line 1677 "qmljs.g"

    case 143: {
        AST::StringLiteral *node = new (pool) AST::StringLiteral(stringRef(1));
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1689 "qmljs.g"

{
    Lexer::RegExpBodyPrefix prefix;
    case 144:
        prefix = Lexer::NoPrefix;
        goto scan_regexp;

#line 1701 "qmljs.g"

    case 145:
        prefix = Lexer::EqualPrefix;
        goto scan_regexp;

    scan_regexp: {
        bool rx = lexer->scanRegExp(prefix);
        if (!rx) {
            diagnostic_messages.append(compileError(location(lexer), lexer->errorMessage()));
            return false;
        }

        loc(1).length = lexer->tokenLength();
        yylloc = loc(1); // adjust the location of the current token

        AST::RegExpLiteral *node = new (pool) AST::RegExpLiteral(driver->newStringRef(lexer->regExpPattern()), lexer->regExpFlags());
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;
}

#line 1725 "qmljs.g"

    case 146: {
        AST::PatternElementList *list = nullptr;
        if (sym(2).Elision)
            list = (new (pool) AST::PatternElementList(sym(2).Elision, nullptr))->finish();
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(list);
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1738 "qmljs.g"

    case 147: {
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(sym(2).PatternElementList->finish());
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1748 "qmljs.g"

    case 148: {
        auto *list = sym(2).PatternElementList;
        if (sym(4).Elision) {
            AST::PatternElementList *l = new (pool) AST::PatternElementList(sym(4).Elision, nullptr);
            list = list->append(l);
        }
        AST::ArrayPattern *node = new (pool) AST::ArrayPattern(list->finish());
        node->lbracketToken = loc(1);
        node->commaToken = loc(3);
        node->rbracketToken = loc(5);
        sym(1).Node = node;
        Q_ASSERT(node->isValidArrayLiteral());
    } break;

#line 1765 "qmljs.g"

    case 149: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(1).Expression);
        sym(1).Node = new (pool) AST::PatternElementList(nullptr, e);
    } break;

#line 1773 "qmljs.g"

    case 150: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(2).Expression);
        sym(1).Node = new (pool) AST::PatternElementList(sym(1).Elision->finish(), e);
    } break;

#line 1781 "qmljs.g"

    case 151: {
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
        sym(1).Node = node;
    } break;

#line 1789 "qmljs.g"

    case 152: {
        AST::PatternElement *e = new (pool) AST::PatternElement(sym(4).Expression);
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(3).Elision, e);
        sym(1).Node = sym(1).PatternElementList->append(node);
    } break;

#line 1798 "qmljs.g"

    case 153: {
        AST::PatternElementList *node = new (pool) AST::PatternElementList(sym(3).Elision, sym(4).PatternElement);
        sym(1).Node = sym(1).PatternElementList->append(node);
    } break;

#line 1806 "qmljs.g"

    case 154: {
        AST::Elision *node = new (pool) AST::Elision();
        node->commaToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1815 "qmljs.g"

    case 155: {
        AST::Elision *node = new (pool) AST::Elision(sym(1).Elision);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1824 "qmljs.g"

    case 156: {
        sym(1).Node = nullptr;
    } break;

#line 1831 "qmljs.g"

    case 157: {
        sym(1).Node = sym(1).Elision->finish();
    } break;

#line 1838 "qmljs.g"

    case 158: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(2).Expression, AST::PatternElement::SpreadElement);
        sym(1).Node = node;
    } break;

#line 1846 "qmljs.g"

    case 159: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern();
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1856 "qmljs.g"

    case 160: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 1866 "qmljs.g"

    case 161: {
        AST::ObjectPattern *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList->finish());
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(4);
        sym(1).Node = node;
    } break;

#line 1877 "qmljs.g"
  case 162: Q_FALLTHROUGH();
#line 1879 "qmljs.g"

    case 163: {
      sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternProperty);
    } break;

#line 1886 "qmljs.g"
  case 164: Q_FALLTHROUGH();
#line 1888 "qmljs.g"

    case 165: {
        AST::PatternPropertyList *node = new (pool) AST::PatternPropertyList(sym(1).PatternPropertyList, sym(3).PatternProperty);
        sym(1).Node = node;
    } break;

#line 1896 "qmljs.g"

    case 166: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        AST::IdentifierExpression *expr = new (pool) AST::IdentifierExpression(stringRef(1));
        expr->identifierToken = loc(1);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, expr);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1912 "qmljs.g"

    case 168: {
        AST::IdentifierPropertyName *name = new (pool) AST::IdentifierPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        AST::IdentifierExpression *left = new (pool) AST::IdentifierExpression(stringRef(1));
        left->identifierToken = loc(1);
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(2).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(2).Expression))
            c->name = stringRef(1);
        AST::BinaryExpression *assignment = new (pool) AST::BinaryExpression(left, QSOperator::Assign, sym(2).Expression);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(name, assignment);
        node->colonToken = loc(1);
        sym(1).Node = node;

    } break;

#line 1932 "qmljs.g"
  case 169: Q_FALLTHROUGH();
#line 1934 "qmljs.g"

    case 170: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, sym(3).Expression);
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression)) {
            if (!AST::cast<AST::ComputedPropertyName *>(sym(1).PropertyName))
                c->name = driver->newStringRef(sym(1).PropertyName->asString());
        }
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 1952 "qmljs.g"

    case 174: {
        AST::IdentifierPropertyName *node = new (pool) AST::IdentifierPropertyName(stringRef(1));
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1961 "qmljs.g"
  case 175: Q_FALLTHROUGH();
#line 1963 "qmljs.g"

    case 176: {
        AST::StringLiteralPropertyName *node = new (pool) AST::StringLiteralPropertyName(stringRef(1));
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 1972 "qmljs.g"
  case 177: Q_FALLTHROUGH();
#line 1974 "qmljs.g"

    case 178: {
        AST::NumericLiteralPropertyName *node = new (pool) AST::NumericLiteralPropertyName(sym(1).dval);
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2025 "qmljs.g"

    case 219: {
        AST::ComputedPropertyName *node = new (pool) AST::ComputedPropertyName(sym(2).Expression);
        node->propertyNameToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2034 "qmljs.g"
  case 220: Q_FALLTHROUGH();
#line 2036 "qmljs.g"

case 221: {
    sym(1) = sym(2);
} break;

#line 2044 "qmljs.g"
  case 222: Q_FALLTHROUGH();
#line 2046 "qmljs.g"

    case 223: {
        sym(1).Node = nullptr;
    } break;

#line 2056 "qmljs.g"
  case 226: Q_FALLTHROUGH();
#line 2059 "qmljs.g"

    case 227: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), nullptr);
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2068 "qmljs.g"
  case 228: Q_FALLTHROUGH();
#line 2071 "qmljs.g"

    case 229: {
        AST::TemplateLiteral *node = new (pool) AST::TemplateLiteral(stringRef(1), rawStringRef(1), sym(2).Expression);
        node->next = sym(3).Template;
        node->literalToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2084 "qmljs.g"

    case 231: {
        AST::SuperLiteral *node = new (pool) AST::SuperLiteral();
        node->superToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2094 "qmljs.g"
  case 232: Q_FALLTHROUGH();
#line 2096 "qmljs.g"

    case 233: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
        node->lbracketToken = loc(2);
        node->rbracketToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2108 "qmljs.g"
  case 234:
    {
        AST::IdentifierExpression *node = new (pool) AST::IdentifierExpression(stringRef(1));
        node->identifierToken= loc(1);
        sym(1).Node = node;
    } Q_FALLTHROUGH();

#line 2116 "qmljs.g"
  case 235: Q_FALLTHROUGH();
#line 2118 "qmljs.g"

    case 236: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2130 "qmljs.g"

    case 238: {
        AST::NewMemberExpression *node = new (pool) AST::NewMemberExpression(sym(2).Expression, sym(4).ArgumentList);
        node->newToken = loc(1);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        sym(1).Node = node;
    } break;

#line 2146 "qmljs.g"

    case 241: {
        AST::NewExpression *node = new (pool) AST::NewExpression(sym(2).Expression);
        node->newToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2156 "qmljs.g"
  case 242: Q_FALLTHROUGH();
#line 2158 "qmljs.g"

    case 243: {
        AST::TaggedTemplate *node = new (pool) AST::TaggedTemplate(sym(1).Expression, sym(2).Template);
        sym(1).Node = node;
    } break;

#line 2166 "qmljs.g"

    case 244: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2176 "qmljs.g"
  case 245: Q_FALLTHROUGH();
#line 2178 "qmljs.g"

    case 246: {
        AST::CallExpression *node = new (pool) AST::CallExpression(sym(1).Expression, sym(3).ArgumentList);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2188 "qmljs.g"

    case 247: {
        AST::ArrayMemberExpression *node = new (pool) AST::ArrayMemberExpression(sym(1).Expression, sym(3).Expression);
        node->lbracketToken = loc(2);
        node->rbracketToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2198 "qmljs.g"

    case 248: {
        AST::FieldMemberExpression *node = new (pool) AST::FieldMemberExpression(sym(1).Expression, stringRef(3));
        node->dotToken = loc(2);
        node->identifierToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2208 "qmljs.g"

    case 249: {
        sym(1).Node = nullptr;
    } break;

#line 2215 "qmljs.g"
  case 250: Q_FALLTHROUGH();
#line 2217 "qmljs.g"

    case 251: {
        sym(1).Node = sym(1).ArgumentList->finish();
    } break;

#line 2224 "qmljs.g"

    case 252: {
        sym(1).Node = new (pool) AST::ArgumentList(sym(1).Expression);
    } break;

#line 2231 "qmljs.g"

    case 253: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(2).Expression);
        node->isSpreadElement = true;
        sym(1).Node = node;
    } break;

#line 2240 "qmljs.g"

    case 254: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(1).ArgumentList, sym(3).Expression);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2249 "qmljs.g"

    case 255: {
        AST::ArgumentList *node = new (pool) AST::ArgumentList(sym(1).ArgumentList, sym(4).Expression);
        node->commaToken = loc(2);
        node->isSpreadElement = true;
        sym(1).Node = node;
    } break;

#line 2264 "qmljs.g"

    case 259: {
        AST::PostIncrementExpression *node = new (pool) AST::PostIncrementExpression(sym(1).Expression);
        node->incrementToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2273 "qmljs.g"

    case 260: {
        AST::PostDecrementExpression *node = new (pool) AST::PostDecrementExpression(sym(1).Expression);
        node->decrementToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2282 "qmljs.g"

    case 261: {
        AST::PreIncrementExpression *node = new (pool) AST::PreIncrementExpression(sym(2).Expression);
        node->incrementToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2291 "qmljs.g"

    case 262: {
        AST::PreDecrementExpression *node = new (pool) AST::PreDecrementExpression(sym(2).Expression);
        node->decrementToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2302 "qmljs.g"

    case 264: {
        AST::DeleteExpression *node = new (pool) AST::DeleteExpression(sym(2).Expression);
        node->deleteToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2311 "qmljs.g"

    case 265: {
        AST::VoidExpression *node = new (pool) AST::VoidExpression(sym(2).Expression);
        node->voidToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2320 "qmljs.g"

    case 266: {
        AST::TypeOfExpression *node = new (pool) AST::TypeOfExpression(sym(2).Expression);
        node->typeofToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2329 "qmljs.g"

    case 267: {
        AST::UnaryPlusExpression *node = new (pool) AST::UnaryPlusExpression(sym(2).Expression);
        node->plusToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2338 "qmljs.g"

    case 268: {
        AST::UnaryMinusExpression *node = new (pool) AST::UnaryMinusExpression(sym(2).Expression);
        node->minusToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2347 "qmljs.g"

    case 269: {
        AST::TildeExpression *node = new (pool) AST::TildeExpression(sym(2).Expression);
        node->tildeToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2356 "qmljs.g"

    case 270: {
        AST::NotExpression *node = new (pool) AST::NotExpression(sym(2).Expression);
        node->notToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2367 "qmljs.g"

    case 272: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Exp, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2378 "qmljs.g"

    case 274: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2387 "qmljs.g"

    case 275: {
        sym(1).ival = QSOperator::Mul;
    } break;

#line 2394 "qmljs.g"

    case 276: {
        sym(1).ival = QSOperator::Div;
    } break;

#line 2401 "qmljs.g"

    case 277: {
        sym(1).ival = QSOperator::Mod;
    } break;

#line 2410 "qmljs.g"

    case 279: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Add, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2419 "qmljs.g"

    case 280: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Sub, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2430 "qmljs.g"

    case 282: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::LShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2439 "qmljs.g"

    case 283: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::RShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2448 "qmljs.g"

    case 284: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::URShift, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2460 "qmljs.g"
  case 287: Q_FALLTHROUGH();
#line 2462 "qmljs.g"

    case 288: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2471 "qmljs.g"

    case 289: {
        sym(1).ival = QSOperator::Lt;
    } break;

#line 2477 "qmljs.g"

    case 290: {
        sym(1).ival = QSOperator::Gt;
    } break;

#line 2483 "qmljs.g"

    case 291: {
        sym(1).ival = QSOperator::Le;
    } break;

#line 2489 "qmljs.g"

    case 292: {
        sym(1).ival = QSOperator::Ge;
    } break;

#line 2495 "qmljs.g"

    case 293: {
        sym(1).ival = QSOperator::InstanceOf;
    } break;

#line 2502 "qmljs.g"

    case 294: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::In, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2514 "qmljs.g"
  case 297: Q_FALLTHROUGH();
#line 2516 "qmljs.g"

    case 298: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2525 "qmljs.g"

    case 299: {
        sym(1).ival = QSOperator::Equal;
    } break;

#line 2531 "qmljs.g"

    case 300: {
        sym(1).ival = QSOperator::NotEqual;
    } break;

#line 2537 "qmljs.g"

    case 301: {
        sym(1).ival = QSOperator::StrictEqual;
    } break;

#line 2543 "qmljs.g"

    case 302: {
        sym(1).ival = QSOperator::StrictNotEqual;
    } break;

#line 2554 "qmljs.g"
  case 305: Q_FALLTHROUGH();
#line 2556 "qmljs.g"

    case 306: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitAnd, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2569 "qmljs.g"
  case 309: Q_FALLTHROUGH();
#line 2571 "qmljs.g"

    case 310: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitXor, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2583 "qmljs.g"
  case 313: Q_FALLTHROUGH();
#line 2585 "qmljs.g"

    case 314: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::BitOr, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2597 "qmljs.g"
  case 317: Q_FALLTHROUGH();
#line 2599 "qmljs.g"

    case 318: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::And, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2611 "qmljs.g"
  case 321: Q_FALLTHROUGH();
#line 2613 "qmljs.g"

    case 322: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Or, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2626 "qmljs.g"
  case 325: Q_FALLTHROUGH();
#line 2628 "qmljs.g"

    case 326: {
        AST::ConditionalExpression *node = new (pool) AST::ConditionalExpression(sym(1).Expression, sym(3).Expression, sym(5).Expression);
        node->questionToken = loc(2);
        node->colonToken = loc(4);
        sym(1).Node = node;
    } break;

#line 2647 "qmljs.g"
  case 333: Q_FALLTHROUGH();
#line 2649 "qmljs.g"

    case 334: {
        // need to convert the LHS to an AssignmentPattern if it was an Array/ObjectLiteral
        if (AST::Pattern *p = sym(1).Expression->patternCast()) {
            AST::SourceLocation errorLoc;
            QString errorMsg;
            if (!p->convertLiteralToAssignmentPattern(pool, &errorLoc, &errorMsg)) {
                syntaxError(errorLoc, errorMsg);
                return false;
            }
        }
        // if lhs is an identifier expression and rhs is an anonymous function expression, we need to assign the name of lhs to the function
        if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression)) {
            if (auto *id = AST::cast<AST::IdentifierExpression *>(sym(1).Expression))
                f->name = id->name;
        }
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression)) {
            if (auto *id = AST::cast<AST::IdentifierExpression *>(sym(1).Expression))
                c->name = id->name;
        }

        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, QSOperator::Assign, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2677 "qmljs.g"
  case 335: Q_FALLTHROUGH();
#line 2679 "qmljs.g"

    case 336: {
        AST::BinaryExpression *node = new (pool) AST::BinaryExpression(sym(1).Expression, sym(2).ival, sym(3).Expression);
        node->operatorToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2688 "qmljs.g"

    case 337: {
        sym(1).ival = QSOperator::InplaceMul;
    } break;

#line 2695 "qmljs.g"

    case 338: {
        sym(1).ival = QSOperator::InplaceExp;
    } break;

#line 2702 "qmljs.g"

    case 339: {
        sym(1).ival = QSOperator::InplaceDiv;
    } break;

#line 2709 "qmljs.g"

    case 340: {
        sym(1).ival = QSOperator::InplaceMod;
    } break;

#line 2716 "qmljs.g"

    case 341: {
        sym(1).ival = QSOperator::InplaceAdd;
    } break;

#line 2723 "qmljs.g"

    case 342: {
        sym(1).ival = QSOperator::InplaceSub;
    } break;

#line 2730 "qmljs.g"

    case 343: {
        sym(1).ival = QSOperator::InplaceLeftShift;
    } break;

#line 2737 "qmljs.g"

    case 344: {
        sym(1).ival = QSOperator::InplaceRightShift;
    } break;

#line 2744 "qmljs.g"

    case 345: {
        sym(1).ival = QSOperator::InplaceURightShift;
    } break;

#line 2751 "qmljs.g"

    case 346: {
        sym(1).ival = QSOperator::InplaceAnd;
    } break;

#line 2758 "qmljs.g"

    case 347: {
        sym(1).ival = QSOperator::InplaceXor;
    } break;

#line 2765 "qmljs.g"

    case 348: {
        sym(1).ival = QSOperator::InplaceOr;
    } break;

#line 2775 "qmljs.g"
  case 351: Q_FALLTHROUGH();
#line 2777 "qmljs.g"

    case 352: {
          AST::Expression *node = new (pool) AST::Expression(sym(1).Expression, sym(3).Expression);
          node->commaToken = loc(2);
          sym(1).Node = node;
    } break;

#line 2786 "qmljs.g"
  case 353: Q_FALLTHROUGH();
#line 2788 "qmljs.g"

    case 354: {
      sym(1).Node = nullptr;
    } break;

#line 2800 "qmljs.g"

    case 357: {
        sym(1).Node = sym(3).Node;
    } break;

#line 2807 "qmljs.g"
  case 358: Q_FALLTHROUGH();
#line 2809 "qmljs.g"
  case 359: Q_FALLTHROUGH();
#line 2811 "qmljs.g"
  case 360: Q_FALLTHROUGH();
#line 2813 "qmljs.g"
  case 361: Q_FALLTHROUGH();
#line 2815 "qmljs.g"
  case 362: Q_FALLTHROUGH();
#line 2817 "qmljs.g"
  case 363: Q_FALLTHROUGH();
#line 2819 "qmljs.g"
  case 364: Q_FALLTHROUGH();
#line 2821 "qmljs.g"
  case 365: Q_FALLTHROUGH();
#line 2823 "qmljs.g"
  case 366: Q_FALLTHROUGH();
#line 2825 "qmljs.g"
  case 367: Q_FALLTHROUGH();
#line 2827 "qmljs.g"
  case 368: Q_FALLTHROUGH();
#line 2829 "qmljs.g"
  case 369: Q_FALLTHROUGH();
#line 2831 "qmljs.g"

    case 370: {
        sym(1).Node = sym(2).Node;
    } break;

#line 2853 "qmljs.g"

    case 381: {
        AST::Block *node = new (pool) AST::Block(sym(2).StatementList);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 2865 "qmljs.g"

    case 383: {
        sym(1).StatementList = sym(1).StatementList->append(sym(2).StatementList);
    } break;

#line 2872 "qmljs.g"

    case 384: {
        sym(1).StatementList = new (pool) AST::StatementList(sym(1).Statement);
    } break;

#line 2879 "qmljs.g"

    case 385: {
        sym(1).Node = new (pool) AST::StatementList(sym(3).FunctionDeclaration);
    } break;

#line 2886 "qmljs.g"

    case 386: {
        sym(1).Node = nullptr;
    } break;

#line 2893 "qmljs.g"

    case 387: {
        sym(1).Node = sym(1).StatementList->finish();
    } break;

#line 2900 "qmljs.g"

    case 388: {
        sym(1).scope = AST::VariableScope::Let;
    } break;

#line 2906 "qmljs.g"

    case 389: {
        sym(1).scope = AST::VariableScope::Const;
    } break;

#line 2913 "qmljs.g"

    case 390: {
        sym(1).scope = AST::VariableScope::Var;
    } break;

#line 2920 "qmljs.g"
  case 391: Q_FALLTHROUGH();
#line 2922 "qmljs.g"
  case 392: Q_FALLTHROUGH();
#line 2924 "qmljs.g"
  case 393: Q_FALLTHROUGH();
#line 2926 "qmljs.g"

    case 394: {
        AST::VariableDeclarationList *declarations = sym(2).VariableDeclarationList->finish(sym(1).scope);
        for (auto it = declarations; it; it = it->next) {
            if (it->declaration && it->declaration->typeAnnotation) {
                syntaxError(it->declaration->typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in variable declarations");
                return false;
            }
        }
        AST::VariableStatement *node = new (pool) AST::VariableStatement(declarations);
        node->declarationKindToken = loc(1);
        sym(1).Node = node;
    } break;

#line 2944 "qmljs.g"
  case 396: Q_FALLTHROUGH();
#line 2946 "qmljs.g"
  case 397: Q_FALLTHROUGH();
#line 2948 "qmljs.g"
  case 398: Q_FALLTHROUGH();
#line 2950 "qmljs.g"

    case 399: {
  sym(1).Node = new (pool) AST::VariableDeclarationList(sym(1).PatternElement);
    } break;

#line 2957 "qmljs.g"
  case 400: Q_FALLTHROUGH();
#line 2959 "qmljs.g"
  case 401: Q_FALLTHROUGH();
#line 2961 "qmljs.g"
  case 402: Q_FALLTHROUGH();
#line 2963 "qmljs.g"

    case 403: {
        AST::VariableDeclarationList *node = new (pool) AST::VariableDeclarationList(sym(1).VariableDeclarationList, sym(3).PatternElement);
        node->commaToken = loc(2);
        sym(1).Node = node;
    } break;

#line 2972 "qmljs.g"
  case 404: Q_FALLTHROUGH();
#line 2974 "qmljs.g"
  case 405: Q_FALLTHROUGH();
#line 2976 "qmljs.g"
  case 406: Q_FALLTHROUGH();
#line 2978 "qmljs.g"

    case 407: {
        auto *node = new (pool) AST::PatternElement(stringRef(1), sym(2).TypeAnnotation, sym(3).Expression);
        node->identifierToken = loc(1);
        sym(1).Node = node;
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(3).Expression))
            c->name = stringRef(1);
    } break;

#line 2992 "qmljs.g"
  case 408: Q_FALLTHROUGH();
#line 2994 "qmljs.g"
  case 409: Q_FALLTHROUGH();
#line 2996 "qmljs.g"
  case 410: Q_FALLTHROUGH();
#line 2998 "qmljs.g"

    case 411: {
        auto *node = new (pool) AST::PatternElement(sym(1).Pattern, sym(2).Expression);
        node->identifierToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3007 "qmljs.g"

    case 412: {
        auto *node = new (pool) AST::ObjectPattern(sym(2).PatternPropertyList);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        node->parseMode = AST::Pattern::Binding;
        sym(1).Node = node;
    } break;

#line 3018 "qmljs.g"

    case 413: {
        auto *node = new (pool) AST::ArrayPattern(sym(2).PatternElementList);
        node->lbracketToken = loc(1);
        node->rbracketToken = loc(3);
        node->parseMode = AST::Pattern::Binding;
        sym(1).Node = node;
    } break;

#line 3029 "qmljs.g"

    case 414: {
        sym(1).Node = nullptr;
    } break;

#line 3036 "qmljs.g"
 case 415:
#line 3038 "qmljs.g"

    case 416: {
        sym(1).Node = sym(1).PatternPropertyList->finish();
    } break;

#line 3045 "qmljs.g"

    case 417: {
        if (sym(1).Elision || sym(2).Node) {
            auto *l = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
            sym(1).Node = l->finish();
        } else {
            sym(1).Node = nullptr;
        }
    } break;

#line 3057 "qmljs.g"

    case 418: {
        sym(1).Node = sym(1).PatternElementList->finish();
    } break;

#line 3064 "qmljs.g"

    case 419: {
        if (sym(3).Elision || sym(4).Node) {
            auto *l = new (pool) AST::PatternElementList(sym(3).Elision, sym(4).PatternElement);
            l = sym(1).PatternElementList->append(l);
            sym(1).Node = l;
        }
        sym(1).Node = sym(1).PatternElementList->finish();
    } break;

#line 3076 "qmljs.g"

    case 420: {
        sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternProperty);
    } break;

#line 3083 "qmljs.g"

    case 421: {
        sym(1).Node = new (pool) AST::PatternPropertyList(sym(1).PatternPropertyList, sym(3).PatternProperty);
    } break;

#line 3092 "qmljs.g"

    case 423: {
        sym(1).PatternElementList = sym(1).PatternElementList->append(sym(3).PatternElementList);
    } break;

#line 3099 "qmljs.g"

    case 424: {
        sym(1).Node = new (pool) AST::PatternElementList(sym(1).Elision, sym(2).PatternElement);
    } break;

#line 3107 "qmljs.g"

    case 425: {
        AST::StringLiteralPropertyName *name = new (pool) AST::StringLiteralPropertyName(stringRef(1));
        name->propertyNameToken = loc(1);
        // if initializer is an anonymous function expression, we need to assign identifierref as it's name
        if (auto *f = asAnonymousFunctionDefinition(sym(2).Expression))
            f->name = stringRef(1);
        if (auto *c = asAnonymousClassDefinition(sym(2).Expression))
            c->name = stringRef(1);
        sym(1).Node = new (pool) AST::PatternProperty(name, stringRef(1), sym(2).Expression);
    } break;

#line 3121 "qmljs.g"

    case 426: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, stringRef(3), sym(4).Expression);
        sym(1).Node = node;
    } break;

#line 3129 "qmljs.g"

    case 427: {
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, sym(3).Pattern, sym(4).Expression);
        sym(1).Node = node;
    } break;

#line 3137 "qmljs.g"

    case 428: {
      AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(1), sym(2).TypeAnnotation, sym(3).Expression);
      node->identifierToken = loc(1);
      // if initializer is an anonymous function expression, we need to assign identifierref as it's name
      if (auto *f = asAnonymousFunctionDefinition(sym(3).Expression))
          f->name = stringRef(1);
      if (auto *c = asAnonymousClassDefinition(sym(3).Expression))
          c->name = stringRef(1);
      sym(1).Node = node;
    } break;

#line 3151 "qmljs.g"

    case 429: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(1).Pattern, sym(2).Expression);
        sym(1).Node = node;
    } break;

#line 3159 "qmljs.g"

    case 430: {
        AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(2), /*type annotation*/nullptr, nullptr, AST::PatternElement::RestElement);
        node->identifierToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3168 "qmljs.g"

    case 431: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(2).Pattern, nullptr, AST::PatternElement::RestElement);
        sym(1).Node = node;
    } break;

#line 3176 "qmljs.g"

    case 432: {
        sym(1).Node = nullptr;
    } break;

#line 3186 "qmljs.g"

    case 434: {
        AST::EmptyStatement *node = new (pool) AST::EmptyStatement();
        node->semicolonToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3201 "qmljs.g"

    case 435: {
        int token = lookaheadToken(lexer);
        if (token == T_LBRACE)
            pushToken(T_FORCE_BLOCK);
        else if (token == T_FUNCTION || token == T_FUNCTION_STAR || token == T_CLASS || token == T_LET || token == T_CONST)
            pushToken(T_FORCE_DECLARATION);
    } break;

#line 3212 "qmljs.g"

    case 436: {
        AST::ExpressionStatement *node = new (pool) AST::ExpressionStatement(sym(1).Expression);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3221 "qmljs.g"

    case 437: {
        AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement, sym(7).Statement);
        node->ifToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->elseToken = loc(6);
        sym(1).Node = node;
    } break;

#line 3233 "qmljs.g"

    case 438: {
        AST::IfStatement *node = new (pool) AST::IfStatement(sym(3).Expression, sym(5).Statement);
        node->ifToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3246 "qmljs.g"

    case 440: {
        AST::DoWhileStatement *node = new (pool) AST::DoWhileStatement(sym(2).Statement, sym(5).Expression);
        node->doToken = loc(1);
        node->whileToken = loc(3);
        node->lparenToken = loc(4);
        node->rparenToken = loc(6);
        node->semicolonToken = loc(7);
        sym(1).Node = node;
    } break;

#line 3259 "qmljs.g"

    case 441: {
        AST::WhileStatement *node = new (pool) AST::WhileStatement(sym(3).Expression, sym(5).Statement);
        node->whileToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3270 "qmljs.g"

    case 442: {
        AST::ForStatement *node = new (pool) AST::ForStatement(sym(3).Expression, sym(5).Expression, sym(7).Expression, sym(9).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->firstSemicolonToken = loc(4);
        node->secondSemicolonToken = loc(6);
        node->rparenToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3283 "qmljs.g"
  case 443: Q_FALLTHROUGH();
#line 3285 "qmljs.g"

    case 444: {
        // ### get rid of the static_cast!
        AST::ForStatement *node = new (pool) AST::ForStatement(
          static_cast<AST::VariableStatement *>(sym(3).Node)->declarations, sym(5).Expression,
          sym(7).Expression, sym(9).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->firstSemicolonToken = loc(4);
        node->secondSemicolonToken = loc(6);
        node->rparenToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3301 "qmljs.g"

    case 445: {
        sym(1).forEachType = AST::ForEachType::In;
    } break;

#line 3308 "qmljs.g"

    case 446: {
        sym(1).forEachType = AST::ForEachType::Of;
    } break;

#line 3315 "qmljs.g"

    case 447: {
        // need to convert the LHS to an AssignmentPattern if it was an Array/ObjectLiteral
        if (AST::Pattern *p = sym(3).Expression->patternCast()) {
            AST::SourceLocation errorLoc;
            QString errorMsg;
            if (!p->convertLiteralToAssignmentPattern(pool, &errorLoc, &errorMsg)) {
                syntaxError(errorLoc, errorMsg);
                return false;
            }
        }
        AST::ForEachStatement *node = new (pool) AST::ForEachStatement(sym(3).Expression, sym(5).Expression, sym(7).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->inOfToken = loc(4);
        node->rparenToken = loc(6);
        node->type = sym(4).forEachType;
        sym(1).Node = node;
    } break;

#line 3337 "qmljs.g"

    case 448: {
        AST::ForEachStatement *node = new (pool) AST::ForEachStatement(sym(3).PatternElement, sym(5).Expression, sym(7).Statement);
        node->forToken = loc(1);
        node->lparenToken = loc(2);
        node->inOfToken = loc(4);
        node->rparenToken = loc(6);
        node->type = sym(4).forEachType;
        sym(1).Node = node;
    } break;

#line 3350 "qmljs.g"
  case 449: Q_FALLTHROUGH();
#line 3352 "qmljs.g"

    case 450: {
        if (auto typeAnnotation = sym(3).TypeAnnotation) {
            syntaxError(typeAnnotation->firstSourceLocation(), "Type annotations are not permitted in variable declarations");
            return false;
        }
        auto *node = new (pool) AST::PatternElement(stringRef(2), sym(3).TypeAnnotation, nullptr);
        node->identifierToken = loc(2);
        node->scope = sym(1).scope;
        node->isForDeclaration = true;
        sym(1).Node = node;
    } break;

#line 3367 "qmljs.g"
  case 451: Q_FALLTHROUGH();
#line 3369 "qmljs.g"

    case 452: {
        auto *node = new (pool) AST::PatternElement(sym(2).Pattern, nullptr);
        node->scope = sym(1).scope;
        node->isForDeclaration = true;
        sym(1).Node = node;
    } break;

#line 3379 "qmljs.g"

    case 453: {
        AST::ContinueStatement *node = new (pool) AST::ContinueStatement();
        node->continueToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3389 "qmljs.g"

    case 454: {
        AST::ContinueStatement *node = new (pool) AST::ContinueStatement(stringRef(2));
        node->continueToken = loc(1);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3400 "qmljs.g"

    case 455: {
        AST::BreakStatement *node = new (pool) AST::BreakStatement(QStringRef());
        node->breakToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3410 "qmljs.g"

    case 456: {
        AST::BreakStatement *node = new (pool) AST::BreakStatement(stringRef(2));
        node->breakToken = loc(1);
        node->identifierToken = loc(2);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3421 "qmljs.g"

    case 457: {
        if (!functionNestingLevel) {
            syntaxError(loc(1), "Return statement not allowed outside of Function declaration.");
            return false;
        }
        AST::ReturnStatement *node = new (pool) AST::ReturnStatement(sym(2).Expression);
        node->returnToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3435 "qmljs.g"

    case 458: {
        AST::WithStatement *node = new (pool) AST::WithStatement(sym(3).Expression, sym(5).Statement);
        node->withToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3446 "qmljs.g"

    case 459: {
        AST::SwitchStatement *node = new (pool) AST::SwitchStatement(sym(3).Expression, sym(5).CaseBlock);
        node->switchToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3457 "qmljs.g"

    case 460: {
        AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3467 "qmljs.g"

    case 461: {
        AST::CaseBlock *node = new (pool) AST::CaseBlock(sym(2).CaseClauses, sym(3).DefaultClause, sym(4).CaseClauses);
        node->lbraceToken = loc(1);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 3477 "qmljs.g"

    case 462: {
        sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClause);
    } break;

#line 3484 "qmljs.g"

    case 463: {
        sym(1).Node = new (pool) AST::CaseClauses(sym(1).CaseClauses, sym(2).CaseClause);
    } break;

#line 3491 "qmljs.g"

    case 464: {
        sym(1).Node = nullptr;
    } break;

#line 3498 "qmljs.g"

    case 465: {
        sym(1).Node = sym(1).CaseClauses->finish();
    } break;

#line 3505 "qmljs.g"

    case 466: {
        AST::CaseClause *node = new (pool) AST::CaseClause(sym(2).Expression, sym(4).StatementList);
        node->caseToken = loc(1);
        node->colonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3515 "qmljs.g"

    case 467: {
        AST::DefaultClause *node = new (pool) AST::DefaultClause(sym(3).StatementList);
        node->defaultToken = loc(1);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3525 "qmljs.g"

    case 468: {
        AST::LabelledStatement *node = new (pool) AST::LabelledStatement(stringRef(1), sym(3).Statement);
        node->identifierToken = loc(1);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3537 "qmljs.g"

    case 470: {
        syntaxError(loc(3), "FunctionDeclarations are not allowed after a label.");
        return false;
    } break;

#line 3545 "qmljs.g"

    case 471: {
        AST::ThrowStatement *node = new (pool) AST::ThrowStatement(sym(2).Expression);
        node->throwToken = loc(1);
        node->semicolonToken = loc(3);
        sym(1).Node = node;
    } break;

#line 3555 "qmljs.g"

    case 472: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3564 "qmljs.g"

    case 473: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Finally);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3573 "qmljs.g"

    case 474: {
        AST::TryStatement *node = new (pool) AST::TryStatement(sym(2).Statement, sym(3).Catch, sym(4).Finally);
        node->tryToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3582 "qmljs.g"

    case 475: {
        AST::Catch *node = new (pool) AST::Catch(sym(3).PatternElement, sym(5).Block);
        node->catchToken = loc(1);
        node->lparenToken = loc(2);
        node->identifierToken = loc(3);
        node->rparenToken = loc(4);
        sym(1).Node = node;
    } break;

#line 3594 "qmljs.g"

    case 476: {
        AST::Finally *node = new (pool) AST::Finally(sym(2).Block);
        node->finallyToken = loc(1);
        sym(1).Node = node;
    } break;

#line 3603 "qmljs.g"

    case 477: {
        AST::PatternElement *node = new (pool) AST::PatternElement(stringRef(1));
        node->identifierToken = loc(1);
        node->scope = AST::VariableScope::Let;
        sym(1).Node = node;
    } break;

#line 3613 "qmljs.g"

    case 478: {
        AST::PatternElement *node = new (pool) AST::PatternElement(sym(1).Pattern);
        node->scope = AST::VariableScope::Let;
        sym(1).Node = node;
    } break;

#line 3622 "qmljs.g"

    case 479: {
        AST::DebuggerStatement *node = new (pool) AST::DebuggerStatement();
        node->debuggerToken = loc(1);
        node->semicolonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3639 "qmljs.g"

    case 481: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                             /*type annotation*/nullptr);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 3656 "qmljs.g"

    case 482: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                             sym(6).TypeAnnotation);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 3672 "qmljs.g"

    case 484: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(QStringRef(), sym(3).FormalParameterList, sym(7).StatementList,
                                                                             /*type annotation*/nullptr);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3688 "qmljs.g"

    case 485: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList,
                                                                           /*type annotation*/nullptr);
        node->functionToken = loc(1);
        if (! stringRef(2).isNull())
          node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(7);
        node->rbraceToken = loc(9);
        sym(1).Node = node;
    } break;

#line 3706 "qmljs.g"

    case 486: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(QStringRef(), sym(3).FormalParameterList, sym(7).StatementList,
                                                                           /*type annotation*/nullptr);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        sym(1).Node = node;
    } break;

#line 3724 "qmljs.g"

    case 488: {
        sym(1).Node = nullptr;
    } break;

#line 3731 "qmljs.g"

    case 489: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 3739 "qmljs.g"
 case 490:
#line 3741 "qmljs.g"

    case 491: {
        sym(1).Node = sym(1).FormalParameterList->finish(pool);
    } break;

#line 3748 "qmljs.g"

    case 492: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(sym(1).FormalParameterList, sym(3).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 3756 "qmljs.g"

    case 493: {
        AST::FormalParameterList *node = new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement);
        sym(1).Node = node;
    } break;

#line 3765 "qmljs.g"

    case 494: {
        AST::FormalParameterList *node = new (pool) AST::FormalParameterList(sym(1).FormalParameterList, sym(3).PatternElement);
        sym(1).Node = node;
    } break;

#line 3775 "qmljs.g"

    case 496: {
        ++functionNestingLevel;
    } break;

#line 3782 "qmljs.g"

    case 497: {
        --functionNestingLevel;
    } break;

#line 3792 "qmljs.g"
  case 499: Q_FALLTHROUGH();
#line 3794 "qmljs.g"

    case 500: {
        AST::ReturnStatement *ret = new (pool) AST::ReturnStatement(sym(4).Expression);
        ret->returnToken = sym(4).Node->firstSourceLocation();
        ret->semicolonToken = sym(4).Node->lastSourceLocation();
        AST::StatementList *statements = (new (pool) AST::StatementList(ret))->finish();
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringRef(), sym(1).FormalParameterList, statements);
        f->isArrowFunction = true;
        f->functionToken = sym(1).Node ? sym(1).Node->firstSourceLocation() : loc(1);
        f->lbraceToken = sym(4).Node->firstSourceLocation();
        f->rbraceToken = sym(4).Node->lastSourceLocation();
        sym(1).Node = f;
    } break;

#line 3810 "qmljs.g"
  case 501: Q_FALLTHROUGH();
#line 3812 "qmljs.g"

    case 502: {
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(QStringRef(), sym(1).FormalParameterList, sym(6).StatementList);
        f->isArrowFunction = true;
        f->functionToken = sym(1).Node ? sym(1).Node->firstSourceLocation() : loc(1);
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(7);
        sym(1).Node = f;
    } break;

#line 3824 "qmljs.g"

    case 503: {
        AST::PatternElement *e = new (pool) AST::PatternElement(stringRef(1), /*type annotation*/nullptr, nullptr, AST::PatternElement::Binding);
        e->identifierToken = loc(1);
        sym(1).FormalParameterList = (new (pool) AST::FormalParameterList(nullptr, e))->finish(pool);
    } break;

#line 3835 "qmljs.g"

    case 504: {
        if (coverExpressionType != CE_FormalParameterList) {
            AST::NestedExpression *ne = static_cast<AST::NestedExpression *>(sym(1).Node);
            AST::FormalParameterList *list = ne->expression->reparseAsFormalParameterList(pool);
            if (!list) {
                syntaxError(loc(1), "Invalid Arrow parameter list.");
                return false;
            }
            sym(1).Node = list->finish(pool);
        }
    } break;

#line 3853 "qmljs.g"

    case 505: {
        if (lookaheadToken(lexer) == T_LBRACE)
            pushToken(T_FORCE_BLOCK);
    } break;

#line 3861 "qmljs.g"

    case 506: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, sym(3).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(1), sym(3).FormalParameterList, sym(7).StatementList);
        f->functionToken = sym(1).PropertyName->firstSourceLocation();
        f->lparenToken = loc(2);
        f->rparenToken = loc(4);
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(8);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(1).PropertyName, f, AST::PatternProperty::Method);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3878 "qmljs.g"

    case 507: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(5);
        f->lbraceToken = loc(7);
        f->rbraceToken = loc(9);
        f->isGenerator = true;
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Method);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3897 "qmljs.g"

    case 508: {
        if (!ensureNoFunctionTypeAnnotations(sym(5).TypeAnnotation, /*formals*/nullptr))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), nullptr, sym(7).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(4);
        f->lbraceToken = loc(6);
        f->rbraceToken = loc(8);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Getter);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3914 "qmljs.g"

    case 509: {
        if (!ensureNoFunctionTypeAnnotations(sym(6).TypeAnnotation, sym(4).FormalParameterList))
            return false;
        AST::FunctionExpression *f = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(8).StatementList);
        f->functionToken = sym(2).PropertyName->firstSourceLocation();
        f->lparenToken = loc(3);
        f->rparenToken = loc(5);
        f->lbraceToken = loc(7);
        f->rbraceToken = loc(9);
        AST::PatternProperty *node = new (pool) AST::PatternProperty(sym(2).PropertyName, f, AST::PatternProperty::Setter);
        node->colonToken = loc(2);
        sym(1).Node = node;
    } break;

#line 3932 "qmljs.g"

    case 510: {
        AST::FormalParameterList *node = (new (pool) AST::FormalParameterList(nullptr, sym(1).PatternElement))->finish(pool);
        sym(1).Node = node;
    } break;

#line 3940 "qmljs.g"

    case 511: {
        lexer->enterGeneratorBody();
    } break;

#line 3947 "qmljs.g"

    case 512: {
        --functionNestingLevel;
        lexer->leaveGeneratorBody();
    } break;

#line 3957 "qmljs.g"

    case 514: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(stringRef(2), sym(4).FormalParameterList, sym(7).StatementList);
        node->functionToken = loc(1);
        node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 3973 "qmljs.g"

    case 516: {
        AST::FunctionDeclaration *node = new (pool) AST::FunctionDeclaration(QStringRef(), sym(3).FormalParameterList, sym(6).StatementList);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(5);
        node->rbraceToken = loc(7);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 3987 "qmljs.g"

    case 517: {
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(stringRef(2), sym(4).FormalParameterList, sym(7).StatementList);
        node->functionToken = loc(1);
        if (!stringRef(2).isNull())
          node->identifierToken = loc(2);
        node->lparenToken = loc(3);
        node->rparenToken = loc(5);
        node->lbraceToken = loc(6);
        node->rbraceToken = loc(8);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4003 "qmljs.g"

    case 518: {
        AST::FunctionExpression *node = new (pool) AST::FunctionExpression(QStringRef(), sym(3).FormalParameterList, sym(6).StatementList);
        node->functionToken = loc(1);
        node->lparenToken = loc(2);
        node->rparenToken = loc(4);
        node->lbraceToken = loc(5);
        node->rbraceToken = loc(7);
        node->isGenerator = true;
        sym(1).Node = node;
    } break;

#line 4019 "qmljs.g"
  case 520: Q_FALLTHROUGH();
#line 4021 "qmljs.g"

    case 521: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression();
        node->yieldToken = loc(1);
        sym(1).Node = node;
    } break;

#line 4030 "qmljs.g"
  case 522: Q_FALLTHROUGH();
#line 4032 "qmljs.g"

    case 523: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression(sym(3).Expression);
        node->yieldToken = loc(1);
        node->isYieldStar = true;
        sym(1).Node = node;
    } break;

#line 4042 "qmljs.g"
  case 524: Q_FALLTHROUGH();
#line 4044 "qmljs.g"

    case 525: {
        AST::YieldExpression *node = new (pool) AST::YieldExpression(sym(2).Expression);
        node->yieldToken = loc(1);
        sym(1).Node = node;
    } break;

#line 4054 "qmljs.g"

    case 526: {
        AST::ClassDeclaration *node = new (pool) AST::ClassDeclaration(stringRef(2), sym(3).Expression, sym(5).ClassElementList);
        node->classToken = loc(1);
        node->identifierToken = loc(2);
        node->lbraceToken = loc(4);
        node->rbraceToken = loc(6);
        sym(1).Node = node;
    } break;

#line 4066 "qmljs.g"

    case 527: {
        AST::ClassExpression *node = new (pool) AST::ClassExpression(stringRef(2), sym(3).Expression, sym(5).ClassElementList);
        node->classToken = loc(1);
        node->identifierToken = loc(2);
        node->lbraceToken = loc(4);
        node->rbraceToken = loc(6);
        sym(1).Node = node;
    } break;

#line 4078 "qmljs.g"

    case 528: {
        AST::ClassDeclaration *node = new (pool) AST::ClassDeclaration(QStringRef(), sym(2).Expression, sym(4).ClassElementList);
        node->classToken = loc(1);
        node->lbraceToken = loc(3);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 4089 "qmljs.g"

    case 529: {
        AST::ClassExpression *node = new (pool) AST::ClassExpression(QStringRef(), sym(2).Expression, sym(4).ClassElementList);
        node->classToken = loc(1);
        node->lbraceToken = loc(3);
        node->rbraceToken = loc(5);
        sym(1).Node = node;
    } break;

#line 4102 "qmljs.g"

    case 531: {
        lexer->setStaticIsKeyword(true);
    } break;

#line 4109 "qmljs.g"
 case 532:
#line 4111 "qmljs.g"

    case 533: {
        lexer->setStaticIsKeyword(false);
    } break;

#line 4118 "qmljs.g"

    case 534: {
        sym(1).Node = nullptr;
    } break;

#line 4125 "qmljs.g"

    case 535: {
        sym(1).Node = sym(2).Node;
    } break;

#line 4132 "qmljs.g"

    case 536: {
        sym(1).Node = nullptr;
    } break;

#line 4139 "qmljs.g"

    case 537: {
        if (sym(1).Node)
            sym(1).Node = sym(1).ClassElementList->finish();
    } break;

#line 4149 "qmljs.g"

    case 539: {
        if (sym(1).Node) {
            if (sym(2).Node)
                sym(1).ClassElementList = sym(1).ClassElementList->append(sym(2).ClassElementList);
        } else if (sym(2).Node) {
            sym(1).Node = sym(2).Node;
        }
    } break;

#line 4161 "qmljs.g"

    case 540: {
        AST::ClassElementList *node = new (pool) AST::ClassElementList(sym(1).PatternProperty, false);
        sym(1).Node = node;
    } break;

#line 4169 "qmljs.g"

    case 541: {
        lexer->setStaticIsKeyword(true);
        AST::ClassElementList *node = new (pool) AST::ClassElementList(sym(2).PatternProperty, true);
        sym(1).Node = node;
    } break;

#line 4178 "qmljs.g"

    case 542: {
        sym(1).Node = nullptr;
    } break;

#line 4187 "qmljs.g"

    case 543: {
        sym(1).Node = nullptr;
    } break;

#line 4196 "qmljs.g"

    case 545: {
        sym(1).Node = new (pool) AST::Program(sym(1).StatementList->finish());
    } break;

#line 4203 "qmljs.g"
  case 546: {
        sym(1).Node = new (pool) AST::ESModule(sym(1).StatementList);
    } break;

#line 4209 "qmljs.g"

    case 547: {
        sym(1).StatementList = sym(1).StatementList->finish();
    } break;

#line 4216 "qmljs.g"

    case 548: {
        sym(1).StatementList = nullptr;
    } break;

#line 4226 "qmljs.g"

    case 551: {
        sym(1).StatementList = sym(1).StatementList->append(sym(2).StatementList);
    } break;

#line 4234 "qmljs.g"
 case 552:  Q_FALLTHROUGH();
#line 4236 "qmljs.g"

    case 553: {
        sym(1).StatementList = new (pool) AST::StatementList(sym(1).Node);
    } break;

#line 4245 "qmljs.g"

    case 555: {
        auto decl = new (pool) AST::ImportDeclaration(sym(2).ImportClause, sym(3).FromClause);
        decl->importToken = loc(1);
        sym(1).Node = decl;
    } break;

#line 4253 "qmljs.g"

    case 556: {
        auto decl = new (pool) AST::ImportDeclaration(stringRef(2));
        decl->importToken = loc(1);
        decl->moduleSpecifierToken = loc(2);
        sym(1).Node = decl;
    } break;

#line 4263 "qmljs.g"

    case 557: {
        auto clause = new (pool) AST::ImportClause(stringRef(1));
        clause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = clause;
    } break;

#line 4271 "qmljs.g"

    case 558: {
        sym(1).ImportClause = new (pool) AST::ImportClause(sym(1).NameSpaceImport);
    } break;

#line 4277 "qmljs.g"

    case 559: {
        sym(1).ImportClause = new (pool) AST::ImportClause(sym(1).NamedImports);
    } break;

#line 4283 "qmljs.g"

    case 560: {
        auto importClause = new (pool) AST::ImportClause(stringRef(1), sym(3).NameSpaceImport);
        importClause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = importClause;
    } break;

#line 4291 "qmljs.g"

    case 561: {
        auto importClause = new (pool) AST::ImportClause(stringRef(1), sym(3).NamedImports);
        importClause->importedDefaultBindingToken = loc(1);
        sym(1).ImportClause = importClause;
    } break;

#line 4302 "qmljs.g"

    case 563: {
        auto import = new (pool) AST::NameSpaceImport(stringRef(3));
        import->starToken = loc(1);
        import->importedBindingToken = loc(3);
        sym(1).NameSpaceImport = import;
    } break;

#line 4312 "qmljs.g"

    case 564: {
        auto namedImports = new (pool) AST::NamedImports();
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(2);
        sym(1).NamedImports = namedImports;
    } break;

#line 4321 "qmljs.g"

    case 565: {
        auto namedImports = new (pool) AST::NamedImports(sym(2).ImportsList->finish());
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(3);
        sym(1).NamedImports = namedImports;
    } break;

#line 4330 "qmljs.g"

    case 566: {
        auto namedImports = new (pool) AST::NamedImports(sym(2).ImportsList->finish());
        namedImports->leftBraceToken = loc(1);
        namedImports->rightBraceToken = loc(4);
        sym(1).NamedImports = namedImports;
    } break;

#line 4340 "qmljs.g"

    case 567: {
        auto clause = new (pool) AST::FromClause(stringRef(2));
        clause->fromToken = loc(1);
        clause->moduleSpecifierToken = loc(2);
        sym(1).FromClause = clause;
    } break;

#line 4350 "qmljs.g"

    case 568: {
        auto importsList = new (pool) AST::ImportsList(sym(1).ImportSpecifier);
        importsList->importSpecifierToken = loc(1);
        sym(1).ImportsList = importsList;
    } break;

#line 4358 "qmljs.g"

    case 569: {
        auto importsList = new (pool) AST::ImportsList(sym(1).ImportsList, sym(3).ImportSpecifier);
        importsList->importSpecifierToken = loc(3);
        sym(1).ImportsList = importsList;
    } break;

#line 4367 "qmljs.g"

    case 570: {
        auto importSpecifier = new (pool) AST::ImportSpecifier(stringRef(1));
        importSpecifier->importedBindingToken = loc(1);
        sym(1).ImportSpecifier = importSpecifier;
    } break;

#line 4375 "qmljs.g"

    case 571: {
    auto importSpecifier = new (pool) AST::ImportSpecifier(stringRef(1), stringRef(3));
    importSpecifier->identifierToken = loc(1);
    importSpecifier->importedBindingToken = loc(3);
    sym(1).ImportSpecifier = importSpecifier;
    } break;

#line 4392 "qmljs.g"

    case 574: {
        int token = lookaheadToken(lexer);
        if (token == T_FUNCTION || token == T_FUNCTION_STAR || token == T_CLASS)
            pushToken(T_FORCE_DECLARATION);
    } break;

#line 4401 "qmljs.g"

    case 575: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(3).FromClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4409 "qmljs.g"

    case 576: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(2).ExportClause, sym(3).FromClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4417 "qmljs.g"

    case 577: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(sym(2).ExportClause);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4425 "qmljs.g"
 case 578:  Q_FALLTHROUGH();
#line 4427 "qmljs.g"

    case 579: {
        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/false, sym(2).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4435 "qmljs.g"

    case 580: {
        if (auto *f = AST::cast<AST::FunctionDeclaration*>(sym(5).Node)) {
            if (f->name.isEmpty()) {
                f->name = stringRef(2);
                f->identifierToken = loc(2);
            }
        }
    } Q_FALLTHROUGH();

#line 4446 "qmljs.g"

    case 581: {
        // Emulate 15.2.3.11
        if (auto *cls = AST::cast<AST::ClassDeclaration*>(sym(5).Node)) {
            if (cls->name.isEmpty()) {
                cls->name = stringRef(2);
                cls->identifierToken = loc(2);
            }
        }

        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/true, sym(5).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4462 "qmljs.g"

    case 582: {
        // if lhs is an identifier expression and rhs is an anonymous function expression, we need to assign the name of lhs to the function
        if (auto *f = asAnonymousFunctionDefinition(sym(4).Node)) {
            f->name = stringRef(2);
        }
        if (auto *c = asAnonymousClassDefinition(sym(4).Expression)) {
            c->name = stringRef(2);
        }

        auto exportDeclaration = new (pool) AST::ExportDeclaration(/*exportDefault=*/true, sym(4).Node);
        exportDeclaration->exportToken = loc(1);
        sym(1).ExportDeclaration = exportDeclaration;
    } break;

#line 4479 "qmljs.g"

    case 583: {
        auto exportClause = new (pool) AST::ExportClause();
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(2);
        sym(1).ExportClause = exportClause;
    } break;

#line 4488 "qmljs.g"

    case 584: {
        auto exportClause = new (pool) AST::ExportClause(sym(2).ExportsList->finish());
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(3);
        sym(1).ExportClause = exportClause;
    } break;

#line 4497 "qmljs.g"

    case 585: {
        auto exportClause = new (pool) AST::ExportClause(sym(2).ExportsList->finish());
        exportClause->leftBraceToken = loc(1);
        exportClause->rightBraceToken = loc(4);
        sym(1).ExportClause = exportClause;
    } break;

#line 4507 "qmljs.g"

    case 586: {
        sym(1).ExportsList = new (pool) AST::ExportsList(sym(1).ExportSpecifier);
    } break;

#line 4513 "qmljs.g"

    case 587: {
        sym(1).ExportsList = new (pool) AST::ExportsList(sym(1).ExportsList, sym(3).ExportSpecifier);
    } break;

#line 4520 "qmljs.g"

    case 588: {
        auto exportSpecifier = new (pool) AST::ExportSpecifier(stringRef(1));
        exportSpecifier->identifierToken = loc(1);
        sym(1).ExportSpecifier = exportSpecifier;
    } break;

#line 4528 "qmljs.g"

    case 589: {
        auto exportSpecifier = new (pool) AST::ExportSpecifier(stringRef(1), stringRef(3));
        exportSpecifier->identifierToken = loc(1);
        exportSpecifier->exportedIdentifierToken = loc(3);
        sym(1).ExportSpecifier = exportSpecifier;
    } break;

#line 4539 "qmljs.g"

    // ------------ end of switch statement
            } // switch
            action = nt_action(state_stack[tos], lhs[r] - TERMINAL_COUNT);
        } // if
    } while (action != 0);

#ifdef PARSER_DEBUG
    qDebug() << "Done or error.";
#endif

    if (first_token == last_token) {
        const int errorState = state_stack[tos];

        // automatic insertion of `;'
        if (yytoken != -1 && ((t_action(errorState, T_AUTOMATIC_SEMICOLON) && lexer->canInsertAutomaticSemicolon(yytoken))
                              || t_action(errorState, T_COMPATIBILITY_SEMICOLON))) {
#ifdef PARSER_DEBUG
            qDebug() << "Inserting automatic semicolon.";
#endif
            SavedToken &tk = token_buffer[0];
            tk.token = yytoken;
            tk.dval = yylval;
            tk.spell = yytokenspell;
            tk.raw = yytokenraw;
            tk.loc = yylloc;

            yylloc = yyprevlloc;
            yylloc.offset += yylloc.length;
            yylloc.startColumn += yylloc.length;
            yylloc.length = 0;

            //const QString msg = QCoreApplication::translate("QQmlParser", "Missing `;'");
            //diagnostic_messages.append(compileError(yyloc, msg, Severity::Warning));

            first_token = &token_buffer[0];
            last_token = &token_buffer[1];

            yytoken = T_SEMICOLON;
            yylval = 0;

            action = errorState;

            goto _Lcheck_token;
        }

        hadErrors = true;

        token_buffer[0].token = yytoken;
        token_buffer[0].dval = yylval;
        token_buffer[0].spell = yytokenspell;
        token_buffer[0].raw = yytokenraw;
        token_buffer[0].loc = yylloc;

        token_buffer[1].token = yytoken       = lexer->lex();
        token_buffer[1].dval  = yylval        = lexer->tokenValue();
        token_buffer[1].spell = yytokenspell  = lexer->tokenSpell();
        token_buffer[1].raw   = yytokenraw    = lexer->rawString();
        token_buffer[1].loc   = yylloc        = location(lexer);

        if (t_action(errorState, yytoken)) {
#ifdef PARSER_DEBUG
            qDebug() << "Parse error, trying to recover.";
#endif
            QString msg;
            int token = token_buffer[0].token;
            if (token < 0 || token >= TERMINAL_COUNT)
                msg = QCoreApplication::translate("QQmlParser", "Syntax error");
            else
                msg = QCoreApplication::translate("QQmlParser", "Unexpected token `%1'").arg(QLatin1String(spell[token]));
            diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

            action = errorState;
            goto _Lcheck_token;
        }

        static int tokens[] = {
            T_PLUS,
            T_EQ,

            T_COMMA,
            T_COLON,
            T_SEMICOLON,

            T_RPAREN, T_RBRACKET, T_RBRACE,

            T_NUMERIC_LITERAL,
            T_IDENTIFIER,

            T_LPAREN, T_LBRACKET, T_LBRACE,

            EOF_SYMBOL
        };

        for (int *tk = tokens; *tk != EOF_SYMBOL; ++tk) {
            int a = t_action(errorState, *tk);
            if (a > 0 && t_action(a, yytoken)) {
#ifdef PARSER_DEBUG
                qDebug() << "Parse error, trying to recover (2).";
#endif
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[*tk]));
                diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

                pushToken(*tk);
                goto _Lcheck_token;
            }
        }

        for (int tk = 1; tk < TERMINAL_COUNT; ++tk) {
            if (tk == T_AUTOMATIC_SEMICOLON || tk == T_FEED_UI_PROGRAM    ||
                tk == T_FEED_JS_STATEMENT   || tk == T_FEED_JS_EXPRESSION)
               continue;

            int a = t_action(errorState, tk);
            if (a > 0 && t_action(a, yytoken)) {
                const QString msg = QCoreApplication::translate("QQmlParser", "Expected token `%1'").arg(QLatin1String(spell[tk]));
                diagnostic_messages.append(compileError(token_buffer[0].loc, msg));

                pushToken(tk);
                goto _Lcheck_token;
            }
        }

        const QString msg = QCoreApplication::translate("QQmlParser", "Syntax error");
        diagnostic_messages.append(compileError(token_buffer[0].loc, msg));
    }

    return false;
}

QT_QML_END_NAMESPACE


