---
name: Question
about: Ask a question
title: ''
labels: ''
assignees: ''
---

# Prerequisites

*Note: You may remove this section prior to submitting your question.*

A small team of volunteers monitors issues; this is the same team that develops the library. Whilst we are keen to help,
there are often better places to ask questions, including:

- [Stack Overflow](https://stackoverflow.com/questions/tagged/mqtt) - well written questions are generally answered 
within a day. Please use the tags MQTT, Python and Paho.
- [Reddit](https://www.reddit.com/r/MQTT/) - great for questions requiring discussion.
- [MQTT Google Group](https://groups.google.com/g/mqtt) - fairly quiet but questions about the protocol are generally answered quickly.
- [Eclipse paho-dev mailing list](https://dev.eclipse.org/mailman/listinfo/paho-dev) - for general discussion about the paho project.

Prior to asking a question here, please:

- [ ] Search the resources mentioned above (it's likely someone else has asked the same question)
- [ ] Read the [readme](https://github.com/eclipse/paho.mqtt.python/blob/master/README.rst) (especially the
"Known limitations" section) and look at the [examples](https://github.com/eclipse/paho.mqtt.python/tree/master/examples).
- [ ] Search through the [project issues](https://github.com/eclipse/paho.mqtt.python/issues).
- [ ] Confirm that you are using the latest release of the library.
- [ ] Ensure your question is specific to this project; consider using another tool (e.g. [MQTTX](https://mqttx.app/) / [mosquitto_sub](https://mosquitto.org/man/mosquitto_sub-1.html))
to test your assumptions.

# Question

*Please clearly and concisely state your question.*


# Environment
*It's often helpful for us to know how you are using the library so please provide:*

* Python version:
* Library version:
* Operating system (including version):
* MQTT server (name, version, configuration, hosting details):