# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ClinicalDocumentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the clinical document."""

    CONSULTATION = "consultation"
    DISCHARGE_SUMMARY = "dischargeSummary"
    HISTORY_AND_PHYSICAL = "historyAndPhysical"
    RADIOLOGY_REPORT = "radiologyReport"
    PROCEDURE = "procedure"
    PROGRESS = "progress"
    LABORATORY = "laboratory"
    PATHOLOGY_REPORT = "pathologyReport"


class ContactPointSystem(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Contact Point System
    see `https://www.hl7.org/fhir/R4/valueset-contact-point-system.html
    <https://www.hl7.org/fhir/R4/valueset-contact-point-system.html>`_.
    """

    PHONE = "phone"
    """Phone"""
    FAX = "fax"
    """Fax"""
    EMAIL = "email"
    """Email"""
    PAGER = "pager"
    """Pager"""
    URL = "url"
    """Url"""
    SMS = "sms"
    """Sms"""
    OTHER = "other"
    """Other"""


class ContactPointUse(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Contact Point Use
    See: 	`http://hl7.org/fhir/ValueSet/contact-point-use
    <http://hl7.org/fhir/ValueSet/contact-point-use>`_.
    """

    HOME = "home"
    """Home"""
    WORK = "work"
    """Work"""
    TEMP = "temp"
    """Temp"""
    OLD = "old"
    """Old"""
    MOBILE = "mobile"
    """Mobile"""


class DocumentContentSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the content's source.
    In case the source type is 'inline', the content is given as a string (for instance, text).
    In case the source type is 'reference', the content is given as a URI.
    """

    INLINE = "inline"
    """The content is given as a string (for instance, text)."""
    REFERENCE = "reference"
    """The content is given as a URI."""


class DocumentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the patient document, such as 'note' (text document) or 'fhirBundle' (FHIR JSON
    document).
    """

    NOTE = "note"
    FHIR_BUNDLE = "fhirBundle"
    DICOM = "dicom"
    GENOMIC_SEQUENCING = "genomicSequencing"


class EncounterClass(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Known values codes that can be used to indicate the class of encounter (TODO://Based on FHIR
    value set--http://....).
    """

    IN_PATIENT = "inpatient"
    """A patient encounter where a patient is admitted by a hospital or equivalent facility, assigned
    to a location where patients generally stay at least overnight and provided with room, board,
    and continuous nursing service."""
    AMBULATORY = "ambulatory"
    """The term ambulatory usually implies that the patient has come to the location and is not
    assigned to a bed. Sometimes referred to as an outpatient encounter."""
    OBSERVATION = "observation"
    """An encounter where the patient usually will start in different encounter, such as one in the
    emergency department but then transition to this type of encounter because they require a
    significant period of treatment and monitoring to determine whether or not their condition
    warrants an inpatient admission or discharge."""
    EMERGENCY = "emergency"
    """A patient encounter that takes place at a dedicated healthcare service delivery location where
    the patient receives immediate evaluation and treatment, provided until the patient can be
    discharged or responsibility for the patient's care is transferred elsewhere (for example, the
    patient could be admitted as an inpatient or transferred to another facility."""
    VIRTUAL = "virtual"
    """A patient encounter where the patient is not physically present for the encounter, such as in a
    telehealth encounter, phone call, or electronic communication."""
    HEALTH_HOME = "healthHome"
    """Healthcare encounter that takes place in the residence of the patient or a designee"""


class GuidanceRankingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Refers to how important a clinical guidance is."""

    HIGH = "high"
    """high"""
    LOW = "low"
    """low"""


class JobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the processing job."""

    NOT_STARTED = "notStarted"
    RUNNING = "running"
    SUCCEEDED = "succeeded"
    FAILED = "failed"
    CANCELED = "canceled"


class LateralityDiscrepancyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Laterality discrepancy type."""

    ORDER_LATERALITY_MISMATCH = "orderLateralityMismatch"
    """Mismatch between order and text"""
    TEXT_LATERALITY_CONTRADICTION = "textLateralityContradiction"
    """Contradiction in text"""
    TEXT_LATERALITY_MISSING = "textLateralityMissing"
    """Missing laterality in text"""


class MedicalProfessionalType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Medical Professional Type."""

    UNKNOWN = "unknown"
    """Unknown medical professional type"""
    DOCTOR = "doctor"
    """Doctor medical professional type"""
    NURSE = "nurse"
    """Nurse medical professional type"""
    MIDWIFE = "midwife"
    """Technician medical professional type"""
    PHYSICIAN_ASSISTANT = "physicianAssistant"
    """Technician medical professional type"""


class ObservationStatusCodeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Observation Status
    Based on `FHIR ObservationStatus
    <https://www.hl7.org/fhir/R4/valueset-observation-status.html>`_.
    """

    REGISTERED = "registered"
    """The existence of the observation is registered, but there is no result yet available."""
    PRELIMINARY = "preliminary"
    """This is an initial or interim observation: data may be incomplete or unverified."""
    FINAL = "final"
    """The observation is complete and verified by an authorized person."""
    AMENDED = "amended"
    """Subsequent to being Final, the observation has been modified subsequent.  This includes
    updates/new information and corrections."""
    CORRECTED = "corrected"
    """Subsequent to being Final, the observation has been modified to correct an error in the test
    result."""
    CANCELLED = "cancelled"
    """The observation is unavailable because the measurement was not started or not completed (also
    sometimes called "aborted")."""
    ENTERED_IN_ERROR = "entered-in-error"
    """The observation has been withdrawn following previous final release."""
    UNKNOWN = "unknown"
    """The observation status is unknown.  Note that "unknown" is a value of last resort and every
    attempt should be made to provide a meaningful value other than "unknown"."""


class PatientSex(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The patient's sex."""

    FEMALE = "female"
    MALE = "male"
    UNSPECIFIED = "unspecified"


class QualityMeasureComplianceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether the document is compliant."""

    NOT_ELIGIBLE = "notEligible"
    """not eligible"""
    PERFORMANCE_NOT_MET = "performanceNotMet"
    """performance not met"""
    PERFORMANCE_MET = "performanceMet"
    """performance met"""
    DENOMINATOR_EXCEPTION = "denominatorException"
    """denominator exception"""


class QualityMeasureType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Mips types that can be checked by the engine."""

    MIPS76 = "mips76"
    """Mips 76"""
    MIPS147 = "mips147"
    """Mips 147"""
    MIPS195 = "mips195"
    """Mips 195"""
    MIPS360 = "mips360"
    """Mips 360"""
    MIPS364 = "mips364"
    """Mips 364"""
    MIPS405 = "mips405"
    """Mips 405"""
    MIPS406 = "mips406"
    """Mips 406"""
    MIPS436 = "mips436"
    """Mips 436"""
    MIPS145 = "mips145"
    """Mips 145"""
    ACRAD36 = "acrad36"
    """Acrad 36"""
    ACRAD37 = "acrad37"
    """Acrad 37"""
    ACRAD38 = "acrad38"
    """Acrad 38"""
    ACRAD39 = "acrad39"
    """Acrad 39"""
    ACRAD40 = "acrad40"
    """Acrad 40"""
    ACRAD41 = "acrad41"
    """Acrad 41"""
    ACRAD42 = "acrad42"
    """Acrad 42"""
    MEDNAX55 = "mednax55"
    """Mednax55"""
    MSN13 = "msn13"
    """Msn13"""
    MSN15 = "msn15"
    """Msn15"""
    QMM26 = "qmm26"
    """Qmm26"""
    QMM17 = "qmm17"
    """Qmm17"""
    QMM18 = "qmm18"
    """Qmm18"""
    QMM19 = "qmm19"
    """Qmm19"""


class RadiologyInsightsInferenceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A Radiology Insights inference types."""

    AGE_MISMATCH = "ageMismatch"
    """Age mismatch inference type"""
    LATERALITY_DISCREPANCY = "lateralityDiscrepancy"
    """Laterality discrepancy inference type"""
    SEX_MISMATCH = "sexMismatch"
    """Sex mismatch inference type"""
    COMPLETE_ORDER_DISCREPANCY = "completeOrderDiscrepancy"
    """Complete order discrepancy inference type"""
    LIMITED_ORDER_DISCREPANCY = "limitedOrderDiscrepancy"
    """Limited order discrepancy inference type"""
    FINDING = "finding"
    """Finding inference type"""
    CRITICAL_RESULT = "criticalResult"
    """Critical finding inference type"""
    FOLLOWUP_RECOMMENDATION = "followupRecommendation"
    """Recommendation inference type"""
    FOLLOWUP_COMMUNICATION = "followupCommunication"
    """Followup Communication inference type"""
    RADIOLOGY_PROCEDURE = "radiologyProcedure"
    """Radiology Procedure inference type"""
    SCORING_AND_ASSESSMENT = "scoringAndAssessment"
    """Scoring and assessment inference type"""
    GUIDANCE = "guidance"
    """Guidance inference type"""
    QUALITY_MEASURE = "qualityMeasure"
    """Guidance measure inference type"""


class RecommendationFindingStatusType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Recommendation finding status."""

    PRESENT = "present"
    """Present finding status"""
    DIFFERENTIAL = "differential"
    """Differential finding status"""
    RULE_OUT = "ruleOut"
    """Rule out finding status"""
    CONDITIONAL = "conditional"
    """Conditional finding status"""


class ResearchStudyStatusCodeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """`https://www.hl7.org/fhir/R4/codesystem-research-study-status.html
    <https://www.hl7.org/fhir/R4/codesystem-research-study-status.html>`_.
    """

    ACTIVE = "active"
    """The study is open for accrual."""
    ADMINISTRATIVELY_COMPLETED = "administratively-completed"
    """Study is completed prematurely and will not resume; patients are no longer examined nor
    treated."""
    APPROVED = "approved"
    """Protocol is approved by the review board."""
    CLOSED_TO_ACCRUAL = "closed-to-accrual"
    """Study is closed for accrual; patients can be examined and treated."""
    CLOSED_TO_ACCRUAL_AND_INTERVENTION = "closed-to-accrual-and-intervention"
    """The study is closed to accrual and intervention, i.e. the study is closed to enrollment, all
    study subjects have completed treatment or intervention but are still being followed according
    to the primary objective of the study."""
    COMPLETED = "completed"
    """Study is closed to accrual and intervention, i.e. the study is closed to enrollment, all study
    subjects have completed treatment or intervention but are still being followed according to the
    primary objective of the study."""
    DISAPPROVED = "disapproved"
    """Protocol was disapproved by the review board."""
    IN_REVIEW = "in-review"
    """Protocol is submitted to the review board for approval."""
    TEMPORARILY_CLOSED_TO_ACCRUAL = "temporarily-closed-to-accrual"
    """The study is temporarily closed to accrual; a pause in accrual while study is reviewed, but is
    expected to resume."""
    TEMPORARILY_CLOSED_TO_ACCRUAL_AND_INTERVENTION = "temporarily-closed-to-accrual-and-intervention"
    """Study is temporarily closed for accrual; can be potentially resumed in the future"""
    WITHDRAWN = "withdrawn"
    """Protocol was withdrawn by the lead organization."""


class ScoringAndAssessmentCategoryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The category that gets a value, e.g. BIRADS, Z-SCORE or FRAX SCORE."""

    BIRADS = "BIRADS"
    """BIRADS"""
    C_RADS_COLONIC_FINDINGS = "C-RADS COLONIC FINDINGS"
    """C-RADS COLONIC FINDINGS"""
    CAD_RADS = "CAD-RADS"
    """CAD-RADS"""
    LI_RADS = "LI-RADS"
    """LI-RADS"""
    LUNG_RADS = "LUNG-RADS"
    """LUNG-RADS"""
    NI_RADS = "NI-RADS"
    """NI-RADS"""
    O_RADS = "O-RADS"
    """O-RADS"""
    PI_RADS = "PI-RADS"
    """PI-RADS"""
    TI_RADS = "TI-RADS"
    """TI-RADS"""
    C_RADS_EXTRACOLONIC_FINDINGS = "C-RADS EXTRACOLONIC FINDINGS"
    """C-RADS EXTRACOLONIC FINDINGS"""
    LIFETIME_BREAST_CANCER_RISK = "LIFETIME BREAST CANCER RISK"
    """LIFETIME BREAST CANCER RISK"""
    ASCVD_RISK = "ASCVD RISK"
    """ASCVD RISK"""
    MODIFIED_GAIL_MODEL_RISK = "MODIFIED GAIL MODEL RISK"
    """MODIFIED GAIL MODEL RISK"""
    TYRER_CUSICK_MODEL_RISK = "TYRER CUSICK MODEL RISK"
    """TYRER CUSICK MODEL RISK"""
    AGATSTON_SCORE = "AGATSTON SCORE"
    """AGATSTON SCORE"""
    TEN_YEAR_CHD_RISK = "10 YEAR CHD RISK"
    """10 YEAR CHD RISK"""
    Z_SCORE = "Z-SCORE"
    """Z-SCORE"""
    T_SCORE = "T-SCORE"
    """T-SCORE"""
    CALCIUM_VOLUME_SCORE = "CALCIUM VOLUME SCORE"
    """CALCIUM VOLUME SCORE"""
    US_LI_RADS_VISUALIZATION_SCORE = "US LI-RADS VISUALIZATION SCORE"
    """US LI-RADS VISUALIZATION SCORE"""
    US_LI_RADS = "US LI-RADS"
    """US LI-RADS"""
    CEUS_LI_RADS = "CEUS LI-RADS"
    """CEUS LI-RADS"""
    TREATMENT_RESPONSE_LI_RADS = "TREATMENT RESPONSE LI-RADS"
    """TREATMENT RESPONSE LI-RADS"""
    O_RADS_MRI = "O-RADS MRI"
    """O-RADS MRI"""
    CALCIUM_MASS_SCORE = "CALCIUM MASS SCORE"
    """CALCIUM MASS SCORE"""
    RISK_OF_MALIGNANCY_INDEX = "RISK OF MALIGNANCY INDEX"
    """RISK OF MALIGNANCY INDEX"""
    HNPCC_MUTATION_RISK = "HNPCC MUTATION RISK"
    """HNPCC MUTATION RISK"""
    ALBERTA_STROKE_PROGRAM_EARLY_CT_SCORE = "ALBERTA STROKE PROGRAM EARLY CT SCORE"
    """ALBERTA STROKE PROGRAM EARLY CT SCORE"""
    KELLGREN_LAWRENCE_GRADING_SCALE = "KELLGREN-LAWRENCE GRADING SCALE"
    """KELLGREN-LAWRENCE GRADING SCALE"""
    TONNIS_CLASSIFICATION = "TONNIS CLASSIFICATION"
    """TONNIS CLASSIFICATION"""
    CALCIUM_SCORE_UNSPECIFIED = "CALCIUM SCORE (UNSPECIFIED)"
    """CALCIUM SCORE (UNSPECIFIED)"""
    TEN_YEAR_CHD_RISK_OBSERVED_AGE = "10 YEAR CHD RISK (OBSERVED AGE)"
    """10 YEAR CHD RISK (OBSERVED AGE)"""
    TEN_YEAR_CHD_RISK_ARTERIAL_AGE = "10 YEAR CHD RISK (ARTERIAL AGE)"
    """10 YEAR CHD RISK (ARTERIAL AGE)"""
    FRAX_SCORE = "FRAX SCORE"
    """FRAX SCORE"""


class SpecialtyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Known values codes that can be used to indicate the type of the Specialty."""

    PATHOLOGY = "pathology"
    """pathology"""
    RADIOLOGY = "radiology"
    """radiology"""
