# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.appplatform import AppPlatformManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-appplatform
# USAGE
    python apps_create_or_update_vnet_injection.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = AppPlatformManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-0000-0000-0000-000000000000",
    )

    response = client.apps.begin_create_or_update(
        resource_group_name="myResourceGroup",
        service_name="myservice",
        app_name="myapp",
        app_resource={
            "identity": {
                "principalId": None,
                "tenantId": None,
                "type": "SystemAssigned,UserAssigned",
                "userAssignedIdentities": {
                    "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {
                        "clientId": None,
                        "principalId": None,
                    },
                    "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/samplegroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": {
                        "clientId": None,
                        "principalId": None,
                    },
                },
            },
            "location": "eastus",
            "properties": {
                "addonConfigs": {
                    "ApplicationConfigurationService": {
                        "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/configurationServices/myacs"
                    },
                    "ServiceRegistry": {
                        "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/serviceRegistries/myServiceRegistry"
                    },
                },
                "customPersistentDisks": [
                    {
                        "customPersistentDiskProperties": {
                            "mountOptions": ["uid=0", "gid=0", "dir_mode=0777", "file_mode=0777"],
                            "mountPath": "/mypath1/mypath2",
                            "shareName": "myFileShare",
                            "type": "AzureFileVolume",
                        },
                        "storageId": "myASCStorageID",
                    }
                ],
                "enableEndToEndTLS": False,
                "httpsOnly": False,
                "loadedCertificates": [
                    {
                        "loadTrustStore": False,
                        "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert1",
                    },
                    {
                        "loadTrustStore": True,
                        "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.AppPlatform/Spring/myservice/certificates/mycert2",
                    },
                ],
                "persistentDisk": {"mountPath": "/mypersistentdisk", "sizeInGB": 2},
                "public": True,
                "temporaryDisk": {"mountPath": "/mytemporarydisk", "sizeInGB": 2},
                "vnetAddons": {"publicEndpoint": True},
            },
        },
    ).result()
    print(response)


# x-ms-original-file: specification/appplatform/resource-manager/Microsoft.AppPlatform/stable/2022-12-01/examples/Apps_CreateOrUpdate_VNetInjection.json
if __name__ == "__main__":
    main()
