# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BackendAuthorizationHeaderCredentials(Model):
    """Authorization header information.

    All required parameters must be populated in order to send to Azure.

    :param scheme: Required. Authentication Scheme name.
    :type scheme: str
    :param parameter: Required. Authentication Parameter value.
    :type parameter: str
    """

    _validation = {
        'scheme': {'required': True, 'max_length': 100, 'min_length': 1},
        'parameter': {'required': True, 'max_length': 300, 'min_length': 1},
    }

    _attribute_map = {
        'scheme': {'key': 'scheme', 'type': 'str'},
        'parameter': {'key': 'parameter', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BackendAuthorizationHeaderCredentials, self).__init__(**kwargs)
        self.scheme = kwargs.get('scheme', None)
        self.parameter = kwargs.get('parameter', None)
