# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from enum import Enum


class JobSupportedAction(Enum):

    invalid = "Invalid"
    cancellable = "Cancellable"
    retriable = "Retriable"


class BackupManagementType(Enum):

    invalid = "Invalid"
    azure_iaas_vm = "AzureIaasVM"
    mab = "MAB"
    dpm = "DPM"
    azure_backup_server = "AzureBackupServer"
    azure_sql = "AzureSql"


class JobStatus(Enum):

    invalid = "Invalid"
    in_progress = "InProgress"
    completed = "Completed"
    failed = "Failed"
    completed_with_warnings = "CompletedWithWarnings"
    cancelled = "Cancelled"
    cancelling = "Cancelling"


class JobOperationType(Enum):

    invalid = "Invalid"
    register = "Register"
    un_register = "UnRegister"
    configure_backup = "ConfigureBackup"
    backup = "Backup"
    restore = "Restore"
    disable_backup = "DisableBackup"
    delete_backup_data = "DeleteBackupData"


class MabServerType(Enum):

    invalid = "Invalid"
    unknown = "Unknown"
    iaas_vm_container = "IaasVMContainer"
    iaas_vm_service_container = "IaasVMServiceContainer"
    dpm_container = "DPMContainer"
    azure_backup_server_container = "AzureBackupServerContainer"
    mab_container = "MABContainer"
    cluster = "Cluster"
    azure_sql_container = "AzureSqlContainer"
    windows = "Windows"
    vcenter = "VCenter"


class WorkloadType(Enum):

    invalid = "Invalid"
    vm = "VM"
    file_folder = "FileFolder"
    azure_sql_db = "AzureSqlDb"
    sqldb = "SQLDB"
    exchange = "Exchange"
    sharepoint = "Sharepoint"
    vmware_vm = "VMwareVM"
    system_state = "SystemState"
    client = "Client"
    generic_data_source = "GenericDataSource"


class ProtectionState(Enum):

    invalid = "Invalid"
    ir_pending = "IRPending"
    protected = "Protected"
    protection_error = "ProtectionError"
    protection_stopped = "ProtectionStopped"
    protection_paused = "ProtectionPaused"


class HealthStatus(Enum):

    passed = "Passed"
    action_required = "ActionRequired"
    action_suggested = "ActionSuggested"
    invalid = "Invalid"


class ProtectedItemState(Enum):

    invalid = "Invalid"
    ir_pending = "IRPending"
    protected = "Protected"
    protection_error = "ProtectionError"
    protection_stopped = "ProtectionStopped"
    protection_paused = "ProtectionPaused"


class UsagesUnit(Enum):

    count = "Count"
    bytes = "Bytes"
    seconds = "Seconds"
    percent = "Percent"
    count_per_second = "CountPerSecond"
    bytes_per_second = "BytesPerSecond"


class StorageType(Enum):

    invalid = "Invalid"
    geo_redundant = "GeoRedundant"
    locally_redundant = "LocallyRedundant"


class StorageTypeState(Enum):

    invalid = "Invalid"
    locked = "Locked"
    unlocked = "Unlocked"


class EnhancedSecurityState(Enum):

    invalid = "Invalid"
    enabled = "Enabled"
    disabled = "Disabled"


class Type(Enum):

    invalid = "Invalid"
    backup_protected_item_count_summary = "BackupProtectedItemCountSummary"
    backup_protection_container_count_summary = "BackupProtectionContainerCountSummary"


class ContainerType(Enum):

    invalid = "Invalid"
    unknown = "Unknown"
    iaas_vm_container = "IaasVMContainer"
    iaas_vm_service_container = "IaasVMServiceContainer"
    dpm_container = "DPMContainer"
    azure_backup_server_container = "AzureBackupServerContainer"
    mab_container = "MABContainer"
    cluster = "Cluster"
    azure_sql_container = "AzureSqlContainer"
    windows = "Windows"
    vcenter = "VCenter"


class RetentionDurationType(Enum):

    invalid = "Invalid"
    days = "Days"
    weeks = "Weeks"
    months = "Months"
    years = "Years"


class RecoveryPointTierType(Enum):

    invalid = "Invalid"
    instant_rp = "InstantRP"
    hardened_rp = "HardenedRP"


class RecoveryPointTierStatus(Enum):

    invalid = "Invalid"
    valid = "Valid"
    disabled = "Disabled"
    deleted = "Deleted"


class RecoveryType(Enum):

    invalid = "Invalid"
    original_location = "OriginalLocation"
    alternate_location = "AlternateLocation"
    restore_disks = "RestoreDisks"


class DayOfWeek(Enum):

    sunday = "Sunday"
    monday = "Monday"
    tuesday = "Tuesday"
    wednesday = "Wednesday"
    thursday = "Thursday"
    friday = "Friday"
    saturday = "Saturday"


class RetentionScheduleFormat(Enum):

    invalid = "Invalid"
    daily = "Daily"
    weekly = "Weekly"


class WeekOfMonth(Enum):

    first = "First"
    second = "Second"
    third = "Third"
    fourth = "Fourth"
    last = "Last"


class MonthOfYear(Enum):

    invalid = "Invalid"
    january = "January"
    february = "February"
    march = "March"
    april = "April"
    may = "May"
    june = "June"
    july = "July"
    august = "August"
    september = "September"
    october = "October"
    november = "November"
    december = "December"


class BackupItemType(Enum):

    invalid = "Invalid"
    vm = "VM"
    file_folder = "FileFolder"
    azure_sql_db = "AzureSqlDb"
    sqldb = "SQLDB"
    exchange = "Exchange"
    sharepoint = "Sharepoint"
    vmware_vm = "VMwareVM"
    system_state = "SystemState"
    client = "Client"
    generic_data_source = "GenericDataSource"


class OperationStatusValues(Enum):

    invalid = "Invalid"
    in_progress = "InProgress"
    succeeded = "Succeeded"
    failed = "Failed"
    canceled = "Canceled"


class HttpStatusCode(Enum):

    continue_enum = "Continue"
    switching_protocols = "SwitchingProtocols"
    ok = "OK"
    created = "Created"
    accepted = "Accepted"
    non_authoritative_information = "NonAuthoritativeInformation"
    no_content = "NoContent"
    reset_content = "ResetContent"
    partial_content = "PartialContent"
    multiple_choices = "MultipleChoices"
    ambiguous = "Ambiguous"
    moved_permanently = "MovedPermanently"
    moved = "Moved"
    found = "Found"
    redirect = "Redirect"
    see_other = "SeeOther"
    redirect_method = "RedirectMethod"
    not_modified = "NotModified"
    use_proxy = "UseProxy"
    unused = "Unused"
    temporary_redirect = "TemporaryRedirect"
    redirect_keep_verb = "RedirectKeepVerb"
    bad_request = "BadRequest"
    unauthorized = "Unauthorized"
    payment_required = "PaymentRequired"
    forbidden = "Forbidden"
    not_found = "NotFound"
    method_not_allowed = "MethodNotAllowed"
    not_acceptable = "NotAcceptable"
    proxy_authentication_required = "ProxyAuthenticationRequired"
    request_timeout = "RequestTimeout"
    conflict = "Conflict"
    gone = "Gone"
    length_required = "LengthRequired"
    precondition_failed = "PreconditionFailed"
    request_entity_too_large = "RequestEntityTooLarge"
    request_uri_too_long = "RequestUriTooLong"
    unsupported_media_type = "UnsupportedMediaType"
    requested_range_not_satisfiable = "RequestedRangeNotSatisfiable"
    expectation_failed = "ExpectationFailed"
    upgrade_required = "UpgradeRequired"
    internal_server_error = "InternalServerError"
    not_implemented = "NotImplemented"
    bad_gateway = "BadGateway"
    service_unavailable = "ServiceUnavailable"
    gateway_timeout = "GatewayTimeout"
    http_version_not_supported = "HttpVersionNotSupported"


class DataSourceType(Enum):

    invalid = "Invalid"
    vm = "VM"
    file_folder = "FileFolder"
    azure_sql_db = "AzureSqlDb"
    sqldb = "SQLDB"
    exchange = "Exchange"
    sharepoint = "Sharepoint"
    vmware_vm = "VMwareVM"
    system_state = "SystemState"
    client = "Client"
    generic_data_source = "GenericDataSource"


class HealthState(Enum):

    passed = "Passed"
    action_required = "ActionRequired"
    action_suggested = "ActionSuggested"
    invalid = "Invalid"


class ScheduleRunType(Enum):

    invalid = "Invalid"
    daily = "Daily"
    weekly = "Weekly"


class ProtectionStatus(Enum):

    invalid = "Invalid"
    not_protected = "NotProtected"
    protecting = "Protecting"
    protected = "Protected"
