'''OpenGL extension EXT.EGL_image_array

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.EGL_image_array to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds functionality to that provided by OES_EGL_image in
	order to support EGLImage 2D arrays. It extends the existing
	EGLImageTargetTexture2DOES entry point from OES_EGL_image. Render buffers
	are not extended to include array support.
	
	EGLImage 2D arrays can be created using extended versions of eglCreateImageKHR.
	For example, EGL_ANDROID_image_native_buffer can import image array native buffers
	on devices where such native buffers can be created.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/EGL_image_array.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.EGL_image_array import *
from OpenGL.raw.GLES2.EXT.EGL_image_array import _EXTENSION_NAME

def glInitEglImageArrayEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION