      REAL FUNCTION  D7TPR(P, X, Y)
C
C  ***  RETURN THE INNER PRODUCT OF THE P-VECTORS X AND Y.  ***
C
      INTEGER P
      REAL X(P), Y(P)
C
      INTEGER I
      REAL ONE, SQTETA, T, ZERO
      REAL  R7MDC
      EXTERNAL  R7MDC
C
C  ***   R7MDC(2) RETURNS A MACHINE-DEPENDENT CONSTANT, SQTETA, WHICH
C  ***  IS SLIGHTLY LARGER THAN THE SMALLEST POSITIVE NUMBER THAT
C  ***  CAN BE SQUARED WITHOUT UNDERFLOWING.
C
C/6
C     DATA ONE/1.E+0/, SQTETA/0.E+0/, ZERO/0.E+0/
C/7
      PARAMETER (ONE=1.E+0, ZERO=0.E+0)
      DATA SQTETA/0.E+0/
C/
C
       D7TPR = ZERO
      IF (P .LE. 0) GO TO 999
      IF (SQTETA .EQ. ZERO) SQTETA =  R7MDC(2)
      DO 20 I = 1, P
         T = AMAX1( ABS(X(I)),  ABS(Y(I)))
         IF (T .GT. ONE) GO TO 10
         IF (T .LT. SQTETA) GO TO 20
         T = (X(I)/SQTETA)*Y(I)
         IF ( ABS(T) .LT. SQTETA) GO TO 20
 10       D7TPR =  D7TPR + X(I)*Y(I)
 20   CONTINUE
C
 999  RETURN
C  ***  LAST LINE OF  D7TPR FOLLOWS  ***
      END
