/*
 * Copyright 2013 Canonical Ltd.
 *
 * This file is part of powerd.
 *
 * powerd is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * powerd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __POWERD_CLI_H__
#define __POWERD_CLI_H__

#include <powerd.h>

#define do_test(test)                                               \
    ({                                                              \
        gboolean result;                                            \
        printf("Test: " #test "\n");                                \
        result = (test);                                            \
        printf("    result: %s\n", result ? "PASSED" : "FAILED");   \
        result;                                                     \
    })

extern gboolean silent_errors;

#define cli_warn(f, a...)   do { if (!silent_errors) g_warning(f, ##a); } while (0)
#define cli_debug(f, a...)  g_debug(f, ##a)

gboolean requestSysState(const char *name, int state, powerd_cookie_t *cookie);
gboolean clearSysState(powerd_cookie_t cookie);
void powerd_cli_client_test(GDBusProxy *proxy);

#endif /* __POWERD_CLI_H__ */
