/*
 * Helper functions to debug models
 *
 * Copyright 2009 Canonical Ltd.
 *
 * Authors:
 * - Aurélien Gâteau <aurelien.gateau@canonical.com>
 *
 * License: GPL v3
 */
#include "modeldump.h"

// Qt
#include <QAbstractItemModel>
#include <QDebug>

namespace ModelDump {

static void dumpIndex(const RoleDumperHash& hash, const QAbstractItemModel* model, const QModelIndex& parent, int depth)
{
    for (int row=0; row < model->rowCount(parent); ++row) {
        QModelIndex index = model->index(row, 0, parent);
        QString line = QString(depth, ' ') + QString::number(row) + '.';

        QMap<int, QVariant> data = model->itemData(index);
        QMapIterator<int, QVariant> it(data);
        while (it.hasNext()) {
            it.next();
            AbstractRoleDumper* dumper = hash.value(it.key());
            QString role, value;
            if (dumper) {
                role = dumper->role();
                value = dumper->value(it.value());
            } else {
                role = QString::number(it.key());
                value = it.value().toString();
            }
            line += QString(" %1:%2;").arg(role).arg(value);
        }
        qDebug() << qPrintable(line);
        if (model->hasChildren(index)) {
            dumpIndex(hash, model, index, depth + 1);
        }
    }
}

void dump(const RoleDumperHash& hash, const QAbstractItemModel* model, const QModelIndex& root)
{
    dumpIndex(hash, model, root, 0);
}

}
