/***************************************************************************
 *   Copyright (C) 2009 by Mathias Rabe <masterunderlined [at] web.de>     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/
#ifndef TRAVERSER_H
#define TRAVERSER_H

#include <kbookmark.h>


class BookmarkTraverser : public QObject,
                    public KBookmarkGroupTraverser
{
    Q_OBJECT
    public:

	using KBookmarkGroupTraverser::traverse;

    protected:

	virtual void visit (const KBookmark &bookmark);
	virtual void visitEnter (const KBookmarkGroup &group);
	virtual void visitLeave (const KBookmarkGroup &group);

    signals:

	void newBookmarkGroup(QString icon, QString text);
	void newBookmark(QString icon, QString rext, KUrl url);
        void leaveBookmarkGroup();

};

#endif
