#!/usr/bin/perl
#
# Convert the result of "autrace program"
# syscalls.
# Ex. autrace /bin/ls > autrace.log
# ./autrace2picviz.pl autrace.log > autrace.pcv
#
# Written by Sebastien Tricaud (C) 2008
#
# Changelog:
# 2008/11/30 - Initial version
#

#
# type=SYSCALL msg=audit(11/30/2008 21:07:31.631:12) : arch=x86_64 syscall=open success=yes exit=3 a0=7f45e54f4b41 a1=0 a2=1 a3=0 items=1 ppid=5110 pid=5112 auid=unset uid=root gid=root euid=root suid=root fsuid=root egid=root sgid=root fsgid=root tty=pts1 ses=4754287995 comm=ls exe=/bin/ls key=(null)
#

print "header {\n";
print "    title = \"Syscalls graph\";\n";
print "}\n";

print "axes {\n";
print "    timeline time [label=\"Timeline\"];\n";
print "    enum     syscall [label=\"Syscall\"];\n";
print "    char     exit [label=\"Exit code\"];\n";
print "    string   exe [label=\"Executable\"];\n";
print "}\n";

print "data {\n";

while ($line = <>) {


	$line =~ s/\\/\\\\/g;
	$line =~ s/\"|&|<|>/\\"/g;


	if ($line =~ m/type=SYSCALL msg=audit\(\d+\/\d+\/\d+ (\d+:\d+:\d+).*\) : arch=\S+ syscall=(\S+) success=(\S+) exit=(\d+) .* exe=(\S+).*/) {

		$time=$1;
		$syscall=$2;
		$success=$3;
		$exitcode=$4;
		$exe=$5;

		if ($exitcode > 255) {
			# We normalize the maximum to 255
			$exitcode = 255;
		}

		if ($success =~ m/yes/) {
			print "    time=\"$time\", syscall=\"$syscall\", exit=\"$exitcode\", exe=\"$exe\";\n";
		} else {
			print "    time=\"$time\", syscall=\"$syscall\", exit=\"$exitcode\", exe=\"$exe\" [color=\"red\"];\n";
		}

	}
}

print "}\n";

