/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <avtTensorMetaData.h>
#include <DataNode.h>

// ****************************************************************************
// Method: avtTensorMetaData::avtTensorMetaData
//
// Purpose: 
//   Init utility for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtTensorMetaData::Init()
{
    dim = 0;

    avtTensorMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtTensorMetaData::avtTensorMetaData
//
// Purpose: 
//   Copy utility for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtTensorMetaData::Copy(const avtTensorMetaData &obj)
{
    dim = obj.dim;

    avtTensorMetaData::SelectAll();
}

// Type map format string
const char *avtTensorMetaData::TypeMapFormatString = AVTTENSORMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtTensorMetaData::TmfsStruct = {AVTTENSORMETADATA_TMFS};


// ****************************************************************************
// Method: avtTensorMetaData::avtTensorMetaData
//
// Purpose: 
//   Default constructor for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtTensorMetaData::avtTensorMetaData() : 
    avtVarMetaData(avtTensorMetaData::TmfsStruct)
{
    avtTensorMetaData::Init();
}

// ****************************************************************************
// Method: avtTensorMetaData::avtTensorMetaData
//
// Purpose: 
//   Constructor for the derived classes of avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtTensorMetaData::avtTensorMetaData(private_tmfs_t tmfs) : 
    avtVarMetaData(tmfs)
{
    avtTensorMetaData::Init();
}

// ****************************************************************************
// Method: avtTensorMetaData::avtTensorMetaData
//
// Purpose: 
//   Copy constructor for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtTensorMetaData::avtTensorMetaData(const avtTensorMetaData &obj) : 
    avtVarMetaData(obj,avtTensorMetaData::TmfsStruct)
{
    avtTensorMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtTensorMetaData::avtTensorMetaData
//
// Purpose: 
//   Copy constructor for derived classes of the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtTensorMetaData::avtTensorMetaData(const avtTensorMetaData &obj, private_tmfs_t tmfs) : 
    avtVarMetaData(obj,tmfs)
{
    avtTensorMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtTensorMetaData::~avtTensorMetaData
//
// Purpose: 
//   Destructor for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtTensorMetaData::~avtTensorMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtTensorMetaData::operator = 
//
// Purpose: 
//   Assignment operator for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtTensorMetaData& 
avtTensorMetaData::operator = (const avtTensorMetaData &obj)
{
    if (this == &obj) return *this;

    // call the base class' assignment operator first
    avtVarMetaData::operator=(obj);

    avtTensorMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtTensorMetaData::operator == 
//
// Purpose: 
//   Comparison operator == for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtTensorMetaData::operator == (const avtTensorMetaData &obj) const
{
    // Create the return value
    return ((dim == obj.dim) &&
            avtVarMetaData::operator==(obj));
}

// ****************************************************************************
// Method: avtTensorMetaData::operator != 
//
// Purpose: 
//   Comparison operator != for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtTensorMetaData::operator != (const avtTensorMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtTensorMetaData::TypeName
//
// Purpose: 
//   Type name method for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
avtTensorMetaData::TypeName() const
{
    return "avtTensorMetaData";
}

// ****************************************************************************
// Method: avtTensorMetaData::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtTensorMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtTensorMetaData *tmp = (const avtTensorMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtTensorMetaData::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtTensorMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtTensorMetaData(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: avtTensorMetaData::NewInstance
//
// Purpose: 
//   NewInstance method for the avtTensorMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtTensorMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtTensorMetaData(*this);
    else
        retval = new avtTensorMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtTensorMetaData::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtTensorMetaData::SelectAll()
{
    // call the base class' SelectAll() first
    avtVarMetaData::SelectAll();
    Select(ID_dim, (void *)&dim);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: avtTensorMetaData constructor
//
//  Arguments:
//      n           The name of the tensor variable.
//      mn          The name of the mesh the tensor var is defined on.
//      c           The centering of the variable.
//      vd          The dimension of the variable.
//
//  Programmer: Hank Childs
//  Creation:   September 20, 2003
//
//  Modifications:
//    Brad Whitlock, Tue Jul 20 13:52:39 PST 2004
//    Added units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
// ****************************************************************************

avtTensorMetaData::avtTensorMetaData(std::string n, std::string mn, 
                                     avtCentering c, int vd)
    : avtVarMetaData(avtTensorMetaData::TmfsStruct, n, mn, c)
{
    avtTensorMetaData::Init();
    dim = vd;
}

// ****************************************************************************
//  Method: avtTensorMetaData::Print
//
//  Purpose:
//      Print statement for debugging.
//
//  Arguments:
//      out      The stream to output to.
//      indent   The number of tabs to indent each line with.
//
//  Programmer:  Hank Childs
//  Creation:    September 20, 2003
//
//  Modifications:
//    Brad Whitlock, Tue Jul 20 13:54:42 PST 2004
//    Added units.
//
//    Hank Childs, Mon Feb 14 14:16:49 PST 2005
//    Added original name.
//
// ****************************************************************************
inline void
Indent(ostream &out, int indent)
{
    for (int i = 0 ; i < indent ; i++)
    {
        out << "\t";
    }
}
void
avtTensorMetaData::Print(ostream &out, int indent) const
{
    avtVarMetaData::Print(out, indent);

    Indent(out, indent);
    out << "Variable Dimension = " << dim << endl;
}

