##############################################################
# Python script to be run within OVITO.
#
# Exports the camera settings of the current viewport to
# the XML format used by Paraview (www.paraview.org).
##############################################################

from sys import *
from math import pi

output_directory = "/home/stukowski1/temp2/"
output_filename = "ovito_camera.pvcc"

vp = ViewportManager.Instance.ActiveViewport
vd = vp.CurrentView
camera_position = vd.InverseViewMatrix.Translation
camera_dir = vd.InverseViewMatrix.GetColumn(2)
camera_up = vd.InverseViewMatrix.GetColumn(1).Normalize()
scene_bb = SceneRenderer.ActiveRenderer.SceneExtents(vp.Settings, AnimManager.Instance.Time, SceneExtentsMode.ALL)
if scene_bb.IsEmpty:
	rotation_center = Point3(0,0,0)
else:
	rotation_center = scene_bb.Center

if vd.IsPerspective:
	fov = vd.FieldOfView * 180.0 / pi
	camera_target = camera_position - camera_dir
else:
	fov = 60.0
	camera_target = camera_position
	camera_position = camera_position + camera_dir * scene_bb.Size.Length

if output_filename == None:
	stream = sys.stdout
else:
	stream = open(output_directory + output_filename, "w")

stream.write("<?xml version=\"1.0\"?>\n")
stream.write("<PVCameraConfiguration description=\"ParaView camera configuration\" version=\"1.0\">\n")
stream.write("  <Proxy group=\"views\" type=\"RenderView\" id=\"21\" servers=\"1\">\n")
stream.write("    <Property name=\"CameraPosition\" id=\"21.CameraPosition\" number_of_elements=\"3\">\n")
stream.write("      <Element index=\"0\" value=\"%f\"/>\n" % camera_position.X)
stream.write("      <Element index=\"1\" value=\"%f\"/>\n" % camera_position.Y)
stream.write("      <Element index=\"2\" value=\"%f\"/>\n" % camera_position.Z)
stream.write("    </Property>\n")
stream.write("    <Property name=\"CameraFocalPoint\" id=\"21.CameraFocalPoint\" number_of_elements=\"3\">\n")
stream.write("      <Element index=\"0\" value=\"%f\"/>\n" % camera_target.X)
stream.write("      <Element index=\"1\" value=\"%f\"/>\n" % camera_target.Y)
stream.write("      <Element index=\"2\" value=\"%f\"/>\n" % camera_target.Z)
stream.write("    </Property>\n")
stream.write("    <Property name=\"CameraViewUp\" id=\"21.CameraViewUp\" number_of_elements=\"3\">\n")
stream.write("      <Element index=\"0\" value=\"%f\"/>\n" % camera_up.X)
stream.write("      <Element index=\"1\" value=\"%f\"/>\n" % camera_up.Y)
stream.write("      <Element index=\"2\" value=\"%f\"/>\n" % camera_up.Z)
stream.write("    </Property>\n")
stream.write("    <Property name=\"CenterOfRotation\" id=\"21.CenterOfRotation\" number_of_elements=\"3\">\n")
stream.write("      <Element index=\"0\" value=\"%f\"/>\n" % rotation_center.X)
stream.write("      <Element index=\"1\" value=\"%f\"/>\n" % rotation_center.Y)
stream.write("      <Element index=\"2\" value=\"%f\"/>\n" % rotation_center.Z)
stream.write("    </Property>\n")
stream.write("    <Property name=\"CameraViewAngle\" id=\"21.CameraViewAngle\" number_of_elements=\"1\">\n")
stream.write("      <Element index=\"0\" value=\"%f\"/>\n" % fov)
stream.write("    </Property>\n")
stream.write("  </Proxy>\n")
stream.write("</PVCameraConfiguration>\n")
