/*
 * Purpose: Definitions for the ymf7xx driver
 */
/*
 *
 * This file is part of Open Sound System.
 *
 * Copyright (C) 4Front Technologies 1996-2008.
 *
 * This this source file is released under GPL v2 license (no other versions).
 * See the COPYING file included in the main directory of this source
 * distribution for the license terms and conditions.
 *
 */
 /*///////////////////////////////////////////////////////// */
 /* */
 /*    Global Control Register  */
 /* */
 /*///////////////////////////////////////////////////////// */
#define		INTERRUPT_FLAG		0x04
#define		ACTIVITY		0x06
#define		GLOBAL_CONTROL		0x08


 /*///////////////////////////////////////////////////////// */
 /* */
 /*    Timer Control Register */
 /* */
 /*///////////////////////////////////////////////////////// */
#define		TIMER_CONTROL		0x10
#define		TIMER_COUNT		0x12


 /*///////////////////////////////////////////////////////// */
 /* */
 /*    SPDIF Control Register */
 /* */
 /*///////////////////////////////////////////////////////// */
#define		SPDIFOUT_CONTROL	0x18
#define		SPDIFOUT_STATUS		0x1c
#define		SPDIFIN_CONTROL		0x34
#define		SPDIFIN_STATUS		0x38

 /*///////////////////////////////////////////////////////// */
 /* */
 /*    EEPROM Control Register */
 /* */
 /*///////////////////////////////////////////////////////// */
#define		EEPROM_CONTROL		0x2c


 /*///////////////////////////////////////////////////////// */
 /* */
 /*    AC3 Control Register */
 /* */
 /*///////////////////////////////////////////////////////// */
#define		AC3_DATA			0x40
#define		AC3_ADDRESS			0x42
#define		AC3_STATUS			0x44


 /*///////////////////////////////////////////////////////// */
 /* */
 /*    AC97 Control Register */
 /* */
 /*///////////////////////////////////////////////////////// */
#define		AC97_CMD_DATA		0x60
#define		AC97_CMD_ADDRESS	0x62
#define		AC97_STATUS_DATA	0x64
#define		AC97_STATUS_ADDRESS	0x66
#define		AC97_SEC_STATUS_DATA	0x68
#define		AC97_SEC_STATUS_ADDR	0x6A
#define		AC97_SEC_CONFIG		0x70

 /*///////////////////////////////////////////////////////// */
 /* */
 /*    Volume Control Register */
 /* */
 /*///////////////////////////////////////////////////////// */
#define		LEGACY_OUTPUT		0x80
#define		LEGACY_OUTPUT_LCH	0x80
#define		LEGACY_OUTPUT_RCH	0x82
#define		NATIVE_DAC		0x84
#define		NATIVE_DAC_LCH		0x84
#define		NATIVE_DAC_RCH		0x86
#define		ZVOUTVOL		0x88
#define		ZV_OUTPUT_LCH		0x88
#define		ZV_OUTPUT_RCH		0x8a
#define		AC3_OUTPUT		0x8c
#define		AC3_OUTPUT_LCH		0x8c
#define		AC3_OUTPUT_RCH		0x8e
#define		ADC_OUTPUT		0x90
#define		ADC_OUTPUT_LCH		0x90
#define		ADC_OUTPUT_RCH		0x92
#define		LEGACY_LOOPBACK		0x94
#define		LEGACY_LOOPBACK_LCH	0x94
#define		LEGACY_LOOPBACK_RCH	0x96
#define		NATIVE_LOOPBACK		0x98
#define		NATIVE_LOOPBACK_LCH	0x98
#define		NATIVE_LOOPBACK_RCH	0x9a
#define		ZVLOOPVOL		0x9c
#define		ZVLOOPBACK_LCH		0x9c
#define		ZVLOOPBACK_RCH		0x9e
#define		AC3_LOOPBACK		0xa0
#define		AC3_LOOPBACK_LCH	0xa0
#define		AC3_LOOPBACK_RCH	0xa2
#define		ADC_LOOPBACK		0xa4
#define		ADC_LOOPBACK_LCH	0xa4
#define		ADC_LOOPBACK_RCH	0xa6
#define		NATIVE_ADC_INPUT	0xa8
#define		NATIVE_ADC_INPUT_LCH	0xa8
#define		NATIVE_ADC_INPUT_RCH	0xaa
#define		NATIVE_REC_INPUT	0xac
#define		NATIVE_REC_INPUT_LCH	0xac
#define		NATIVE_REC_INPUT_RCH	0xae
#define 		BUF441OUTVOL            0xB0
#define 		BUF441OUTVOLL           0xB0
#define 		BUF441OUTVOLR           0xB2
#define 		BUF441LOOPVOL           0xB4
#define 		BUF441LOOPVOLL          0xB4
#define 		BUF441LOOPVOLR          0xB6
#define 		SPDIFOUTVOL             0xB8
#define 		SPDIFOUTVOLL            0xB8
#define 		SPDIFOUTVOLR            0xBA
#define 		SPDIFLOOPVOL            0xBC
#define 		SPDIFLOOPVOLL           0xBC
#define 		SPDIFLOOPVOLR           0xBE


 /*///////////////////////////////////////////////////////// */
 /* */
 /*    Sampling Rate Control Register */
 /* */
 /*///////////////////////////////////////////////////////// */
#define		ADC_SAMPLING_RATE	0xc0
#define		REC_SAMPLING_RATE	0xc4
#define		ADC_FORMAT		0xc8
#define        	REC_FORMAT          	0xcc


 /*///////////////////////////////////////////////////////// */
 /* */
 /*    PCI Native Audio Control Register */
 /* */
 /*///////////////////////////////////////////////////////// */
#define		STATUS			0x100
#define		CONTROL_SELECT		0x104
#define		MODE			0x108
#define		SAMPLE_COUNT		0x10c
#define		NUM_OF_SAMPLES		0x110
#define		CONFIG			0x114
#define		PLAY_CNTRL_SIZE		0x140
#define		REC_CNTRL_SIZE		0x144
#define		EFF_CNTRL_SIZE		0x148
#define		WORK_SIZE		0x14c
#define		MAP_OF_REC		0x150
#define		MAP_OF_EFFECTS		0x154
#define		PLAY_CNTRL_BASE		0x158
#define		REC_CNTRL_BASE		0x15c
#define		EFF_CNTRL_BASE		0x160
#define		WORK_BASE		0x164


 /*///////////////////////////////////////////////////////// */
 /* */
 /*    Instruction RAM */
 /* */
 /*///////////////////////////////////////////////////////// */
#define		DSP_INST_RAM		0x1000
#define		CONTROL_INST_RAM	0x4000


 /*///////////////////////////////////////////////////////// */
 /* */
 /*    Map Length */
 /* */
 /*///////////////////////////////////////////////////////// */
#define		MAP_LENGTH		0x8000


/*============================================================================= */
/* Copyright (c) 1997	Yamaha Corporation.	All Rights Reserved. */
/* */
/*	Title: */
/*		hwmcode.c */
/*	Desc: */
/*		micro-code for CTRL & DSP */
/*	HISTORY: */
/*		April 03, 1997:		1st try by M. Mukojima */
/*============================================================================= */

static unsigned int dsp_size = 0x0020;
static unsigned int dsp[] = {
  0x00000081, 0x000001a4, 0x0000000a, 0x0000002f,
  0x00080253, 0x01800317, 0x0000407b, 0x0000843f,
  0x0001483c, 0x0001943c, 0x0005d83c, 0x00001c3c,
  0x0000c07b, 0x00050c3f, 0x0121503c, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000
};

static unsigned int cntrl_size = 0x0c00;
static unsigned int cntrl[] = {
  0x000007, 0x240007, 0x0C0007, 0x1C0007,
  0x060007, 0x700002, 0x000020, 0x030040,
  0x007104, 0x004286, 0x030040, 0x000F0D,
  0x000810, 0x20043A, 0x000282, 0x00020D,
  0x000810, 0x20043A, 0x001282, 0x200E82,
  0x001A82, 0x033B8D, 0x000810, 0x10043A,
  0x02D90D, 0x000810, 0x18043A, 0x00010D,
  0x020015, 0x0000FD, 0x000020, 0x038860,
  0x039060, 0x038060, 0x038040, 0x038040,
  0x038040, 0x018040, 0x000A7D, 0x038040,
  0x038040, 0x018040, 0x200402, 0x000882,
  0x08001A, 0x000904, 0x015986, 0x000007,
  0x260007, 0x000007, 0x000007, 0x018A06,
  0x000007, 0x03120D, 0x000810, 0x18043A,
  0x260007, 0x00087D, 0x018042, 0x00160A,
  0x04A206, 0x000007, 0x00218D, 0x000810,
  0x08043A, 0x220A06, 0x000007, 0x0007FD,
  0x018042, 0x08000A, 0x000904, 0x029386,
  0x000195, 0x090D04, 0x000007, 0x000820,
  0x0000F5, 0x000B7D, 0x01F060, 0x0000FD,
  0x032206, 0x018040, 0x000A7D, 0x038042,
  0x13804A, 0x18000A, 0x001820, 0x059060,
  0x058860, 0x018040, 0x0000FD, 0x018042,
  0x70000A, 0x000115, 0x071144, 0x032386,
  0x030000, 0x007020, 0x034A06, 0x018040,
  0x00348D, 0x000810, 0x08043A, 0x223206,
  0x000007, 0x02D90D, 0x000810, 0x18043A,
  0x018206, 0x000007, 0x240007, 0x000F8D,
  0x000810, 0x00163A, 0x002402, 0x005C02,
  0x0028FD, 0x000020, 0x018040, 0x08000D,
  0x000815, 0x510984, 0x000007, 0x00004D,
  0x000E5D, 0x000E02, 0x00418D, 0x000810,
  0x08043A, 0x2CE206, 0x000007, 0x00008D,
  0x000924, 0x000F02, 0x00458D, 0x000810,
  0x08043A, 0x2CE206, 0x000007, 0x00387D,
  0x018042, 0x08000A, 0x001015, 0x010984,
  0x018386, 0x000007, 0x01AA06, 0x000007,
  0x0008FD, 0x018042, 0x18000A, 0x001904,
  0x21C886, 0x280007, 0x001810, 0x28043A,
  0x280C02, 0x00000D, 0x000810, 0x28143A,
  0x08808D, 0x000820, 0x0002FD, 0x018040,
  0x200007, 0x00020D, 0x189904, 0x000007,
  0x00402D, 0x0000BD, 0x0002FD, 0x018042,
  0x08000A, 0x000904, 0x055A86, 0x000007,
  0x000100, 0x000A20, 0x00047D, 0x018040,
  0x018042, 0x20000A, 0x003015, 0x012144,
  0x034986, 0x000007, 0x002104, 0x034986,
  0x000007, 0x000F8D, 0x000810, 0x280C3A,
  0x023944, 0x06C986, 0x000007, 0x001810,
  0x28043A, 0x08810D, 0x000820, 0x0002FD,
  0x018040, 0x200007, 0x002810, 0x78003A,
  0x00688D, 0x000810, 0x08043A, 0x28D206,
  0x000007, 0x00400D, 0x001015, 0x189904,
  0x292904, 0x393904, 0x000007, 0x060206,
  0x000007, 0x0004F5, 0x00007D, 0x000020,
  0x00008D, 0x010860, 0x018040, 0x00047D,
  0x038042, 0x21804A, 0x18000A, 0x021944,
  0x21A086, 0x000007, 0x004075, 0x71F104,
  0x000007, 0x010042, 0x28000A, 0x002904,
  0x216886, 0x000007, 0x003C0D, 0x30A904,
  0x000007, 0x00077D, 0x018042, 0x08000A,
  0x000904, 0x07DA86, 0x00057D, 0x002820,
  0x03B060, 0x07F206, 0x018040, 0x003020,
  0x03A860, 0x018040, 0x0002FD, 0x018042,
  0x08000A, 0x000904, 0x07FA86, 0x000007,
  0x00057D, 0x018042, 0x28040A, 0x000E8D,
  0x000810, 0x280C3A, 0x00000D, 0x000810,
  0x28143A, 0x09000D, 0x000820, 0x0002FD,
  0x018040, 0x200007, 0x003DFD, 0x000020,
  0x018040, 0x00107D, 0x008D8D, 0x000810,
  0x08043A, 0x28D206, 0x000007, 0x000815,
  0x08001A, 0x010984, 0x095186, 0x00137D,
  0x200500, 0x280F20, 0x338F60, 0x3B8F60,
  0x438F60, 0x4B8F60, 0x538F60, 0x5B8F60,
  0x038A60, 0x018040, 0x007FBD, 0x383DC4,
  0x000007, 0x001A7D, 0x001375, 0x018042,
  0x09004A, 0x10000A, 0x0B8D04, 0x139504,
  0x000007, 0x000820, 0x019060, 0x001104,
  0x216886, 0x010040, 0x0017FD, 0x018042,
  0x08000A, 0x000904, 0x216A86, 0x000007,
  0x00197D, 0x038042, 0x09804A, 0x10000A,
  0x000924, 0x001664, 0x0011FD, 0x038042,
  0x2B804A, 0x19804A, 0x30000A, 0x00008D,
  0x218944, 0x000007, 0x002244, 0x0AF186,
  0x000007, 0x001A64, 0x002A24, 0x003664,
  0x00197D, 0x080102, 0x100122, 0x000820,
  0x039060, 0x018040, 0x003DFD, 0x00008D,
  0x000820, 0x018040, 0x001375, 0x001A7D,
  0x010042, 0x09804A, 0x10000A, 0x00021D,
  0x0189E4, 0x2992E4, 0x309144, 0x000007,
  0x00060D, 0x000A15, 0x000C1D, 0x001025,
  0x00A9E4, 0x012BE4, 0x000464, 0x01B3E4,
  0x0232E4, 0x000464, 0x000464, 0x000464,
  0x000464, 0x00040D, 0x08B1C4, 0x000007,
  0x000820, 0x000BF5, 0x030040, 0x00197D,
  0x038042, 0x09804A, 0x000A24, 0x08000A,
  0x080E64, 0x000007, 0x100122, 0x000820,
  0x031060, 0x010040, 0x0064AC, 0x00027D,
  0x000020, 0x018040, 0x00107D, 0x018042,
  0x0011FD, 0x3B804A, 0x09804A, 0x20000A,
  0x000095, 0x1A1144, 0x00A144, 0x0D3086,
  0x00040D, 0x00B984, 0x0D3186, 0x0018FD,
  0x018042, 0x0010FD, 0x09804A, 0x28000A,
  0x000095, 0x010924, 0x002A64, 0x0D2186,
  0x000007, 0x002904, 0x0D3286, 0x000007,
  0x0D3A06, 0x080002, 0x00008D, 0x00387D,
  0x000820, 0x018040, 0x00127D, 0x018042,
  0x10000A, 0x003904, 0x0DE186, 0x00080D,
  0x7FFFB5, 0x00B984, 0x0DB186, 0x000025,
  0x0E8A06, 0x00002D, 0x000015, 0x00082D,
  0x02CD0D, 0x000820, 0x0ED206, 0x00000D,
  0x7F8035, 0x00B984, 0x0E8186, 0x400025,
  0x00008D, 0x110944, 0x000007, 0x00018D,
  0x109504, 0x000007, 0x009164, 0x000424,
  0x000424, 0x000424, 0x100102, 0x280002,
  0x02CC0D, 0x000820, 0x0ED206, 0x00018D,
  0x00042D, 0x00008D, 0x109504, 0x000007,
  0x00020D, 0x109184, 0x000007, 0x02CC8D,
  0x000820, 0x00008D, 0x0038FD, 0x018040,
  0x003BFD, 0x001020, 0x03A860, 0x000815,
  0x313184, 0x212184, 0x000007, 0x03B060,
  0x03A060, 0x018040, 0x0022FD, 0x000095,
  0x010924, 0x000424, 0x000424, 0x001264,
  0x100102, 0x000820, 0x039060, 0x018040,
  0x001924, 0x00FC8D, 0x00397D, 0x000820,
  0x058040, 0x038042, 0x09844A, 0x000606,
  0x08040A, 0x000424, 0x000424, 0x00117D,
  0x018042, 0x08000A, 0x000A24, 0x280502,
  0x280C02, 0x09800D, 0x000820, 0x0002FD,
  0x018040, 0x200007, 0x0022FD, 0x018042,
  0x08000A, 0x000095, 0x280DC4, 0x011924,
  0x00197D, 0x018042, 0x0011FD, 0x09804A,
  0x10000A, 0x0000B5, 0x113144, 0x0A8D04,
  0x000007, 0x080A44, 0x129504, 0x000007,
  0x0023FD, 0x001020, 0x038040, 0x101244,
  0x000007, 0x000820, 0x039060, 0x018040,
  0x0002FD, 0x018042, 0x08000A, 0x000904,
  0x110A86, 0x000007, 0x003BFD, 0x000100,
  0x000A10, 0x0B807A, 0x13804A, 0x090984,
  0x000007, 0x000095, 0x013D04, 0x119086,
  0x10000A, 0x100002, 0x090984, 0x000007,
  0x038042, 0x11804A, 0x090D04, 0x000007,
  0x10000A, 0x090D84, 0x000007, 0x00257D,
  0x000820, 0x018040, 0x00010D, 0x000810,
  0x28143A, 0x00127D, 0x018042, 0x20000A,
  0x00197D, 0x018042, 0x00117D, 0x31804A,
  0x10000A, 0x003124, 0x01290D, 0x00397D,
  0x000820, 0x058040, 0x038042, 0x09844A,
  0x000606, 0x08040A, 0x300102, 0x003124,
  0x000424, 0x000424, 0x001224, 0x280502,
  0x001A4C, 0x131186, 0x700002, 0x00002D,
  0x030000, 0x00387D, 0x018042, 0x10000A,
  0x133A06, 0x002124, 0x0000AD, 0x100002,
  0x00010D, 0x000924, 0x006B24, 0x01378D,
  0x00397D, 0x000820, 0x058040, 0x038042,
  0x09844A, 0x000606, 0x08040A, 0x003264,
  0x00008D, 0x000A24, 0x001020, 0x00227D,
  0x018040, 0x013D0D, 0x000810, 0x08043A,
  0x2A1A06, 0x000007, 0x002820, 0x00207D,
  0x018040, 0x00387D, 0x018042, 0x08000A,
  0x000904, 0x166286, 0x000007, 0x00117D,
  0x038042, 0x13804A, 0x33800A, 0x018042,
  0x28000A, 0x00008D, 0x030964, 0x01498D,
  0x00397D, 0x000820, 0x058040, 0x038042,
  0x09844A, 0x000606, 0x08040A, 0x380102,
  0x000424, 0x000424, 0x001224, 0x0002FD,
  0x018042, 0x08000A, 0x000904, 0x14C286,
  0x000007, 0x280502, 0x001A4C, 0x166186,
  0x000007, 0x032164, 0x002E64, 0x00632C,
  0x003DFD, 0x018042, 0x08000A, 0x000095,
  0x090904, 0x000007, 0x000820, 0x001A4C,
  0x158986, 0x018040, 0x030000, 0x15A206,
  0x002124, 0x00010D, 0x000924, 0x006B24,
  0x015E0D, 0x00397D, 0x000820, 0x058040,
  0x038042, 0x09844A, 0x000606, 0x08040A,
  0x003A64, 0x000095, 0x001224, 0x0002FD,
  0x018042, 0x08000A, 0x000904, 0x160286,
  0x000007, 0x01650D, 0x000810, 0x08043A,
  0x2A1A06, 0x000007, 0x14F206, 0x000007,
  0x007020, 0x08010A, 0x10012A, 0x0020FD,
  0x038860, 0x039060, 0x018040, 0x00227D,
  0x018042, 0x003DFD, 0x31844A, 0x18008B,
  0x00324C, 0x172386, 0x000007, 0x001904,
  0x172086, 0x000007, 0x000095, 0x199144,
  0x00222C, 0x003124, 0x002E64, 0x00636C,
  0x000E3D, 0x001375, 0x000BFD, 0x010042,
  0x09804A, 0x10000A, 0x038AEC, 0x0393EC,
  0x00224C, 0x17A186, 0x000007, 0x00008D,
  0x189904, 0x00226C, 0x00322C, 0x002E6C,
  0x00227D, 0x018042, 0x08000A, 0x000904,
  0x17E086, 0x000007, 0x00312C, 0x002A2C,
  0x30050A, 0x301DAB, 0x002083, 0x0018FD,
  0x018042, 0x08000A, 0x018924, 0x300502,
  0x001083, 0x001875, 0x010042, 0x10000A,
  0x00008D, 0x010924, 0x001375, 0x330542,
  0x330CCB, 0x332CCB, 0x3334CB, 0x333CCB,
  0x3344CB, 0x334CCB, 0x3354CB, 0x305C8B,
  0x006083, 0x0002F5, 0x010042, 0x08000A,
  0x000904, 0x18B286, 0x000007, 0x001E2D,
  0x0005FD, 0x058042, 0x08000A, 0x028924,
  0x280502, 0x00060D, 0x000810, 0x280C3A,
  0x00008D, 0x000810, 0x28143A, 0x0A808D,
  0x000820, 0x0002F5, 0x010040, 0x220007,
  0x002275, 0x010042, 0x20000A, 0x002104,
  0x1A2886, 0x000007, 0x0002F5, 0x010042,
  0x08000A, 0x000904, 0x199A86, 0x000007,
  0x002010, 0x30043A, 0x000083, 0x018042,
  0x08000A, 0x028924, 0x280502, 0x280C02,
  0x0A810D, 0x000820, 0x0002F5, 0x010040,
  0x220007, 0x001275, 0x030042, 0x21004A,
  0x28000A, 0x00008D, 0x1A0944, 0x000007,
  0x01A88D, 0x000810, 0x08043A, 0x2B6A06,
  0x000007, 0x0001F5, 0x030042, 0x0D004A,
  0x10000A, 0x089144, 0x000007, 0x000820,
  0x010040, 0x0025F5, 0x0A3144, 0x000007,
  0x000820, 0x032860, 0x030040, 0x00217D,
  0x038042, 0x0B804A, 0x10000A, 0x000820,
  0x031060, 0x030040, 0x00008D, 0x000124,
  0x00012C, 0x000E64, 0x001A64, 0x00636C,
  0x08010A, 0x10012A, 0x000820, 0x031060,
  0x030040, 0x0020FD, 0x018042, 0x08000A,
  0x00227D, 0x018042, 0x10000A, 0x000820,
  0x031060, 0x030040, 0x00197D, 0x018042,
  0x08000A, 0x0022FD, 0x038042, 0x10000A,
  0x000820, 0x031060, 0x030040, 0x090D04,
  0x000007, 0x000820, 0x030040, 0x038042,
  0x0B804A, 0x10000A, 0x000820, 0x031060,
  0x030040, 0x038042, 0x13804A, 0x19804A,
  0x110D04, 0x198D04, 0x000007, 0x08000A,
  0x001020, 0x031860, 0x030860, 0x030040,
  0x00008D, 0x0B0944, 0x000007, 0x000820,
  0x010040, 0x0005F5, 0x030042, 0x08000A,
  0x000820, 0x010040, 0x0000F5, 0x010042,
  0x08000A, 0x000904, 0x1D6886, 0x001E75,
  0x030042, 0x01044A, 0x000C0A, 0x1D7A06,
  0x000007, 0x000402, 0x000C02, 0x00177D,
  0x001AF5, 0x018042, 0x03144A, 0x031C4A,
  0x03244A, 0x032C4A, 0x03344A, 0x033C4A,
  0x03444A, 0x004C0A, 0x00043D, 0x0013F5,
  0x001AFD, 0x030042, 0x0B004A, 0x1B804A,
  0x13804A, 0x20000A, 0x089144, 0x19A144,
  0x0389E4, 0x0399EC, 0x005502, 0x005D0A,
  0x030042, 0x0B004A, 0x1B804A, 0x13804A,
  0x20000A, 0x089144, 0x19A144, 0x0389E4,
  0x0399EC, 0x006502, 0x006D0A, 0x030042,
  0x0B004A, 0x19004A, 0x2B804A, 0x13804A,
  0x21804A, 0x30000A, 0x089144, 0x19A144,
  0x2AB144, 0x0389E4, 0x0399EC, 0x007502,
  0x007D0A, 0x03A9E4, 0x000702, 0x00107D,
  0x000415, 0x018042, 0x08000A, 0x0109E4,
  0x000F02, 0x002AF5, 0x0019FD, 0x010042,
  0x09804A, 0x10000A, 0x000934, 0x001674,
  0x0029F5, 0x010042, 0x10000A, 0x00917C,
  0x002075, 0x010042, 0x08000A, 0x000904,
  0x1FDA86, 0x0026F5, 0x0027F5, 0x030042,
  0x09004A, 0x10000A, 0x000A3C, 0x00167C,
  0x801A75, 0x800BFD, 0x810042, 0xD1804A,
  0xC8000A, 0x960007, 0x801075, 0x810042,
  0xA82C0A, 0xA81D12, 0xA82512, 0x801F32,
  0x9E0007, 0x8E0007, 0x801975, 0x810042,
  0x802DF5, 0x8D004A, 0x90000A, 0x809144,
  0xA0BA86, 0x810042, 0xA8340A, 0x800E5D,
  0x80008D, 0x800375, 0x800820, 0x810040,
  0x85D2F4, 0xD4D104, 0x800007, 0x80735C,
  0xA16386, 0x800007, 0x8C0007, 0x880007,
  0x8A0007, 0x82150D, 0x800810, 0x88043A,
  0xB40A06, 0x800007, 0xA16A06, 0x800007,
  0x880007, 0x8004FD, 0x818042, 0xF0000A,
  0x830000, 0x807020, 0x86FA06, 0x818040,
  0x821C8D, 0x800810, 0x88043A, 0xAB6A06,
  0x800007, 0x8002FD, 0x818042, 0x88000A,
  0x800904, 0xA1D286, 0x800007, 0x81F206,
  0x800007, 0x800875, 0x8009FD, 0x80010D,
  0xA25206, 0x800295, 0x800B75, 0x80097D,
  0x80000D, 0x800515, 0x810042, 0x98000A,
  0x801904, 0xA8C086, 0x8006F5, 0x801020,
  0x810040, 0x8004F5, 0x800820, 0x810040,
  0x800775, 0x810042, 0x89804A, 0x90000A,
  0x801124, 0x800904, 0xA30286, 0x800815,
  0x880102, 0x901204, 0xA32206, 0x800575,
  0x881204, 0x800007, 0x900102, 0x800575,
  0x800425, 0x821124, 0x900102, 0x800820,
  0x831060, 0x810040, 0x801924, 0xA8C086,
  0x80008D, 0x800464, 0x809D04, 0xA7D086,
  0x980102, 0x800575, 0x810042, 0xA8040A,
  0x80018D, 0x800924, 0xA80D02, 0x80000D,
  0x800924, 0xA81502, 0x90000D, 0x800820,
  0x8002F5, 0x810040, 0xA00007, 0x801175,
  0x8002FD, 0x818042, 0x88000A, 0x800904,
  0xA40A86, 0x800007, 0x800100, 0x880B20,
  0x930B60, 0x9B0B60, 0x830A60, 0x810040,
  0x850042, 0xBD004A, 0xB5004A, 0xAD004A,
  0xA0000A, 0x8006F5, 0x810042, 0xA8140A,
  0x8004F5, 0x810042, 0x88000A, 0x800315,
  0x810D04, 0xA51286, 0x804015, 0x800095,
  0x810D04, 0xA50086, 0x900022, 0x90002A,
  0xA52A06, 0x800007, 0xB33104, 0xAAA904,
  0x800007, 0x832124, 0xA80502, 0x801124,
  0x800424, 0x800424, 0x803224, 0x80292C,
  0x80636C, 0xA63B86, 0x800007, 0x82B164,
  0x800464, 0x800464, 0x80008D, 0x800A64,
  0xA80D02, 0x90008D, 0x800820, 0x8002F5,
  0x810040, 0xA20007, 0x80008D, 0xB8B904,
  0x800007, 0x83296C, 0xB0010A, 0x8002F5,
  0x810042, 0x88000A, 0x800904, 0xA60286,
  0x800007, 0x82312C, 0xA8050A, 0x80008D,
  0x81096C, 0xA80D0A, 0x90010D, 0x800820,
  0x8002F5, 0x810040, 0xA20007, 0x801124,
  0x800424, 0x800424, 0x803224, 0xB00102,
  0x832944, 0xA6C286, 0x800007, 0xB00002,
  0x8004F5, 0x810042, 0x88000A, 0x800315,
  0x810D04, 0xA70886, 0x803124, 0x800464,
  0xB00102, 0x8002F5, 0x810042, 0x88000A,
  0x800904, 0xA71286, 0x800007, 0x803124,
  0xB00502, 0x803924, 0xB00583, 0x800883,
  0x8005F5, 0x810042, 0xA8040A, 0x80008D,
  0x808124, 0xA80D02, 0x80008D, 0x808124,
  0xA81502, 0x90018D, 0x800820, 0x8002F5,
  0x810040, 0xA20007, 0x801025, 0x800575,
  0x830042, 0x89004A, 0x90000A, 0x8A0904,
  0x921104, 0x800007, 0x801020, 0x850860,
  0x850040, 0x8006FD, 0x818042, 0x89004A,
  0x90000A, 0x8000A5, 0x8A0904, 0x921104,
  0x800007, 0x800820, 0x819060, 0x810040,
  0x8002F5, 0x810042, 0x88000A, 0x800904,
  0xA88A86, 0x800007, 0xA35206, 0x800007,
  0x800606, 0x800007, 0x8002F5, 0x810042,
  0x88000A, 0x800904, 0xA8DA86, 0x800007,
  0x800100, 0x880B20, 0x938B60, 0x9B8B60,
  0xA38B60, 0xAB8B60, 0xB38B60, 0xBB8B60,
  0xC38B60, 0xCB8B60, 0xD38B60, 0xDB8B60,
  0xE38B60, 0xEB8B60, 0xF38B60, 0xFB8B60,
  0x838F60, 0x8B8F60, 0x938F60, 0x9B8F60,
  0xA38F60, 0xAB8F60, 0xB38F60, 0xBB8F60,
  0xC38F60, 0xCB8F60, 0xD38F60, 0xDB8F60,
  0xE38F60, 0xEB8F60, 0xF38F60, 0xFB8F60,
  0x838A60, 0x800606, 0x818040, 0x80008D,
  0x800A64, 0xA80D02, 0x800A24, 0x80027D,
  0x818042, 0x90000A, 0x801224, 0x8003FD,
  0x818042, 0x88000A, 0x800904, 0xAACA86,
  0x800007, 0x80018D, 0x800A24, 0x800464,
  0x800464, 0x880102, 0x800924, 0x800424,
  0x800424, 0x900102, 0x82000D, 0x809144,
  0xAB2186, 0x800007, 0x8001FD, 0x818042,
  0x88000A, 0x800A44, 0xAB0386, 0x818042,
  0x8A000D, 0x800820, 0x8002FD, 0x818040,
  0xA00007, 0x80027D, 0x801020, 0x800606,
  0x818040, 0x8002F5, 0x810042, 0x88000A,
  0x800904, 0xAB7286, 0x800007, 0x80037D,
  0x818042, 0x88000A, 0x800904, 0xABA286,
  0x800007, 0x800075, 0x802E7D, 0x810042,
  0x8B804A, 0x800020, 0x800904, 0x810040,
  0x800686, 0x800007, 0xB1844A, 0xB0048B,
  0x800883, 0x80008D, 0x800810, 0xA8143A,
  0x80008D, 0x800810, 0xA80C3A, 0x800675,
  0x810042, 0x88000A, 0x803815, 0x810924,
  0xA80502, 0x8B000D, 0x800820, 0x8002F5,
  0x810040, 0xA20007, 0x800606, 0x800007,
  0x800464, 0x800464, 0x800606, 0x800007,
  0x800134, 0x807F8D, 0x80093C, 0xA81D12,
  0xA82512, 0x801F32, 0x8E0007, 0x80010D,
  0x80037D, 0x800820, 0x818040, 0x85D2F4,
  0x800007, 0x880007, 0x80037D, 0x818042,
  0x88000A, 0x800904, 0xAD5A86, 0x800007,
  0x800606, 0x800007, 0x800007, 0x800012,
  0x900007, 0xB20007, 0xE00007, 0x900080,
  0xC8001A, 0x804904, 0xADB986, 0x800007,
  0x801210, 0xD8003A, 0x800145, 0xDC5D04,
  0x800007, 0x800080, 0xC8001A, 0x804904,
  0xAE0986, 0x800007, 0x801210, 0xD0003A,
  0x805904, 0xAE6086, 0x800045, 0x8000C5,
  0xFFFFF5, 0xFFFF7D, 0x87D524, 0x804224,
  0xD00102, 0xA00502, 0x800082, 0xC0001A,
  0x804104, 0xAE9186, 0x800007, 0x803865,
  0xC0001A, 0x804020, 0x80104D, 0x84C184,
  0xB07386, 0x800040, 0x840007, 0x800165,
  0x800145, 0x804020, 0x800040, 0x800765,
  0x880080, 0xC0001A, 0x804104, 0xAF2186,
  0x800007, 0x801210, 0xC0003A, 0x804104,
  0xAF7A86, 0x80004D, 0x8000CD, 0x804810,
  0xA0043A, 0x800882, 0xC0001A, 0x804104,
  0xAF8986, 0x800007, 0x804820, 0x805904,
  0xB06086, 0x800040, 0x8007E5, 0xA00480,
  0xA816A0, 0xB216E0, 0xBA16E0, 0xC216E0,
  0x821260, 0x800040, 0x800032, 0xC00075,
  0x80007D, 0x87D574, 0xA00512, 0x800082,
  0xC0001A, 0x804104, 0xB03986, 0x800007,
  0x837206, 0xE40007, 0x860007, 0x8000E5,
  0x800020, 0x800040, 0x800A65, 0x800020,
  0x820040, 0x820040, 0x800040, 0x800165,
  0x800042, 0xF0000A, 0x807104, 0xB0FA86,
  0x800007, 0x818206, 0xE40007, 0x850000,
  0x807020, 0x800040, 0x837206, 0xE40007,
  0x800007, 0x80306D, 0x828860, 0x829060,
  0x829860, 0x88000A, 0x828860, 0x880102,
  0x900122, 0x828860, 0x829060, 0x808040,
  0x900012, 0x801020, 0x803B6D, 0x808040,
  0x80100D, 0x809184, 0xB1E186, 0x800007,
  0x800E0D, 0x809184, 0xB2B986, 0x800007,
  0xB00007, 0x800080, 0x88001A, 0x800904,
  0xB1E986, 0x800007, 0x801220, 0x800DED,
  0x808040, 0x808042, 0x98000A, 0xC0000D,
  0x809D64, 0xA00502, 0x800082, 0x88001A,
  0x800904, 0xB25186, 0x800007, 0x803B6D,
  0x808042, 0x88000A, 0x800E15, 0x810984,
  0xE00007, 0xB33B86, 0x800007, 0x8003ED,
  0x808042, 0x88000A, 0x800904, 0xB31A86,
  0x800007, 0x88001A, 0x800C15, 0x810984,
  0xB31B86, 0x800007, 0x9A0007, 0x8002ED,
  0x800020, 0x808040, 0xE20007, 0x8032ED,
  0x828042, 0x88804A, 0x90000A, 0x800924,
  0x801664, 0x800007, 0x80306D, 0x828042,
  0x8A804A, 0x800820, 0x8A804A, 0x92804A,
  0x9A804A, 0x800606, 0x800007, 0x800007,
  0xA82512, 0x801F32, 0x85D2F4, 0xD4D104,
  0x80735C, 0x800786, 0x800007, 0x8C0007,
  0x8A0007, 0x9C0007, 0x803465, 0x820040,
  0x804820, 0x825060, 0xC0000A, 0x824060,
  0x800040, 0xC54944, 0x800007, 0x804020,
  0x803AE5, 0x800040, 0x8028E5, 0x820042,
  0xC8000A, 0x804904, 0xB9A886, 0x800007,
  0x800042, 0xC0000A, 0x804104, 0xB4E086,
  0x800007, 0x802402, 0xB7EA06, 0x805C02,
  0x802C65, 0x800042, 0xC0000A, 0x8000D5,
  0xC54104, 0x800007, 0x800655, 0x854504,
  0xB67286, 0x800007, 0x8001D5, 0x854504,
  0xB67086, 0x800007, 0x802B65, 0x800042,
  0xD0000A, 0x803AE5, 0x800042, 0xC0000A,
  0xC5C3D4, 0x800007, 0xC54504, 0x800007,
  0x803A65, 0x805820, 0x800040, 0x8000DD,
  0xC45944, 0x800007, 0xC54504, 0x800007,
  0x80015D, 0xD55944, 0x800007, 0x845144,
  0xB65186, 0x800007, 0x802C65, 0x800042,
  0xD8000A, 0xDDD104, 0x800007, 0x85C144,
  0xB65B86, 0x800007, 0x960007, 0x803A65,
  0x800042, 0xD8000A, 0x802CE5, 0x840042,
  0xC0000A, 0x804020, 0x800040, 0x8025E5,
  0x820042, 0xC0004A, 0xD0000A, 0x804274,
  0x805674, 0x802AE5, 0x800042, 0xC0000A,
  0x804274, 0xD00112, 0x8029E5, 0x800042,
  0xC0000A, 0x804234, 0xC54104, 0x800007,
  0x804020, 0x800040, 0x803EE5, 0x800020,
  0x800040, 0x802DE5, 0xC00152, 0xD0000A,
  0x845144, 0xB79286, 0x8000C5, 0x803EE5,
  0x804020, 0x800040, 0x802BE5, 0x800042,
  0xC0000A, 0xC04254, 0x800007, 0x802AE5,
  0x804020, 0x800040, 0xD00132, 0x840134,
  0x805674, 0x8029E5, 0x820042, 0xC2000A,
  0x800042, 0xD0000A, 0x85417C, 0x8000C5,
  0xCCC144, 0xB84086, 0x8026E5, 0x8027E5,
  0x820042, 0xC0004A, 0xD0000A, 0x80423C,
  0x80567C, 0x8028E5, 0x804820, 0x800040,
  0xA81D12, 0xA82512, 0x801F72, 0x802965,
  0x800042, 0xC0000A, 0x804104, 0xB8DA86,
  0x800007, 0x960007, 0x9E0007, 0x8E0007,
  0x803EE5, 0x800042, 0xC0000A, 0x804104,
  0xB92086, 0x802D65, 0x800042, 0xA8340A,
  0x803465, 0x820042, 0xC2004A, 0x804020,
  0xCA004A, 0xD0004A, 0x85D2F4, 0xD4D104,
  0x800007, 0x80735C, 0xB99186, 0x800007,
  0x800606, 0x880007, 0x8C0007, 0x880007,
  0x8A0007, 0x8001E5, 0x820045, 0x804020,
  0x800060, 0x800365, 0x800040, 0x802E65,
  0x801A20, 0x8A1A60, 0x800040, 0x803465,
  0x820042, 0xC2004A, 0x804020, 0xCA004A,
  0x800606, 0xD0004A, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000
};

static unsigned int cntrl1E_size = 0x0c00;
static unsigned int cntrl1E[] = {
  0x000007, 0x240007, 0x0C0007, 0x1C0007,
  0x060007, 0x700002, 0x000020, 0x030040,
  0x007104, 0x004286, 0x030040, 0x000F0D,
  0x000810, 0x20043A, 0x000282, 0x00020D,
  0x000810, 0x20043A, 0x001282, 0x200E82,
  0x00800D, 0x000810, 0x20043A, 0x001A82,
  0x03460D, 0x000810, 0x10043A, 0x02EC0D,
  0x000810, 0x18043A, 0x00010D, 0x020015,
  0x0000FD, 0x000020, 0x038860, 0x039060,
  0x038060, 0x038040, 0x038040, 0x038040,
  0x018040, 0x000A7D, 0x038040, 0x038040,
  0x018040, 0x200402, 0x000882, 0x08001A,
  0x000904, 0x017186, 0x000007, 0x260007,
  0x400007, 0x000007, 0x03258D, 0x000810,
  0x18043A, 0x260007, 0x284402, 0x00087D,
  0x018042, 0x00160A, 0x05A206, 0x000007,
  0x440007, 0x00230D, 0x000810, 0x08043A,
  0x22FA06, 0x000007, 0x0007FD, 0x018042,
  0x08000A, 0x000904, 0x02AB86, 0x000195,
  0x090D04, 0x000007, 0x000820, 0x0000F5,
  0x000B7D, 0x01F060, 0x0000FD, 0x033A06,
  0x018040, 0x000A7D, 0x038042, 0x13804A,
  0x18000A, 0x001820, 0x059060, 0x058860,
  0x018040, 0x0000FD, 0x018042, 0x70000A,
  0x000115, 0x071144, 0x033B86, 0x030000,
  0x007020, 0x036206, 0x018040, 0x00360D,
  0x000810, 0x08043A, 0x232206, 0x000007,
  0x02EC0D, 0x000810, 0x18043A, 0x019A06,
  0x000007, 0x240007, 0x000F8D, 0x000810,
  0x00163A, 0x002402, 0x005C02, 0x0028FD,
  0x000020, 0x018040, 0x08000D, 0x000815,
  0x510984, 0x000007, 0x00004D, 0x000E5D,
  0x000E02, 0x00430D, 0x000810, 0x08043A,
  0x2E1206, 0x000007, 0x00008D, 0x000924,
  0x000F02, 0x00470D, 0x000810, 0x08043A,
  0x2E1206, 0x000007, 0x480480, 0x001210,
  0x28043A, 0x00778D, 0x000810, 0x280C3A,
  0x00068D, 0x000810, 0x28143A, 0x284402,
  0x03258D, 0x000810, 0x18043A, 0x07FF8D,
  0x000820, 0x0002FD, 0x018040, 0x260007,
  0x200007, 0x0002FD, 0x018042, 0x08000A,
  0x000904, 0x051286, 0x000007, 0x240007,
  0x02EC0D, 0x000810, 0x18043A, 0x00387D,
  0x018042, 0x08000A, 0x001015, 0x010984,
  0x019B86, 0x000007, 0x01B206, 0x000007,
  0x0008FD, 0x018042, 0x18000A, 0x001904,
  0x22B886, 0x280007, 0x001810, 0x28043A,
  0x280C02, 0x00000D, 0x000810, 0x28143A,
  0x08808D, 0x000820, 0x0002FD, 0x018040,
  0x200007, 0x00020D, 0x189904, 0x000007,
  0x00402D, 0x0000BD, 0x0002FD, 0x018042,
  0x08000A, 0x000904, 0x065A86, 0x000007,
  0x000100, 0x000A20, 0x00047D, 0x018040,
  0x018042, 0x20000A, 0x003015, 0x012144,
  0x036186, 0x000007, 0x002104, 0x036186,
  0x000007, 0x000F8D, 0x000810, 0x280C3A,
  0x023944, 0x07C986, 0x000007, 0x001810,
  0x28043A, 0x08810D, 0x000820, 0x0002FD,
  0x018040, 0x200007, 0x002810, 0x78003A,
  0x00788D, 0x000810, 0x08043A, 0x2A1206,
  0x000007, 0x00400D, 0x001015, 0x189904,
  0x292904, 0x393904, 0x000007, 0x070206,
  0x000007, 0x0004F5, 0x00007D, 0x000020,
  0x00008D, 0x010860, 0x018040, 0x00047D,
  0x038042, 0x21804A, 0x18000A, 0x021944,
  0x229086, 0x000007, 0x004075, 0x71F104,
  0x000007, 0x010042, 0x28000A, 0x002904,
  0x225886, 0x000007, 0x003C0D, 0x30A904,
  0x000007, 0x00077D, 0x018042, 0x08000A,
  0x000904, 0x08DA86, 0x00057D, 0x002820,
  0x03B060, 0x08F206, 0x018040, 0x003020,
  0x03A860, 0x018040, 0x0002FD, 0x018042,
  0x08000A, 0x000904, 0x08FA86, 0x000007,
  0x00057D, 0x018042, 0x28040A, 0x000E8D,
  0x000810, 0x280C3A, 0x00000D, 0x000810,
  0x28143A, 0x09000D, 0x000820, 0x0002FD,
  0x018040, 0x200007, 0x003DFD, 0x000020,
  0x018040, 0x00107D, 0x009D8D, 0x000810,
  0x08043A, 0x2A1206, 0x000007, 0x000815,
  0x08001A, 0x010984, 0x0A5186, 0x00137D,
  0x200500, 0x280F20, 0x338F60, 0x3B8F60,
  0x438F60, 0x4B8F60, 0x538F60, 0x5B8F60,
  0x038A60, 0x018040, 0x00107D, 0x018042,
  0x08000A, 0x000215, 0x010984, 0x3A8186,
  0x000007, 0x007FBD, 0x383DC4, 0x000007,
  0x001A7D, 0x001375, 0x018042, 0x09004A,
  0x10000A, 0x0B8D04, 0x139504, 0x000007,
  0x000820, 0x019060, 0x001104, 0x225886,
  0x010040, 0x0017FD, 0x018042, 0x08000A,
  0x000904, 0x225A86, 0x000007, 0x00197D,
  0x038042, 0x09804A, 0x10000A, 0x000924,
  0x001664, 0x0011FD, 0x038042, 0x2B804A,
  0x19804A, 0x00008D, 0x218944, 0x000007,
  0x002244, 0x0C1986, 0x000007, 0x001A64,
  0x002A24, 0x00197D, 0x080102, 0x100122,
  0x000820, 0x039060, 0x018040, 0x003DFD,
  0x00008D, 0x000820, 0x018040, 0x001375,
  0x001A7D, 0x010042, 0x09804A, 0x10000A,
  0x00021D, 0x0189E4, 0x2992E4, 0x309144,
  0x000007, 0x00060D, 0x000A15, 0x000C1D,
  0x001025, 0x00A9E4, 0x012BE4, 0x000464,
  0x01B3E4, 0x0232E4, 0x000464, 0x000464,
  0x000464, 0x000464, 0x00040D, 0x08B1C4,
  0x000007, 0x000820, 0x000BF5, 0x030040,
  0x00197D, 0x038042, 0x09804A, 0x000A24,
  0x08000A, 0x080E64, 0x000007, 0x100122,
  0x000820, 0x031060, 0x010040, 0x0064AC,
  0x00027D, 0x000020, 0x018040, 0x00107D,
  0x018042, 0x0011FD, 0x3B804A, 0x09804A,
  0x20000A, 0x000095, 0x1A1144, 0x00A144,
  0x0E5886, 0x00040D, 0x00B984, 0x0E5986,
  0x0018FD, 0x018042, 0x0010FD, 0x09804A,
  0x28000A, 0x000095, 0x010924, 0x002A64,
  0x0E4986, 0x000007, 0x002904, 0x0E5A86,
  0x000007, 0x0E6206, 0x080002, 0x00008D,
  0x00387D, 0x000820, 0x018040, 0x00127D,
  0x018042, 0x10000A, 0x003904, 0x0F0986,
  0x00080D, 0x7FFFB5, 0x00B984, 0x0ED986,
  0x000025, 0x0FB206, 0x00002D, 0x000015,
  0x00082D, 0x02E00D, 0x000820, 0x0FFA06,
  0x00000D, 0x7F8035, 0x00B984, 0x0FA986,
  0x400025, 0x00008D, 0x110944, 0x000007,
  0x00018D, 0x109504, 0x000007, 0x009164,
  0x000424, 0x000424, 0x000424, 0x100102,
  0x280002, 0x02DF0D, 0x000820, 0x0FFA06,
  0x00018D, 0x00042D, 0x00008D, 0x109504,
  0x000007, 0x00020D, 0x109184, 0x000007,
  0x02DF8D, 0x000820, 0x00008D, 0x0038FD,
  0x018040, 0x003BFD, 0x001020, 0x03A860,
  0x000815, 0x313184, 0x212184, 0x000007,
  0x03B060, 0x03A060, 0x018040, 0x0022FD,
  0x000095, 0x010924, 0x000424, 0x000424,
  0x001264, 0x100102, 0x000820, 0x039060,
  0x018040, 0x001924, 0x010F0D, 0x00397D,
  0x000820, 0x058040, 0x038042, 0x09844A,
  0x000606, 0x08040A, 0x000424, 0x000424,
  0x00117D, 0x018042, 0x08000A, 0x000A24,
  0x280502, 0x280C02, 0x09800D, 0x000820,
  0x0002FD, 0x018040, 0x200007, 0x0022FD,
  0x018042, 0x08000A, 0x000095, 0x280DC4,
  0x011924, 0x00197D, 0x018042, 0x0011FD,
  0x09804A, 0x10000A, 0x0000B5, 0x113144,
  0x0A8D04, 0x000007, 0x080A44, 0x129504,
  0x000007, 0x0023FD, 0x001020, 0x038040,
  0x101244, 0x000007, 0x000820, 0x039060,
  0x018040, 0x0002FD, 0x018042, 0x08000A,
  0x000904, 0x123286, 0x000007, 0x003BFD,
  0x000100, 0x000A10, 0x0B807A, 0x13804A,
  0x090984, 0x000007, 0x000095, 0x013D04,
  0x12B886, 0x10000A, 0x100002, 0x090984,
  0x000007, 0x038042, 0x11804A, 0x090D04,
  0x000007, 0x10000A, 0x090D84, 0x000007,
  0x00257D, 0x000820, 0x018040, 0x00010D,
  0x000810, 0x28143A, 0x00127D, 0x018042,
  0x20000A, 0x00197D, 0x018042, 0x00117D,
  0x31804A, 0x10000A, 0x003124, 0x013B8D,
  0x00397D, 0x000820, 0x058040, 0x038042,
  0x09844A, 0x000606, 0x08040A, 0x300102,
  0x003124, 0x000424, 0x000424, 0x001224,
  0x280502, 0x001A4C, 0x143986, 0x700002,
  0x00002D, 0x030000, 0x00387D, 0x018042,
  0x10000A, 0x146206, 0x002124, 0x0000AD,
  0x100002, 0x00010D, 0x000924, 0x006B24,
  0x014A0D, 0x00397D, 0x000820, 0x058040,
  0x038042, 0x09844A, 0x000606, 0x08040A,
  0x003264, 0x00008D, 0x000A24, 0x001020,
  0x00227D, 0x018040, 0x014F8D, 0x000810,
  0x08043A, 0x2B5A06, 0x000007, 0x002820,
  0x00207D, 0x018040, 0x00117D, 0x038042,
  0x13804A, 0x33800A, 0x00387D, 0x018042,
  0x08000A, 0x000904, 0x177286, 0x000007,
  0x00008D, 0x030964, 0x015B0D, 0x00397D,
  0x000820, 0x058040, 0x038042, 0x09844A,
  0x000606, 0x08040A, 0x380102, 0x000424,
  0x000424, 0x001224, 0x0002FD, 0x018042,
  0x08000A, 0x000904, 0x15DA86, 0x000007,
  0x280502, 0x001A4C, 0x177186, 0x000007,
  0x032164, 0x00632C, 0x003DFD, 0x018042,
  0x08000A, 0x000095, 0x090904, 0x000007,
  0x000820, 0x001A4C, 0x169986, 0x018040,
  0x030000, 0x16B206, 0x002124, 0x00010D,
  0x000924, 0x006B24, 0x016F0D, 0x00397D,
  0x000820, 0x058040, 0x038042, 0x09844A,
  0x000606, 0x08040A, 0x003A64, 0x000095,
  0x001224, 0x0002FD, 0x018042, 0x08000A,
  0x000904, 0x171286, 0x000007, 0x01760D,
  0x000810, 0x08043A, 0x2B5A06, 0x000007,
  0x160A06, 0x000007, 0x007020, 0x08010A,
  0x10012A, 0x0020FD, 0x038860, 0x039060,
  0x018040, 0x00227D, 0x018042, 0x003DFD,
  0x08000A, 0x31844A, 0x000904, 0x181086,
  0x18008B, 0x00008D, 0x189904, 0x00312C,
  0x18E206, 0x000007, 0x00324C, 0x186B86,
  0x000007, 0x001904, 0x186886, 0x000007,
  0x000095, 0x199144, 0x00222C, 0x003124,
  0x00636C, 0x000E3D, 0x001375, 0x000BFD,
  0x010042, 0x09804A, 0x10000A, 0x038AEC,
  0x0393EC, 0x00224C, 0x18E186, 0x000007,
  0x00008D, 0x189904, 0x00226C, 0x00322C,
  0x30050A, 0x301DAB, 0x002083, 0x0018FD,
  0x018042, 0x08000A, 0x018924, 0x300502,
  0x001083, 0x001875, 0x010042, 0x10000A,
  0x00008D, 0x010924, 0x001375, 0x330542,
  0x330CCB, 0x332CCB, 0x3334CB, 0x333CCB,
  0x3344CB, 0x334CCB, 0x3354CB, 0x305C8B,
  0x006083, 0x0002F5, 0x010042, 0x08000A,
  0x000904, 0x19B286, 0x000007, 0x001E2D,
  0x0005FD, 0x018042, 0x08000A, 0x028924,
  0x280502, 0x00060D, 0x000810, 0x280C3A,
  0x00008D, 0x000810, 0x28143A, 0x0A808D,
  0x000820, 0x0002F5, 0x010040, 0x220007,
  0x001275, 0x030042, 0x21004A, 0x00008D,
  0x1A0944, 0x000007, 0x01AB8D, 0x000810,
  0x08043A, 0x2CAA06, 0x000007, 0x0001F5,
  0x030042, 0x0D004A, 0x10000A, 0x089144,
  0x000007, 0x000820, 0x010040, 0x0025F5,
  0x0A3144, 0x000007, 0x000820, 0x032860,
  0x030040, 0x00217D, 0x038042, 0x0B804A,
  0x10000A, 0x000820, 0x031060, 0x030040,
  0x00008D, 0x000124, 0x00012C, 0x000E64,
  0x001A64, 0x00636C, 0x08010A, 0x10012A,
  0x000820, 0x031060, 0x030040, 0x0020FD,
  0x018042, 0x08000A, 0x00227D, 0x018042,
  0x10000A, 0x000820, 0x031060, 0x030040,
  0x00197D, 0x018042, 0x08000A, 0x0022FD,
  0x038042, 0x10000A, 0x000820, 0x031060,
  0x030040, 0x090D04, 0x000007, 0x000820,
  0x030040, 0x038042, 0x0B804A, 0x10000A,
  0x000820, 0x031060, 0x030040, 0x038042,
  0x13804A, 0x19804A, 0x110D04, 0x198D04,
  0x000007, 0x08000A, 0x001020, 0x031860,
  0x030860, 0x030040, 0x00008D, 0x0B0944,
  0x000007, 0x000820, 0x010040, 0x0005F5,
  0x030042, 0x08000A, 0x000820, 0x010040,
  0x0000F5, 0x010042, 0x08000A, 0x000904,
  0x1D9886, 0x001E75, 0x030042, 0x01044A,
  0x000C0A, 0x1DAA06, 0x000007, 0x000402,
  0x000C02, 0x00177D, 0x001AF5, 0x018042,
  0x03144A, 0x031C4A, 0x03244A, 0x032C4A,
  0x03344A, 0x033C4A, 0x03444A, 0x004C0A,
  0x00043D, 0x0013F5, 0x001AFD, 0x030042,
  0x0B004A, 0x1B804A, 0x13804A, 0x20000A,
  0x089144, 0x19A144, 0x0389E4, 0x0399EC,
  0x005502, 0x005D0A, 0x030042, 0x0B004A,
  0x1B804A, 0x13804A, 0x20000A, 0x089144,
  0x19A144, 0x0389E4, 0x0399EC, 0x006502,
  0x006D0A, 0x030042, 0x0B004A, 0x19004A,
  0x2B804A, 0x13804A, 0x21804A, 0x30000A,
  0x089144, 0x19A144, 0x2AB144, 0x0389E4,
  0x0399EC, 0x007502, 0x007D0A, 0x03A9E4,
  0x000702, 0x00107D, 0x000415, 0x018042,
  0x08000A, 0x0109E4, 0x000F02, 0x002AF5,
  0x0019FD, 0x010042, 0x09804A, 0x10000A,
  0x000934, 0x001674, 0x0029F5, 0x010042,
  0x10000A, 0x00917C, 0x002075, 0x010042,
  0x08000A, 0x000904, 0x200A86, 0x0026F5,
  0x0027F5, 0x030042, 0x09004A, 0x10000A,
  0x000A3C, 0x00167C, 0x001A75, 0x000BFD,
  0x010042, 0x51804A, 0x48000A, 0x160007,
  0x001075, 0x010042, 0x282C0A, 0x281D12,
  0x282512, 0x001F32, 0x1E0007, 0x0E0007,
  0x001975, 0x010042, 0x002DF5, 0x0D004A,
  0x10000A, 0x009144, 0x20EA86, 0x010042,
  0x28340A, 0x000E5D, 0x00008D, 0x000375,
  0x000820, 0x010040, 0x05D2F4, 0x54D104,
  0x00735C, 0x218B86, 0x000007, 0x0C0007,
  0x080007, 0x0A0007, 0x02178D, 0x000810,
  0x08043A, 0x34B206, 0x000007, 0x219206,
  0x000007, 0x080007, 0x002275, 0x010042,
  0x20000A, 0x002104, 0x225886, 0x001E2D,
  0x0002F5, 0x010042, 0x08000A, 0x000904,
  0x21CA86, 0x000007, 0x002010, 0x30043A,
  0x00057D, 0x0180C3, 0x08000A, 0x028924,
  0x280502, 0x280C02, 0x0A810D, 0x000820,
  0x0002F5, 0x010040, 0x220007, 0x0004FD,
  0x018042, 0x70000A, 0x030000, 0x007020,
  0x07FA06, 0x018040, 0x022B8D, 0x000810,
  0x08043A, 0x2CAA06, 0x000007, 0x0002FD,
  0x018042, 0x08000A, 0x000904, 0x22C286,
  0x000007, 0x020206, 0x000007, 0x000875,
  0x0009FD, 0x00010D, 0x234206, 0x000295,
  0x000B75, 0x00097D, 0x00000D, 0x000515,
  0x010042, 0x18000A, 0x001904, 0x2A0086,
  0x0006F5, 0x001020, 0x010040, 0x0004F5,
  0x000820, 0x010040, 0x000775, 0x010042,
  0x09804A, 0x10000A, 0x001124, 0x000904,
  0x23F286, 0x000815, 0x080102, 0x101204,
  0x241206, 0x000575, 0x081204, 0x000007,
  0x100102, 0x000575, 0x000425, 0x021124,
  0x100102, 0x000820, 0x031060, 0x010040,
  0x001924, 0x2A0086, 0x00008D, 0x000464,
  0x009D04, 0x291086, 0x180102, 0x000575,
  0x010042, 0x28040A, 0x00018D, 0x000924,
  0x280D02, 0x00000D, 0x000924, 0x281502,
  0x10000D, 0x000820, 0x0002F5, 0x010040,
  0x200007, 0x001175, 0x0002FD, 0x018042,
  0x08000A, 0x000904, 0x24FA86, 0x000007,
  0x000100, 0x080B20, 0x130B60, 0x1B0B60,
  0x030A60, 0x010040, 0x050042, 0x3D004A,
  0x35004A, 0x2D004A, 0x20000A, 0x0006F5,
  0x010042, 0x28140A, 0x0004F5, 0x010042,
  0x08000A, 0x000315, 0x010D04, 0x260286,
  0x004015, 0x000095, 0x010D04, 0x25F086,
  0x100022, 0x10002A, 0x261A06, 0x000007,
  0x333104, 0x2AA904, 0x000007, 0x032124,
  0x280502, 0x284402, 0x001124, 0x400102,
  0x000424, 0x000424, 0x003224, 0x00292C,
  0x00636C, 0x277386, 0x000007, 0x02B164,
  0x000464, 0x000464, 0x00008D, 0x000A64,
  0x280D02, 0x10008D, 0x000820, 0x0002F5,
  0x010040, 0x220007, 0x00008D, 0x38B904,
  0x000007, 0x03296C, 0x30010A, 0x0002F5,
  0x010042, 0x08000A, 0x000904, 0x270286,
  0x000007, 0x00212C, 0x28050A, 0x00316C,
  0x00046C, 0x00046C, 0x28450A, 0x001124,
  0x006B64, 0x100102, 0x00008D, 0x01096C,
  0x280D0A, 0x10010D, 0x000820, 0x0002F5,
  0x010040, 0x220007, 0x004124, 0x000424,
  0x000424, 0x003224, 0x300102, 0x032944,
  0x27FA86, 0x000007, 0x300002, 0x0004F5,
  0x010042, 0x08000A, 0x000315, 0x010D04,
  0x284086, 0x003124, 0x000464, 0x300102,
  0x0002F5, 0x010042, 0x08000A, 0x000904,
  0x284A86, 0x000007, 0x284402, 0x003124,
  0x300502, 0x003924, 0x300583, 0x000883,
  0x0005F5, 0x010042, 0x28040A, 0x00008D,
  0x008124, 0x280D02, 0x00008D, 0x008124,
  0x281502, 0x10018D, 0x000820, 0x0002F5,
  0x010040, 0x220007, 0x001025, 0x000575,
  0x030042, 0x09004A, 0x10000A, 0x0A0904,
  0x121104, 0x000007, 0x001020, 0x050860,
  0x050040, 0x0006FD, 0x018042, 0x09004A,
  0x10000A, 0x0000A5, 0x0A0904, 0x121104,
  0x000007, 0x000820, 0x019060, 0x010040,
  0x0002F5, 0x010042, 0x08000A, 0x000904,
  0x29CA86, 0x000007, 0x244206, 0x000007,
  0x000606, 0x000007, 0x0002F5, 0x010042,
  0x08000A, 0x000904, 0x2A1A86, 0x000007,
  0x000100, 0x080B20, 0x138B60, 0x1B8B60,
  0x238B60, 0x2B8B60, 0x338B60, 0x3B8B60,
  0x438B60, 0x4B8B60, 0x538B60, 0x5B8B60,
  0x638B60, 0x6B8B60, 0x738B60, 0x7B8B60,
  0x038F60, 0x0B8F60, 0x138F60, 0x1B8F60,
  0x238F60, 0x2B8F60, 0x338F60, 0x3B8F60,
  0x438F60, 0x4B8F60, 0x538F60, 0x5B8F60,
  0x638F60, 0x6B8F60, 0x738F60, 0x7B8F60,
  0x038A60, 0x000606, 0x018040, 0x00008D,
  0x000A64, 0x280D02, 0x000A24, 0x00027D,
  0x018042, 0x10000A, 0x001224, 0x0003FD,
  0x018042, 0x08000A, 0x000904, 0x2C0A86,
  0x000007, 0x00018D, 0x000A24, 0x000464,
  0x000464, 0x080102, 0x000924, 0x000424,
  0x000424, 0x100102, 0x02000D, 0x009144,
  0x2C6186, 0x000007, 0x0001FD, 0x018042,
  0x08000A, 0x000A44, 0x2C4386, 0x018042,
  0x0A000D, 0x000820, 0x0002FD, 0x018040,
  0x200007, 0x00027D, 0x001020, 0x000606,
  0x018040, 0x0002F5, 0x010042, 0x08000A,
  0x000904, 0x2CB286, 0x000007, 0x00037D,
  0x018042, 0x08000A, 0x000904, 0x2CE286,
  0x000007, 0x000075, 0x002E7D, 0x010042,
  0x0B804A, 0x000020, 0x000904, 0x000686,
  0x010040, 0x31844A, 0x30048B, 0x000883,
  0x00008D, 0x000810, 0x28143A, 0x00008D,
  0x000810, 0x280C3A, 0x000675, 0x010042,
  0x08000A, 0x003815, 0x010924, 0x280502,
  0x0B000D, 0x000820, 0x0002F5, 0x010040,
  0x000606, 0x220007, 0x000464, 0x000464,
  0x000606, 0x000007, 0x000134, 0x007F8D,
  0x00093C, 0x281D12, 0x282512, 0x001F32,
  0x0E0007, 0x00010D, 0x00037D, 0x000820,
  0x018040, 0x05D2F4, 0x000007, 0x080007,
  0x00037D, 0x018042, 0x08000A, 0x000904,
  0x2E8A86, 0x000007, 0x000606, 0x000007,
  0x000007, 0x000012, 0x100007, 0x320007,
  0x600007, 0x460007, 0x100080, 0x48001A,
  0x004904, 0x2EF186, 0x000007, 0x001210,
  0x58003A, 0x000145, 0x5C5D04, 0x000007,
  0x000080, 0x48001A, 0x004904, 0x2F4186,
  0x000007, 0x001210, 0x50003A, 0x005904,
  0x2F9886, 0x000045, 0x0000C5, 0x7FFFF5,
  0x7FFF7D, 0x07D524, 0x004224, 0x500102,
  0x200502, 0x000082, 0x40001A, 0x004104,
  0x2FC986, 0x000007, 0x003865, 0x40001A,
  0x004020, 0x00104D, 0x04C184, 0x31AB86,
  0x000040, 0x040007, 0x000165, 0x000145,
  0x004020, 0x000040, 0x000765, 0x080080,
  0x40001A, 0x004104, 0x305986, 0x000007,
  0x001210, 0x40003A, 0x004104, 0x30B286,
  0x00004D, 0x0000CD, 0x004810, 0x20043A,
  0x000882, 0x40001A, 0x004104, 0x30C186,
  0x000007, 0x004820, 0x005904, 0x319886,
  0x000040, 0x0007E5, 0x200480, 0x2816A0,
  0x3216E0, 0x3A16E0, 0x4216E0, 0x021260,
  0x000040, 0x000032, 0x400075, 0x00007D,
  0x07D574, 0x200512, 0x000082, 0x40001A,
  0x004104, 0x317186, 0x000007, 0x038A06,
  0x640007, 0x0000E5, 0x000020, 0x000040,
  0x000A65, 0x000020, 0x020040, 0x020040,
  0x000040, 0x000165, 0x000042, 0x70000A,
  0x007104, 0x323286, 0x000007, 0x060007,
  0x019A06, 0x640007, 0x050000, 0x007020,
  0x000040, 0x038A06, 0x640007, 0x000007,
  0x00306D, 0x028860, 0x029060, 0x08000A,
  0x028860, 0x008040, 0x100012, 0x00100D,
  0x009184, 0x32D186, 0x000E0D, 0x009184,
  0x33E186, 0x000007, 0x300007, 0x001020,
  0x003B6D, 0x008040, 0x000080, 0x08001A,
  0x000904, 0x32F186, 0x000007, 0x001220,
  0x000DED, 0x008040, 0x008042, 0x10000A,
  0x40000D, 0x109544, 0x000007, 0x001020,
  0x000DED, 0x008040, 0x008042, 0x20040A,
  0x000082, 0x08001A, 0x000904, 0x338186,
  0x000007, 0x003B6D, 0x008042, 0x08000A,
  0x000E15, 0x010984, 0x342B86, 0x600007,
  0x08001A, 0x000C15, 0x010984, 0x341386,
  0x000020, 0x1A0007, 0x0002ED, 0x008040,
  0x620007, 0x00306D, 0x028042, 0x0A804A,
  0x000820, 0x0A804A, 0x000606, 0x10804A,
  0x000007, 0x282512, 0x001F32, 0x05D2F4,
  0x54D104, 0x00735C, 0x000786, 0x000007,
  0x0C0007, 0x0A0007, 0x1C0007, 0x003465,
  0x020040, 0x004820, 0x025060, 0x40000A,
  0x024060, 0x000040, 0x454944, 0x000007,
  0x004020, 0x003AE5, 0x000040, 0x0028E5,
  0x000042, 0x48000A, 0x004904, 0x39F886,
  0x002C65, 0x000042, 0x40000A, 0x0000D5,
  0x454104, 0x000007, 0x000655, 0x054504,
  0x368286, 0x0001D5, 0x054504, 0x368086,
  0x002B65, 0x000042, 0x003AE5, 0x50004A,
  0x40000A, 0x45C3D4, 0x000007, 0x454504,
  0x000007, 0x0000CD, 0x444944, 0x000007,
  0x454504, 0x000007, 0x00014D, 0x554944,
  0x000007, 0x045144, 0x367986, 0x002C65,
  0x000042, 0x48000A, 0x4CD104, 0x000007,
  0x04C144, 0x368386, 0x000007, 0x160007,
  0x002CE5, 0x040042, 0x40000A, 0x004020,
  0x000040, 0x002965, 0x000042, 0x40000A,
  0x004104, 0x36F086, 0x000007, 0x002402,
  0x383206, 0x005C02, 0x0025E5, 0x000042,
  0x40000A, 0x004274, 0x002AE5, 0x000042,
  0x40000A, 0x004274, 0x500112, 0x0029E5,
  0x000042, 0x40000A, 0x004234, 0x454104,
  0x000007, 0x004020, 0x000040, 0x003EE5,
  0x000020, 0x000040, 0x002DE5, 0x400152,
  0x50000A, 0x045144, 0x37DA86, 0x0000C5,
  0x003EE5, 0x004020, 0x000040, 0x002BE5,
  0x000042, 0x40000A, 0x404254, 0x000007,
  0x002AE5, 0x004020, 0x000040, 0x500132,
  0x040134, 0x005674, 0x0029E5, 0x020042,
  0x42000A, 0x000042, 0x50000A, 0x05417C,
  0x0028E5, 0x000042, 0x48000A, 0x0000C5,
  0x4CC144, 0x38A086, 0x0026E5, 0x0027E5,
  0x020042, 0x40004A, 0x50000A, 0x00423C,
  0x00567C, 0x0028E5, 0x004820, 0x000040,
  0x281D12, 0x282512, 0x001F72, 0x002965,
  0x000042, 0x40000A, 0x004104, 0x393A86,
  0x0E0007, 0x160007, 0x1E0007, 0x003EE5,
  0x000042, 0x40000A, 0x004104, 0x397886,
  0x002D65, 0x000042, 0x28340A, 0x003465,
  0x020042, 0x42004A, 0x004020, 0x4A004A,
  0x50004A, 0x05D2F4, 0x54D104, 0x00735C,
  0x39E186, 0x000007, 0x000606, 0x080007,
  0x0C0007, 0x080007, 0x0A0007, 0x0001E5,
  0x020045, 0x004020, 0x000060, 0x000365,
  0x000040, 0x002E65, 0x001A20, 0x0A1A60,
  0x000040, 0x003465, 0x020042, 0x42004A,
  0x004020, 0x4A004A, 0x000606, 0x50004A,
  0x0017FD, 0x018042, 0x08000A, 0x000904,
  0x225A86, 0x000007, 0x00107D, 0x018042,
  0x0011FD, 0x33804A, 0x19804A, 0x20000A,
  0x000095, 0x2A1144, 0x01A144, 0x3B9086,
  0x00040D, 0x00B184, 0x3B9186, 0x0018FD,
  0x018042, 0x0010FD, 0x09804A, 0x38000A,
  0x000095, 0x010924, 0x003A64, 0x3B8186,
  0x000007, 0x003904, 0x3B9286, 0x000007,
  0x3B9A06, 0x00000D, 0x00008D, 0x000820,
  0x00387D, 0x018040, 0x700002, 0x00117D,
  0x018042, 0x00197D, 0x29804A, 0x30000A,
  0x380002, 0x003124, 0x000424, 0x000424,
  0x002A24, 0x280502, 0x00068D, 0x000810,
  0x28143A, 0x00750D, 0x00B124, 0x002264,
  0x3D0386, 0x284402, 0x000810, 0x280C3A,
  0x0B800D, 0x000820, 0x0002FD, 0x018040,
  0x200007, 0x00758D, 0x00B124, 0x100102,
  0x012144, 0x3E4986, 0x001810, 0x10003A,
  0x00387D, 0x018042, 0x08000A, 0x000904,
  0x3E4886, 0x030000, 0x3E4A06, 0x0000BD,
  0x00008D, 0x023164, 0x000A64, 0x280D02,
  0x0B808D, 0x000820, 0x0002FD, 0x018040,
  0x200007, 0x00387D, 0x018042, 0x08000A,
  0x000904, 0x3E3286, 0x030000, 0x0002FD,
  0x018042, 0x08000A, 0x000904, 0x3D8286,
  0x000007, 0x002810, 0x28043A, 0x00750D,
  0x030924, 0x002264, 0x280D02, 0x02316C,
  0x28450A, 0x0B810D, 0x000820, 0x0002FD,
  0x018040, 0x200007, 0x00008D, 0x000A24,
  0x3E4A06, 0x100102, 0x001810, 0x10003A,
  0x0000BD, 0x003810, 0x30043A, 0x00187D,
  0x018042, 0x0018FD, 0x09804A, 0x20000A,
  0x0000AD, 0x028924, 0x07212C, 0x001010,
  0x300583, 0x300D8B, 0x3014BB, 0x301C83,
  0x002083, 0x00137D, 0x038042, 0x33844A,
  0x33ACCB, 0x33B4CB, 0x33BCCB, 0x33C4CB,
  0x33CCCB, 0x33D4CB, 0x305C8B, 0x006083,
  0x001E0D, 0x0005FD, 0x018042, 0x20000A,
  0x020924, 0x00068D, 0x00A96C, 0x00009D,
  0x0002FD, 0x018042, 0x08000A, 0x000904,
  0x3F6A86, 0x000007, 0x280502, 0x280D0A,
  0x284402, 0x001810, 0x28143A, 0x0C008D,
  0x000820, 0x0002FD, 0x018040, 0x220007,
  0x003904, 0x225886, 0x001E0D, 0x00057D,
  0x018042, 0x20000A, 0x020924, 0x0000A5,
  0x0002FD, 0x018042, 0x08000A, 0x000904,
  0x402A86, 0x000007, 0x280502, 0x280C02,
  0x002010, 0x28143A, 0x0C010D, 0x000820,
  0x0002FD, 0x018040, 0x225A06, 0x220007,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000,
  0x000000, 0x000000, 0x000000, 0x000000
};

#define	PLAY_TABLE_SIZE		0x200
#define DMA_BUFF_SIZE		0x2000
#define	RIGHT			0
#define	LEFT			1

typedef struct
{
  unsigned int *table;
}
PLAY_CNTRL_TABLE;


typedef struct
{
  unsigned int Format;
  unsigned int LoopDefault;
  unsigned int PgBase;
  unsigned int PgLoop;
  unsigned int PgLoopEnd;
  unsigned int PgLoopFrac;
  unsigned int PgDeltaEnd;
  unsigned int LpfKEnd;
  unsigned int EgGainEnd;
  unsigned int LchGainEnd;
  unsigned int RchGainEnd;
  unsigned int Effect1GainEnd;
  unsigned int Effect2GainEnd;
  unsigned int Effect3GainEnd;
  unsigned int LpfQ;
  unsigned int Status;
  unsigned int NumOfFrames;
  unsigned int LoopCount;
  unsigned int PgStart;
  unsigned int PgStartFrac;
  unsigned int PgDelta;
  unsigned int LpfK;
  unsigned int EgGain;
  unsigned int LchGain;
  unsigned int RchGain;
  unsigned int Effect1Gain;
  unsigned int Effect2Gain;
  unsigned int Effect3Gain;
  unsigned int LpfDelay1;
  unsigned int LpfDelay2;
}
PLAY_BANK;

typedef struct
{
  unsigned int PgBase;
  unsigned int PgLoopEndAdr;
  unsigned int PgStartAdr;
  unsigned int NumOfLoops;
}
REC_BANK;

typedef struct
{
  unsigned int PgBase;
  unsigned int PgLoopEnd;
  unsigned int PgStart;
  unsigned int Temp;

}
EFFECT_BANK;

typedef struct
{
  PLAY_BANK *bank1;
  PLAY_BANK *bank2;
}
PLAY_CNTRL_SLOT;

typedef struct
{
  oss_native_word base;
  REC_BANK *bank1;
  REC_BANK *bank2;
  REC_BANK *bank3;
  REC_BANK *bank4;
}
REC_CNTRL_SLOT;

typedef struct
{
  oss_native_word base;
  EFFECT_BANK *bank1;
  EFFECT_BANK *bank2;
  EFFECT_BANK *bank3;
  EFFECT_BANK *bank4;
  EFFECT_BANK *bank5;
  EFFECT_BANK *bank6;
  EFFECT_BANK *bank7;
  EFFECT_BANK *bank8;
  EFFECT_BANK *bank9;
  EFFECT_BANK *bank10;
}
EFFECT_CNTRL_SLOT;
