###############################################################################
# OpenVAS Vulnerability Test
# $Id: serv_u_36585.nasl 7589 2010-05-07 14:33:00Z chandra $
#
# Serv-U 'SITE SET TRANSFERPROGRESS ON' Command Remote Denial of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100338);
 script_bugtraq_id(36585);
 script_version ("1.0-$Revision: 7589 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Serv-U 'SITE SET TRANSFERPROGRESS ON' Command Remote Denial of Service Vulnerability");

desc = "Overview:
Serv-U is prone to a remote denial-of-service vulnerability.

Successfully exploiting this issue will allow attackers to deny
service to legitimate users.

Serv-U 7.0.0.1 through 8.2.0.3 are vulnerable; other versions may also
be affected.

Solution:
The vendor has released an update. Please see the references
for details.

References:
http://www.securityfocus.com/bid/36585
http://www.serv-u.com/
http://www.serv-u.com/releasenotes/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Serv-U is prone to a remote denial-of-service vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family("FTP");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("gb_rhinosoft_serv-u_detect.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(get_kb_item('ftp/'+port+'/broken'))exit(0);

if(!get_port_state(port)){
  exit(0);
}

if(!version = get_kb_item(string("ftp/", port, "/Serv-U"))) {
 if(!version = get_kb_item(string("Serv-U/FTP/Ver"))) {
  exit(0);
 }  
}  

if(!isnull(version[1])) {
  vers = version[1];
}  

if(!isnull(vers)) {

    if( version_in_range(version:vers, test_version:"7.0.0.1", test_version2:"8.2.0.3") ) {
        security_warning(port: port);
        exit(0);
    }
}

exit(0);

