###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ruby_heap_bof_vuln_lin_dec09.nasl 6202 2009-12-22 18:25:29Z dec $
#
# Ruby Interpreter Heap Overflow Vulnerability (Linux) - Dec09
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900726);
  script_version("$Revision: 8288 $: 1.0");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-4124");
  script_bugtraq_id(37278);
  script_name("Ruby Interpreter Heap Overflow Vulnerability (Linux) - Dec09");
  desc = "
  Overview: This host is installed with Ruby Interpreter and is prone to Heap
  Overflow vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper sanitization check while processing user
  supplied input data to the buffer inside 'String#ljust', 'String#center' and
  'String#rjust' methods.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code, corrupt
  the heap area to execute the crafted malicious shellcode into the system
  registers to take control over the remote machine.

  Affected Software/OS:
  Ruby Interpreter version 1.9.1 before 1.9.1 Patchlevel 376

  Fix:  Apply the patch
  ftp://ftp.ruby-lang.org/pub/ruby/1.9/ruby-1.9.1-p376.tar.bz2

  *****
  NOTE: Please ignore this warning if the patch is applied.
  *****

  References:
  http://www.osvdb.org/60880
  http://secunia.com/advisories/37660
  http://www.vupen.com/english/advisories/2009/3471
  http://www.ruby-lang.org/en/news/2009/12/07/heap-overflow-in-string

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Ruby Interpreter");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_ruby_detect_lin.nasl");
  script_require_keys("Ruby/Lin/Ver");
  exit(0);
}


include("version_func.inc");

rubyVer = get_kb_item("Ruby/Lin/Ver");
if(!rubyVer){
  exit(0);
}

# Grep for Ruby Interpreter version from 1.9.1 to 1.9.1 Patch Level 375
if(version_in_range(version:rubyVer, test_version:"1.9.1",
                                     test_version2:"1.9.1.p375")){
  security_hole(0);
}
