###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for netpbm CESA-2008:0131-01 centos2 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880006);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "CESA", value: "2008:0131-01");
  script_cve_id("CVE-2008-0554");
  script_name( "CentOS Update for netpbm CESA-2008:0131-01 centos2 i386");
  desc = "

  Vulnerability Insight:
  The netpbm package contains a library of functions for editing and
  converting between various graphics file formats, including .pbm (portable
  bitmaps), .pgm (portable graymaps), .pnm (portable anymaps), .ppm (portable
  pixmaps) and others. The package includes no interactive tools and is
  primarily used by other programs (eg CGI scripts that manage web-site
  images).
  
  An input validation flaw was discovered in the GIF-to-PNM converter
  (giftopnm) shipped with the netpbm package. An attacker could create a
  carefully crafted GIF file which could cause giftopnm to crash or possibly
  execute arbitrary code as the user running giftopnm. (CVE-2008-0554)
  
  All users are advised to upgrade to these updated packages which contain a
  backported patch which resolves this issue.


  Affected Software/OS:
  netpbm on CentOS 2

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-March/014758.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of netpbm");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CentOS2")
{

  if(isrpmvuln(pkg:"netpbm", rpm:"netpbm~9.24~9.AS21.7", rls:"CentOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"netpbm-devel", rpm:"netpbm-devel~9.24~9.AS21.7", rls:"CentOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"netpbm-progs", rpm:"netpbm-progs~9.24~9.AS21.7", rls:"CentOS2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
