# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1909-1 (postgresql-ocaml)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66057);
 script_cve_id("CVE-2009-2943");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1909-1 (postgresql-ocaml)");

 desc = "The remote host is missing an update to postgresql-ocaml
announced via advisory DSA 1909-1.


It was discovered that postgresql-ocaml, OCaml bindings to PostgreSQL's
libpq, was missing a function to call PQescapeStringConn(). This is
needed, because PQescapeStringConn() honours the charset of the
connection and prevents insufficient escaping, when certain multibyte
character encodings are used. The added function is called
escape_string_conn() and takes the established database connection as a
first argument. The old escape_string() was kept for backwards
compatibility.

Developers using these bindings are encouraged to adjust their code to
use the new function.


For the stable distribution (lenny), this problem has been fixed in
version 1.7.0-3+lenny1.

For the oldstable distribution (etch), this problem has been fixed in
version 1.5.4-2+etch1.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem has been fixed in version 1.12.1-1.


We recommend that you upgrade your postgresql-ocaml packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201909-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1909-1 (postgresql-ocaml)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpostgresql-ocaml-dev", ver:"1.5.4-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpostgresql-ocaml", ver:"1.5.4-2+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpostgresql-ocaml-dev", ver:"1.7.0-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpostgresql-ocaml", ver:"1.7.0-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
