#!/bin/bash

#################################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
#################################################################################

if test "$2" = pegasus
then
	if !( ps -C cimserver > /dev/null 2>&1 )
	then
		echo "ERROR: Pegasus CIM server is not running"
		exit 1
	fi
fi

if test "$2" = openwbem
then
	if !( ps -C owcimomd > /dev/null 2>&1 )
	then
		echo "ERROR: OpenWBEM CIM server is not running"
		exit 1
	fi
fi

if test "$2" = sfcb
then
	/etc/init.d/sfcb stop
fi

$4/registration/OpenDRIM_TCPProtocolEndpointBindsToIPProtocolEndpoint-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_HostedSSHService-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_SSHSettingData-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_SSHServiceSettingData-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_SSHServiceAccessBySAP-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_SSHProtocolService-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_SSHProtocolEndpointBindsToTCPProtocolEndpoint-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_SSHConformsToProfile-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_RegisteredSSHProfile-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_HostedSSHAccessPoint-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_SSHCapabilities-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_SSHProtocolProvidesEndpoint-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_SSHSessionSettingData-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_TCPProtocolEndpoint-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_SSHProtocolCapabilities-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_SSHProtocolEndpoint-remove.sh $1 $2 $3 $4

if test "$2" = sfcb
then
	/etc/init.d/sfcb start
fi

