/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_INSTALLEDOSACCESS_H_
#define OPENDRIM_INSTALLEDOSACCESS_H_

#include "OS_Common.h"

#include "OpenDRIM_InstalledOS.h"
#include "assocOpenDRIM_InstalledOS.h"

int OS_OpenDRIM_InstalledOS_load(const CMPIBroker* broker, string& errorMessage);

int OS_OpenDRIM_InstalledOS_unload(string& errorMessage);

int OS_OpenDRIM_InstalledOS_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_InstalledOS>& instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_InstalledOS_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_InstalledOS& instance, const char** properties, string& errorMessage);

int OS_OpenDRIM_InstalledOS_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_InstalledOS& newInstance, const OpenDRIM_InstalledOS& oldInstance, const char** properties, string& errorMessage);

int OS_OpenDRIM_InstalledOS_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_InstalledOS& instance, string& errorMessage);

int OS_OpenDRIM_InstalledOS_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_InstalledOS& instance, string& errorMessage);

int OS_OpenDRIM_InstalledOS_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_InstalledOS_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_InstalledOS_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_InstalledOS>& OpenDRIM_InstalledOS_instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_InstalledOS_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_InstalledOS>& OpenDRIM_InstalledOS_instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_InstalledOS_populate(OpenDRIM_InstalledOS& instance, string& errorMessage);

#endif /*OPENDRIM_INSTALLEDOSACCESS_H_*/
