# Gallery

# MoveIt!

An overview of [MoveIt!](http://moveit.ros.org), the [ROS](http://www.ros.org) package that provides a high-level interface to OMPL and other motion planning packages.

\htmlonly
<iframe width="560" height="315" src="http://www.youtube.com/embed/vAeEEoxVhAo" frameborder="0" allowfullscreen></iframe>
\endhtmlonly

# Manipulation Planning

An example of using OMPL on the PR2 from [Willow Garage](http://www.willowgarage.com). The robot is asked to move the manipulate objects on the table. This demo is using [ROS](http://www.ros.org).

\htmlonly
<iframe width="560" height="315" src="http://www.youtube.com/embed/eUpvbOxrbwY" frameborder="0" allowfullscreen></iframe>
\endhtmlonly

# ROS-Industrial Consortium

ROS-Industrial aims to bring ROS to the industrial world. Path and motion planning, as provided by OMPL, are critical component of that. Below is brief overview of ROS-Industrial.

\htmlonly
<iframe width="560" height="315" src="http://www.youtube.com/embed/h54YzGIZFt4" frameborder="0" allowfullscreen></iframe>
\endhtmlonly

# Real-time footstep planning for humanoid robots

Below is a video illustrating the results of using OMPL to plan footsteps for a humanoid. The work is described in detail in:

  Nicolas Perrin and Olivier Stasse and Florent Lamiraux and Young J. Kim and Dinesh Manocha, Real-time footstep planning for humanoid robots among 3D obstacles using a hybrid bounding box, in _Proc. IEEE Conf. on Robotics and Automation_, 2012.

The focus is not so much on OMPL, but rather a new hybrid bounding box that allows the robot to step over obstacles.

\htmlonly
<iframe width="420" height="315" src="http://www.youtube.com/embed/HNE4dMycosE" frameborder="0" allowfullscreen></iframe>
\endhtmlonly

# Planning for a Car-Like Vehicle Using ODE

An example of using OMPL to plan for a robotic system simulated with [ODE](http://sourceforge.net/projects/opende). The goal is for the yellow car to reach the location of the green box without hitting the red box. The computation is performed using \ref cKPIECE1 "KPIECE". For each computed motion plan, a representation of the exploration data structure (a tree of motions) is also shown.

\htmlonly
<iframe width="420" height="315" src="http://www.youtube.com/embed/bX23YA-pasg" frameborder="0" allowfullscreen></iframe>
\endhtmlonly

# Planning Using OMPL.app {#gallery_omplapp}

Below are some rigid body motion planning problems and corresponding solutions found by OMPL.app. The planar examples use a kinematic car model.

\htmlonly
<div class="row">
    <div class="span4">
        <iframe src="http://player.vimeo.com/video/58686594?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff&amp;autoplay=1&amp;loop=1" width="280" height="281" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
    </div>
    <div class="span4">
        <iframe src="http://player.vimeo.com/video/58709484?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff&amp;autoplay=1&amp;loop=1" width="280" height="256" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
    </div>
    <div class="span4">
        <iframe src="http://player.vimeo.com/video/58686591?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff&amp;autoplay=1&amp;loop=1" width="280" height="280" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
    </div>
</div>
<div class="row">
    <div class="span4">
        <iframe src="http://player.vimeo.com/video/58709589?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff&amp;autoplay=1&amp;loop=1" width="280" height="188" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
    </div>
    <div class="span4">
        <iframe src="http://player.vimeo.com/video/58686593?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff&amp;autoplay=1&amp;loop=1" width="280" height="195" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
    </div>
    <div class="span4">
        <iframe src="http://player.vimeo.com/video/58686590?title=0&amp;byline=0&amp;portrait=0&amp;color=ffffff&amp;autoplay=1&amp;loop=1" width="280" height="198" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
    </div>
</div>
\endhtmlonly

# Planning for Underactuated Systems in the Presence of Drift

In the [game of Koules](http://www.ucw.cz/~hubicka/koules/English/), there are a number of balls (called koules) flying in an orbit. The user controls a spaceship. At any time the user can do one of four things: coast, accelerate, turn left, or turn right. The ship and the koules are allowed to collide. The objective is for the ship to bounce all the koules out of the workspace. The user loses when the ship is bounced out of the workspace first. We have written a [demo program](Koules_8cpp_source.html) that solves this game. The physics have been made significantly harder than in the original game. The movie below shows a solution path found by the [Koules demo](Koules_8cpp_source.html) for 7 koules.

\htmlonly
<iframe src="http://player.vimeo.com/video/68184980?byline=0&amp;portrait=0&amp;color=ffffff" width="560" height="560" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
\endhtmlonly


# Class Project from COMP 450 on Path Optimization {#gallery_comp450}

In Fall 2010 OMPL was used for the first time in Lydia Kavraki's Algorithmic Robotics class. Students completed several projects. For their last project they could choose from several options. Linda Hill and Yu Yun worked on path optimization. The different optimization criteria considered they considered were path length and sum of discrete path curvature sum. Minimizing the former in shorter paths, minimizing the second results in smoother paths. They used two optimization techniques specific to paths / curves: B-spline interpolation and path hybridization. Path smoothing using B-spline interpolation is shown below on the left. In path hybridization a set of (approximate) solutions to a motion planning problem is given as input, cross-over points are computed, and a new optimized path composed of path segments is found. An example of path hybridization to minimize path length is shown below on the right. In both cases the paths were in SE(3); the figures show simply the R<sup>3</sup> component.

\htmlonly
<div class="row">
<div class="span6">
  <img src="../images/bspline_cubicle_smoother.png" width="100%"><br>
<b>Path smoothing with B-splines.</b> The input path is shown in red, the optimized output path is shown in blue.
</div>
<div class="span6">
  <img src="../images/hybridization_cubicle_shorter.png" width="100%"><br>
<b>Path shortening using path hybridization.</b> The colored paths are input, the solid black path is the optimized output path.
</div>
</div>
\endhtmlonly
