      logical function tce_ccsdt_response_driver(title,thresh,maxiter,
     &        d_tr1,k_tr1_offset,size_tr1,d_tr2,k_tr2_offset,size_tr2,
     &        d_tr3,k_tr3_offset,size_tr3,d_t1,k_t1_offset,
     &        d_t2,k_t2_offset,d_t3,k_t3_offset,d_f1,k_f1_offset,
     &        d_v2,k_v2_offset,d_o1,k_o1_offset,omega,diis_tr3)
c
c $Id: tce_ccsdt_response_driver.F 19706 2010-10-29 17:52:31Z d3y133 $
c 
c Main routine for many-electron theory calculations.
c Some of the subroutines have been generated by 
c operator/tensor contraction engines.
c
c Written by Jeff Hammond, January 2008.
c
      implicit none
#include "mafdecls.fh"
#include "tcgmsg.fh"
#include "global.fh"
#include "bas.fh"
#include "geom.fh"
#include "sym.fh"
#include "util.fh"
#include "msgids.fh"
#include "stdio.fh"
#include "sf.fh"
#include "inp.fh"
#include "errquit.fh"
#include "tce.fh"
c#include "tce_main.fh"
c#include "tce_prop.fh"
c#include "tce_ints.fh"
c#include "tce_amps.fh"
c#include "tce_diis.fh"
c
c     CI, CC, & MBPT
c
      integer iter,maxiter
      logical nodezero         ! True if node 0
      logical recompf          ! True if recompute Fock
      logical diis_tr3
      double precision cpu     ! CPU sec counter
      double precision wall    ! WALL sec counter
      integer irrep
      integer irrep_g
      integer d_tr1            ! SF handle for tr1 amplitudes
      integer k_tr1_offset      ! Offset for tr1 file
      integer size_tr1          ! File size in doubles
      integer d_tr2            ! SF handle for tr2 amplitudes
      integer k_tr2_offset      ! Offset for tr2 file
      integer size_tr2          ! File size in doubles
      integer d_tr3            ! SF handle for tr2 amplitudes
      integer k_tr3_offset      ! Offset for tr2 file
      integer size_tr3          ! File size in doubles
      integer d_rr1,d_rr2,d_rr3
      integer d_o1
      integer k_o1_offset
      integer d_f1             ! SF handle for MO 1e integrals
      integer k_f1_offset      ! Offset for 1e integral file
      integer d_v2             ! SF handle for MO 2e integrals
      integer k_v2_offset      ! Offset for 2e integral file
      integer d_t1             ! SF handle for t1 amplitudes
      integer k_t1_offset      ! Offset for t1 file
      integer size_t1          ! File size in doubles
      integer d_t2             ! SF handle for t2 amplitudes
      integer k_t2_offset      ! Offset for t2 file
      integer size_t2          ! File size in doubles
      integer d_t3             ! SF handle for t2 amplitudes
      integer k_t3_offset      ! Offset for t2 file
      integer size_t3          ! File size in doubles
      double precision rr1,rr2,rr3
      double precision residual! Largest residual
      double precision thresh
      double precision ddotfile
      double precision omega
      character*6 rr1filename ! File name stub
      data rr1filename/'rr1   '/
      character*6 rr2filename ! File name stub
      data rr2filename/'rr2   '/
      character*6 rr3filename ! File name stub
      data rr3filename/'rr3   '/
      external ddotfile
      integer dummy            ! Dummy argument for DIIS
      character*255 filename
      character*20 title
      character*4 irrepname
      nodezero=(ga_nodeid().eq.0)
      call tce_diis_init()
      do iter=1,maxiter
        cpu=-util_cpusec()
        wall=-util_wallsec()
        if (nodezero.and.(iter.eq.1))
     &    write(LuOut,9400) title
        call tce_filename(rr1filename,filename)
        call createfile(filename,d_rr1,size_tr1)
        call tce_zero(d_rr1,size_tr1)
        call daxpyfile(1,omega,d_tr1,d_rr1,size_tr1)
        call ccsdt_o1(d_rr1,d_o1,d_t1,d_t2,k_tr1_offset,k_o1_offset,
     &       k_t1_offset,k_t2_offset)
        call eomccsdt_x1(d_f1,d_rr1,d_t1,d_t2,d_v2,d_tr1,d_tr2,d_tr3,
     &       k_f1_offset,k_tr1_offset,k_t1_offset,k_t2_offset,
     &       k_v2_offset,k_tr1_offset,k_tr2_offset,k_tr3_offset)
        call tce_filename(rr2filename,filename)
        call createfile(filename,d_rr2,size_tr2)
        call tce_zero(d_rr2,size_tr2)
        call daxpyfile(1,omega,d_tr2,d_rr2,size_tr2)
        call ccsdt_o2(d_rr2,d_o1,d_t1,d_t2,d_t3,k_tr2_offset,
     &       k_o1_offset,k_t1_offset,k_t2_offset,k_t3_offset)
        call eomccsdt_x2(d_f1,d_rr2,d_t1,d_t2,d_t3,d_v2,
     &       d_tr1,d_tr2,d_tr3,k_f1_offset,k_tr2_offset,
     &       k_t1_offset,k_t2_offset,k_t3_offset,
     &       k_v2_offset,k_tr1_offset,k_tr2_offset,k_tr3_offset)
        call tce_filename(rr3filename,filename)
        call createfile(filename,d_rr3,size_tr3)
        call tce_zero(d_rr3,size_tr3)
        call daxpyfile(1,omega,d_tr3,d_rr3,size_tr3)
        call eomccsdt_x3(d_f1,d_rr3,d_t1,d_t2,d_t3,d_v2,
     1       d_tr1,d_tr2,d_tr3,k_f1_offset,k_tr3_offset,
     3       k_t1_offset,k_t2_offset,k_t3_offset,k_v2_offset,
     4       k_tr1_offset,k_tr2_offset,k_tr3_offset)
        call ccsdt_o3(d_rr3,d_o1,d_t1,d_t2,d_t3,
     &       k_tr3_offset,k_o1_offset,
     &       k_t1_offset,k_t2_offset,k_t3_offset)
        call reconcilefile(d_rr1,size_tr1)
        call reconcilefile(d_rr2,size_tr2)
        call reconcilefile(d_rr3,size_tr3)
        call tce_residual_tr1(d_rr1,k_tr1_offset,rr1)
        call tce_residual_tr2(d_rr2,k_tr2_offset,rr2)
        call tce_residual_tr3(d_rr3,k_tr3_offset,rr3)
        residual = max(rr1,rr2)
        cpu=cpu+util_cpusec()
        wall=wall+util_wallsec()
        if (nodezero) write(LuOut,9420) iter,residual,cpu,wall
        if (residual .lt. thresh) then
          if (nodezero) write(LuOut,9410)
          call deletefile(d_rr3)
          call deletefile(d_rr2)
          call deletefile(d_rr1)
          call tce_diis_tidy()
          tce_ccsdt_response_driver=.true.
          return
        endif
        call tce_diis2(.false.,iter,.true.,.true.,diis_tr3,.false.,
     1       d_rr1,d_tr1,k_tr1_offset,size_tr1,
     2       d_rr2,d_tr2,k_tr2_offset,size_tr2,
     3       d_rr3,d_tr3,k_tr3_offset,size_tr3,
     4       dummy,dummy,dummy,dummy)
        call deletefile(d_rr2)
        call deletefile(d_rr1)
        if (nodezero) call util_flush(LuOut)
      enddo
      call tce_diis_tidy()
      tce_ccsdt_response_driver=.false.
      return  
c
c     ======
c     Format
c     ======
c
 9000 format(1x,A,' file size   = ',i16)
 9010 format(1x,A,' file name   = ',A)
 9090 format(1x,A,' file handle = ',i10)
 9020 format(1x,'Cpu & wall time / sec',2f15.1)
 9480 format(1x,'Cpu & wall time / sec for ',A,2f15.1)
 9050 format(/,1x,A,' iterations',/,
     1  1x,'--------------------------------------------------------',/
     2  1x,'Iter          Residuum       Correlation     Cpu    Wall',/
     3  1x,'--------------------------------------------------------')
 9060 format(
     1  1x,'--------------------------------------------------------',/
     2  1x,'Iterations converged')
 9070 format(1x,A,' correlation energy / hartree = ',f25.15)
 9080 format(1x,A,' total energy / hartree       = ',f25.15)
 9100 format(1x,i4,2f18.13,2f8.1)
 9120 format(1x,A)
 9250 format(1x,'Ground-state symmetry is ',A4)
 9210 format(/,1x,'Iteration ',i3,' using ',i4,' trial vectors')
 9230 format(1x,f17.13,f18.13,f11.5,2f8.1)
 9240 format(1x,
     1'--------------------------------------------------------------'
     2,/,1x,'Iterations converged')
 9310 format(1x,A,' ground state energy / hartree  =',f25.15)
 9400 format(/,1x,A,' iterations',/,
     1  1x,'--------------------------------------',/
     2  1x,'Iter          Residuum     Cpu    Wall',/
     3  1x,'--------------------------------------')
 9410 format(
     1  1x,'--------------------------------------',/
     2  1x,'Iterations converged')
 9420 format(1x,i4,f18.13,2f8.1)
 9440 format(1x,A3,' axis ( ',A4,'symmetry)')
      end
