/*
 ** Copyright 2004-2007 - INL
 ** Written by Eric Leblond <eric.leblond@inl.fr>
 **            Vincent Deffontaines <vincent@inl.fr>
 ** INL http://www.inl.fr/
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __SYSTRAY__
#define __SYSTRAY__

#include <nuclient.h>
#include <QMainWindow>
#include <QtGui>
#include <QSystemTrayIcon>
#include "auth_dlg.h"
#include "logs.h"
#include "preferences.h"
#include "thread_session.h"

class NuAppSystray : public QSystemTrayIcon {
	Q_OBJECT

public:
	NuAppSystray();
	~NuAppSystray();

public slots:
	void onClick(QSystemTrayIcon::ActivationReason reason);
	void start_auth(QString _username, QString _password);
	void stop_auth();
	void popup_about();

	void tray_set_connected();
	void tray_set_stopped();
	void tray_set_trying();
	void tray_report_error();
	void tray_report_connected();
	void tray_report_disconnected();

signals:
	void showAuthDlg();

private:
	void createActions();
	void createTrayIcon();

	void parse_cmdline_options(int argc, char **argv);
	void usage();

	// Authentication related
	QSettings settings;
	QMenu *trayIconMenu;

	// GUI related
	QAction *exitAct;
	QAction *preferencesAct;
	QAction *logsAct;
	QAction *connectAct;
	QAction *disconnectAct;
	QAction *aboutAct;
	ThreadCheckConn timer;

	NuAppAuthDialog* auth_dlg;
	NuLogsWindow* logs_dlg;
	NuAppPreferences* pref_dlg;
};

#endif /* __SYSTRAY__ */
