"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _instance = _interopRequireDefault(require("./instance"));

var _instances = _interopRequireDefault(require("./instances"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _default = (node, options = {}) => {
  // Stream was passed instead of `options` object
  if (typeof options.write === 'function') {
    options = {
      stdout: options,
      stdin: process.stdin
    };
  }

  options = _objectSpread({
    stdout: process.stdout,
    stdin: process.stdin,
    debug: false,
    exitOnCtrlC: true,
    experimental: false
  }, options);
  let instance;

  if (_instances.default.has(options.stdout)) {
    instance = _instances.default.get(options.stdout);
  } else {
    instance = new _instance.default(options);

    _instances.default.set(options.stdout, instance);
  }

  instance.render(node);
  return {
    rerender: instance.render,
    unmount: () => instance.unmount(),
    waitUntilExit: instance.waitUntilExit,
    cleanup: () => _instances.default.delete(options.stdout)
  };
};

exports.default = _default;