/*
 * Copyright 2013 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QFile>
#include <QDebug>
#include <QDir>

#include "QNetworkRequest"
#include "QNetworkReply"
#include "QNetworkAccessManager"
#include "image.h"

QNetworkAccessManager::QNetworkAccessManager(QObject* parent)
{
}

QNetworkReply* QNetworkAccessManager::get(QNetworkRequest request)
{
    QNetworkReply* reply = new QNetworkReply(this);

    QString path = request.m_url.path();
    if (path == "/image.png") {
        reply->setData(reinterpret_cast<const char *>(image_png), image_png_len);
    } else if (path == "/redirect_loop.png") {
        reply->setRedirectUrl(QUrl("/redirect_loop.png"));
    } else if (path == "/redirect/1.png") {
        reply->setRedirectUrl(QUrl("/redirect/2.png"));
    } else if (path == "/redirect/2.png") {
        reply->setRedirectUrl(QUrl("/redirect/3.png"));
    } else if (path == "/redirect/3.png") {
        reply->setRedirectUrl(QUrl("/image.png"));
    }

    QNetworkAccessManager::log().append(path);
    return reply;
}
