/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Compute a mid-range incrementally.
*
* @module @stdlib/stats/incr/midrange
*
* @example
* var incrmidrange = require( '@stdlib/stats/incr/midrange' );
*
* var accumulator = incrmidrange();
*
* var midrange = accumulator();
* // returns null
*
* midrange = accumulator( 3.14 );
* // returns 3.14
*
* midrange = accumulator( -5.0 );
* // returns ~-0.93
*
* midrange = accumulator( 10.1 );
* // returns 2.55
*
* midrange = accumulator();
* // returns 2.55
*/

// MODULES //

var incrmidrange = require( './main.js' );


// EXPORTS //

module.exports = incrmidrange;
