/**
* @license Apache-2.0
*
* Copyright (c) 2021 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var resolve = require( 'path' ).resolve;
var bench = require( '@stdlib/bench' );
var isnan = require( '@stdlib/math/base/assert/is-nan' );
var Float64Array = require( '@stdlib/array/float64' );
var ndarray = require( './../../../../base/ctor' );
var tryRequire = require( '@stdlib/utils/try-require' );
var pkg = require( './../package.json' ).name;


// VARIABLES //

var addon = tryRequire( resolve( __dirname, './../lib/native.js' ) );
var opts = {
	'skip': ( addon instanceof Error )
};


// MAIN //

bench( pkg, opts, function benchmark( b ) {
	var xbuf;
	var ybuf;
	var len;
	var x;
	var y;
	var z;
	var i;

	len = 10;
	xbuf = new Float64Array( len );
	ybuf = new Float64Array( len );

	x = new ndarray( 'float64', xbuf, [ len ], [ 1 ], 0, 'row-major' );
	y = new ndarray( x.dtype, ybuf, x.shape, x.strides, x.offset, x.order );

	b.tic();
	for ( i = 0; i < b.iterations; i++ ) {
		z = addon( x, y );
		if ( isnan( z.data[ i%len ] ) ) {
			b.fail( 'should not return NaN' );
		}
	}
	b.toc();
	if ( isnan( z.data[ i%len ] ) ) {
		b.fail( 'should not return NaN' );
	}
	b.pass( 'benchmark finished' );
	b.end();
});
