/*
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/**
* Returns a double-precision floating-point number with the magnitude of `x` and the sign of `x*y`.
*
* @param x - number from which to derive a magnitude
* @param y - number from which to derive a sign
* @returns a double-precision floating-point number
*
* @example
* var z = flipsign( -3.14, 10.0 );
* // returns -3.14
*
* @example
* var z = flipsign( -3.14, -1.0 );
* // returns 3.14
*
* @example
* var z = flipsign( 1.0, -0.0 );
* // returns -1.0
*
* @example
* var z = flipsign( -3.14, -0.0 );
* // returns 3.14
*
* @example
* var z = flipsign( -0.0, 1.0 );
* // returns -0.0
*
* @example
* var z = flipsign( 0.0, -1.0 );
* // returns -0.0
*/
declare function flipsign( x: number, y: number ): number;


// EXPORTS //

export = flipsign;
