/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Square root of the golden ratio.
*
* @module @stdlib/constants/float64/sqrt-phi
* @type {number}
*
* @example
* var SQRT_PHI = require( '@stdlib/constants/float64/sqrt-phi' );
* // returns 1.272019649514069
*/


// MAIN //

/**
* Square root of the golden ratio.
*
* @constant
* @type {number}
* @default 1.272019649514069
* @see [OEIS]{@link http://oeis.org/A139339}
* @see [Wikipedia]{@link http://en.wikipedia.org/wiki/Golden_ratio}
*/
var SQRT_PHI = 1.27201964951406896425242246173749149171560804184009624861664038;


// EXPORTS //

module.exports = SQRT_PHI;
