/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var arrayfun = require( './../../tools/array-like-function' );
var isPrimitive = require( './../../is-primitive' );


// MAIN //

/**
* Tests if a value is an array-like object containing only JavaScript primitives.
*
* @name isPrimitiveArray
* @type {Function}
* @param {*} value - value to test
* @returns {boolean} boolean indicating whether an input value is an array-like object containing only JavaScript primitives
*
* @example
* var bool = isPrimitiveArray( [ '3', 2, null ] );
* // returns true
*
* bool = isPrimitiveArray( [ {}, 2, 1 ] );
* // returns false
*
* bool = isPrimitiveArray( [ new String('abc'), '3.0' ] );
* // returns false
*/
var isPrimitiveArray = arrayfun( isPrimitive );


// EXPORTS //

module.exports = isPrimitiveArray;
