import test from 'ava'
import fs from 'fs-extra'

import cli from './helpers/cli.js'
import tmp from './helpers/tmp.js'
import read from './helpers/read.js'

test('inline maps are generated by default', async (t) => {
  const output = tmp('output.css')

  const { error, stderr } = await cli([
    'test/fixtures/import.css',
    '-u',
    'postcss-import',
    '-o',
    output,
  ])

  t.falsy(error, stderr)

  t.regex(await read(output), /\/*# sourceMappingURL=/)
})

test('--map generates external sourcemaps', async (t) => {
  const output = tmp('output.css')

  const { error, stderr } = await cli([
    'test/fixtures/import.css',
    '-u',
    'postcss-import',
    '-o',
    output,
    '--map',
  ])

  t.falsy(error, stderr)

  t.truthy(await fs.pathExists(output.replace('.css', '.css.map')))
})

test('--no-map disables internal sourcemaps', async (t) => {
  const output = tmp('output.css')

  const { error, stderr } = await cli([
    'test/fixtures/import.css',
    '-u',
    'postcss-import',
    '-o',
    output,
    '--no-map',
  ])
  t.falsy(error, stderr)

  t.notRegex(await read(output), /\/*# sourceMappingURL=/)
})
