/*************************************************************
 *
 *  Copyright (c) 2018-2022 The MathJax Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import {SVGCharMap, AddPaths} from '../../FontData.js';
import {frakturBold as font} from '../../../common/fonts/tex/fraktur-bold.js';

export const frakturBold: SVGCharMap = AddPaths(font, {
    0x21: '121 621Q121 657 132 673T177 689Q223 689 223 644V635Q223 604 222 595Q221 590 210 490T187 292T175 190V186L166 185L156 184Q156 185 139 393T121 621ZM107 47Q107 70 127 87T174 104Q201 104 221 89T241 48Q241 24 222 6T174 -12Q147 -12 127 6T107 47',
    0x22: '53 695Q74 695 90 679V622L65 433L52 432H39L27 516Q10 626 10 655Q10 680 26 688Q33 693 39 693Q49 695 53 695ZM151 668Q151 691 191 691Q217 691 224 685T231 661V652Q230 634 219 531L207 433L195 432Q183 432 183 433L168 541Q151 664 151 668',
    0x26: '290 -14Q186 -14 115 41T44 185Q44 222 54 249T88 300T131 336T189 371Q216 387 216 388Q185 459 185 510Q185 563 206 601T263 659T334 687T405 696Q476 696 503 668T531 603Q531 565 513 536T450 476Q423 459 370 432L334 413L354 384Q474 212 560 139L563 137Q611 185 611 250Q611 295 577 329Q549 356 496 357Q439 357 433 354Q432 354 432 379V403L437 402Q443 402 479 401T557 400Q653 400 735 403T831 407H836Q833 352 833 351L821 352Q809 352 792 352T756 352T720 353T696 354Q680 354 680 353L681 346Q682 339 683 327T685 306Q685 283 681 260T669 218T653 182T635 152T619 129T606 114L602 109Q604 107 618 99T659 81T707 71Q742 71 767 99T804 155L815 183Q815 184 821 183T833 180T839 177Q837 169 834 156T816 110T782 52T727 5T648 -16Q569 -16 499 35H498Q496 35 466 23T387 -1T290 -14ZM418 592Q418 617 398 639T352 661T302 642T278 574Q278 545 288 514T306 465T319 444Q342 456 353 463T382 488T409 529T418 584V592ZM159 239Q159 158 222 98T364 38Q386 38 447 57L469 63L434 98Q349 185 286 275Q258 316 238 345Q233 353 232 353Q159 316 159 239',
    0x27: '80 645T80 662T93 687T123 695Q158 695 158 659Q158 649 157 643L123 437Q123 436 114 436H104Q104 442 92 538Q80 645 80 662',
    0x28: '347 719Q325 708 311 698T272 656T233 580T207 455T195 267Q195 30 247 -79Q261 -110 291 -136Q320 -163 347 -172V-179Q347 -186 344 -186Q338 -186 328 -184T287 -165T230 -123Q134 -25 134 271Q134 417 158 514T226 662T335 734L346 737Q347 737 347 728V719',
    0x29: '264 262Q264 366 253 446T226 572T186 649T145 692T105 714V725Q105 735 107 735Q108 734 121 731T154 719T196 692T242 641T284 560T314 437T326 268Q326 112 299 7Q279 -78 239 -124T116 -185L105 -187V-179L106 -171L109 -169Q130 -161 138 -158T165 -146T190 -127T210 -101T229 -64T243 -12T255 58T261 148T264 262',
    0x2A: '40 516L62 529Q85 542 110 556T140 574L126 582Q112 591 104 595T80 607T40 629Q53 642 57 645L65 652L78 642Q106 620 132 603L152 589V595Q152 630 149 681V692H179V689Q178 681 174 638T171 593Q173 593 240 639L258 652Q260 652 267 643L276 633L260 625Q190 587 175 576Q173 575 180 570Q183 569 186 567Q213 549 256 527L277 515L256 495Q246 501 228 515T194 539T170 554V543Q170 486 178 449H148V456Q152 492 152 550L151 562Q150 562 102 528L53 495Q40 514 40 516',
    0x2B: '422 584L471 598Q472 598 472 440V282H837Q833 273 829 263L821 244L647 243H472V-63L448 -73L423 -82Q422 -82 422 81V243H239Q56 243 56 244Q60 253 65 263L73 282H422V584',
    0x2C: '118 61Q118 80 135 93T169 107Q190 107 221 65T253 -23Q253 -39 251 -49T237 -80T198 -133Q148 -191 144 -191Q142 -191 137 -182T132 -172Q143 -161 160 -131T183 -83Q185 -77 185 -62Q185 -54 184 -48T182 -38T177 -28T171 -19T162 -8T150 6Q130 28 124 38T118 61',
    0x2D: '54 236L73 275H453Q833 275 833 274Q830 265 825 255L818 236H54',
    0x2E: '103 23T103 44T120 83T170 102Q200 102 218 84T237 44Q237 20 216 3T168 -15Q138 -15 121 4',
    0x2F: '272 270Q503 721 506 721L509 720Q512 720 518 719T529 717L550 713L91 -181L66 -182Q41 -182 41 -181L272 270',
    0x30: '238 -12Q162 -12 102 42T42 185Q42 303 130 393Q163 425 208 452T284 490L313 501Q323 499 339 495T395 472T464 426Q533 357 533 273Q533 201 483 133T364 27T238 -12ZM428 208Q428 255 402 297T342 365T280 404T241 419Q214 419 178 374T142 259Q142 206 168 164T225 99Q259 74 310 74Q326 74 337 75T366 82T396 103T417 141Q428 171 428 208',
    0x31: '95 481Q102 481 217 485T383 489Q384 489 384 485Q367 397 367 165Q367 58 369 54Q374 46 380 44T410 42H466H546V40Q547 38 547 19L548 0H54V23Q54 29 54 34T54 44L55 47Q79 47 134 46T202 45Q226 45 234 52Q240 57 241 64T245 105Q254 236 254 320V347Q254 369 252 382T240 409T211 431L97 450L96 465Q95 480 95 481',
    0x32: '307 335Q307 374 283 397T224 421Q187 421 112 387Q105 384 100 382T95 381Q90 387 86 394L77 407L86 413Q219 491 298 491Q370 491 399 460T428 388Q428 373 424 358T409 326T391 297T363 264T335 235T301 202T269 171L199 104Q194 99 205 97Q209 96 214 96Q527 105 544 105Q553 107 563 102Q563 100 557 79T545 34T537 2H377Q338 2 247 2T130 4H44V26L104 77Q185 145 212 172T267 235Q307 291 307 335',
    0x33: '102 402L108 408Q115 413 122 418T141 431T165 447T194 461T227 474T263 483T302 487H307Q413 487 452 420Q465 400 465 371Q465 334 445 303T396 253T347 225T317 213Q314 213 314 211Q316 209 316 205Q317 201 320 201Q337 201 359 198T411 184T465 156T506 109T523 39Q523 -62 436 -127T229 -193Q179 -193 130 -178T56 -150T31 -133Q31 -132 41 -122L52 -112L63 -117Q128 -148 201 -148Q282 -148 331 -104T381 20Q381 71 363 100T304 145Q243 166 149 166H137V204H146Q179 204 211 210T275 229T326 268T346 329Q346 372 314 401Q292 423 245 423Q188 423 125 383L102 402',
    0x34: '346 -196Q344 -196 335 -187L336 -148Q337 -127 337 -55V0H13V29L187 253Q362 477 362 479L368 480Q375 481 387 483T411 487T434 491T452 494L459 495Q460 495 470 482V453Q470 389 466 230T461 62Q461 61 513 61T565 60L555 29L546 -1H461V-15Q461 -48 463 -100T465 -154L457 -157Q449 -160 434 -165T405 -175Q347 -196 346 -196ZM339 265V341Q339 362 335 362Q327 362 219 217T110 65V61H337V117Q338 133 338 187T339 265',
    0x35: '232 192Q176 192 122 152L95 162V481H306Q516 481 516 479Q514 477 501 433L486 389L319 388H152V386V382Q152 379 152 374T151 365Q147 329 146 260V218H149Q211 242 284 242Q353 242 402 224T474 176T508 117T518 55Q518 -62 432 -126T220 -190Q184 -190 151 -185T96 -172T57 -157T31 -145T20 -139T19 -138Q19 -136 27 -125L35 -112L51 -120Q114 -152 174 -152Q257 -152 314 -100T371 46Q371 107 340 149T232 192',
    0x36: '48 251Q48 330 76 403T150 529T253 623T370 683T485 704Q494 704 520 701T547 695Q547 692 542 659T536 625Q531 624 524 624L512 623L502 628Q489 635 468 640Q452 645 423 645Q403 645 379 640T320 617T255 568T201 481T171 348Q170 341 170 330V325L183 333Q275 385 357 385H361Q464 385 514 312Q546 267 546 217Q546 127 457 58T262 -12Q225 -12 189 3T120 49T68 132T48 251ZM448 165Q448 228 406 274T289 320Q264 320 236 312T190 295T173 284Q173 266 176 241T189 178T214 112T259 61T326 39Q372 39 410 75T448 165',
    0x37: '57 376L87 479H591V455L584 446Q544 399 491 328T349 117T185 -169L171 -196H159Q152 -197 102 -197Q58 -197 58 -196T56 -185L54 -175L299 158L443 359Q446 367 444 370H254L71 365L57 376',
    0x38: '88 533Q88 573 120 610T194 668T268 701T307 714Q324 714 352 711T422 695T486 659Q518 625 518 585Q518 536 479 489T384 406L371 398L385 390Q387 389 400 382T420 370T442 356T466 339T489 319T510 295T526 269T538 238T542 204Q542 125 463 60T256 -5Q145 -5 92 52Q45 97 45 165Q45 204 64 237T109 290T163 324T209 345T228 353L214 364Q199 375 179 392T138 431T103 480T88 533ZM405 557Q405 568 402 581T387 612T350 644T286 663Q283 663 280 663T274 664H272Q256 664 228 636T199 572Q199 547 238 507Q268 475 320 437L334 427Q345 433 358 443T388 483T405 549V557ZM304 42Q366 42 398 76T431 155Q431 178 420 200T396 238T359 270T321 296T283 318L263 328Q262 328 230 312Q190 290 175 266T160 198Q160 132 202 87T304 42',
    0x39: '549 220Q549 23 429 -82T105 -195H84V-189Q84 -179 85 -174V-164H93Q184 -156 238 -132T334 -56Q361 -23 376 16T394 78L397 100L363 88Q329 75 291 61T244 45Q237 44 218 44Q154 44 94 97Q29 152 29 240Q29 350 108 404Q145 429 257 480Q270 487 279 487Q403 487 470 421Q549 347 549 220ZM408 217Q408 276 390 320T346 385T297 415T259 424Q218 424 185 393T151 286Q151 216 213 154Q252 115 321 115Q368 115 388 134T408 217',
    0x3A: '57 398Q57 419 72 438T117 457Q154 457 174 439T194 398Q194 379 176 361T119 343Q85 343 71 362T57 398ZM62 19T62 43T77 85T115 104Q153 104 175 86T197 42Q197 14 171 1T119 -12Q96 -12 79 3',
    0x3B: '56 399Q56 424 73 440T104 456Q114 458 120 458Q149 458 170 440T192 399Q192 380 174 362T120 344Q85 344 71 362T56 399ZM78 53Q78 67 84 76T90 86Q90 88 98 92T116 98Q117 98 121 98T128 99Q152 97 181 58T211 -24Q211 -77 128 -165Q124 -170 121 -173T116 -178T113 -181T110 -185T106 -190L97 -184L88 -177L95 -168Q143 -104 143 -65Q143 -51 137 -40T113 -7T81 35Q78 41 78 53',
    0x3D: '559 342L549 304H22L27 319Q29 328 30 333T33 343H296Q559 343 559 342ZM559 206L549 168H22L27 183Q29 192 30 197T33 207H296Q559 207 559 206',
    0x3F: '121 590Q121 575 128 562T144 542T152 533T115 512L78 491Q55 499 47 516Q40 530 40 553Q40 601 77 632Q155 697 257 697H268Q316 697 355 679Q422 646 422 576Q422 518 388 476Q383 468 376 461T358 444T340 428T316 410T290 390L230 344Q180 307 180 275Q180 261 187 248T202 227L209 219Q209 215 176 193L142 170Q114 177 100 194T84 226V239Q84 259 93 276T113 302T150 331T192 362Q203 370 219 382T247 403T267 422Q312 471 312 546Q312 593 282 623T207 653Q170 653 146 636T121 590ZM95 23T95 49T117 94T173 113Q204 113 223 96T242 54Q242 27 221 7T167 -14Q136 -14 116 4',
    0x5B: '226 711T225 711T86 699V-93H89Q94 -93 157 -96T223 -100H226V-119H223Q134 -119 42 -130H36V740H42Q61 738 156 736H226V723Q226 711 225 711',
    0x5D: '69 732Q116 733 146 734T184 736T197 737T206 738H208V-132Q190 -129 160 -127T99 -125T66 -124H14V-103H19Q20 -103 84 -98T152 -92H158V699H151Q148 700 85 703T18 708H14V732H69',
    0x5E: '1 463T1 464T148 599T296 734Q584 486 584 485L561 472Q538 459 537 461Q296 672 293 672L161 563Q133 539 97 509T44 466L28 452Q27 452 14 457',
    0x2018: '187 456Q187 437 169 424T138 411Q114 411 84 454T53 538Q53 565 75 597Q109 648 155 697L166 708L181 694L173 681Q124 610 124 577Q124 549 155 511T187 456',
    0x2019: '125 524Q125 545 92 588T58 651Q58 661 61 667Q65 674 80 683T107 692Q131 692 162 645T193 564Q193 540 176 509T144 460T87 394L78 400L68 406L79 421Q125 489 125 524',
    0x2044: '272 270Q503 721 506 721L509 720Q512 720 518 719T529 717L550 713L91 -181L66 -182Q41 -182 41 -181L272 270',
    0xE301: '388 427Q320 485 242 524T128 563H116Q95 563 87 561L77 559Q72 563 69 566T65 570T65 572L75 576Q106 592 154 611T212 630Q230 630 262 622T358 581T492 498L508 486Q512 463 512 396Q512 246 469 112L465 102Q453 94 341 25Q252 -27 247 -27Q243 -27 174 24T97 84Q90 100 90 214Q90 285 98 345Q100 360 102 363T118 377Q175 422 262 465Q264 463 270 460L277 456Q277 455 267 447T244 428T228 414Q206 382 206 269Q206 187 214 164T259 110Q286 89 342 58Q391 131 391 313Q391 355 388 412V427',
    0xE302: '39 362L37 366L38 368L82 405H133V474Q135 563 143 589T198 658Q210 669 224 676T247 687L255 690H253Q241 690 253 692Q254 692 256 692T260 693Q263 693 262 691L261 690Q300 690 361 662L373 656L388 666Q404 675 405 675L406 674Q406 672 406 670T406 664L408 655L301 555Q300 555 287 564T254 584T221 597Q190 597 176 583T161 550Q161 525 184 495T232 440T261 405H387V399Q377 389 364 379L340 359H258V315Q258 52 228 -18L172 -120L121 -211H109Q102 -212 96 -212L109 -174Q131 -108 135 -80T139 53V76V157V362H39',
    0xE303: '41 352Q40 354 39 355T37 358L36 360H37Q48 370 61 380L84 400H108Q131 400 131 402Q121 424 104 501L100 519Q109 560 134 602T196 664Q230 681 271 681Q291 681 316 669T358 644L373 631Q373 630 304 553Q299 548 294 547Q292 547 290 546H287Q286 546 274 562T243 593T205 609Q180 609 165 596T150 562Q150 526 191 488L217 462Q248 431 253 405V400H381L384 394L349 352H251V332Q249 271 231 17L227 -37L120 -217L109 -218Q103 -219 97 -219Q97 -218 101 -206T110 -177T118 -151Q126 -129 128 -120T136 -46T141 127Q141 250 136 340V352H41',
    0xE304: '107 370Q127 384 172 409T255 454T294 473L306 468Q356 446 425 431L435 429L524 468Q528 465 531 461Q499 395 499 271V263Q499 146 509 71T519 -8Q519 -28 512 -45Q510 -50 435 -123T355 -197Q296 -212 257 -212Q209 -212 164 -196T98 -167T67 -143L133 -44H144Q167 -88 216 -111T320 -134Q371 -134 390 -118T410 -69Q410 -52 404 -12T392 60T385 92L193 -29L158 5Q124 39 110 51L96 63V71Q94 79 94 121Q94 130 94 148T93 174Q93 230 96 275T103 344T107 370ZM221 397Q200 334 200 254Q200 170 210 140Q216 126 234 109T268 81L283 71L383 119V127Q384 132 384 241L385 347L368 349Q325 357 290 369T240 389T221 397',
    0xE305: '103 453Q103 631 95 661Q95 663 102 667T110 672L114 664Q117 655 123 641T131 621L140 597L154 606Q208 641 275 673L297 684Q300 683 302 682T307 679T310 678L314 676Q283 658 256 625Q238 601 231 579T223 515L224 512L282 548Q339 583 341 583T365 548T386 509Q326 443 318 443L316 446Q314 448 311 452T304 460T294 470T283 480T272 488T260 494T248 497Q231 497 223 474Q220 468 218 440T215 407V401H345L309 360H218V314Q218 181 221 139V129L253 108Q306 73 310 73Q315 73 343 83L373 92L374 87Q375 82 375 79T375 74T360 65T308 36T229 -13L208 -27L192 -13Q149 24 90 61Q89 61 89 62L90 68Q91 73 93 87T97 125T100 191T103 291V360H33V366L34 371L85 405H94L103 404V453',
    0xE308: '602 575Q505 508 505 489Q505 488 505 482T506 463T507 432Q507 314 456 237L449 226L434 216Q420 208 325 143L316 137Q453 82 488 82Q527 82 585 127L596 136Q597 136 599 126L602 115Q578 85 511 27T428 -31Q400 -31 308 10T170 51Q143 51 123 43T92 24T54 -15L34 6L41 14Q65 41 170 129L188 144L204 145Q254 147 293 164T350 208Q378 249 378 344Q378 422 362 478T320 563T268 605T213 618Q177 618 156 600T134 561Q134 539 162 508T217 446T245 394Q245 368 213 337T85 250L62 262Q73 269 86 279T116 308T133 338T108 378T57 439T32 499Q32 556 117 617T291 679Q350 679 393 658Q415 647 433 631T462 600T480 572T490 550T494 541T499 544T516 556T547 578T603 613T689 662L720 679L730 670Q742 659 756 649T785 629T810 615T836 601T855 590Q855 587 860 536T870 419T875 312Q875 114 800 -25Q794 -35 781 -47Q584 -220 398 -220Q322 -220 278 -190Q253 -173 239 -155L244 -150Q248 -145 255 -138T271 -120T290 -100T310 -80T328 -63T341 -51T349 -46Q350 -46 351 -46T354 -47Q357 -47 357 -52Q359 -68 364 -83T383 -118T424 -151T491 -166Q559 -166 613 -129Q629 -118 641 -108T674 -68T710 1T735 107T746 260Q746 433 727 507Q727 512 685 535T615 570L602 575',
    0xE309: '351 571Q317 571 247 563T171 555Q153 555 133 563T107 584Q94 605 98 609Q101 615 138 658T190 717H207Q204 710 204 699Q204 673 231 666Q235 665 264 665Q296 665 345 667T426 669Q474 669 501 660T545 626Q553 612 553 594Q553 531 498 474T379 384Q371 379 371 378Q371 376 390 376H411H434Q520 376 602 318Q621 303 627 288T633 234Q633 59 540 -34Q465 -109 348 -130Q308 -137 235 -137Q159 -136 143 -129Q132 -125 132 -118V-53Q118 -24 90 -24Q69 -24 37 -39L27 -44L25 -42Q23 -39 21 -35T17 -30Q17 -28 40 -14T103 19T177 44Q183 45 205 45Q219 45 227 44T245 37T259 20T264 -12Q264 -33 262 -48T259 -80Q259 -93 260 -95Q271 -110 305 -110Q343 -110 383 -86T443 -33Q491 34 491 154Q491 223 467 249Q428 288 334 288H322Q288 288 237 276L222 273L206 286L262 367Q279 369 303 377T358 403T410 452T431 524Q431 531 431 533T427 545T416 558T392 566T351 571',
},{
});
