/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.openide.filesystems;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import junit.framework.Test;
import org.netbeans.junit.NbTestSuite;

/**
 * @author  rm111737
 */
public class JarFileSystemTest extends FileSystemFactoryHid {
     JarFileSystem jfs;
    /** Creates new JarFileSystemTest */
    public JarFileSystemTest(Test test) {
        super(test);
    }

    public static Test suite() {
        NbTestSuite suite = new NbTestSuite();
        suite.addTestSuite(RepositoryTestHid.class);                
        suite.addTestSuite(FileSystemTestHid.class);        
        suite.addTestSuite(FileObjectTestHid.class);
        /*failing tests*/
        suite.addTestSuite(URLMapperTestHidden.class);
        suite.addTestSuite(URLMapperTestInternalHidden.class);
        suite.addTestSuite(FileUtilTestHidden.class);
        suite.addTestSuite(JarFileSystemHidden.class);
        
        return new JarFileSystemTest(suite);
    }
    @Override
    protected void destroyFileSystem (String testName) throws IOException {}
    
    @Override
    protected FileSystem[] createFileSystem (String testName, String[] resources) throws IOException{
        File jar = TestUtilHid.locationOfTempFolder("jfstest");
        jar.mkdir();
        
        File f = new File (jar,"jfstest.jar");
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            f.createNewFile();
        }
        JarOutputStream jos = new JarOutputStream (new FileOutputStream (f));        
        
        for (int i = 0; i < resources.length; i++) {
            String entryName = resources[i];
            if (entryName.startsWith("/")) entryName = entryName.substring(1);             
            jos.putNextEntry(new ZipEntry (entryName));
        }
        
        
       jos.close();        
        
        jfs = new JarFileSystem  ();
        try {
            jfs.setJarFile(f);
        } catch (Exception ex) {}
                
        return new FileSystem[] {jfs};
    }
}
