
#include <stdio.h>
#include <stdlib.h>
#include "ini.h"


inifile_t openfiles[10];
int maxfiles = 10;
char init = 1;

stringlist_t* nextstr(stringlist_t* in) {
  return in->next;
}

section_t* nextsec(section_t* in) {
  return in->next;
}


void printsection(section_t* in) {
  stringlist_t* p;
  stringlist_t* p2;

  p = in->name;
  p2 = in->value;

  while(p) {
    printf("\"%s\"=\"%s\"\n",p->string,p2->string);
    p = nextstr(p);
    p2 = nextstr(p2);
  }
}


section_t* addsection(int fileno,section_t* current,char* name) {
  inifile_t* ini;
  section_t* sec;

  if (strlen(name) == 0)
       return NULL;

  ini = &openfiles[fileno];

  if (ini->sections == 0) {
    sec = ini->sections = (section_t*) malloc(sizeof(section_t));
  }
  else {
    sec = current->next = (section_t*) malloc(sizeof(section_t));
  }

  ini->count++;
  sec->count = 0;
  sec->next = 0;
  sec->name = 0;
  sec->value = 0;
  sec->sectionname = (char*) malloc(strlen(name)+1);
  strcpy(sec->sectionname,name);
  return sec;

}

void addkeyvalue(section_t* sec,char* name,char* value) {
  int c;
  char* ptr;
  char* ptr2;
  stringlist_t* strl;
  int found = -1;

  if (strlen(name) == 0)
       return;
  if (strlen(value) == 0)
       return;


  c = sec->count;
  sec->count++;

  ptr = (char*) malloc(strlen(name)+1);
  strcpy(ptr,name);
  ptr2 = (char*) malloc(strlen(value)+1);
  strcpy(ptr2,value);


  if (!sec->name) {
    strl = sec->name = (stringlist_t*) malloc(sizeof(stringlist_t));
    strl->string = ptr;
    strl->next = 0;
  }
  else {
       int i = 0;
       for(strl = sec->name;;strl=strl->next,i++) {
	    if (strcmp(strl->string,ptr) == 0) {
		 free(strl->string);
		 strl->string = ptr;
		 found = i;
	    }
		 
	    if (strl->next == 0) break;
       }
       if (found < 0) {
	    strl->next =  (stringlist_t*) malloc(sizeof(stringlist_t));
	    strl = strl->next;
	    strl->string = ptr;
	    strl->next = 0;
       }
  }

  if (!sec->value) {
    strl = sec->value = (stringlist_t*) malloc(sizeof(stringlist_t));
    strl->string = ptr2;
    strl->next = 0;
  }
  else {
       int i = 0;
       for(strl = sec->value;;strl=strl->next,i++) {
	    if (i == found) {
		 free(strl->string);
		 strl->string = ptr2;
	    }
	    if (strl->next == 0)
		 break;
       }
       if (found < 0) {
	    strl->next =  (stringlist_t*) malloc(sizeof(stringlist_t));
	    strl = strl->next;
	    strl->string = ptr2;
	    strl->next = 0;
       }
  }
  
}


void ini_Init() {
  int i;

  for(i=0;i<maxfiles;i++) {
    openfiles[i].count = 0;
    openfiles[i].sections = 0;
  }
}


int ini_ReadFile(char *buffer) {
  FILE* fp;
  char line[320];
  char* c;
  char* b;
  char* d;
  section_t* currentsec = 0;
  int fileno;
  int len;


  if (init) {
    ini_Init();
    init = 0;
  }

  fp =  fopen(buffer,"r");
  if (!fp)
    return -1;

  for(fileno=0;fileno<maxfiles;fileno++)
    if (openfiles[fileno].count == 0)
      break;

  if (fileno == maxfiles)
    return -1;

  while (!feof(fp)) {
    fgets(line,320,fp);
    c = line;
    len = strlen(line);
    if (len < 2)
	 continue;
    // fucking crlf
    if (line[len -1] == 10)
      line[len-1] = '\0';
    if (line[len -2] == 10)
      line[len-2] = '\0';
    if (line[len -1] == 13)
      line[len-1] = '\0';
    if (line[len -2] == 13)
      line[len-2] = '\0';

    while(*c == ' ')
      c++;

    if (*c == 0)
      continue;

    if (*c == ';')
      continue;

    if (*c == '[') {
      c++;
      while(*c == ' ')
	c++;
      b = c;
      while(*b != ']')
	if (*b != 0)
	  b++;
	else
	  break;

      if (*b == 0)
	continue;

      if (b == c)
	continue;

      while(*(b-1) == ' ')
	b--;

      *b = 0;
      currentsec = addsection(fileno,currentsec,c);

      continue;
    }

    b = c;
    
    while(*b != '=')
      if (*b != 0)
	b++;
      else
	break;

    if (*b == 0)
      continue;

    if (b == c)
      continue;

    d = b;

    while(*(b-1) == ' ')
      b--;
    
    *b = 0;
    d++;

    while(*d == ' ')
      d++;

    b = d;

    while(*d != 0)
      d++;

    if (d == b)
      continue;

    while(*(d-1) == ' ')
      d--;

    *d = 0;

    if (currentsec) addkeyvalue(currentsec,c,b);
  }

  fclose(fp);

  if (openfiles[fileno].count == 0)
    return -1;
  
  return fileno;

}

int ini_NewFile() {
  int fileno;

  if (init) {
    ini_Init();
    init = 0;
  }

  for(fileno=0;fileno<maxfiles;fileno++)
    if (openfiles[fileno].count == 0)
      break;

  if (fileno == maxfiles)
    return -1;

  return fileno;
}


void deletesection(section_t* in) {
  stringlist_t* p;
  stringlist_t* p2;

  p = in->name;

  while(p) {
    p2 = nextstr(p);
    free(p->string);
    free(p);
    p = p2;
  }

  p = in->value;

  while(p) {
    p2 = nextstr(p);
    free(p->string);
    free(p);
    p = p2;
  }

}

void ini_Free(int filedex) {
  section_t* del;
  section_t* tmp;

  del = openfiles[filedex].sections;

  if (!del)
    return;

  if (filedex >= maxfiles)
    return;

  do{
    tmp = nextsec(del);
    deletesection(del);
    free(del->sectionname);
    free(del);
  } while(del = tmp);
  
  openfiles[filedex].count = 0;
  openfiles[filedex].sections = 0;
}


section_t* ini_FindSection(int filenum,char* name) {
  section_t* ptr;

  ptr = openfiles[filenum].sections;
  if (ptr == 0) return 0;

  do {
    if (strcmp(ptr->sectionname,name) == 0)
      return ptr;    
  } while(ptr = nextsec(ptr));

  return 0;  
}

char* findvalue(section_t* sec,char* name) {
  stringlist_t* ptr;
  stringlist_t* ptr2;

  if (sec == 0)
    return 0;

  ptr = sec->name;
  ptr2 = sec->value;

  if ( (ptr == NULL) || (ptr2 == NULL))
       return 0;

  do {
    if (strcmp(ptr->string,name) == 0)
      return ptr2->string;
    ptr2 = nextstr(ptr2);
  } while(ptr = nextstr(ptr));
  return 0;

}

char* ini_ReadValue(int filenum,char* secname,char* key) {
  return findvalue(ini_FindSection(filenum,secname),key);
}

char* ini_ReadSections(int filenum){
  static section_t* current = 0;
  char* retval;

  if (!current) {
    current = openfiles[filenum].sections;
  }
  
  if ((unsigned int)current == 1) {
    current = 0;
    return 0;
  }

  if (openfiles[filenum].count == 0) {
    current = 0;
    return 0;
  }

  retval = current->sectionname;
  current = current->next;
  if (!current)
    current = (section_t*)1;
  return retval;
}

char* ini_ReadKeysValues(int filenum,char* secname,char** keyname) {
  static section_t* current = 0;
  static stringlist_t* ptr = 0;
  static stringlist_t* ptr2 = 0;
  char* retval;

  if (!current) {
    current = ini_FindSection(filenum,secname);
    ptr = current->name;
    ptr2 = current->value;
  }

  if (!ptr)
       current = (section_t*)1;

  if ((unsigned int)current == 1) {
    current = 0;
    return 0;
  }

  *keyname = ptr->string;
  retval = ptr2->string;
  
  ptr = nextstr(ptr);
  ptr2 = nextstr(ptr2);
  
  
  return retval;


}


void  ini_DeleteSection(int filenum, char* secname) {
  section_t* sec;
  section_t* t;


  sec = ini_FindSection(filenum,secname);
  if (!sec)
    return;
  deletesection(sec);  

  if (sec == openfiles[filenum].sections)
    openfiles[filenum].sections = sec->next;
  else {
    for(t = openfiles[filenum].sections;t->next != sec;t = nextsec(t));
    t->next = sec->next;
  }
  free(sec->sectionname);
  free(sec);
  openfiles[filenum].count--;
}

void ini_WriteString(int filenum, char* secname,char* key,char* value) {
  section_t* p;

  if (!(p = ini_FindSection(filenum,secname))) {
    if (openfiles[filenum].sections)
      for(p = openfiles[filenum].sections;p->next != 0;p = p->next);
    p = addsection(filenum,p,secname);
  }
  if (key)
    addkeyvalue(p,key,value);
}

int ini_Save(int filenum,char* filename) {
  FILE* fp;
  section_t* p;
  stringlist_t* str;
  stringlist_t* str2;
  char* comment = ";options file\n";

  fp = fopen(filename,"wb");
  if (!fp)
    return 0;

  fwrite(comment,1,strlen(comment),fp);

  for(p=openfiles[filenum].sections;p;p = nextsec(p)) {
    fwrite("[",1,1,fp);
    fwrite(p->sectionname,1,strlen(p->sectionname),fp);
    fwrite("]\n",1,2,fp);
    for(str=p->name,str2=p->value; str; str= nextstr(str),str2=nextstr(str2))
      {
	fwrite(str->string,1,strlen(str->string),fp);
	fwrite("=",1,1,fp);
	fwrite(str2->string,1,strlen(str2->string),fp);
	fwrite("\n",1,1,fp);
      }
    fwrite("\n",1,1,fp);
  }
  
  fclose(fp);
  return 1;
    
}

 
/*
int main() {
  int filedex;
  section_t* print;
  char input[64];
  char input2[64];
  char* c;

  ini_init();
  filedex = ini_readfile("blah.ini");
  printf("ini_readfile  returned %d\n",filedex);
  
  print = openfiles[filedex].sections;

    do{
    printf("\nsection \"%s\"\n",print->sectionname);
    printsection(print);
  } while(print = nextsec(print));


  printf("there are %d sections\n",openfiles[filedex].count);
  while(c = ini_ReadSections(filedex))
    printf("%s\n",c);
  while(c = ini_ReadSections(filedex))
    printf("%s\n",c);

    printf("enter section to search");
  gets(input);
  printf("enter key to get");
  gets(input2);
  printf("result %s\n",ini_ReadValue(filedex,input,input2)); 

}

*/

