/* moonshot-id.c generated by valac 0.24.0, the Vala compiler
 * generated from moonshot-id.vala, do not modify */

/*
 * Copyright (c) 2011-2014, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gnome-keyring-memory.h>


#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;
typedef struct _TrustAnchorPrivate TrustAnchorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;
typedef struct _IdCardPrivate IdCardPrivate;

#define ID_CARD_TYPE_DIFF_FLAGS (id_card_diff_flags_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _TrustAnchor {
	GObject parent_instance;
	TrustAnchorPrivate * priv;
};

struct _TrustAnchorClass {
	GObjectClass parent_class;
};

struct _TrustAnchorPrivate {
	gchar* _ca_cert;
	gchar* _subject;
	gchar* _subject_alt;
	gchar* _server_cert;
};

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};

struct _IdCard {
	GObject parent_instance;
	IdCardPrivate * priv;
};

struct _IdCardClass {
	GObjectClass parent_class;
};

struct _IdCardPrivate {
	gchar* _nai;
	gchar* _display_name;
	gchar* _username;
	const gchar* _password;
	gchar* _issuer;
	Rule* _rules;
	gint _rules_length1;
	gint __rules_size_;
	gchar** _services;
	gint _services_length1;
	gint __services_size_;
	gboolean _temporary;
	TrustAnchor* _trust_anchor;
	gboolean _store_password;
};

typedef enum  {
	ID_CARD_DIFF_FLAGS_DISPLAY_NAME,
	ID_CARD_DIFF_FLAGS_USERNAME,
	ID_CARD_DIFF_FLAGS_PASSWORD,
	ID_CARD_DIFF_FLAGS_ISSUER,
	ID_CARD_DIFF_FLAGS_RULES,
	ID_CARD_DIFF_FLAGS_SERVICES,
	ID_CARD_DIFF_FLAGS_TRUST_ANCHOR
} IdCardDiffFlags;


static gpointer trust_anchor_parent_class = NULL;
static gpointer id_card_parent_class = NULL;

GType trust_anchor_get_type (void) G_GNUC_CONST;
#define TRUST_ANCHOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRUST_ANCHOR, TrustAnchorPrivate))
enum  {
	TRUST_ANCHOR_DUMMY_PROPERTY,
	TRUST_ANCHOR_CA_CERT,
	TRUST_ANCHOR_SUBJECT,
	TRUST_ANCHOR_SUBJECT_ALT,
	TRUST_ANCHOR_SERVER_CERT
};
gint trust_anchor_Compare (TrustAnchor* self, TrustAnchor* other);
const gchar* trust_anchor_get_ca_cert (TrustAnchor* self);
const gchar* trust_anchor_get_subject (TrustAnchor* self);
const gchar* trust_anchor_get_subject_alt (TrustAnchor* self);
const gchar* trust_anchor_get_server_cert (TrustAnchor* self);
TrustAnchor* trust_anchor_new (void);
TrustAnchor* trust_anchor_construct (GType object_type);
void trust_anchor_set_ca_cert (TrustAnchor* self, const gchar* value);
void trust_anchor_set_subject (TrustAnchor* self, const gchar* value);
void trust_anchor_set_subject_alt (TrustAnchor* self, const gchar* value);
void trust_anchor_set_server_cert (TrustAnchor* self, const gchar* value);
static void trust_anchor_finalize (GObject* obj);
static void _vala_trust_anchor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_trust_anchor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
gint rule_Compare (Rule *self, Rule* other);
GType id_card_get_type (void) G_GNUC_CONST;
#define ID_CARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ID_CARD, IdCardPrivate))
enum  {
	ID_CARD_DUMMY_PROPERTY,
	ID_CARD_DISPLAY_NAME,
	ID_CARD_USERNAME,
	ID_CARD_PASSWORD,
	ID_CARD_ISSUER,
	ID_CARD_SERVICES,
	ID_CARD_TEMPORARY,
	ID_CARD_TRUST_ANCHOR,
	ID_CARD_NAI,
	ID_CARD_STORE_PASSWORD
};
void id_card_set_password (IdCard* self, const gchar* value);
GType id_card_diff_flags_get_type (void) G_GNUC_CONST;
static void _vala_Rule_array_free (Rule* array, gint array_length);
#define ID_CARD_NO_IDENTITY "No Identity"
gboolean id_card_IsNoIdentity (IdCard* self);
const gchar* id_card_get_display_name (IdCard* self);
gint id_card_Compare (IdCard* self, IdCard* other);
const gchar* id_card_get_username (IdCard* self);
const gchar* id_card_get_password (IdCard* self);
const gchar* id_card_get_issuer (IdCard* self);
gint CompareRules (Rule* a, int a_length1, Rule* b, int b_length1);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
gint CompareStringArray (gchar** a, int a_length1, gchar** b, int b_length1);
gchar** id_card_get_services (IdCard* self, int* result_length1);
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
IdCard* id_card_NewNoIdentity (void);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
void id_card_set_display_name (IdCard* self, const gchar* value);
void id_card_set_username (IdCard* self, const gchar* value);
void id_card_set_issuer (IdCard* self, const gchar* value);
void id_card_set_rules (IdCard* self, Rule* value, int value_length1);
static Rule* _vala_array_dup8 (Rule* self, int length);
void id_card_set_services (IdCard* self, gchar** value, int value_length1);
static gchar** _vala_array_dup9 (gchar** self, int length);
gboolean id_card_get_temporary (IdCard* self);
void id_card_set_temporary (IdCard* self, gboolean value);
void id_card_set_trust_anchor (IdCard* self, TrustAnchor* value);
const gchar* id_card_get_nai (IdCard* self);
gboolean id_card_get_store_password (IdCard* self);
void id_card_set_store_password (IdCard* self, gboolean value);
static void id_card_finalize (GObject* obj);
static void _vala_id_card_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_id_card_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gint trust_anchor_Compare (TrustAnchor* self, TrustAnchor* other) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	TrustAnchor* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	TrustAnchor* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	TrustAnchor* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	TrustAnchor* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
#line 38 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 38 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (other != NULL, 0);
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_ca_cert;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = other;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = _tmp1_->priv->_ca_cert;
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp0_, _tmp2_) != 0) {
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 41 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 246 "moonshot-id.c"
	}
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = self->priv->_subject;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = other;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = _tmp4_->priv->_subject;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp3_, _tmp5_) != 0) {
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 260 "moonshot-id.c"
	}
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp6_ = self->priv->_subject_alt;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp7_ = other;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp8_ = _tmp7_->priv->_subject_alt;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp6_, _tmp8_) != 0) {
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 274 "moonshot-id.c"
	}
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp9_ = self->priv->_server_cert;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp10_ = other;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp11_ = _tmp10_->priv->_server_cert;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp9_, _tmp11_) != 0) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 288 "moonshot-id.c"
	}
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = 0;
#line 48 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 294 "moonshot-id.c"
}


TrustAnchor* trust_anchor_construct (GType object_type) {
	TrustAnchor * self = NULL;
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self = (TrustAnchor*) g_object_new (object_type, NULL);
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return self;
#line 304 "moonshot-id.c"
}


TrustAnchor* trust_anchor_new (void) {
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return trust_anchor_construct (TYPE_TRUST_ANCHOR);
#line 311 "moonshot-id.c"
}


const gchar* trust_anchor_get_ca_cert (TrustAnchor* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_ca_cert;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 326 "moonshot-id.c"
}


void trust_anchor_set_ca_cert (TrustAnchor* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_ca_cert);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_ca_cert = _tmp1_;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "ca-cert");
#line 345 "moonshot-id.c"
}


const gchar* trust_anchor_get_subject (TrustAnchor* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_subject;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 360 "moonshot-id.c"
}


void trust_anchor_set_subject (TrustAnchor* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_subject);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_subject = _tmp1_;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "subject");
#line 379 "moonshot-id.c"
}


const gchar* trust_anchor_get_subject_alt (TrustAnchor* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_subject_alt;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 394 "moonshot-id.c"
}


void trust_anchor_set_subject_alt (TrustAnchor* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_subject_alt);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_subject_alt = _tmp1_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "subject-alt");
#line 413 "moonshot-id.c"
}


const gchar* trust_anchor_get_server_cert (TrustAnchor* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_server_cert;
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 428 "moonshot-id.c"
}


void trust_anchor_set_server_cert (TrustAnchor* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_server_cert);
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_server_cert = _tmp1_;
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "server-cert");
#line 447 "moonshot-id.c"
}


static void trust_anchor_class_init (TrustAnchorClass * klass) {
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	trust_anchor_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_type_class_add_private (klass, sizeof (TrustAnchorPrivate));
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_trust_anchor_get_property;
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_trust_anchor_set_property;
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (klass)->finalize = trust_anchor_finalize;
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRUST_ANCHOR_CA_CERT, g_param_spec_string ("ca-cert", "ca-cert", "ca-cert", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRUST_ANCHOR_SUBJECT, g_param_spec_string ("subject", "subject", "subject", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRUST_ANCHOR_SUBJECT_ALT, g_param_spec_string ("subject-alt", "subject-alt", "subject-alt", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRUST_ANCHOR_SERVER_CERT, g_param_spec_string ("server-cert", "server-cert", "server-cert", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 470 "moonshot-id.c"
}


static void trust_anchor_instance_init (TrustAnchor * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv = TRUST_ANCHOR_GET_PRIVATE (self);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = g_strdup ("");
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_ca_cert = _tmp0_;
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup ("");
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_subject = _tmp1_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = g_strdup ("");
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_subject_alt = _tmp2_;
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = g_strdup ("");
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_server_cert = _tmp3_;
#line 497 "moonshot-id.c"
}


static void trust_anchor_finalize (GObject* obj) {
	TrustAnchor * self;
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TRUST_ANCHOR, TrustAnchor);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_ca_cert);
#line 35 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_subject);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_subject_alt);
#line 37 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_server_cert);
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (trust_anchor_parent_class)->finalize (obj);
#line 515 "moonshot-id.c"
}


GType trust_anchor_get_type (void) {
	static volatile gsize trust_anchor_type_id__volatile = 0;
	if (g_once_init_enter (&trust_anchor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrustAnchorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) trust_anchor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrustAnchor), 0, (GInstanceInitFunc) trust_anchor_instance_init, NULL };
		GType trust_anchor_type_id;
		trust_anchor_type_id = g_type_register_static (G_TYPE_OBJECT, "TrustAnchor", &g_define_type_info, 0);
		g_once_init_leave (&trust_anchor_type_id__volatile, trust_anchor_type_id);
	}
	return trust_anchor_type_id__volatile;
}


static void _vala_trust_anchor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrustAnchor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TRUST_ANCHOR, TrustAnchor);
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	switch (property_id) {
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case TRUST_ANCHOR_CA_CERT:
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, trust_anchor_get_ca_cert (self));
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case TRUST_ANCHOR_SUBJECT:
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, trust_anchor_get_subject (self));
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case TRUST_ANCHOR_SUBJECT_ALT:
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, trust_anchor_get_subject_alt (self));
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case TRUST_ANCHOR_SERVER_CERT:
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, trust_anchor_get_server_cert (self));
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 560 "moonshot-id.c"
		default:
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 566 "moonshot-id.c"
	}
}


static void _vala_trust_anchor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrustAnchor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TRUST_ANCHOR, TrustAnchor);
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	switch (property_id) {
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case TRUST_ANCHOR_CA_CERT:
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		trust_anchor_set_ca_cert (self, g_value_get_string (value));
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case TRUST_ANCHOR_SUBJECT:
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		trust_anchor_set_subject (self, g_value_get_string (value));
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case TRUST_ANCHOR_SUBJECT_ALT:
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		trust_anchor_set_subject_alt (self, g_value_get_string (value));
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case TRUST_ANCHOR_SERVER_CERT:
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		trust_anchor_set_server_cert (self, g_value_get_string (value));
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 600 "moonshot-id.c"
		default:
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 606 "moonshot-id.c"
	}
}


gint rule_Compare (Rule *self, Rule* other) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	Rule _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	Rule _tmp4_ = {0};
	const gchar* _tmp5_ = NULL;
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (other != NULL, 0);
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = (*self).pattern;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = *other;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = _tmp1_.pattern;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp0_, _tmp2_) != 0) {
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 58 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 633 "moonshot-id.c"
	}
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = (*self).always_confirm;
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = *other;
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = _tmp4_.always_confirm;
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp3_, _tmp5_) != 0) {
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 647 "moonshot-id.c"
	}
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = 0;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 653 "moonshot-id.c"
}


void rule_copy (const Rule* self, Rule* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = (*self).pattern;
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 ((*dest).pattern);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	(*dest).pattern = _tmp1_;
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = (*self).always_confirm;
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 ((*dest).always_confirm);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	(*dest).always_confirm = _tmp3_;
#line 678 "moonshot-id.c"
}


void rule_destroy (Rule* self) {
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 ((*self).pattern);
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 ((*self).always_confirm);
#line 687 "moonshot-id.c"
}


Rule* rule_dup (const Rule* self) {
	Rule* dup;
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	dup = g_new0 (Rule, 1);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	rule_copy (self, dup);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return dup;
#line 699 "moonshot-id.c"
}


void rule_free (Rule* self) {
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	rule_destroy (self);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_free (self);
#line 708 "moonshot-id.c"
}


GType rule_get_type (void) {
	static volatile gsize rule_type_id__volatile = 0;
	if (g_once_init_enter (&rule_type_id__volatile)) {
		GType rule_type_id;
		rule_type_id = g_boxed_type_register_static ("Rule", (GBoxedCopyFunc) rule_dup, (GBoxedFreeFunc) rule_free);
		g_once_init_leave (&rule_type_id__volatile, rule_type_id);
	}
	return rule_type_id__volatile;
}


GType id_card_diff_flags_get_type (void) {
	static volatile gsize id_card_diff_flags_type_id__volatile = 0;
	if (g_once_init_enter (&id_card_diff_flags_type_id__volatile)) {
		static const GEnumValue values[] = {{ID_CARD_DIFF_FLAGS_DISPLAY_NAME, "ID_CARD_DIFF_FLAGS_DISPLAY_NAME", "display-name"}, {ID_CARD_DIFF_FLAGS_USERNAME, "ID_CARD_DIFF_FLAGS_USERNAME", "username"}, {ID_CARD_DIFF_FLAGS_PASSWORD, "ID_CARD_DIFF_FLAGS_PASSWORD", "password"}, {ID_CARD_DIFF_FLAGS_ISSUER, "ID_CARD_DIFF_FLAGS_ISSUER", "issuer"}, {ID_CARD_DIFF_FLAGS_RULES, "ID_CARD_DIFF_FLAGS_RULES", "rules"}, {ID_CARD_DIFF_FLAGS_SERVICES, "ID_CARD_DIFF_FLAGS_SERVICES", "services"}, {ID_CARD_DIFF_FLAGS_TRUST_ANCHOR, "ID_CARD_DIFF_FLAGS_TRUST_ANCHOR", "trust-anchor"}, {0, NULL, NULL}};
		GType id_card_diff_flags_type_id;
		id_card_diff_flags_type_id = g_enum_register_static ("IdCardDiffFlags", values);
		g_once_init_leave (&id_card_diff_flags_type_id__volatile, id_card_diff_flags_type_id);
	}
	return id_card_diff_flags_type_id__volatile;
}


static void _vala_Rule_array_free (Rule* array, gint array_length) {
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (array != NULL) {
#line 738 "moonshot-id.c"
		int i;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			rule_destroy (&array[i]);
#line 744 "moonshot-id.c"
		}
	}
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_free (array);
#line 749 "moonshot-id.c"
}


gboolean id_card_IsNoIdentity (IdCard* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_display_name;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = g_strcmp0 (_tmp0_, ID_CARD_NO_IDENTITY) == 0;
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 764 "moonshot-id.c"
}


gint id_card_Compare (IdCard* self, IdCard* other) {
	gint result = 0;
	gint diff = 0;
	const gchar* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp4_ = NULL;
	IdCard* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	IdCard* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp14_ = NULL;
	IdCard* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	Rule* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	Rule* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	IdCard* _tmp20_ = NULL;
	Rule* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	Rule* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gint _tmp23_ = 0;
	gchar** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gchar** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	IdCard* _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	gint _tmp30_ = 0;
	TrustAnchor* _tmp32_ = NULL;
	IdCard* _tmp33_ = NULL;
	TrustAnchor* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	FILE* _tmp37_ = NULL;
	gint _tmp38_ = 0;
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 120 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (other != NULL, 0);
#line 122 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	diff = 0;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_display_name;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = other;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = _tmp1_->priv->_display_name;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp0_, _tmp2_) != 0) {
#line 825 "moonshot-id.c"
		gint _tmp3_ = 0;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp3_ = diff;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp3_ | (1 << ID_CARD_DIFF_FLAGS_DISPLAY_NAME);
#line 831 "moonshot-id.c"
	}
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = self->priv->_username;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = other;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp6_ = _tmp5_->priv->_username;
#line 125 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp4_, _tmp6_) != 0) {
#line 841 "moonshot-id.c"
		gint _tmp7_ = 0;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp7_ = diff;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp7_ | (1 << ID_CARD_DIFF_FLAGS_USERNAME);
#line 847 "moonshot-id.c"
	}
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp8_ = id_card_get_password (self);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp9_ = _tmp8_;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp10_ = other;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp11_ = id_card_get_password (_tmp10_);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp12_ = _tmp11_;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp9_, _tmp12_) != 0) {
#line 861 "moonshot-id.c"
		gint _tmp13_ = 0;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp13_ = diff;
#line 128 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp13_ | (1 << ID_CARD_DIFF_FLAGS_PASSWORD);
#line 867 "moonshot-id.c"
	}
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp14_ = self->priv->_issuer;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp15_ = other;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp16_ = _tmp15_->priv->_issuer;
#line 129 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (g_strcmp0 (_tmp14_, _tmp16_) != 0) {
#line 877 "moonshot-id.c"
		gint _tmp17_ = 0;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp17_ = diff;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp17_ | (1 << ID_CARD_DIFF_FLAGS_ISSUER);
#line 883 "moonshot-id.c"
	}
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp18_ = id_card_get_rules (self, &_tmp18__length1);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp19_ = _tmp18_;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp19__length1 = _tmp18__length1;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp20_ = other;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp21_ = id_card_get_rules (_tmp20_, &_tmp21__length1);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp22_ = _tmp21_;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp22__length1 = _tmp21__length1;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp23_ = CompareRules (_tmp19_, _tmp19__length1, _tmp22_, _tmp22__length1);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp23_ != 0) {
#line 903 "moonshot-id.c"
		gint _tmp24_ = 0;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp24_ = diff;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp24_ | (1 << ID_CARD_DIFF_FLAGS_RULES);
#line 909 "moonshot-id.c"
	}
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp25_ = id_card_get_services (self, &_tmp25__length1);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp26_ = _tmp25_;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp26__length1 = _tmp25__length1;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp27_ = other;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp28_ = id_card_get_services (_tmp27_, &_tmp28__length1);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp29_ = _tmp28_;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp29__length1 = _tmp28__length1;
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp30_ = CompareStringArray (_tmp26_, _tmp26__length1, _tmp29_, _tmp29__length1);
#line 133 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp30_ != 0) {
#line 929 "moonshot-id.c"
		gint _tmp31_ = 0;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp31_ = diff;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp31_ | (1 << ID_CARD_DIFF_FLAGS_SERVICES);
#line 935 "moonshot-id.c"
	}
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp32_ = self->priv->_trust_anchor;
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp33_ = other;
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp34_ = _tmp33_->priv->_trust_anchor;
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp35_ = trust_anchor_Compare (_tmp32_, _tmp34_);
#line 135 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp35_ != 0) {
#line 947 "moonshot-id.c"
		gint _tmp36_ = 0;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp36_ = diff;
#line 136 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		diff = _tmp36_ | (1 << ID_CARD_DIFF_FLAGS_TRUST_ANCHOR);
#line 953 "moonshot-id.c"
	}
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp37_ = stdout;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp38_ = diff;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	fprintf (_tmp37_, "Diff Flags: %x\n", (guint) _tmp38_);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = diff;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 965 "moonshot-id.c"
}


IdCard* id_card_NewNoIdentity (void) {
	IdCard* result = NULL;
	IdCard* card = NULL;
	IdCard* _tmp0_ = NULL;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = id_card_new ();
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	card = _tmp0_;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	id_card_set_display_name (card, ID_CARD_NO_IDENTITY);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = card;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 983 "moonshot-id.c"
}


IdCard* id_card_construct (GType object_type) {
	IdCard * self = NULL;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self = (IdCard*) g_object_new (object_type, NULL);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return self;
#line 993 "moonshot-id.c"
}


IdCard* id_card_new (void) {
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return id_card_construct (TYPE_ID_CARD);
#line 1000 "moonshot-id.c"
}


const gchar* id_card_get_display_name (IdCard* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_display_name;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1015 "moonshot-id.c"
}


void id_card_set_display_name (IdCard* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_display_name);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_display_name = _tmp1_;
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "display-name");
#line 1034 "moonshot-id.c"
}


const gchar* id_card_get_username (IdCard* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_username;
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1049 "moonshot-id.c"
}


void id_card_set_username (IdCard* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_username);
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_username = _tmp1_;
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "username");
#line 1068 "moonshot-id.c"
}


const gchar* id_card_get_password (IdCard* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = self->priv->_password;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp1_ != NULL) {
#line 1082 "moonshot-id.c"
		const gchar* _tmp2_ = NULL;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp2_ = self->priv->_password;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0_ = _tmp2_;
#line 1088 "moonshot-id.c"
	} else {
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0_ = "";
#line 1092 "moonshot-id.c"
	}
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1098 "moonshot-id.c"
}


void id_card_set_password (IdCard* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_password;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp0_ != NULL) {
#line 1111 "moonshot-id.c"
		const gchar* _tmp1_ = NULL;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp1_ = self->priv->_password;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		gnome_keyring_memory_free ((void*) _tmp1_);
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		self->priv->_password = NULL;
#line 1119 "moonshot-id.c"
	}
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = value;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp2_ != NULL) {
#line 1125 "moonshot-id.c"
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp3_ = value;
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp4_ = gnome_keyring_memory_strdup (_tmp3_);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		self->priv->_password = _tmp4_;
#line 1134 "moonshot-id.c"
	}
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "password");
#line 1138 "moonshot-id.c"
}


const gchar* id_card_get_issuer (IdCard* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_issuer;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1153 "moonshot-id.c"
}


void id_card_set_issuer (IdCard* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_issuer);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_issuer = _tmp1_;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "issuer");
#line 1172 "moonshot-id.c"
}


Rule* id_card_get_rules (IdCard* self, int* result_length1) {
	Rule* result;
	Rule* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	Rule* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_rules;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0__length1 = self->priv->_rules_length1;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = _tmp0_;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1__length1 = _tmp0__length1;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (result_length1) {
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		*result_length1 = _tmp1__length1;
#line 1196 "moonshot-id.c"
	}
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp1_;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1202 "moonshot-id.c"
}


static Rule* _vala_array_dup8 (Rule* self, int length) {
	Rule* result;
	int i;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = g_new0 (Rule, length);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	for (i = 0; i < length; i++) {
#line 1213 "moonshot-id.c"
		Rule _tmp0_ = {0};
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		rule_copy (&self[i], &_tmp0_);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result[i] = _tmp0_;
#line 1219 "moonshot-id.c"
	}
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1223 "moonshot-id.c"
}


void id_card_set_rules (IdCard* self, Rule* value, int value_length1) {
	Rule* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	Rule* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0__length1 = value_length1;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup8 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1__length1 = _tmp0__length1;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_rules = (_vala_Rule_array_free (self->priv->_rules, self->priv->_rules_length1), NULL);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_rules = _tmp1_;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_rules_length1 = _tmp1__length1;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->__rules_size_ = self->priv->_rules_length1;
#line 1250 "moonshot-id.c"
}


gchar** id_card_get_services (IdCard* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_services;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0__length1 = self->priv->_services_length1;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = _tmp0_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1__length1 = _tmp0__length1;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (result_length1) {
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		*result_length1 = _tmp1__length1;
#line 1274 "moonshot-id.c"
	}
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp1_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1280 "moonshot-id.c"
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = g_new0 (gchar*, length + 1);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	for (i = 0; i < length; i++) {
#line 1291 "moonshot-id.c"
		gchar* _tmp0_ = NULL;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		_tmp0_ = g_strdup (self[i]);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result[i] = _tmp0_;
#line 1297 "moonshot-id.c"
	}
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1301 "moonshot-id.c"
}


void id_card_set_services (IdCard* self, gchar** value, int value_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0__length1 = value_length1;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup9 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1__length1 = _tmp0__length1;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_services = (_vala_array_free (self->priv->_services, self->priv->_services_length1, (GDestroyNotify) g_free), NULL);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_services = _tmp1_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_services_length1 = _tmp1__length1;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->__services_size_ = self->priv->_services_length1;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "services");
#line 1330 "moonshot-id.c"
}


gboolean id_card_get_temporary (IdCard* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_temporary;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1345 "moonshot-id.c"
}


void id_card_set_temporary (IdCard* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_temporary = _tmp0_;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "temporary");
#line 1359 "moonshot-id.c"
}


TrustAnchor* id_card_get_trust_anchor (IdCard* self) {
	TrustAnchor* result;
	TrustAnchor* _tmp0_ = NULL;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_trust_anchor;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1374 "moonshot-id.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return self ? g_object_ref (self) : NULL;
#line 1381 "moonshot-id.c"
}


void id_card_set_trust_anchor (IdCard* self, TrustAnchor* value) {
	TrustAnchor* _tmp0_ = NULL;
	TrustAnchor* _tmp1_ = NULL;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_object_unref0 (self->priv->_trust_anchor);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_trust_anchor = _tmp1_;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "trust-anchor");
#line 1400 "moonshot-id.c"
}


const gchar* id_card_get_nai (IdCard* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_username;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strconcat (_tmp0_, "@", NULL);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = _tmp1_;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = self->priv->_issuer;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_nai);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_nai = _tmp4_;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (_tmp2_);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = self->priv->_nai;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp5_;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1436 "moonshot-id.c"
}


gboolean id_card_get_store_password (IdCard* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = self->priv->_store_password;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = _tmp0_;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1451 "moonshot-id.c"
}


void id_card_set_store_password (IdCard* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_return_if_fail (self != NULL);
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = value;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_store_password = _tmp0_;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_notify ((GObject *) self, "store-password");
#line 1465 "moonshot-id.c"
}


static void id_card_class_init (IdCardClass * klass) {
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	id_card_parent_class = g_type_class_peek_parent (klass);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_type_class_add_private (klass, sizeof (IdCardPrivate));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_id_card_get_property;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_id_card_set_property;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (klass)->finalize = id_card_finalize;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_USERNAME, g_param_spec_string ("username", "username", "username", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_PASSWORD, g_param_spec_string ("password", "password", "password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_ISSUER, g_param_spec_string ("issuer", "issuer", "issuer", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_SERVICES, g_param_spec_boxed ("services", "services", "services", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_TEMPORARY, g_param_spec_boolean ("temporary", "temporary", "temporary", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_TRUST_ANCHOR, g_param_spec_object ("trust-anchor", "trust-anchor", "trust-anchor", TYPE_TRUST_ANCHOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_NAI, g_param_spec_string ("nai", "nai", "nai", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_STORE_PASSWORD, g_param_spec_boolean ("store-password", "store-password", "store-password", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1498 "moonshot-id.c"
}


static void id_card_instance_init (IdCard * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	Rule* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	TrustAnchor* _tmp5_ = NULL;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv = ID_CARD_GET_PRIVATE (self);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = g_strdup ("");
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_display_name = _tmp0_;
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = g_strdup ("");
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_username = _tmp1_;
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp2_ = g_strdup ("");
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_issuer = _tmp2_;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp3_ = g_new0 (Rule, 0);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_rules = _tmp3_;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_rules_length1 = 0;
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->__rules_size_ = self->priv->_rules_length1;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp4_ = g_new0 (gchar*, 0 + 1);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_services = _tmp4_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_services_length1 = 0;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->__services_size_ = self->priv->_services_length1;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_temporary = FALSE;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp5_ = trust_anchor_new ();
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_trust_anchor = _tmp5_;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_store_password = FALSE;
#line 1547 "moonshot-id.c"
}


static void id_card_finalize (GObject* obj) {
	IdCard * self;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ID_CARD, IdCard);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	id_card_set_password (self, NULL);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_nai);
#line 71 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_display_name);
#line 73 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_username);
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_free0 (self->priv->_issuer);
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_rules = (_vala_Rule_array_free (self->priv->_rules, self->priv->_rules_length1), NULL);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	self->priv->_services = (_vala_array_free (self->priv->_services, self->priv->_services_length1, (GDestroyNotify) g_free), NULL);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_g_object_unref0 (self->priv->_trust_anchor);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	G_OBJECT_CLASS (id_card_parent_class)->finalize (obj);
#line 1573 "moonshot-id.c"
}


GType id_card_get_type (void) {
	static volatile gsize id_card_type_id__volatile = 0;
	if (g_once_init_enter (&id_card_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IdCardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) id_card_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdCard), 0, (GInstanceInitFunc) id_card_instance_init, NULL };
		GType id_card_type_id;
		id_card_type_id = g_type_register_static (G_TYPE_OBJECT, "IdCard", &g_define_type_info, 0);
		g_once_init_leave (&id_card_type_id__volatile, id_card_type_id);
	}
	return id_card_type_id__volatile;
}


static void _vala_id_card_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	IdCard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ID_CARD, IdCard);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	switch (property_id) {
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_DISPLAY_NAME:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, id_card_get_display_name (self));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_USERNAME:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, id_card_get_username (self));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_PASSWORD:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, id_card_get_password (self));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_ISSUER:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, id_card_get_issuer (self));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_SERVICES:
#line 1620 "moonshot-id.c"
		{
			int length;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			g_value_set_boxed (value, id_card_get_services (self, &length));
#line 1625 "moonshot-id.c"
		}
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_TEMPORARY:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_boolean (value, id_card_get_temporary (self));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_TRUST_ANCHOR:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_object (value, id_card_get_trust_anchor (self));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_NAI:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_string (value, id_card_get_nai (self));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_STORE_PASSWORD:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		g_value_set_boolean (value, id_card_get_store_password (self));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 1653 "moonshot-id.c"
		default:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 1659 "moonshot-id.c"
	}
}


static void _vala_id_card_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	IdCard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ID_CARD, IdCard);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	switch (property_id) {
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_DISPLAY_NAME:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_display_name (self, g_value_get_string (value));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_USERNAME:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_username (self, g_value_get_string (value));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_PASSWORD:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_password (self, g_value_get_string (value));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_ISSUER:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_issuer (self, g_value_get_string (value));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_SERVICES:
#line 1695 "moonshot-id.c"
		{
			gpointer boxed;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			boxed = g_value_get_boxed (value);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			id_card_set_services (self, boxed, g_strv_length (boxed));
#line 1702 "moonshot-id.c"
		}
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_TEMPORARY:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_temporary (self, g_value_get_boolean (value));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_TRUST_ANCHOR:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_trust_anchor (self, g_value_get_object (value));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		case ID_CARD_STORE_PASSWORD:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		id_card_set_store_password (self, g_value_get_boolean (value));
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 1724 "moonshot-id.c"
		default:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		break;
#line 1730 "moonshot-id.c"
	}
}


gint CompareRules (Rule* a, int a_length1, Rule* b, int b_length1) {
	gint result = 0;
	Rule* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	Rule* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = a;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0__length1 = a_length1;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = b;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1__length1 = b_length1;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp0__length1 != _tmp1__length1) {
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 1755 "moonshot-id.c"
	}
	{
		gint i = 0;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		i = 0;
#line 1761 "moonshot-id.c"
		{
			gboolean _tmp2_ = FALSE;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_tmp2_ = TRUE;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			while (TRUE) {
#line 1768 "moonshot-id.c"
				gint _tmp4_ = 0;
				Rule* _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				Rule* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				Rule* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				Rule _tmp10_ = {0};
				gint _tmp11_ = 0;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (!_tmp2_) {
#line 1782 "moonshot-id.c"
					gint _tmp3_ = 0;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					_tmp3_ = i;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					i = _tmp3_ + 1;
#line 1788 "moonshot-id.c"
				}
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp2_ = FALSE;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp4_ = i;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp5_ = a;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp5__length1 = a_length1;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (!(_tmp4_ < _tmp5__length1)) {
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					break;
#line 1802 "moonshot-id.c"
				}
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp6_ = a;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp6__length1 = a_length1;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp7_ = i;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp8_ = b;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp8__length1 = b_length1;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp9_ = i;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp10_ = _tmp8_[_tmp9_];
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp11_ = rule_Compare (&_tmp6_[_tmp7_], &_tmp10_);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (_tmp11_ != 0) {
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					result = 1;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					return result;
#line 1826 "moonshot-id.c"
				}
			}
		}
	}
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = 0;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1835 "moonshot-id.c"
}


gint CompareStringArray (gchar** a, int a_length1, gchar** b, int b_length1) {
	gint result = 0;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0_ = a;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp0__length1 = a_length1;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1_ = b;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	_tmp1__length1 = b_length1;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	if (_tmp0__length1 != _tmp1__length1) {
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		result = 1;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		return result;
#line 1859 "moonshot-id.c"
	}
	{
		gint i = 0;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
		i = 0;
#line 1865 "moonshot-id.c"
		{
			gboolean _tmp2_ = FALSE;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			_tmp2_ = TRUE;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
			while (TRUE) {
#line 1872 "moonshot-id.c"
				gint _tmp4_ = 0;
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				const gchar* _tmp8_ = NULL;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				const gchar* _tmp11_ = NULL;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (!_tmp2_) {
#line 1886 "moonshot-id.c"
					gint _tmp3_ = 0;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					_tmp3_ = i;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					i = _tmp3_ + 1;
#line 1892 "moonshot-id.c"
				}
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp2_ = FALSE;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp4_ = i;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp5_ = a;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp5__length1 = a_length1;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (!(_tmp4_ < _tmp5__length1)) {
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					break;
#line 1906 "moonshot-id.c"
				}
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp6_ = a;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp6__length1 = a_length1;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp7_ = i;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp8_ = _tmp6_[_tmp7_];
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp9_ = b;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp9__length1 = b_length1;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp10_ = i;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				_tmp11_ = _tmp9_[_tmp10_];
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
				if (g_strcmp0 (_tmp8_, _tmp11_) != 0) {
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					result = 1;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
					return result;
#line 1930 "moonshot-id.c"
				}
			}
		}
	}
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	result = 0;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-id.vala"
	return result;
#line 1939 "moonshot-id.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



