// Author(s): Wieger Wesselink
// Copyright: see the accompanying file COPYING or copy at
// https://svn.win.tue.nl/trac/MCRL2/browser/trunk/COPYING
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
/// \file mcrl22lps.cpp
/// \brief Add your file description here.

// #define MCRL2_PBES_TRANSLATE_DEBUG

#include <iostream>
#include <string>
#include "mcrl2/lps/specification.h"
#include "mcrl2/lps/linearise.h"
#include "mcrl2/pbes/pbes.h"
#include "mcrl2/pbes/lps2pbes.h"
#include "mcrl2/utilities/text_utility.h"
#include "mcrl2/atermpp/aterm_init.h"

using namespace std;
using namespace mcrl2;
using namespace mcrl2::data;
using namespace mcrl2::lps;
using namespace mcrl2::state_formulas;
using namespace mcrl2::pbes_system;
using namespace mcrl2::pbes_system::pbes_expr;

int main(int argc, char* argv[])
{
  MCRL2_ATERMPP_INIT(argc, argv)

  if (argc < 4)
  {
    std::cout << "Usage: lps2pbes FILENAME-INPUT-LPS FILENAME-INPUT-MCF FILENAME-OUTPUT-PBES" << std::endl;
    return 0;
  }
  

  string spec_file(argv[1]); // specification file
  string mcf_file(argv[2]);  // modal formula file
  string pbes_file(argv[3]); // resulting pbes file

  specification spec = linearise(utilities::read_text(spec_file));
  state_formula sf = parse_state_formula(utilities::read_text(mcf_file), spec);
  bool timed = false;
  pbes<> p = lps2pbes(spec, sf, timed);
  p.save(pbes_file);

  return 0;
}
