# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.implicit_function import ImplicitFunction


class Spheres(ImplicitFunction):
    r"""
    Spheres - implicit function for a set of spheres
    
    Superclass: ImplicitFunction
    
    Spheres computes the implicit function and function gradient for a
    set of spheres. The spheres are combined via a union operation (i.e.,
    the minimum value from the evaluation of all spheres is taken).
    
    The function value is the distance of a point to the closest sphere,
    with negative values interior to the spheres, positive outside the
    spheres, and distance=0 on the spheres surface.  The function
    gradient is the sphere normal at the function value.
    
    @sa
    Planes ImplicitBoolean
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSpheres, obj, update, **traits)
    
    def _get_centers(self):
        return wrap_vtk(self._vtk_obj.GetCenters())
    def _set_centers(self, arg):
        old_val = self._get_centers()
        my_arg = deref_array([arg], [['vtkPoints']])
        self._wrap_call(self._vtk_obj.SetCenters,
                        my_arg[0])
        self.trait_property_changed('centers', old_val, arg)
    centers = traits.Property(_get_centers, _set_centers, desc=\
        r"""
        
        """
    )

    def _get_radii(self):
        return wrap_vtk(self._vtk_obj.GetRadii())
    def _set_radii(self, arg):
        old_val = self._get_radii()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetRadii,
                        my_arg[0])
        self.trait_property_changed('radii', old_val, arg)
    radii = traits.Property(_get_radii, _set_radii, desc=\
        r"""
        
        """
    )

    def _get_number_of_spheres(self):
        return self._vtk_obj.GetNumberOfSpheres()
    number_of_spheres = traits.Property(_get_number_of_spheres, desc=\
        r"""
        Return the number of spheres in the set of spheres.
        """
    )

    def get_sphere(self, *args):
        """
        get_sphere(self, i:int) -> Sphere
        C++: Sphere *get_sphere(int i)
        get_sphere(self, i:int, sphere:Sphere) -> None
        C++: void get_sphere(int i, Sphere *sphere)
        Create and return a pointer to a Sphere object at the ith
        position. Asking for a sphere outside the allowable range returns
        nullptr.  This method always returns the same object. 
        Alternatively use get_sphere(int i, Sphere *sphere) to update a
        user supplied sphere.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetSphere, *my_args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Spheres, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Spheres properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit Spheres properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Spheres properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

