# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_processing_pass import ImageProcessingPass


class OutlineGlowPass(ImageProcessingPass):
    r"""
    OutlineGlowPass - Renders a glowing outline using a image
    processing pass
    
    Superclass: ImageProcessingPass
    
    Create a glowing outline of the image rendered by the delegate.
    
    This render pass was designed to highlight parts of a scene by
    applying the render pass to a layered renderer on top of the main
    scene. For optimal results, actors that form the outline should be
    brightly colored with lighting disabled. The outline will have the
    color of the actors. There is only one outline around all objects
    rendered by the delegate.
    
    This pass expects an initialized depth buffer and color buffer.
    Initialized buffers means they have been cleared with farthest
    z-value and background color/gradient/transparent color. An opaque
    pass may have been performed right after the initialization.
    
    The delegate is used once.
    
    Its delegate is usually set to a CameraPass or to a
    post-processing pass.
    
    This pass requires a open_gl context that supports texture objects
    (TO), framebuffer objects (FBO) and GLSL. If not, it will emit an
    error message and will render its delegate and return.
    
    @par Implementation: The image is first rendered to a full size
    offscreen render target, then blurred twice on a half sized render
    target using Gaussian blur with an offset. The offset and the smaller
    render target increase the size of the outline without incurring the
    cost of a big Gaussian blur kernel. The implementation of the
    gaussian blur is similar to GaussianBlurPass with the alterations
    described above.
    
    @sa
    RenderPass GaussianBlurPass
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOutlineGlowPass, obj, update, **traits)
    
    outline_intensity = traits.Float(3.0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _outline_intensity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutlineIntensity,
                        self.outline_intensity)

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('outline_intensity',
    'GetOutlineIntensity'), ('active_draw_buffers',
    'GetActiveDrawBuffers'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'active_draw_buffers',
    'object_name', 'outline_intensity'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OutlineGlowPass, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OutlineGlowPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['active_draw_buffers', 'object_name',
            'outline_intensity']),
            title='Edit OutlineGlowPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OutlineGlowPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

