/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include "mn-maildir-mailbox-backend.h"

#include "mn-maildir-mailbox-backend-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 24 "src/mn-maildir-mailbox-backend.gob"

#include <string.h>
#include <stdlib.h>
#include <glib/gi18n.h>
#include "mn-mailbox-private.h"
#include "mn-reentrant-mailbox-private.h"
#include "mn-vfs-mailbox-backend-private.h"
#include "mn-vfs.h"
#include "mn-util.h"
#include "mn-message-mime.h"
#include "mn-maildir-message.h"

#line 37 "mn-maildir-mailbox-backend.c"
/* self casting macros */
#define SELF(x) MN_MAILDIR_MAILBOX_BACKEND(x)
#define SELF_CONST(x) MN_MAILDIR_MAILBOX_BACKEND_CONST(x)
#define IS_SELF(x) MN_IS_MAILDIR_MAILBOX_BACKEND(x)
#define TYPE_SELF MN_TYPE_MAILDIR_MAILBOX_BACKEND
#define SELF_CLASS(x) MN_MAILDIR_MAILBOX_BACKEND_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILDIR_MAILBOX_BACKEND_GET_CLASS(x)

/* self typedefs */
typedef MNMaildirMailboxBackend Self;
typedef MNMaildirMailboxBackendClass SelfClass;

/* here are local prototypes */
#line 0 "src/mn-maildir-mailbox-backend.gob"
static void mn_maildir_mailbox_backend_init (MNMaildirMailboxBackend * o);
#line 54 "mn-maildir-mailbox-backend.c"
#line 39 "src/mn-maildir-mailbox-backend.gob"
static void mn_maildir_mailbox_backend_class_init (MNMaildirMailboxBackendClass * class);
#line 57 "mn-maildir-mailbox-backend.c"
#line 44 "src/mn-maildir-mailbox-backend.gob"
static void ___2_mn_maildir_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend, const char * info_uri, GnomeVFSMonitorEventType event_type);
#line 60 "mn-maildir-mailbox-backend.c"
#line 66 "src/mn-maildir-mailbox-backend.gob"
static gboolean mn_maildir_mailbox_backend_dir_exists (MNVFSMailbox * mailbox, const char * name);
#line 63 "mn-maildir-mailbox-backend.c"
#line 80 "src/mn-maildir-mailbox-backend.gob"
static gboolean ___4_mn_maildir_mailbox_backend_is (MNVFSMailboxBackend * dummy, MNVFSMailboxBackendClass * class, MNVFSMailbox * mailbox);
#line 66 "mn-maildir-mailbox-backend.c"
#line 90 "src/mn-maildir-mailbox-backend.gob"
static void mn_maildir_mailbox_backend_monitor_directory (MNMaildirMailboxBackend * self, int check_id, const char * dir);
#line 69 "mn-maildir-mailbox-backend.c"
#line 105 "src/mn-maildir-mailbox-backend.gob"
static gboolean mn_maildir_mailbox_backend_scan_directory (MNMaildirMailboxBackend * self, int check_id, const char * dir, gboolean new, GSList ** messages, int * num_errors, GError ** err);
#line 72 "mn-maildir-mailbox-backend.c"
#line 240 "src/mn-maildir-mailbox-backend.gob"
static void ___7_mn_maildir_mailbox_backend_check (MNVFSMailboxBackend * backend, int check_id);
#line 75 "mn-maildir-mailbox-backend.c"

/* pointer to the class of our parent */
static MNVFSMailboxBackendClass *parent_class = NULL;

/* Short form macros */
#define self_dir_exists mn_maildir_mailbox_backend_dir_exists
#define self_monitor_directory mn_maildir_mailbox_backend_monitor_directory
#define self_scan_directory mn_maildir_mailbox_backend_scan_directory
GType
mn_maildir_mailbox_backend_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMaildirMailboxBackendClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_maildir_mailbox_backend_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMaildirMailboxBackend),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_maildir_mailbox_backend_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_VFS_MAILBOX_BACKEND, "MNMaildirMailboxBackend", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMaildirMailboxBackend *)g_object_new(mn_maildir_mailbox_backend_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMaildirMailboxBackend * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMaildirMailboxBackend *
GET_NEW_VARG (const char *first, ...)
{
	MNMaildirMailboxBackend *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMaildirMailboxBackend *)g_object_new_valist (mn_maildir_mailbox_backend_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
mn_maildir_mailbox_backend_init (MNMaildirMailboxBackend * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Maildir:Mailbox:Backend::init"
}
#undef __GOB_FUNCTION__
#line 39 "src/mn-maildir-mailbox-backend.gob"
static void 
mn_maildir_mailbox_backend_class_init (MNMaildirMailboxBackendClass * class G_GNUC_UNUSED)
{
#line 136 "mn-maildir-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Maildir:Mailbox:Backend::class_init"
	MNVFSMailboxBackendClass *mn_vfs_mailbox_backend_class = (MNVFSMailboxBackendClass *)class;

	parent_class = g_type_class_ref (MN_TYPE_VFS_MAILBOX_BACKEND);

#line 44 "src/mn-maildir-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->monitor_cb = ___2_mn_maildir_mailbox_backend_monitor_cb;
#line 80 "src/mn-maildir-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->is = ___4_mn_maildir_mailbox_backend_is;
#line 240 "src/mn-maildir-mailbox-backend.gob"
	mn_vfs_mailbox_backend_class->check = ___7_mn_maildir_mailbox_backend_check;
#line 148 "mn-maildir-mailbox-backend.c"
 {
#line 40 "src/mn-maildir-mailbox-backend.gob"

    MN_VFS_MAILBOX_BACKEND_CLASS(class)->format = "Maildir";
  
#line 154 "mn-maildir-mailbox-backend.c"
 }
}
#undef __GOB_FUNCTION__



#line 44 "src/mn-maildir-mailbox-backend.gob"
static void 
___2_mn_maildir_mailbox_backend_monitor_cb (MNVFSMailboxBackend * backend G_GNUC_UNUSED, const char * info_uri, GnomeVFSMonitorEventType event_type)
#line 164 "mn-maildir-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___info_uri,___event_type) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->monitor_cb)(___backend,___info_uri,___event_type); }
{
#define __GOB_FUNCTION__ "MN:Maildir:Mailbox:Backend::monitor_cb"
{
#line 48 "src/mn-maildir-mailbox-backend.gob"
	
    if (event_type == GNOME_VFS_MONITOR_EVENT_CHANGED
	|| event_type == GNOME_VFS_MONITOR_EVENT_DELETED
	|| event_type == GNOME_VFS_MONITOR_EVENT_CREATED)
      {
	char *filename;

	filename = mn_vfs_uri_extract_short_name(info_uri);
	if (filename)
	  {
	    if (filename[0] != '.')
	      mn_reentrant_mailbox_queue_check(MN_REENTRANT_MAILBOX(backend->mailbox));

	    g_free(filename);
	  }
      }
  }}
#line 189 "mn-maildir-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 66 "src/mn-maildir-mailbox-backend.gob"
static gboolean 
mn_maildir_mailbox_backend_dir_exists (MNVFSMailbox * mailbox, const char * name)
{
#line 197 "mn-maildir-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Maildir:Mailbox:Backend::dir_exists"
#line 66 "src/mn-maildir-mailbox-backend.gob"
	g_return_val_if_fail (mailbox != NULL, (gboolean )0);
#line 66 "src/mn-maildir-mailbox-backend.gob"
	g_return_val_if_fail (MN_IS_VFS_MAILBOX (mailbox), (gboolean )0);
#line 66 "src/mn-maildir-mailbox-backend.gob"
	g_return_val_if_fail (name != NULL, (gboolean )0);
#line 205 "mn-maildir-mailbox-backend.c"
{
#line 69 "src/mn-maildir-mailbox-backend.gob"
	
    GnomeVFSURI *dir_uri;
    gboolean exists;

    dir_uri = gnome_vfs_uri_append_path(mailbox->vfs_uri, name);
    exists = mn_vfs_test(dir_uri, G_FILE_TEST_IS_DIR);
    gnome_vfs_uri_unref(dir_uri);

    return exists;
  }}
#line 218 "mn-maildir-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 80 "src/mn-maildir-mailbox-backend.gob"
static gboolean 
___4_mn_maildir_mailbox_backend_is (MNVFSMailboxBackend * dummy G_GNUC_UNUSED, MNVFSMailboxBackendClass * class, MNVFSMailbox * mailbox)
#line 224 "mn-maildir-mailbox-backend.c"
#define PARENT_HANDLER(___dummy,___class,___mailbox) \
	((MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)? \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->is)(___dummy,___class,___mailbox): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "MN:Maildir:Mailbox:Backend::is"
{
#line 84 "src/mn-maildir-mailbox-backend.gob"
	
    return self_dir_exists(mailbox, "cur")
      && self_dir_exists(mailbox, "new")
      && self_dir_exists(mailbox, "tmp");
  }}
#line 238 "mn-maildir-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 90 "src/mn-maildir-mailbox-backend.gob"
static void 
mn_maildir_mailbox_backend_monitor_directory (MNMaildirMailboxBackend * self, int check_id, const char * dir)
{
#line 246 "mn-maildir-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Maildir:Mailbox:Backend::monitor_directory"
#line 90 "src/mn-maildir-mailbox-backend.gob"
	g_return_if_fail (self != NULL);
#line 90 "src/mn-maildir-mailbox-backend.gob"
	g_return_if_fail (MN_IS_MAILDIR_MAILBOX_BACKEND (self));
#line 90 "src/mn-maildir-mailbox-backend.gob"
	g_return_if_fail (dir != NULL);
#line 254 "mn-maildir-mailbox-backend.c"
{
#line 92 "src/mn-maildir-mailbox-backend.gob"
	
    MNVFSMailboxBackend *backend = MN_VFS_MAILBOX_BACKEND(self);
    GnomeVFSURI *uri;
    char *text_uri;

    uri = gnome_vfs_uri_append_path(backend->mailbox->vfs_uri, dir);
    text_uri = gnome_vfs_uri_to_string(uri, GNOME_VFS_URI_HIDE_NONE);
    gnome_vfs_uri_unref(uri);

    mn_vfs_mailbox_backend_monitor(backend, check_id, text_uri, GNOME_VFS_MONITOR_DIRECTORY);
    g_free(text_uri);
  }}
#line 269 "mn-maildir-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 105 "src/mn-maildir-mailbox-backend.gob"
static gboolean 
mn_maildir_mailbox_backend_scan_directory (MNMaildirMailboxBackend * self, int check_id, const char * dir, gboolean new, GSList ** messages, int * num_errors, GError ** err)
{
#line 276 "mn-maildir-mailbox-backend.c"
#define __GOB_FUNCTION__ "MN:Maildir:Mailbox:Backend::scan_directory"
#line 105 "src/mn-maildir-mailbox-backend.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 105 "src/mn-maildir-mailbox-backend.gob"
	g_return_val_if_fail (MN_IS_MAILDIR_MAILBOX_BACKEND (self), (gboolean )0);
#line 105 "src/mn-maildir-mailbox-backend.gob"
	g_return_val_if_fail (dir != NULL, (gboolean )0);
#line 105 "src/mn-maildir-mailbox-backend.gob"
	g_return_val_if_fail (messages != NULL, (gboolean )0);
#line 105 "src/mn-maildir-mailbox-backend.gob"
	g_return_val_if_fail (num_errors != NULL, (gboolean )0);
#line 288 "mn-maildir-mailbox-backend.c"
{
#line 113 "src/mn-maildir-mailbox-backend.gob"
	
    MNVFSMailboxBackend *backend = MN_VFS_MAILBOX_BACKEND(self);
    GnomeVFSURI *uri;
    GnomeVFSResult result;
    GnomeVFSResult close_result;
    GnomeVFSDirectoryHandle *handle;
    GnomeVFSFileInfo *file_info;
    gboolean aborted = FALSE;

    uri = gnome_vfs_uri_append_path(backend->mailbox->vfs_uri, dir);

    result = gnome_vfs_directory_open_from_uri(&handle, uri, GNOME_VFS_FILE_INFO_FOLLOW_LINKS);
    if (result != GNOME_VFS_OK)
      {
	g_set_error(err, 0, 0, _("unable to open folder \"%s\": %s"), dir, gnome_vfs_result_to_string(result));
	gnome_vfs_uri_unref(uri);
	return FALSE;
      }

    file_info = gnome_vfs_file_info_new();
    while ((result = gnome_vfs_directory_read_next(handle, file_info)) == GNOME_VFS_OK)
      if (file_info->name[0] != '.')
	{
	  char *mid;
	  MNMessageFlags flags = 0;
	  MNVFSMessage *message = NULL;

	  if (mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
	    {
	      aborted = TRUE;
	      break;
	    }

	  if (new)
	    {
	      mid = g_strdup(file_info->name);
	      flags |= MN_MESSAGE_NEW;
	    }
	  else
	    {
	      char *info;

	      /* http://cr.yp.to/proto/maildir.html */

	      info = strrchr(file_info->name, ':');
	      if (! info
		  || ! g_str_has_prefix(info + 1, "2,")
		  || strpbrk(info + 3, "ST"))
		continue; /* no info, or message seen/trashed: ignore it */

	      mid = g_strndup(file_info->name, info - file_info->name);
	    }

	  /*
	   * Hold the GDK lock while using
	   * mn_mailbox_get_message_from_mid(), since for
	   * MNReentrantMailbox, mail checks can run concurrently, so
	   * another check could be modifying the MID hash table.
	   */
	  GDK_THREADS_ENTER();

	  message = MN_VFS_MESSAGE(mn_mailbox_get_message_from_mid(MN_MAILBOX(backend->mailbox), mid));
	  if (message)
	    message = mn_vfs_message_new_from_message(message,
						      uri,
						      file_info->name,
						      flags);

	  gdk_flush();
	  GDK_THREADS_LEAVE();

	  if (! message)
	    {
	      GError *tmp_err = NULL;

	      message = mn_vfs_message_new(MN_TYPE_MAILDIR_MESSAGE,
					   backend,
					   mid,
					   uri,
					   file_info->name,
					   flags,
					   FALSE,
					   &tmp_err);

	      if (tmp_err)
		{
		  GnomeVFSURI *message_uri;
		  char *message_text_uri;

		  message_uri = gnome_vfs_uri_append_file_name(uri, file_info->name);
		  message_text_uri = gnome_vfs_uri_to_string(message_uri, GNOME_VFS_URI_HIDE_PASSWORD);
		  gnome_vfs_uri_unref(message_uri);

		  mn_mailbox_warning(MN_MAILBOX(backend->mailbox), "cannot read message \"%s\": %s",
				     message_text_uri, tmp_err->message);
		  g_free(message_text_uri);
		  g_error_free(tmp_err);

		  (*num_errors)++;
		}
	    }

	  g_free(mid);

	  if (message)
	    *messages = g_slist_prepend(*messages, message);
	}
    gnome_vfs_uri_unref(uri);
    gnome_vfs_file_info_unref(file_info);
    close_result = gnome_vfs_directory_close(handle);

    if (! aborted)
      {
	if (result == GNOME_VFS_ERROR_EOF || result == GNOME_VFS_OK)
	  {
	    if (close_result == GNOME_VFS_OK)
	      return TRUE;
	    else
	      g_set_error(err, 0, 0, _("unable to close folder \"%s\": %s"), dir, gnome_vfs_result_to_string(close_result));
	  }
	else
	  g_set_error(err, 0, 0, _("error while reading folder \"%s\": %s"), dir, gnome_vfs_result_to_string(result));
      }

    return FALSE;
  }}
#line 417 "mn-maildir-mailbox-backend.c"
#undef __GOB_FUNCTION__

#line 240 "src/mn-maildir-mailbox-backend.gob"
static void 
___7_mn_maildir_mailbox_backend_check (MNVFSMailboxBackend * backend G_GNUC_UNUSED, int check_id)
#line 423 "mn-maildir-mailbox-backend.c"
#define PARENT_HANDLER(___backend,___check_id) \
	{ if(MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check) \
		(* MN_VFS_MAILBOX_BACKEND_CLASS(parent_class)->check)(___backend,___check_id); }
{
#define __GOB_FUNCTION__ "MN:Maildir:Mailbox:Backend::check"
{
#line 242 "src/mn-maildir-mailbox-backend.gob"
	
    Self *self = SELF(backend);
    GSList *messages = NULL;
    GError *err = NULL;
    int num_errors = 0;
    gboolean status;

    self_monitor_directory(self, check_id, "cur");
    self_monitor_directory(self, check_id, "new");

    status = self_scan_directory(self, check_id, "cur", FALSE, &messages, &num_errors, &err)
      && self_scan_directory(self, check_id, "new", TRUE, &messages, &num_errors, &err);

    GDK_THREADS_ENTER();

    if (! mn_reentrant_mailbox_check_aborted(MN_REENTRANT_MAILBOX(backend->mailbox), check_id))
      {
	if (status)
	  {
	    mn_mailbox_set_messages(MN_MAILBOX(backend->mailbox), messages);

	    if (num_errors != 0)
	      mn_mailbox_set_error(MN_MAILBOX(backend->mailbox),
				   ngettext("cannot read %i message",
					    "cannot read %i messages",
					    num_errors),
				   num_errors);
	  }
	else
	  mn_mailbox_set_error(MN_MAILBOX(backend->mailbox), "%s", err->message);
      }

    mn_g_object_slist_free(messages);

    gdk_flush();
    GDK_THREADS_LEAVE();

    if (err)
      g_error_free(err);
  }}
#line 471 "mn-maildir-mailbox-backend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER
