# Python Spatial Analysis Library Core

[![Continuous Integration](https://github.com/pysal/libpysal/actions/workflows/unittests.yml/badge.svg)](https://github.com/pysal/libpysal/actions/workflows/unittests.yml)
[![codecov](https://codecov.io/gh/pysal/libpysal/branch/main/graph/badge.svg)](https://codecov.io/gh/pysal/libpysal)
[![PyPI version](https://badge.fury.io/py/libpysal.svg)](https://badge.fury.io/py/libpysal)
[![Conda Version](https://img.shields.io/conda/vn/conda-forge/libpysal.svg)](https://anaconda.org/conda-forge/libpysal)
[![DOI](https://zenodo.org/badge/81501824.svg)](https://zenodo.org/badge/latestdoi/81501824)
   
## libpysal modules

- `libpysal.cg` –  Computational geometry
- `libpysal.io` –  Input and output
- `libpysal.weights` –  Spatial weights
- `libpysal.examples` –  Built-in example datasets

## Example Notebooks

- [Spatial Weights](notebooks/weights.ipynb)
- [Voronoi](notebooks/voronoi.ipynb)
- [Input and Output](notebooks/io.ipynb)

## Development

libpysal development is hosted on [github](https://github.com/pysal/libpysal).

Discussions of development occurs on the [developer list](http://groups.google.com/group/pysal-dev) as well as [gitter](https://gitter.im/pysal/pysal?).

## Contributing

PySAL-libpysal is under active development and contributors are welcome. If you have any suggestions, feature requests, or bug reports, please open new [issues](https://github.com/pysal/libpysal/issues) on GitHub. To submit patches, please review [PySAL's documentation for developers](https://pysal.org/docs/devs/), the PySAL [development guidelines](https://github.com/pysal/pysal/wiki), and the [libpysal contributing guidelines](https://github.com/pysal/libpysal/blob/main/.github/CONTRIBUTING.md)
before opening a [pull request](https://github.com/pysal/libpysal/pulls). Once your changes get merged, you’ll automatically be added to the [Contributors List](https://github.com/pysal/libpysal/graphs/contributors).

## Bug reports

To search for or report bugs, please see [libpysal's issues](https://github.com/pysal/libpysal/issues).

## License information

See [LICENSE.txt](https://github.com/pysal/libpysal/blob/main/LICENSE.txt) for information on the history of this software, terms & conditions for usage, and a DISCLAIMER OF ALL WARRANTIES.
